<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

/*
 * Settings Module Model Class
 */
class Settings_RelationMaker_Module_Model extends Settings_Vtiger_Module_Model {

	/**
	 * Function to get the url for create view of the module
	 * @return <string> - url
	 */
	public function getCreateRecordUrl() {
		return 'index.php?module=ModuleMaker&parent=Settings&view=Edit';
	}
	public function getPrimaryModules()
	{
    	global $adb;
		$sql= $adb->pquery("SELECT tabid,name,tablabel FROM vtiger_tab where name not in('Emails','PBXManager') AND isentitytype=1 AND presence in (0,2) ORDER BY tablabel ASC",array());
		$modulearr=array();
		while($resultinfo = $adb->fetch_array($sql))
		{
			$tabid=$resultinfo["tabid"];
			$name=$resultinfo["name"];
			$tablabel=$resultinfo["tablabel"];
			$modulearr[$name]=$tablabel;
			
		}
		return $modulearr;
	}
	public function create_relation($requestData)
	{
		global $adb;
		$rm_pri_module=$requestData["rm_pri_module"];
		$rm_sec_module=$requestData["rm_sec_module"];
		$rm_reltype=$requestData["rm_reltype"];
		$return_data=array("status"=>false,"message"=>"Relation not recognised");
		switch ($rm_reltype) {
			case "one-to-one":
			$return_data=$this->RM_one_to_one($rm_pri_module,$rm_sec_module);
			
			break;
			
			case "one-to-many":
			$return_data=$this->RM_one_to_many($rm_pri_module,$rm_sec_module);
			
			break;
			
			case "many-to-many":
			$return_data=$this->RM_many_to_many($rm_pri_module,$rm_sec_module);
			
			break;
			
			default:
			$return_data=array("status"=>false,"message"=>"Relation not recognised");
		}
		return $return_data;
	}
	public function RM_one_to_many($rm_pri_module,$rm_sec_module)
	{
		global $adb;
		$tabid_pri=getTabid($rm_pri_module);
		$tabid_sec=getTabid($rm_sec_module);
		$sql= $adb->pquery("SELECT * FROM vtiger_relatedlists WHERE tabid=? AND related_tabid=?",array($tabid_pri,$tabid_sec));
		if($adb->num_rows($sql)>0)
			return array("status"=>false,"message"=>"Relation already exists");
		
		$fieldid=$this->create_relation_field($rm_pri_module,$rm_sec_module);
		if($fieldid>0)
		{
			$priModuleInstance = Vtiger_Module::getInstance($rm_pri_module);
		$secModuleInstance = Vtiger_Module::getInstance($rm_sec_module);
		$priModuleInstance->setRelatedlist($secModuleInstance,$rm_sec_module,array('ADD'),'get_dependents_list',$fieldid);
			
			return array("status"=>true,"message"=>"Relation created");
		}
		else
		{
			return array("status"=>false,"message"=>"Error creating 1:N Relation");
		}
	  return array("status"=>false,"message"=>"Error in operation");
	}
	public function create_relation_field($rm_pri_module,$rm_sec_module)
	{
		global $adb;
		$fieldid=0;
		$tabid_pri=getTabid($rm_pri_module);
		$tabid_sec=getTabid($rm_sec_module);
		$priModuleInstance = Vtiger_Module::getInstance($rm_pri_module);
		$secModuleInstance = Vtiger_Module::getInstance($rm_sec_module);
		
		$sql= $adb->pquery("SELECT * FROM vtiger_ws_referencetype wref LEFT JOIN vtiger_ws_fieldtype wftype ON wref.fieldtypeid=wftype.fieldtypeid  WHERE wref.type=? AND wftype.fieldtype=?",array($rm_pri_module,"reference"));
		//if($adb->num_rows($sql)>0)
		if(false)	
		{
			$uitype_arr=array();
			while($resultinfo = $adb->fetch_array($sql))
			{
				$uitype=$resultinfo["uitype"];
				array_push($uitype_arr,$uitype);
			}
			$uitypes = implode(', ', array_map(function($val){return sprintf("'%s'", $val);}, $uitype_arr));
			
			$sql2= $adb->pquery("SELECT * FROM vtiger_field WHERE tabid=? AND uitype IN($uitypes) AND presence IN(0,2)",array($tabid_sec));
			
			if($adb->num_rows($sql2)>0)
			{
				$resultinfo2 = $adb->fetch_array($sql2);
				$fieldid=$resultinfo2["fieldid"];
			}
			else
			{
				$blocklabel=$this->get_field_block_label($rm_sec_module);
				if($blocklabel=='')
					$fieldid=0;
				else
				{
					$uitype=array_shift(array_slice($uitype_arr,0,1));
					$moduleInstance=Vtiger_Module::getInstance($rm_sec_module);
					$fieldname="related_".strtolower($rm_pri_module);
					$parentname=ucfirst(strtolower($rm_pri_module));
					$fiellabel="Related ".$parentname;
					$fieldcreatedinfo=$this->create_field($tabid_sec,$moduleInstance,$blocklabel,$fieldname,$fiellabel,$uitype);
					$fieldid=$fieldcreatedinfo["fieldid"];
				}
			}
		}
		else
		{
			$sql2= $adb->pquery("SELECT * FROM vtiger_fieldmodulerel WHERE module=? AND relmodule=?",array($rm_sec_module,$rm_pri_module));
			if($adb->num_rows($sql2)>0)
			{
				$resultinfo2 = $adb->fetch_array($sql2);
				$fieldid=$resultinfo2["fieldid"];
			}
			else
			{
				$uitype=10;
				$blocklabel=$this->get_field_block_label($rm_sec_module);
				if($blocklabel=='')
				$fieldid=0;
				else
				{
					$moduleInstance=Vtiger_Module::getInstance($rm_sec_module);
					$fieldname="related_".strtolower($rm_pri_module);
					$parentname=ucfirst(strtolower($rm_pri_module));
					$fiellabel="Related ".$parentname;
					$fieldcreatedinfo=$this->create_field($tabid_sec,$moduleInstance,$blocklabel,$fieldname,$fiellabel,$uitype);
				    $fieldid=$fieldcreatedinfo["fieldid"];
					if($fieldid>0)
					{
						$adb->pquery("INSERT INTO vtiger_fieldmodulerel SET fieldid=?,module=?,relmodule=?,status=?,sequence=?",array($fieldid,$rm_sec_module,$rm_pri_module,NULL,NULL));
					}
					
					
				}
			}
		}
		return $fieldid;
	}
	public function RM_many_to_many($rm_pri_module,$rm_sec_module)
	{
		global $adb;
		$tabid_pri=getTabid($rm_pri_module);
		$tabid_sec=getTabid($rm_sec_module);
		$sql= $adb->pquery("SELECT * FROM vtiger_relatedlists WHERE tabid=? AND related_tabid=?",array($tabid_pri,$tabid_sec));
		if($adb->num_rows($sql)>0)
			return array("status"=>false,"message"=>"Relation already exists");
		
		$priModuleInstance = Vtiger_Module::getInstance($rm_pri_module);
		$secModuleInstance = Vtiger_Module::getInstance($rm_sec_module);
		$priModuleInstance->setRelatedlist($secModuleInstance,$rm_sec_module,array('ADD','SELECT'),'get_related_list');
		return array("status"=>true,"message"=>"Relation created"); 
	}
	public function RM_one_to_one($rm_pri_module,$rm_sec_module)
	{
		global $adb;
		$tabid_pri=getTabid($rm_pri_module);
		$tabid_sec=getTabid($rm_sec_module);
		$priModuleInstance = Vtiger_Module::getInstance($rm_pri_module);
		$secModuleInstance = Vtiger_Module::getInstance($rm_sec_module);
		
		$sql= $adb->pquery("SELECT * FROM vtiger_ws_referencetype wref LEFT JOIN vtiger_ws_fieldtype wftype ON wref.fieldtypeid=wftype.fieldtypeid  WHERE wref.type=? AND wftype.fieldtype=?",array($rm_sec_module,"reference"));
		if($adb->num_rows($sql)>0)
		{
			$uitype_arr=array();
			while($resultinfo = $adb->fetch_array($sql))
			{
				$uitype=$resultinfo["uitype"];
				array_push($uitype_arr,$uitype);
			}
			$uitypes = implode(', ', array_map(function($val){return sprintf("'%s'", $val);}, $uitype_arr));
			
			$sql2= $adb->pquery("SELECT * FROM vtiger_field WHERE tabid=? AND uitype IN($uitypes) AND presence IN(0,2)",array($tabid_pri));
			
			if($adb->num_rows($sql2)>0)
				return array("status"=>false,"message"=>"Relation already exists");
			else
			{
				$blocklabel=$this->get_field_block_label($rm_pri_module);
				if($blocklabel=='')
				return array("status"=>false,"message"=>"Block name not found");
				
				$uitype=array_shift(array_slice($uitype_arr,0,1));
				$moduleInstance=Vtiger_Module::getInstance($rm_pri_module);
				$fieldname="related_".strtolower($rm_sec_module);
				$parentname=ucfirst(strtolower($rm_sec_module));
				$fiellabel="Related ".$parentname;
				$fieldcreatedinfo=$this->create_field($tabid_pri,$moduleInstance,$blocklabel,$fieldname,$fiellabel,$uitype);
				$fieldid=$fieldcreatedinfo["fieldid"];
				if($fieldid>0)
				return array("status"=>true,"message"=>"Relation created");
				else
				return array("status"=>false,"message"=>"Relation Field not created");
			}
			
		}
		else
		{
			$sql2= $adb->pquery("SELECT * FROM vtiger_fieldmodulerel WHERE module=? AND uitype=? AND relmodule=?",array($rm_pri_module,$rm_sec_module));
			if($adb->num_rows($sql2)>0)
				return array("status"=>false,"message"=>"Relation already exists");
			else
			{
				$uitype=10;
				$blocklabel=$this->get_field_block_label($rm_pri_module);
				if($blocklabel=='')
				return array("status"=>false,"message"=>"Block name not found");
				$moduleInstance=Vtiger_Module::getInstance($rm_pri_module);
				$fieldname="related_".strtolower($rm_sec_module);
				$parentname=ucfirst(strtolower($rm_sec_module));
				$fiellabel="Related ".$parentname;
				$fieldcreatedinfo=$this->create_field($tabid_pri,$moduleInstance,$blocklabel,$fieldname,$fiellabel,$uitype);
				$fieldid=$fieldcreatedinfo["fieldid"];
				
				if($fieldid>0)
				{
					$adb->pquery("INSERT INTO vtiger_fieldmodulerel SET fieldid=?,module=?,relmodule=?,status=?,sequence=?",array($fieldid,$rm_pri_module,$rm_sec_module,NULL,NULL));
					return array("status"=>true,"message"=>"Relation created");
				}
				
				else
				return array("status"=>false,"message"=>"Relation Field not created");
			}
		}
		return false;
	}
	public function get_field_block_label($moduleName)
	{
		global $adb;
		$tabid=getTabid($moduleName);
		$sql= $adb->pquery("SELECT blocklabel FROM vtiger_blocks WHERE tabid=? AND display_status=? LIMIT 0,1",array($tabid,1));
		$resultinfo = $adb->fetch_array($sql);
		$blocklabel=$resultinfo["blocklabel"];
		return $blocklabel;
	}
	public function create_field($tabid,$moduleInstance,$blocklabel,$fieldname,$fiellabel,$uitype)
	{
		global $adb;
		$sql = $adb->pquery("SELECT MAX(quickcreatesequence) AS max_quickcreateseq FROM vtiger_field WHERE tabid=?", Array($tabid));
		$resultinfo = $adb->fetch_array($sql);
		$max_quickcreateseq=$resultinfo["max_quickcreateseq"];
		$max_quickcreateseq += 1;
		
		$blockInstance = Vtiger_Block::getInstance($blocklabel, $moduleInstance); 
		$fieldInstance = new Vtiger_Field();
		$fieldInstance->name = $fieldname;
		$fieldInstance->table = $moduleInstance->basetable;
		$fieldInstance->column = $fieldname;
		$fieldInstance->label=$fiellabel;
		$fieldInstance->columntype = 'INT(11)';
		$fieldInstance->uitype =$uitype;
		$fieldInstance->typeofdata = 'V~M';
		$fieldInstance->readonly = '1';
		$fieldInstance->displaytype = '1';
		$fieldInstance->masseditable = '0';
		$fieldInstance->quickcreate= '1';
		$fieldInstance->quicksequence= $max_quickcreateseq;
		$fieldInstance->summaryfield ='1';
		$fieldInstance->headerfield ='1';
		$blockInstance->addField($fieldInstance);
		
		if($blockInstance->addField($fieldInstance))
		{
			$fieldModel = Vtiger_Field_Model::getInstance($fieldname, $moduleInstance);
			$fieldid=$fieldModel->getId();
			return array("fieldid"=>$fieldid,"fieldname"=>$fieldname);
		}
		else
		return array();
	}
	public static function getInstance() {
		$moduleModel = new self();
		return $moduleModel;
	}
	
}
