<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

/*
 * Settings Module Model Class
 */
class Settings_ModuleMaker_Module_Model extends Settings_Vtiger_Module_Model {

	/**
	 * Function to get the url for create view of the module
	 * @return <string> - url
	 */
	public function getCreateRecordUrl() {
		return 'index.php?module=ModuleMaker&parent=Settings&view=Edit';
	}
	public function getParentMenu()
	{
		$appmenulist = Vtiger_MenuStructure_Model::getAppMenuList();
		return $appmenulist;
	}
	public static function getInstance() {
		$moduleModel = new self();
		return $moduleModel;
	}
	public function create_module($requestData)
	{
		global $adb;
		$modulename=$requestData["cm_crmmodulenamne"];
		$cm_modulename=$requestData["cm_modulename"];
		$cm_appmenu=$requestData["cm_appmenu"];
		$cm_prefix=$requestData["cm_prefix"];
		$cm_startseq=$requestData["cm_startseq"];
		
		if($cm_appmenu=='PROJECT')
			$cm_appmenu='SUPPORT';
		
		$modulestr_len=strlen($modulename);
		if($modulestr_len>15)
			return array("status"=>false,"message"=>"Module Name is too big.");
		
		$sql= $adb->pquery("SELECT * FROM vtiger_tab WHERE name=?",array($modulename));
		if($adb->num_rows($sql)>0)
			return array("status"=>false,"message"=>"Module already exists");
		
		$parentname=ucfirst(strtolower($cm_appmenu));
		$vtModule = new Vtiger_Module();
		$vtModule->name = $modulename;
		$vtModule->label= $cm_modulename;
		$vtModule->parent=$parentname;
		$vtModule->version='7.4.1';
		if($vtModule->save())
		{
			$vtModule->initTables();
			$menu = Vtiger_Menu::getInstance($cm_appmenu); 
			$menu->addModule($modulename);

			$tabid=getTabid($modulename);

			$modentity_uniqueid_num=$adb->getUniqueId("vtiger_modentity_num");
			$adb->pquery("INSERT INTO vtiger_modentity_num values(?,?,?,?,?,?)", array($modentity_uniqueid_num,$modulename,$cm_prefix,$cm_startseq,$cm_startseq,1));

			// Update vtiger_app2tab table
			$seqSql = $adb->pquery("SELECT max(sequence) as sequence FROM vtiger_app2tab WHERE appname=?",array($cm_appmenu));
			$resultinfo = $adb->fetch_array($seqSql);
			$sequence=$resultinfo["sequence"];
			$new_seq=$sequence+1;
			$adb->pquery("INSERT INTO vtiger_app2tab(tabid,appname,sequence,visible) values(?,?,?,?)", array($tabid,$cm_appmenu,$new_seq,1));


			$block1 = new Vtiger_Block();
			$block1->label = 'LBL_'.strtoupper($modulename).'_INFORMATION';
			$vtModule->addBlock($block1);

			$field1 = new Vtiger_Field();
			$field1->name = strtolower($modulename).'name';
			$field1->label = $cm_modulename.' Name';
			$field1->table = $vtModule->basetable;
			$field1->column = strtolower($modulename).'name';
			$field1->columntype = 'VARCHAR(155)';
			$field1->uitype = 2;
			$field1->typeofdata = 'V~M';
			$field1->quickcreate= '1';
			$field1->quicksequence= 1;
			$field1->summaryfield ='1';
			$field1->headerfield ='1';
			$block1->addField($field1);

			$field2 = new Vtiger_Field();
			$field2->name = strtolower($modulename).'_no';
			$field2->label = $cm_modulename.' No';
			$field2->table = $vtModule->basetable;
			$field2->column = strtolower($modulename).'_no';
			$field2->columntype = 'VARCHAR(100)';
			$field2->uitype = 4;
			$field2->typeofdata = 'V~O';
			$block1->addField($field2);

			$field3 = new Vtiger_Field();
			$field3->name = 'createdtime';
			$field3->label= 'Created Time';
			$field3->table = 'vtiger_crmentity';
			$field3->column = 'createdtime';
			$field3->uitype = 70;
			$field3->typeofdata = 'DT~O';
			$field3->displaytype= 2;
			$block1->addField($field3);

			$field4 = new Vtiger_Field();
			$field4->name = 'modifiedtime';
			$field4->label= 'Modified Time';
			$field4->table = 'vtiger_crmentity';
			$field4->column = 'modifiedtime';
			$field4->uitype = 70;
			$field4->typeofdata = 'DT~O';
			$field4->displaytype= 2;
			$block1->addField($field4);


			$field5 = new Vtiger_Field();
			$field5->name = 'assigned_user_id';
			$field5->label = 'Assigned To';
			$field5->table = 'vtiger_crmentity'; 
			$field5->column = 'smownerid';
			$field5->uitype = 53;
			$field5->typeofdata = 'V~M';
			$block1->addField($field5);

			$vtModule->setEntityIdentifier($field1);

			// Create default custom filter (mandatory)
			$filter1 = new Vtiger_Filter();
			$filter1->name = 'All';
			$filter1->isdefault = true;
			$vtModule->addFilter($filter1);
			$filter1->addField($field1);

			/** Set sharing access of this module */
			$vtModule->setDefaultSharing('Public'); 
				
			/** Enable and Disable available tools */
			$vtModule->enableTools(Array('Import', 'Export'));
			$vtModule->disableTools('Merge');

			$vtModule = Vtiger_Module::getInstance($modulename);
			$vtModule->initWebservice(); 

			$this->full_copy(dirname(__FILE__).'/../Package/LanguageFiles/__vtModule__.php',dirname(__FILE__).'/../../../../languages/en_us/__vtModule__.php');
			$this->full_copy(dirname(__FILE__).'/../Package/ModuleFiles/',dirname(__FILE__).'/../../../../modules/'.$modulename.'');
			$this->full_copy(dirname(__FILE__).'/../Package/vlayoutFiles/',dirname(__FILE__).'/../../../../layouts/v7/modules/'.$modulename.'');

			// Update Language File
			$old_file=dirname(__FILE__).'/../../../../languages/en_us/__vtModule__.php';
			$new_file=dirname(__FILE__).'/../../../../languages/en_us/'.$modulename.'.php';
			rename($old_file , $new_file);
			$lang_data = '<?php
			$languageStrings = Array(
			\''.$modulename.'\'=>\''.$cm_modulename.'\',
			\'SINGLE_'.$modulename.'\'=>\''.$cm_modulename.': Home\',
			\'LBL_ADD_RECORD\'=>\'Add '.$cm_modulename.'\',
			\'LBL_RECORDS_LIST\'=>\''.$cm_modulename.' List\',
			\'LBL_'.strtoupper($modulename).'_NAME\'=>\''.$cm_modulename.' Name:\',
			\'LBL_'.strtoupper($modulename).'_INFORMATION\'=>\''.$cm_modulename.' Information\' );
			?>';
			file_put_contents($new_file,$lang_data);

			// Update schema.xml
			$schema_file=dirname(__FILE__).'/../../../../modules/'.$modulename.'/schema.xml';
			$this->replace_file($schema_file, '__vtModuleBaseTable__', $vtModule->basetable);
			$this->replace_file($schema_file, '__vtBaseTableIndexColumn__', strtolower($modulename).'id');
			$this->replace_file($schema_file, '__vtBaseTablePrimaryField__', strtolower($modulename).'name');
			$this->replace_file($schema_file, '__vtBaseTableAutoSeqNo__', strtolower($modulename).'_no');

			// JS 
			$this->replace_file(dirname(__FILE__).'/../../../../layouts/v7/modules/'.$modulename.'/resources/Detail.js', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../layouts/v7/modules/'.$modulename.'/resources/Edit.js', '__vtModule__', $modulename);

			//Update Module specific Files
			$vtbasemodoule_file=dirname(__FILE__).'/../../../../modules/'.$modulename.'/__vtModule__.php';
			$basemodoule_file=dirname(__FILE__).'/../../../../modules/'.$modulename.'/'.$modulename.'.php';
			rename($vtbasemodoule_file , $basemodoule_file);

			// Handler File
			$vthandler_file=dirname(__FILE__).'/../../../../modules/'.$modulename.'/__vtModule__Handler.php';
			$handler_file=dirname(__FILE__).'/../../../../modules/'.$modulename.'/'.$modulename.'Handler.php';
			rename($vthandler_file , $handler_file);

			$this->replace_file($handler_file, '__vtModule__', $modulename);

			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/views/Edit.php', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/views/Detail.php', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/models/RelationListView.php', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/models/Record.php', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/models/Module.php', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/models/DetailView.php', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/models/DashBoard.php', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/actions/SaveAjax.php', '__vtModule__', $modulename);
			$this->replace_file(dirname(__FILE__).'/../../../../modules/'.$modulename.'/actions/Save.php', '__vtModule__', $modulename);

			$this->replace_file($basemodoule_file, '__vtModuleBaseTable__', $vtModule->basetable);
			$this->replace_file($basemodoule_file, '__vtBaseTableIndexColumn__', strtolower($modulename).'id');
			$this->replace_file($basemodoule_file, '__vtModule__', $modulename);
			$this->replace_file($basemodoule_file, '__vtBaseTablePrimaryField__', strtolower($modulename).'name');


			// Add Comment Block to Module
			$commentsModuleModel = Vtiger_Module_Model::getInstance('ModComments');
			$sql=$adb->pquery("SELECT fieldid FROM vtiger_field WHERE fieldname = ? AND tabid = ?",array("related_to",$commentsModuleModel->getId()));
			$resultinfo= $adb->fetch_array($sql);
			$fieldId = $resultinfo["fieldid"];
			$sql1=$adb->pquery("INSERT INTO vtiger_fieldmodulerel SET fieldid=?,module=?,relmodule=?",array($fieldId,"ModComments",$modulename));

			// Add Update Block

			$tabid = getTabid($modulename);
			$sql1=$adb->pquery("INSERT INTO vtiger_modtracker_tabs SET tabid=?,visible=?",array($tabid,1));
			
			// Link Documents Module
			
			$moduleInstance = Vtiger_Module::getInstance($modulename);
			$rm_sec_module='Documents';
		$secModuleInstance = Vtiger_Module::getInstance($rm_sec_module);
		$moduleInstance->setRelatedlist($secModuleInstance,$rm_sec_module,array('ADD','SELECT'),'get_attachments');


			return array("status"=>true,"message"=>"Module created");
		}
		else
		{
		    return array("status"=>false,"message"=>"Error creating module");
		}
	}
	function replace_file($path, $string, $replace)
	{
		set_time_limit(0);
		if (is_file($path) === true)
		{
			$file = fopen($path, 'r');
			$temp = tempnam('./', 'tmp');
			if (is_resource($file) === true)
			{
				while (feof($file) === false)
				{
					file_put_contents($temp, str_replace($string, $replace, fgets($file)), FILE_APPEND);
				}
				fclose($file);
			}
			unlink($path);
		}
		return rename($temp, $path);
	}

	function full_copy( $source, $target ) 
	{
		if ( is_dir( $source ) ) {
		@mkdir( $target );
		$d = dir( $source );
		while ( FALSE !== ( $entry = $d->read() ) ) {
		if ( $entry == '.' || $entry == '..' ) {
		continue;
		}
		$Entry = $source . '/' . $entry; 
		if ( is_dir( $Entry ) ) {
		$this->full_copy( $Entry, $target . '/' . $entry );
		continue;
		}
		copy( $Entry, $target . '/' . $entry );
		}
		$d->close();
		}else {
		copy( $source, $target );
		}

	}
}
