(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define(['jquery', 'jquery-ui'], factory)
    } else if (typeof exports !== 'undefined') {
        var $, ui;
        try {
            $ = require('jquery');
            ui = require('jquery-ui')
        } catch (e) {
        }
        module.exports = factory($, ui)
    } else {
        factory(root.jQuery, root.jQuery.ui, !0)
    }
}(this, function ($, _ui, toGlobal) {
    toGlobal = toGlobal || !1;
    var elFinder = function (elm, opts, bootCallback) {
        var self = this, dfrdsBeforeBootup = [], conflictChecks = ['button', 'tooltip'], node = $(elm),
            prevEvents = $.extend(!0, {}, $._data(node.get(0), 'events')),
            prevContent = $('<div/>').append(node.contents()).attr('class', node.attr('class') || '').attr('style', node.attr('style') || ''),
            id = node.attr('id') || node.attr('id', 'elfauto' + $('.elfinder').length).attr('id'),
            namespace = 'elfinder-' + id, mousedown = 'mousedown.' + namespace, keydown = 'keydown.' + namespace,
            keypress = 'keypress.' + namespace, keyup = 'keyup.' + namespace, enabled = !1, prevEnabled = !1,
            events = ['enable', 'disable', 'load', 'open', 'reload', 'select', 'add', 'remove', 'change', 'dblclick', 'getfile', 'lockfiles', 'unlockfiles', 'selectfiles', 'unselectfiles', 'dragstart', 'dragstop', 'search', 'searchend', 'viewchange'],
            rules = {}, cwd = '', cwdOptionsDefault = {
                path: '',
                url: '',
                tmbUrl: '',
                disabled: [],
                separator: '/',
                archives: [],
                extract: [],
                copyOverwrite: !0,
                uploadOverwrite: !0,
                uploadMaxSize: 0,
                jpgQuality: 100,
                tmbCrop: !1,
                tmb: !1
            }, cwdOptions = {}, files = {}, hiddenFiles = {}, ownFiles = {}, selected = [], listeners = {}, shortcuts = {},
            clipboard = [], remember = {}, queue = [], cwdQueue = [], base = new self.command(self), width = 'auto',
            height = 400, heightBase = null, textMimes = null, soundPath = 'sounds/', prevSorterStr = '',
            extToMimeTable, diableUnloadCheck = !1,
            beeper = $(document.createElement('audio')).hide().appendTo('body')[0], syncInterval, autoSyncStop = 0,
            uiCmdMapPrev = '', gcJobRes = null, open = function (data) {
                var volumeid, contextmenu, emptyDirs = {}, stayDirs = {}, rmClass, hashes, calc, gc, collapsed, prevcwd,
                    sorterStr;
                if (self.api >= 2.1) {
                    self.commandMap = (data.options.uiCmdMap && Object.keys(data.options.uiCmdMap).length) ? data.options.uiCmdMap : {};
                    if (uiCmdMapPrev !== JSON.stringify(self.commandMap)) {
                        uiCmdMapPrev = JSON.stringify(self.commandMap)
                    }
                } else {
                    self.options.sync = 0
                }
                if (data.init) {
                    files = {};
                    ownFiles = {}
                } else {
                    prevcwd = cwd;
                    rmClass = 'elfinder-subtree-loaded ' + self.res('class', 'navexpand');
                    collapsed = self.res('class', 'navcollapse');
                    hashes = Object.keys(files);
                    calc = function (i) {
                        if (!files[i]) {
                            return !0
                        }
                        var isDir = (files[i].mime === 'directory'), phash = files[i].phash, pnav;
                        if ((!isDir || emptyDirs[phash] || (!stayDirs[phash] && self.navHash2Elm(files[i].hash).is(':hidden') && self.navHash2Elm(phash).next('.elfinder-navbar-subtree').children().length > 100)) && (isDir || phash !== cwd) && !remember[i]) {
                            if (isDir && !emptyDirs[phash]) {
                                emptyDirs[phash] = !0;
                                self.navHash2Elm(phash).removeClass(rmClass).next('.elfinder-navbar-subtree').empty()
                            }
                            deleteCache(files[i])
                        } else if (isDir) {
                            stayDirs[phash] = !0
                        }
                    };
                    gc = function () {
                        if (hashes.length) {
                            gcJobRes && gcJobRes._abort();
                            gcJobRes = self.asyncJob(calc, hashes, {interval: 20, numPerOnce: 100}).done(function () {
                                var hd = self.storage('hide') || {items: {}};
                                if (Object.keys(hiddenFiles).length) {
                                    $.each(hiddenFiles, function (h) {
                                        if (!hd.items[h]) {
                                            delete hiddenFiles[h]
                                        }
                                    })
                                }
                            })
                        }
                    };
                    self.trigger('filesgc').one('filesgc', function () {
                        hashes = []
                    });
                    self.one('opendone', function () {
                        if (prevcwd !== cwd) {
                            if (!node.data('lazycnt')) {
                                gc()
                            } else {
                                self.one('lazydone', gc)
                            }
                        }
                    })
                }
                self.sorters = {};
                cwd = data.cwd.hash;
                cache(data.files);
                if (!files[cwd]) {
                    cache([data.cwd])
                }
                sorterStr = JSON.stringify(self.sorters);
                if (prevSorterStr !== sorterStr) {
                    self.trigger('sorterupdate');
                    prevSorterStr = sorterStr
                }
                self.lastDir(cwd);
                self.autoSync()
            }, cache = function (data, type) {
                var defsorter = {name: !0, perm: !0, date: !0, size: !0, kind: !0}, sorterChk = !self.sorters._checked,
                    l = data.length, setSorter = function (file) {
                        var f = file || {}, sorters = [];
                        $.each(self.sortRules, function (key) {
                            if (defsorter[key] || typeof f[key] !== 'undefined' || (key === 'mode' && typeof f.perm !== 'undefined')) {
                                sorters.push(key)
                            }
                        });
                        self.sorters = self.arrayFlip(sorters, !0);
                        self.sorters._checked = !0
                    }, keeps = ['sizeInfo'], changedParents = {}, hideData = self.storage('hide') || {},
                    hides = hideData.items || {}, f, i, keepProp, parents, hidden;
                for (i = 0; i < l; i++) {
                    f = Object.assign({}, data[i]);
                    hidden = (!hideData.show && hides[f.hash]) ? !0 : !1;
                    if (f.name && f.hash && f.mime) {
                        if (!hidden) {
                            if (sorterChk && f.phash === cwd) {
                                setSorter(f);
                                sorterChk = !1
                            }
                            if (f.phash && (type === 'add' || type === 'change')) {
                                if (parents = self.parents(f.phash)) {
                                    $.each(parents, function () {
                                        changedParents[this] = !0
                                    })
                                }
                            }
                        }
                        if (files[f.hash]) {
                            $.each(keeps, function () {
                                if (files[f.hash][this] && !f[this]) {
                                    f[this] = files[f.hash][this]
                                }
                            });
                            if (f.sizeInfo && !f.size) {
                                f.size = f.sizeInfo.size
                            }
                            deleteCache(files[f.hash], !0)
                        }
                        if (hides[f.hash]) {
                            hiddenFiles[f.hash] = f
                        }
                        if (hidden) {
                            l--;
                            data.splice(i--, 1)
                        } else {
                            files[f.hash] = f;
                            if (f.mime === 'directory' && !ownFiles[f.hash]) {
                                ownFiles[f.hash] = {}
                            }
                            if (f.phash) {
                                if (!ownFiles[f.phash]) {
                                    ownFiles[f.phash] = {}
                                }
                                ownFiles[f.phash][f.hash] = !0
                            }
                        }
                    }
                }
                $.each(Object.keys(changedParents), function () {
                    var target = files[this];
                    if (target && target.sizeInfo) {
                        delete target.sizeInfo
                    }
                });
                sorterChk && setSorter()
            }, remove = function (removed) {
                var l = removed.length, roots = {}, rm = function (hash) {
                    var file = files[hash], i;
                    if (file) {
                        if (file.mime === 'directory') {
                            if (roots[hash]) {
                                delete self.roots[roots[hash]]
                            }
                            $.each(self.leafRoots, function (phash, roots) {
                                var idx, pdir;
                                if ((idx = $.inArray(hash, roots)) !== -1) {
                                    if (roots.length === 1) {
                                        if ((pdir = Object.assign({}, files[phash])) && pdir._realStats) {
                                            $.each(pdir._realStats, function (k, v) {
                                                pdir[k] = v
                                            });
                                            remove(files[phash]._realStats);
                                            self.change({changed: [pdir]})
                                        }
                                        delete self.leafRoots[phash]
                                    } else {
                                        self.leafRoots[phash].splice(idx, 1)
                                    }
                                }
                            });
                            if (self.searchStatus.state < 2) {
                                $.each(files, function (h, f) {
                                    f.phash == hash && rm(h)
                                })
                            }
                        }
                        if (file.phash) {
                            if (parents = self.parents(file.phash)) {
                                $.each(parents, function () {
                                    changedParents[this] = !0
                                })
                            }
                        }
                        deleteCache(files[hash])
                    }
                }, changedParents = {}, parents;
                $.each(self.roots, function (k, v) {
                    roots[v] = k
                });
                while (l--) {
                    rm(removed[l])
                }
                $.each(Object.keys(changedParents), function () {
                    var target = files[this];
                    if (target && target.sizeInfo) {
                        delete target.sizeInfo
                    }
                })
            }, change = function (changed) {
                $.each(changed, function (i, file) {
                    var hash = file.hash;
                    if (files[hash]) {
                        $.each(Object.keys(files[hash]), function (i, v) {
                            if (typeof file[v] === 'undefined') {
                                delete files[hash][v]
                            }
                        })
                    }
                    files[hash] = files[hash] ? Object.assign(files[hash], file) : file
                })
            }, deleteCache = function (file, update) {
                var hash = file.hash, phash = file.phash;
                if (phash && ownFiles[phash]) {
                    delete ownFiles[phash][hash]
                }
                if (!update) {
                    ownFiles[hash] && delete ownFiles[hash];
                    self.optionsByHashes[hash] && delete self.optionsByHashes[hash]
                }
                delete files[hash]
            }, requestMaxConn, requestCnt = 0, requestQueue = [], requestQueueSkipOpen = !1, execShortcut = function (e) {
                var code = e.keyCode, ctrlKey = !!(e.ctrlKey || e.metaKey), isMousedown = e.type === 'mousedown', ddm;
                !isMousedown && (self.keyState.keyCode = code);
                self.keyState.ctrlKey = ctrlKey;
                self.keyState.shiftKey = e.shiftKey;
                self.keyState.metaKey = e.metaKey;
                self.keyState.altKey = e.altKey;
                if (isMousedown) {
                    return
                } else if (e.type === 'keyup') {
                    self.keyState.keyCode = null;
                    return
                }
                if (enabled) {
                    $.each(shortcuts, function (i, shortcut) {
                        if (shortcut.type == e.type && shortcut.keyCode == code && shortcut.shiftKey == e.shiftKey && shortcut.ctrlKey == ctrlKey && shortcut.altKey == e.altKey) {
                            e.preventDefault();
                            e.stopPropagation();
                            shortcut.callback(e, self);
                            self.debug('shortcut-exec', i + ' : ' + shortcut.description)
                        }
                    });
                    if (code == $.ui.keyCode.TAB && !$(e.target).is(':input')) {
                        e.preventDefault()
                    }
                    if (e.type === 'keydown' && code == $.ui.keyCode.ESCAPE) {
                        if (!node.find('.ui-widget:visible').length) {
                            self.clipboard().length && self.clipboard([])
                        }
                        if ($.ui.ddmanager) {
                            ddm = $.ui.ddmanager.current;
                            ddm && ddm.helper && ddm.cancel()
                        }
                        self.toHide(node.find('.ui-widget.elfinder-button-menu.elfinder-frontmost:visible'));
                        self.trigger('keydownEsc', e)
                    }
                }
            }, date = new Date(), utc, i18n, inFrame = (window.parent !== window), parentIframe = (function () {
                var pifm, ifms;
                if (inFrame) {
                    try {
                        ifms = $('iframe', window.parent.document);
                        if (ifms.length) {
                            $.each(ifms, function (i, ifm) {
                                if (ifm.contentWindow === window) {
                                    pifm = $(ifm);
                                    return !1
                                }
                            })
                        }
                    } catch (e) {
                    }
                }
                return pifm
            })(), bootUp, savedXhrSend;
        if (!opts) {
            opts = {}
        }
        if (self.UA.Mobile) {
            $(window).on('orientationchange.' + namespace, function () {
                var a = ((screen && screen.orientation && screen.orientation.angle) || window.orientation || 0) + 0;
                if (a === -90) {
                    a = 270
                }
                self.UA.Angle = a;
                self.UA.Rotated = a % 180 === 0 ? !1 : !0
            }).trigger('orientationchange.' + namespace)
        }
        if (opts.bootCallback && typeof opts.bootCallback === 'function') {
            (function () {
                var func = bootCallback, opFunc = opts.bootCallback;
                bootCallback = function (fm, extraObj) {
                    func && typeof func === 'function' && func.call(this, fm, extraObj);
                    opFunc.call(this, fm, extraObj)
                }
            })()
        }
        delete opts.bootCallback;
        this.api = null;
        this.newAPI = !1;
        this.oldAPI = !1;
        this.netDrivers = [];
        this.baseUrl = '';
        this.i18nBaseUrl = '';
        this.cssloaded = !1;
        this.theme = null;
        this.mimesCanMakeEmpty = {};
        this.bootCallback;
        this.reloadCallback;
        this.id = id;
        this.storage = (function () {
            try {
                if ('localStorage' in window && window.localStorage !== null) {
                    if (self.UA.Safari) {
                        window.localStorage.setItem('elfstoragecheck', 1);
                        window.localStorage.removeItem('elfstoragecheck')
                    }
                    return self.localStorage
                } else {
                    return self.cookie
                }
            } catch (e) {
                return self.cookie
            }
        })();
        this.pauseUnloadCheck = function (state, keep) {
            if (typeof state === 'undefined') {
                return diableUnloadCheck
            } else {
                diableUnloadCheck = !!state;
                if (state && !keep) {
                    requestAnimationFrame(function () {
                        diableUnloadCheck = !1
                    })
                }
            }
        };
        this.options = Object.assign({}, this._options);
        if (opts.uiOptions) {
            if (opts.uiOptions.toolbar && Array.isArray(opts.uiOptions.toolbar)) {
                if ($.isPlainObject(opts.uiOptions.toolbar[opts.uiOptions.toolbar.length - 1])) {
                    self.options.uiOptions.toolbarExtra = Object.assign(self.options.uiOptions.toolbarExtra || {}, opts.uiOptions.toolbar.pop())
                }
            }
        }
        (function () {
            var arrOv = function (obj, base) {
                if ($.isPlainObject(obj)) {
                    $.each(obj, function (k, v) {
                        if ($.isPlainObject(v)) {
                            if (!base[k]) {
                                base[k] = {}
                            }
                            arrOv(v, base[k])
                        } else {
                            base[k] = v
                        }
                    })
                }
            };
            arrOv(opts, self.options)
        })();
        this.options.uiOptions.toolbar.push(this.options.uiOptions.toolbarExtra);
        delete this.options.uiOptions.toolbarExtra;
        this.toUnbindEvents = {};
        this.bind = function (event, callback, priorityFirst) {
            var i, len;
            if (callback && (typeof callback === 'function' || typeof callback.done === 'function')) {
                event = ('' + event).toLowerCase().replace(/^\s+|\s+$/g, '').split(/\s+/);
                len = event.length;
                for (i = 0; i < len; i++) {
                    if (listeners[event[i]] === void(0)) {
                        listeners[event[i]] = []
                    }
                    listeners[event[i]][priorityFirst ? 'unshift' : 'push'](callback)
                }
            }
            return this
        };
        this.unbind = function (event, callback) {
            var i, len, l, ci;
            event = ('' + event).toLowerCase().split(/\s+/);
            len = event.length;
            for (i = 0; i < len; i++) {
                if (l = listeners[event[i]]) {
                    ci = $.inArray(callback, l);
                    ci > -1 && l.splice(ci, 1)
                }
            }
            callback = null;
            return this
        };
        this.trigger = function (evType, data, allowModify) {
            var type = evType.toLowerCase(), isopen = (type === 'open'), dataIsObj = (typeof data === 'object'),
                handlers = listeners[type] || [], dones = [], i, l, jst, event;
            this.debug('event-' + type, data);
            if (!dataIsObj || typeof allowModify === 'undefined') {
                allowModify = !0
            }
            if (l = handlers.length) {
                event = $.Event(type);
                if (data) {
                    data._event = event
                }
                if (allowModify) {
                    event.data = data
                }
                for (i = 0; i < l; i++) {
                    if (!handlers[i]) {
                        continue
                    }
                    if (handlers[i].done) {
                        dones.push(handlers[i].done);
                        continue
                    }
                    if (handlers[i].length) {
                        if (!allowModify) {
                            if (typeof jst === 'undefined') {
                                try {
                                    jst = JSON.stringify(data)
                                } catch (e) {
                                    jst = !1
                                }
                            }
                            event.data = jst ? JSON.parse(jst) : data
                        }
                    }
                    try {
                        if (handlers[i].call(event, event, this) === !1 || event.isDefaultPrevented()) {
                            this.debug('event-stoped', event.type);
                            break
                        }
                    } catch (ex) {
                        window.console && window.console.log && window.console.log(ex)
                    }
                }
                if (l = dones.length) {
                    for (i = 0; i < l; i++) {
                        try {
                            if (dones[i].call(event, event, this) === !1 || event.isDefaultPrevented()) {
                                this.debug('event-stoped', event.type + '(done)');
                                break
                            }
                        } catch (ex) {
                            window.console && window.console.log && window.console.log(ex)
                        }
                    }
                }
                if (this.toUnbindEvents[type] && this.toUnbindEvents[type].length) {
                    $.each(this.toUnbindEvents[type], function (i, v) {
                        self.unbind(v.type, v.callback)
                    });
                    delete this.toUnbindEvents[type]
                }
            }
            return this
        };
        this.getListeners = function (event) {
            return event ? listeners[event.toLowerCase()] : listeners
        };
        this.baseUrl = (function () {
            var myTag, base, baseUrl;
            if (self.options.baseUrl) {
                return self.options.baseUrl
            } else {
                baseUrl = '';
                myTag = null;
                $('head > script').each(function () {
                    if (this.src && this.src.match(/js\/elfinder(?:-[a-z0-9_-]+)?\.(?:min|full)\.js$/i)) {
                        myTag = $(this);
                        return !1
                    }
                });
                if (myTag) {
                    baseUrl = myTag.attr('src').replace(/js\/[^\/]+$/, '');
                    if (!baseUrl.match(/^(https?\/\/|\/)/)) {
                        if (base = $('head > base[href]').attr('href')) {
                            baseUrl = base.replace(/\/$/, '') + '/' + baseUrl
                        }
                    }
                }
                if (baseUrl !== '') {
                    self.options.baseUrl = baseUrl
                } else {
                    if (!self.options.baseUrl) {
                        self.options.baseUrl = './'
                    }
                    baseUrl = self.options.baseUrl
                }
                return baseUrl
            }
        })();
        this.i18nBaseUrl = (this.options.i18nBaseUrl || this.baseUrl + 'js/i18n').replace(/\/$/, '') + '/';
        this.options.maxErrorDialogs = Math.max(1, parseInt(this.options.maxErrorDialogs || 5));
        cwdOptionsDefault.dispInlineRegex = this.options.dispInlineRegex;
        if (this.options.cssAutoLoad) {
            (function () {
                var baseUrl = self.baseUrl,
                    myCss = $('head > link[href$="css/elfinder.min.css"],link[href$="css/elfinder.full.css"]:first').length,
                    rmTag = function () {
                        if (node.data('cssautoloadHide')) {
                            node.data('cssautoloadHide').remove();
                            node.removeData('cssautoloadHide')
                        }
                    }, loaded = function () {
                        if (!self.cssloaded) {
                            rmTag();
                            self.cssloaded = !0;
                            self.trigger('cssloaded')
                        }
                    };
                if (!myCss) {
                    self.cssloaded = null
                }
                if (Array.isArray(self.options.cssAutoLoad)) {
                    if (self.cssloaded === !0) {
                        self.loadCss(self.options.cssAutoLoad)
                    } else {
                        self.bind('cssloaded', function () {
                            self.loadCss(self.options.cssAutoLoad)
                        })
                    }
                }
                if (self.cssloaded === null) {
                    node.addClass('elfinder').data('cssautoloadHide', $('<style>.elfinder{visibility:hidden;overflow:hidden}</style>'));
                    $('head').append(node.data('cssautoloadHide'));
                    if (!self.options.themes.default) {
                        self.options.themes = Object.assign({
                            'default': {
                                'name': 'default',
                                'cssurls': 'css/theme.css',
                                'author': 'elFinder Project',
                                'license': '3-clauses BSD'
                            }
                        }, self.options.themes);
                        if (!self.options.theme) {
                            self.options.theme = 'default'
                        }
                    }
                    requestAnimationFrame(function () {
                        if (node.css('visibility') === 'hidden') {
                            self.loadCss([baseUrl + 'css/elfinder.min.css'], {
                                dfd: $.Deferred().done(function () {
                                    loaded()
                                }).fail(function () {
                                    rmTag();
                                    if (!self.cssloaded) {
                                        self.cssloaded = !1;
                                        self.bind('init', function () {
                                            if (!self.cssloaded) {
                                                self.error(['errRead', 'CSS (elfinder.min)'])
                                            }
                                        })
                                    }
                                })
                            })
                        } else {
                            loaded()
                        }
                    })
                }
            })()
        }
        (function () {
            var theme, themes = self.options.themes, ids = Object.keys(themes || {});
            if (ids.length) {
                theme = self.storage('theme') || self.options.theme;
                if (!themes[theme]) {
                    theme = ids[0]
                }
                if (self.cssloaded) {
                    self.changeTheme(theme)
                } else {
                    self.bind('cssloaded', function () {
                        self.changeTheme(theme)
                    })
                }
            }
        })();
        this.optionProperties = {
            icon: void(0),
            csscls: void(0),
            tmbUrl: void(0),
            uiCmdMap: {},
            netkey: void(0),
            disabled: []
        };
        if (!inFrame && !this.options.enableAlways && $('body').children().length === 2) {
            this.options.enableAlways = !0
        }
        if (this.options.debug === !0) {
            this.options.debug = 'all'
        } else if (Array.isArray(this.options.debug)) {
            (function () {
                var d = {};
                $.each(self.options.debug, function () {
                    d[this] = !0
                });
                self.options.debug = d
            })()
        } else {
            this.options.debug = !1
        }
        this.noConflicts = {};
        this.noConflict = function () {
            $.each(conflictChecks, function (i, p) {
                if ($.fn[p] && typeof $.fn[p].noConflict === 'function') {
                    self.noConflicts[p] = $.fn[p].noConflict()
                }
            })
        };
        this.noConflict();
        this.isCORS = !1;
        (function () {
            if (typeof self.options.cors !== 'undefined' && self.options.cors !== null) {
                self.isCORS = self.options.cors ? !0 : !1
            } else {
                var parseUrl = document.createElement('a'), parseUploadUrl, selfProtocol = window.location.protocol,
                    portReg = function (protocol) {
                        protocol = (!protocol || protocol === ':') ? selfProtocol : protocol;
                        return protocol === 'https:' ? /\:443$/ : /\:80$/
                    }, selfHost = window.location.host.replace(portReg(selfProtocol), '');
                parseUrl.href = opts.url;
                if (opts.urlUpload && (opts.urlUpload !== opts.url)) {
                    parseUploadUrl = document.createElement('a');
                    parseUploadUrl.href = opts.urlUpload
                }
                if (selfHost !== parseUrl.host.replace(portReg(parseUrl.protocol), '') || (parseUrl.protocol !== ':' && parseUrl.protocol !== '' && (selfProtocol !== parseUrl.protocol)) || (parseUploadUrl && (selfHost !== parseUploadUrl.host.replace(portReg(parseUploadUrl.protocol), '') || (parseUploadUrl.protocol !== ':' && parseUploadUrl.protocol !== '' && (selfProtocol !== parseUploadUrl.protocol))))) {
                    self.isCORS = !0
                }
            }
            if (self.isCORS) {
                if (!$.isPlainObject(self.options.customHeaders)) {
                    self.options.customHeaders = {}
                }
                if (!$.isPlainObject(self.options.xhrFields)) {
                    self.options.xhrFields = {}
                }
                self.options.requestType = 'post';
                self.options.customHeaders['X-Requested-With'] = 'XMLHttpRequest';
                self.options.xhrFields.withCredentials = !0
            }
        })();
        this.requestType = /^(get|post)$/i.test(this.options.requestType) ? this.options.requestType.toLowerCase() : 'get';
        requestMaxConn = Math.max(parseInt(this.options.requestMaxConn), 1);
        this.optsCustomData = $.isPlainObject(this.options.customData) ? this.options.customData : {};
        this.customData = Object.assign({}, this.optsCustomData);
        this.prevCustomData = null;
        this.customHeaders = $.isPlainObject(this.options.customHeaders) ? this.options.customHeaders : {};
        this.xhrFields = $.isPlainObject(this.options.xhrFields) ? this.options.xhrFields : {};
        this.replaceXhrSend = function () {
            if (!savedXhrSend) {
                savedXhrSend = XMLHttpRequest.prototype.send
            }
            XMLHttpRequest.prototype.send = function () {
                var xhr = this;
                if (self.customHeaders) {
                    $.each(self.customHeaders, function (key) {
                        xhr.setRequestHeader(key, this)
                    })
                }
                if (self.xhrFields) {
                    $.each(self.xhrFields, function (key) {
                        if (key in xhr) {
                            xhr[key] = this
                        }
                    })
                }
                return savedXhrSend.apply(this, arguments)
            }
        };
        this.restoreXhrSend = function () {
            savedXhrSend && (XMLHttpRequest.prototype.send = savedXhrSend)
        };
        this.abortCmdsOnOpen = this.options.abortCmdsOnOpen || ['tmb', 'parents'];
        this.navPrefix = 'nav' + (elFinder.prototype.uniqueid ? elFinder.prototype.uniqueid : '') + '-';
        this.cwdPrefix = elFinder.prototype.uniqueid ? ('cwd' + elFinder.prototype.uniqueid + '-') : '';
        ++elFinder.prototype.uniqueid;
        this.uploadURL = opts.urlUpload || opts.url;
        this.namespace = namespace;
        this.today = (new Date(date.getFullYear(), date.getMonth(), date.getDate())).getTime() / 1000;
        this.yesterday = this.today - 86400;
        utc = this.options.UTCDate ? 'UTC' : '';
        this.getHours = 'get' + utc + 'Hours';
        this.getMinutes = 'get' + utc + 'Minutes';
        this.getSeconds = 'get' + utc + 'Seconds';
        this.getDate = 'get' + utc + 'Date';
        this.getDay = 'get' + utc + 'Day';
        this.getMonth = 'get' + utc + 'Month';
        this.getFullYear = 'get' + utc + 'FullYear';
        this.zIndex;
        this.searchStatus = {state: 0, query: '', target: '', mime: '', mixed: !1, ininc: !1};
        this.lang = this.storage('lang') || this.options.lang;
        if (this.lang === 'jp') {
            this.lang = this.options.lang = 'ja'
        }
        this.viewType = this.storage('view') || this.options.defaultView || 'icons';
        this.sortType = this.storage('sortType') || this.options.sortType || 'name';
        this.sortOrder = this.storage('sortOrder') || this.options.sortOrder || 'asc';
        this.sortStickFolders = this.storage('sortStickFolders');
        if (this.sortStickFolders === null) {
            this.sortStickFolders = !!this.options.sortStickFolders
        } else {
            this.sortStickFolders = !!this.sortStickFolders
        }
        this.sortAlsoTreeview = this.storage('sortAlsoTreeview');
        if (this.sortAlsoTreeview === null || this.options.sortAlsoTreeview === null) {
            this.sortAlsoTreeview = !!this.options.sortAlsoTreeview
        } else {
            this.sortAlsoTreeview = !!this.sortAlsoTreeview
        }
        this.sortRules = $.extend(!0, {}, this._sortRules, this.options.sortRules);
        $.each(this.sortRules, function (name, method) {
            if (typeof method != 'function') {
                delete self.sortRules[name]
            }
        });
        this.compare = $.proxy(this.compare, this);
        this.notifyDelay = this.options.notifyDelay > 0 ? parseInt(this.options.notifyDelay) : 500;
        this.draggingUiHelper = null;
        this.droppable = {
            greedy: !0,
            tolerance: 'pointer',
            accept: '.elfinder-cwd-file-wrapper,.elfinder-navbar-dir,.elfinder-cwd-file,.elfinder-cwd-filename',
            hoverClass: this.res('class', 'adroppable'),
            classes: {'ui-droppable-hover': this.res('class', 'adroppable')},
            autoDisable: !0,
            drop: function (e, ui) {
                var dst = $(this), targets = $.grep(ui.helper.data('files') || [], function (h) {
                        return h ? !0 : !1
                    }), result = [], dups = [], faults = [], isCopy = ui.helper.hasClass('elfinder-drag-helper-plus'),
                    c = 'class', cnt, hash, i, h;
                if (typeof e.button === 'undefined' || ui.helper.data('namespace') !== namespace || !self.insideWorkzone(e.pageX, e.pageY)) {
                    return !1
                }
                if (dst.hasClass(self.res(c, 'cwdfile'))) {
                    hash = self.cwdId2Hash(dst.attr('id'))
                } else if (dst.hasClass(self.res(c, 'navdir'))) {
                    hash = self.navId2Hash(dst.attr('id'))
                } else {
                    hash = cwd
                }
                cnt = targets.length;
                while (cnt--) {
                    h = targets[cnt];
                    if (h != hash && files[h].phash != hash) {
                        result.push(h)
                    } else {
                        ((isCopy && h !== hash && files[hash].write) ? dups : faults).push(h)
                    }
                }
                if (faults.length) {
                    return !1
                }
                ui.helper.data('droped', !0);
                if (dups.length) {
                    ui.helper.hide();
                    self.exec('duplicate', dups, {_userAction: !0})
                }
                if (result.length) {
                    ui.helper.hide();
                    self.clipboard(result, !isCopy);
                    self.exec('paste', hash, {_userAction: !0}, hash).always(function () {
                        self.clipboard([]);
                        self.trigger('unlockfiles', {files: targets})
                    });
                    self.trigger('drop', {files: targets})
                }
            }
        };
        this.enabled = function () {
            return enabled && this.visible()
        };
        this.visible = function () {
            return node[0].elfinder && node.is(':visible')
        };
        this.isRoot = function (file) {
            return (file.isroot || !file.phash) ? !0 : !1
        };
        this.root = function (hash, fake) {
            hash = hash || cwd;
            var dir, i;
            if (!fake) {
                $.each(self.roots, function (id, rhash) {
                    if (hash.indexOf(id) === 0) {
                        dir = rhash;
                        return !1
                    }
                });
                if (dir) {
                    return dir
                }
            }
            dir = files[hash];
            while (dir && dir.phash && (fake || !dir.isroot)) {
                dir = files[dir.phash]
            }
            if (dir) {
                return dir.hash
            }
            while (i in files && files.hasOwnProperty(i)) {
                dir = files[i];
                if (dir.mime === 'directory' && !dir.phash && dir.read) {
                    return dir.hash
                }
            }
            return ''
        };
        this.cwd = function () {
            return files[cwd] || {}
        };
        this.option = function (name, target) {
            var res, item;
            target = target || cwd;
            if (self.optionsByHashes[target] && typeof self.optionsByHashes[target][name] !== 'undefined') {
                return self.optionsByHashes[target][name]
            }
            if (self.hasVolOptions && cwd !== target && (!(item = self.file(target)) || item.phash !== cwd)) {
                res = '';
                $.each(self.volOptions, function (id, opt) {
                    if (target.indexOf(id) === 0) {
                        res = opt[name] || '';
                        return !1
                    }
                });
                return res
            } else {
                return cwdOptions[name] || ''
            }
        };
        this.getDisabledCmds = function (targets, flip) {
            var disabled = {'hidden': !0};
            if (!Array.isArray(targets)) {
                targets = [targets]
            }
            $.each(targets, function (i, h) {
                var disCmds = self.option('disabledFlip', h);
                if (disCmds) {
                    Object.assign(disabled, disCmds)
                }
            });
            return flip ? disabled : Object.keys(disabled)
        };
        this.file = function (hash, alsoHidden) {
            return hash ? (files[hash] || (alsoHidden ? hiddenFiles[hash] : void(0))) : void(0)
        };
        this.files = function (phash) {
            var items = {};
            if (phash) {
                if (!ownFiles[phash]) {
                    return {}
                }
                $.each(ownFiles[phash], function (h) {
                    if (files[h]) {
                        items[h] = files[h]
                    } else {
                        delete ownFiles[phash][h]
                    }
                });
                return Object.assign({}, items)
            }
            return Object.assign({}, files)
        };
        this.parents = function (hash) {
            var parents = [], dir;
            while (hash && (dir = this.file(hash))) {
                parents.unshift(dir.hash);
                hash = dir.phash
            }
            return parents
        };
        this.path2array = function (hash, i18) {
            var file, path = [];
            while (hash) {
                if ((file = files[hash]) && file.hash) {
                    path.unshift(i18 && file.i18 ? file.i18 : file.name);
                    hash = file.isroot ? null : file.phash
                } else {
                    path = [];
                    break
                }
            }
            return path
        };
        this.path = function (hash, i18, asyncOpt) {
            var path = files[hash] && files[hash].path ? files[hash].path : this.path2array(hash, i18).join(cwdOptions.separator);
            if (!asyncOpt || !files[hash]) {
                return path
            } else {
                asyncOpt = Object.assign({notify: {type: 'parents', cnt: 1, hideCnt: !0}}, asyncOpt);
                var dfd = $.Deferred(), notify = asyncOpt.notify, noreq = !1, req = function () {
                    self.request({
                        data: {cmd: 'parents', target: files[hash].phash},
                        notify: notify,
                        preventFail: !0
                    }).done(done).fail(function () {
                        dfd.reject()
                    })
                }, done = function () {
                    self.one('parentsdone', function () {
                        path = self.path(hash, i18);
                        if (path === '' && noreq) {
                            noreq = !1;
                            req()
                        } else {
                            if (notify) {
                                clearTimeout(ntftm);
                                notify.cnt = -(parseInt(notify.cnt || 0));
                                self.notify(notify)
                            }
                            dfd.resolve(path)
                        }
                    })
                }, ntftm;
                if (path) {
                    return dfd.resolve(path)
                } else {
                    if (self.ui.tree) {
                        if (notify) {
                            ntftm = setTimeout(function () {
                                self.notify(notify)
                            }, self.notifyDelay)
                        }
                        noreq = !0;
                        done(!0)
                    } else {
                        req()
                    }
                    return dfd
                }
            }
        };
        this.url = function (hash, o) {
            var file = files[hash], opts = o || {}, async = opts.async || !1, temp = opts.temporary || !1,
                onetm = (opts.onetime && self.option('onetimeUrl', hash)) || !1, absurl = opts.absurl || !1,
                dfrd = (async || onetm) ? $.Deferred() : null, filter = function (url) {
                    if (url && absurl) {
                        url = self.convAbsUrl(url)
                    }
                    return url
                }, getUrl = function (url) {
                    if (url) {
                        return filter(url)
                    }
                    if (file.url) {
                        return filter(file.url)
                    }
                    if (typeof baseUrl === 'undefined') {
                        baseUrl = self.option('url', (!self.isRoot(file) && file.phash) || file.hash)
                    }
                    if (baseUrl) {
                        return filter(baseUrl + $.map(self.path2array(hash), function (n) {
                            return encodeURIComponent(n)
                        }).slice(1).join('/'))
                    }
                    var params = Object.assign({}, self.customData, {cmd: 'file', target: file.hash});
                    if (self.oldAPI) {
                        params.cmd = 'open';
                        params.current = file.phash
                    }
                    return filter(self.options.url + (self.options.url.indexOf('?') === -1 ? '?' : '&') + $.param(params, !0))
                }, baseUrl, res;
            if (!file || !file.read) {
                return async ? dfrd.resolve('') : ''
            }
            if (onetm) {
                async = !0;
                this.request({
                    data: {cmd: 'url', target: hash, options: {onetime: 1}},
                    preventDefault: !0,
                    options: {async: async},
                    notify: {type: 'file', cnt: 1, hideCnt: !0}
                }).done(function (data) {
                    dfrd.resolve(filter(data.url || ''))
                }).fail(function () {
                    dfrd.resolve('')
                })
            } else {
                if (file.url == '1' || (temp && !file.url && !(baseUrl = self.option('url', (!self.isRoot(file) && file.phash) || file.hash)))) {
                    this.request({
                        data: {cmd: 'url', target: hash, options: {temporary: temp ? 1 : 0}},
                        preventDefault: !0,
                        options: {async: async},
                        notify: async ? {type: temp ? 'file' : 'url', cnt: 1, hideCnt: !0} : {}
                    }).done(function (data) {
                        file.url = data.url || ''
                    }).fail(function () {
                        file.url = ''
                    }).always(function () {
                        var url;
                        if (file.url && temp) {
                            url = file.url;
                            file.url = '1'
                        }
                        if (async) {
                            dfrd.resolve(getUrl(url))
                        } else {
                            return getUrl(url)
                        }
                    })
                } else {
                    if (async) {
                        dfrd.resolve(getUrl())
                    } else {
                        return getUrl()
                    }
                }
            }
            if (async) {
                return dfrd
            }
        };
        this.forExternalUrl = function (hash, options) {
            var onetime = self.option('onetimeUrl', hash), opts = {async: !0, absurl: !0};
            opts[onetime ? 'onetime' : 'temporary'] = !0;
            return self.url(hash, Object.assign({}, options, opts))
        };
        this.openUrl = function (hash, download) {
            var file = files[hash], url = '';
            if (!file || !file.read) {
                return ''
            }
            if (!download) {
                if (file.url) {
                    if (file.url != 1) {
                        url = file.url
                    }
                } else if (cwdOptions.url && file.hash.indexOf(self.cwd().volumeid) === 0) {
                    url = cwdOptions.url + $.map(this.path2array(hash), function (n) {
                        return encodeURIComponent(n)
                    }).slice(1).join('/')
                }
                if (url) {
                    url += (url.match(/\?/) ? '&' : '?') + '_'.repeat((url.match(/[\?&](_+)t=/g) || ['&t=']).sort().shift().match(/[\?&](_*)t=/)[1].length + 1) + 't=' + (file.ts || parseInt(+new Date() / 1000));
                    return url
                }
            }
            url = this.options.url;
            url = url + (url.indexOf('?') === -1 ? '?' : '&') + (this.oldAPI ? 'cmd=open&current=' + file.phash : 'cmd=file') + '&target=' + file.hash + '&_t=' + (file.ts || parseInt(+new Date() / 1000));
            if (download) {
                url += '&download=1'
            }
            $.each(this.customData, function (key, val) {
                url += '&' + encodeURIComponent(key) + '=' + encodeURIComponent(val)
            });
            return url
        };
        this.tmb = function (file) {
            var tmbUrl, tmbCrop, cls = 'elfinder-cwd-bgurl', url = '';
            if ($.isPlainObject(file)) {
                if (self.searchStatus.state && file.hash.indexOf(self.cwd().volumeid) !== 0) {
                    tmbUrl = self.option('tmbUrl', file.hash);
                    tmbCrop = self.option('tmbCrop', file.hash)
                } else {
                    tmbUrl = cwdOptions.tmbUrl;
                    tmbCrop = cwdOptions.tmbCrop
                }
                if (tmbCrop) {
                    cls += ' elfinder-cwd-bgurl-crop'
                }
                if (tmbUrl === 'self' && file.mime.indexOf('image/') === 0) {
                    url = self.openUrl(file.hash);
                    cls += ' elfinder-cwd-bgself'
                } else if ((self.oldAPI || tmbUrl) && file && file.tmb && file.tmb != 1) {
                    url = tmbUrl + file.tmb
                } else if (self.newAPI && file && file.tmb && file.tmb != 1) {
                    url = file.tmb
                }
                if (url) {
                    if (file.ts && tmbUrl !== 'self') {
                        url += (url.match(/\?/) ? '&' : '?') + '_t=' + file.ts
                    }
                    return {url: url, className: cls}
                }
            }
            return !1
        };
        this.selected = function () {
            return selected.slice(0)
        };
        this.selectedFiles = function () {
            return $.map(selected, function (hash) {
                return files[hash] ? Object.assign({}, files[hash]) : null
            })
        };
        this.fileByName = function (name, phash) {
            var hash;
            for (hash in files) {
                if (files.hasOwnProperty(hash) && files[hash].phash == phash && files[hash].name == name) {
                    return files[hash]
                }
            }
        };
        this.validResponse = function (cmd, data) {
            return data.error || this.rules[this.rules[cmd] ? cmd : 'defaults'](data)
        };
        this.returnBytes = function (val) {
            var last;
            if (isNaN(val)) {
                if (!val) {
                    val = ''
                }
                val = val.replace(/b$/i, '');
                last = val.charAt(val.length - 1).toLowerCase();
                val = val.replace(/[tgmk]$/i, '');
                if (last == 't') {
                    val = val * 1024 * 1024 * 1024 * 1024
                } else if (last == 'g') {
                    val = val * 1024 * 1024 * 1024
                } else if (last == 'm') {
                    val = val * 1024 * 1024
                } else if (last == 'k') {
                    val = val * 1024
                }
                val = isNaN(val) ? 0 : parseInt(val)
            } else {
                val = parseInt(val);
                if (val < 1) val = 0
            }
            return val
        };
        this.request = function (opts) {
            var self = this, o = this.options, dfrd = $.Deferred(),
                reqId = (+new Date()).toString(16) + Math.floor(1000 * Math.random()).toString(16),
                data = Object.assign({}, self.customData, {mimes: o.onlyMimes}, opts.data || opts), cmd = data.cmd,
                isBinary = (opts.options || {}).dataType === 'binary', isOpen = (!opts.asNotOpen && cmd === 'open'),
                deffail = !(isBinary || opts.preventDefault || opts.preventFail),
                defdone = !(isBinary || opts.preventDefault || opts.preventDone),
                notify = Object.assign({}, opts.notify), cancel = !!opts.cancel, raw = isBinary || !!opts.raw,
                syncOnFail = opts.syncOnFail, lazy = !!opts.lazy, prepare = opts.prepare, navigate = opts.navigate,
                timeout, useCache = (opts.options || {}).cache, options = Object.assign({
                    url: o.url,
                    async: !0,
                    type: this.requestType,
                    dataType: 'json',
                    cache: (self.api >= 2.1029),
                    data: data,
                    headers: this.customHeaders,
                    xhrFields: this.xhrFields
                }, opts.options || {}), done = function (data) {
                    data.warning && self.error(data.warning);
                    if (isOpen) {
                        open(data)
                    } else {
                        self.updateCache(data)
                    }
                    data.changed && data.changed.length && change(data.changed);
                    self.lazy(function () {
                        data.removed && data.removed.length && self.remove(data);
                        data.added && data.added.length && self.add(data);
                        data.changed && data.changed.length && self.change(data)
                    }).then(function () {
                        return self.lazy(function () {
                            self.trigger(cmd, data, !1)
                        })
                    }).then(function () {
                        return self.lazy(function () {
                            self.trigger(cmd + 'done')
                        })
                    }).then(function () {
                        if (data.toasts && Array.isArray(data.toasts)) {
                            $.each(data.toasts, function () {
                                this.msg && self.toast(this)
                            })
                        }
                        data.sync && self.sync()
                    })
                }, error = function (xhr, status) {
                    var error, data, d = self.options.debug;
                    switch (status) {
                        case 'abort':
                            error = xhr.quiet ? '' : ['errConnect', 'errAbort'];
                            break;
                        case 'timeout':
                            error = ['errConnect', 'errTimeout'];
                            break;
                        case 'parsererror':
                            error = ['errResponse', 'errDataNotJSON'];
                            if (xhr.responseText) {
                                if (!cwd || (d && (d === 'all' || d['backend-error']))) {
                                    error.push(xhr.responseText)
                                }
                            }
                            break;
                        default:
                            if (xhr.responseText) {
                                try {
                                    data = JSON.parse(xhr.responseText);
                                    if (data && data.error) {
                                        error = data.error
                                    }
                                } catch (e) {
                                }
                            }
                            if (!error) {
                                if (xhr.status == 403) {
                                    error = ['errConnect', 'errAccess', 'HTTP error ' + xhr.status]
                                } else if (xhr.status == 404) {
                                    error = ['errConnect', 'errNotFound', 'HTTP error ' + xhr.status]
                                } else if (xhr.status >= 500) {
                                    error = ['errResponse', 'errServerError', 'HTTP error ' + xhr.status]
                                } else {
                                    if (xhr.status == 414 && options.type === 'get') {
                                        options.type = 'post';
                                        self.abortXHR(xhr);
                                        dfrd.xhr = xhr = self.transport.send(options).fail(error).done(success);
                                        return
                                    }
                                    error = xhr.quiet ? '' : ['errConnect', 'HTTP error ' + xhr.status]
                                }
                            }
                    }
                    self.trigger(cmd + 'done');
                    dfrd.reject({error: error}, xhr, status)
                }, success = function (response) {
                    var d = self.options.debug;
                    self.currentReqCmd = cmd;
                    if (response.debug && (!d || d !== 'all')) {
                        if (!d) {
                            d = self.options.debug = {}
                        }
                        d['backend-error'] = !0;
                        d.warning = !0
                    }
                    if (raw) {
                        self.abortXHR(xhr);
                        response && response.debug && self.debug('backend-debug', response);
                        return dfrd.resolve(response)
                    }
                    if (!response) {
                        return dfrd.reject({error: ['errResponse', 'errDataEmpty']}, xhr, response)
                    } else if (!$.isPlainObject(response)) {
                        return dfrd.reject({error: ['errResponse', 'errDataNotJSON']}, xhr, response)
                    } else if (response.error) {
                        if (isOpen) {
                            $.each(self.leafRoots, function (phash, roots) {
                                self.leafRoots[phash] = $.grep(roots, function (h) {
                                    return h !== data.target
                                })
                            })
                        }
                        return dfrd.reject({error: response.error}, xhr, response)
                    }
                    var resolve = function () {
                        var pushLeafRoots = function (name) {
                            if (self.leafRoots[data.target] && response[name]) {
                                $.each(self.leafRoots[data.target], function (i, h) {
                                    var root;
                                    if (root = self.file(h)) {
                                        response[name].push(root)
                                    }
                                })
                            }
                        }, setTextMimes = function () {
                            self.textMimes = {};
                            $.each(self.res('mimes', 'text'), function () {
                                self.textMimes[this.toLowerCase()] = !0
                            })
                        }, actionTarget;
                        if (isOpen) {
                            pushLeafRoots('files')
                        } else if (cmd === 'tree') {
                            pushLeafRoots('tree')
                        }
                        response = self.normalize(response);
                        if (!self.validResponse(cmd, response)) {
                            return dfrd.reject({error: (response.norError || 'errResponse')}, xhr, response)
                        }
                        if (isOpen) {
                            if (!self.api) {
                                self.api = response.api || 1;
                                if (self.api == '2.0' && typeof response.options.uploadMaxSize !== 'undefined') {
                                    self.api = '2.1'
                                }
                                self.newAPI = self.api >= 2;
                                self.oldAPI = !self.newAPI
                            }
                            if (response.textMimes && Array.isArray(response.textMimes)) {
                                self.resources.mimes.text = response.textMimes;
                                setTextMimes()
                            }
                            !self.textMimes && setTextMimes();
                            if (response.options) {
                                cwdOptions = Object.assign({}, cwdOptionsDefault, response.options)
                            }
                            if (response.netDrivers) {
                                self.netDrivers = response.netDrivers
                            }
                            if (response.maxTargets) {
                                self.maxTargets = response.maxTargets
                            }
                            if (!!data.init) {
                                self.uplMaxSize = self.returnBytes(response.uplMaxSize);
                                self.uplMaxFile = !!response.uplMaxFile ? Math.min(parseInt(response.uplMaxFile), 50) : 20
                            }
                        }
                        if (typeof prepare === 'function') {
                            prepare(response)
                        }
                        if (navigate) {
                            actionTarget = navigate.target || 'added';
                            if (response[actionTarget] && response[actionTarget].length) {
                                self.one(cmd + 'done', function () {
                                    var targets = response[actionTarget], newItems = self.findCwdNodes(targets),
                                        inCwdHashes = function () {
                                            var cwdHash = self.cwd().hash;
                                            return $.map(targets, function (f) {
                                                return (f.phash && cwdHash === f.phash) ? f.hash : null
                                            })
                                        }, hashes = inCwdHashes(), makeToast = function (t) {
                                            var node = void(0), data = t.action ? t.action.data : void(0), cmd, msg, done;
                                            if ((data || hashes.length) && t.action && (msg = t.action.msg) && (cmd = t.action.cmd) && (!t.action.cwdNot || t.action.cwdNot !== self.cwd().hash)) {
                                                done = t.action.done;
                                                data = t.action.data;
                                                node = $('<div/>').append($('<button type="button" class="ui-button ui-widget ui-state-default ui-corner-all elfinder-tabstop"><span class="ui-button-text">' + self.i18n(msg) + '</span></button>').on('mouseenter mouseleave', function (e) {
                                                    $(this).toggleClass('ui-state-hover', e.type == 'mouseenter')
                                                }).on('click', function () {
                                                    self.exec(cmd, data || hashes, {
                                                        _userAction: !0,
                                                        _currentType: 'toast',
                                                        _currentNode: $(this)
                                                    });
                                                    if (done) {
                                                        self.one(cmd + 'done', function () {
                                                            if (typeof done === 'function') {
                                                                done()
                                                            } else if (done === 'select') {
                                                                self.trigger('selectfiles', {files: inCwdHashes()})
                                                            }
                                                        })
                                                    }
                                                }))
                                            }
                                            delete t.action;
                                            t.extNode = node;
                                            return t
                                        };
                                    if (!navigate.toast) {
                                        navigate.toast = {}
                                    }
                                    !navigate.noselect && self.trigger('selectfiles', {
                                        files: self.searchStatus.state > 1 ? $.map(targets, function (f) {
                                            return f.hash
                                        }) : hashes
                                    });
                                    if (newItems.length) {
                                        if (!navigate.noscroll) {
                                            newItems.first().trigger('scrolltoview', {blink: !1});
                                            self.resources.blink(newItems, 'lookme')
                                        }
                                        if ($.isPlainObject(navigate.toast.incwd)) {
                                            self.toast(makeToast(navigate.toast.incwd))
                                        }
                                    } else {
                                        if ($.isPlainObject(navigate.toast.inbuffer)) {
                                            self.toast(makeToast(navigate.toast.inbuffer))
                                        }
                                    }
                                })
                            }
                        }
                        dfrd.resolve(response);
                        response.debug && self.debug('backend-debug', response)
                    };
                    self.abortXHR(xhr);
                    lazy ? self.lazy(resolve) : resolve()
                }, xhr, _xhr, xhrAbort = function (e) {
                    if (xhr && xhr.state() === 'pending') {
                        self.abortXHR(xhr, {quiet: !0, abort: !0});
                        if (!e || (e.type !== 'unload' && e.type !== 'destroy')) {
                            self.autoSync()
                        }
                    }
                }, abort = function (e) {
                    self.trigger(cmd + 'done');
                    if (e.type == 'autosync') {
                        if (e.data.action != 'stop') return
                    } else if (e.type != 'unload' && e.type != 'destroy' && e.type != 'openxhrabort') {
                        if (!e.data.added || !e.data.added.length) {
                            return
                        }
                    }
                    xhrAbort(e)
                }, request = function (mode) {
                    var queueAbort = function () {
                        syncOnFail = !1;
                        dfrd.reject()
                    };
                    if (mode) {
                        if (mode === 'cmd') {
                            return cmd
                        }
                    }
                    if (isOpen) {
                        if (requestQueueSkipOpen) {
                            return dfrd.reject()
                        }
                        requestQueueSkipOpen = !0
                    }
                    dfrd.always(function () {
                        delete options.headers['X-elFinderReqid']
                    }).fail(function (error, xhr, response) {
                        var errData = {cmd: cmd, err: error, xhr: xhr, rc: response};
                        if (error === 0) {
                            if (requestQueue.length) {
                                requestQueue = $.grep(requestQueue, function (req) {
                                    return (req('cmd') === cmd) ? !1 : !0
                                })
                            }
                        }
                        self.trigger('requestError', errData);
                        if (errData._event && errData._event.isDefaultPrevented()) {
                            deffail = !1;
                            syncOnFail = !1;
                            if (error) {
                                error.error = ''
                            }
                        }
                        xhrAbort();
                        if (isOpen) {
                            openDir = self.file(data.target);
                            openDir && openDir.volumeid && self.isRoot(openDir) && delete self.volumeExpires[openDir.volumeid]
                        }
                        self.trigger(cmd + 'fail', response);
                        if (error) {
                            deffail ? self.error(error) : self.debug('error', self.i18n(error))
                        }
                        syncOnFail && self.sync()
                    });
                    if (!cmd) {
                        syncOnFail = !1;
                        return dfrd.reject({error: 'errCmdReq'})
                    }
                    if (self.maxTargets && data.targets && data.targets.length > self.maxTargets) {
                        syncOnFail = !1;
                        return dfrd.reject({error: ['errMaxTargets', self.maxTargets]})
                    }
                    defdone && dfrd.done(done);
                    if (isOpen) {
                        while ((_xhr = queue.pop())) {
                            _xhr.queueAbort()
                        }
                        if (cwd !== data.target) {
                            while ((_xhr = cwdQueue.pop())) {
                                _xhr.queueAbort()
                            }
                        }
                    }
                    if ($.inArray(cmd, (self.cmdsToAdd + ' autosync').split(' ')) !== -1) {
                        if (cmd !== 'autosync') {
                            self.autoSync('stop');
                            dfrd.always(function () {
                                self.autoSync()
                            })
                        }
                        self.trigger('openxhrabort')
                    }
                    delete options.preventFail;
                    if (self.api >= 2.1029) {
                        if (useCache) {
                            options.headers['X-elFinderReqid'] = reqId
                        } else {
                            Object.assign(options.data, {reqid: reqId})
                        }
                    }
                    dfrd.syncOnFail = function (state) {
                        syncOnFail = !!state
                    };
                    requestCnt++;
                    dfrd.xhr = xhr = self.transport.send(options).always(function () {
                        if (options._xhr && typeof options._xhr.responseURL !== 'undefined') {
                            xhr.responseURL = options._xhr.responseURL || ''
                        }
                        --requestCnt;
                        if (requestQueue.length) {
                            requestQueue.shift()()
                        } else {
                            requestQueueSkipOpen = !1
                        }
                    }).fail(error).done(success);
                    if (self.api >= 2.1029) {
                        xhr._requestId = reqId
                    }
                    if (isOpen || (data.compare && cmd === 'info')) {
                        xhr.queueAbort = queueAbort;
                        queue.unshift(xhr);
                        data.compare && self.bind(self.cmdsToAdd + ' autosync openxhrabort', abort);
                        dfrd.always(function () {
                            var ndx = $.inArray(xhr, queue);
                            data.compare && self.unbind(self.cmdsToAdd + ' autosync openxhrabort', abort);
                            ndx !== -1 && queue.splice(ndx, 1)
                        })
                    } else if ($.inArray(cmd, self.abortCmdsOnOpen) !== -1) {
                        xhr.queueAbort = queueAbort;
                        cwdQueue.unshift(xhr);
                        dfrd.always(function () {
                            var ndx = $.inArray(xhr, cwdQueue);
                            ndx !== -1 && cwdQueue.splice(ndx, 1)
                        })
                    }
                    self.bind('unload destroy', abort);
                    dfrd.always(function () {
                        self.unbind('unload destroy', abort)
                    });
                    return dfrd
                }, queueingRequest = function () {
                    if (notify.type && notify.cnt) {
                        if (cancel) {
                            notify.cancel = dfrd;
                            opts.eachCancel && (notify.id = +new Date())
                        }
                        timeout = setTimeout(function () {
                            self.notify(notify);
                            dfrd.always(function () {
                                notify.cnt = -(parseInt(notify.cnt) || 0);
                                self.notify(notify)
                            })
                        }, self.notifyDelay);
                        dfrd.always(function () {
                            clearTimeout(timeout)
                        })
                    }
                    if (isOpen) {
                        requestQueueSkipOpen = !1
                    }
                    if (requestCnt < requestMaxConn) {
                        return request()
                    } else {
                        if (isOpen) {
                            requestQueue.unshift(request)
                        } else {
                            requestQueue.push(request)
                        }
                        return dfrd
                    }
                }, bindData = {opts: opts, result: !0}, openDir;
            if (!self.api && !data.init) {
                syncOnFail = !1;
                return dfrd.reject()
            }
            self.trigger('request.' + cmd, bindData, !0);
            if (!bindData.result) {
                self.trigger(cmd + 'done');
                return dfrd.reject()
            } else if (typeof bindData.result === 'object' && bindData.result.promise) {
                bindData.result.done(queueingRequest).fail(function () {
                    self.trigger(cmd + 'done');
                    dfrd.reject()
                });
                return dfrd
            }
            return queueingRequest()
        };
        this.cache = function (dataArray) {
            if (!Array.isArray(dataArray)) {
                dataArray = [dataArray]
            }
            cache(dataArray)
        };
        this.updateCache = function (data) {
            if ($.isPlainObject(data)) {
                data.files && data.files.length && cache(data.files, 'files');
                data.tree && data.tree.length && cache(data.tree, 'tree');
                data.removed && data.removed.length && remove(data.removed);
                data.added && data.added.length && cache(data.added, 'add');
                data.changed && data.changed.length && change(data.changed, 'change')
            }
        };
        this.diff = function (incoming, onlydir, excludeProps) {
            var raw = {}, added = [], removed = [], changed = [], excludes = null, isChanged = function (hash) {
                var l = changed.length;
                while (l--) {
                    if (changed[l].hash == hash) {
                        return !0
                    }
                }
            };
            $.each(incoming, function (i, f) {
                raw[f.hash] = f
            });
            if (excludeProps && excludeProps.length) {
                excludes = {};
                $.each(excludeProps, function () {
                    excludes[this] = !0
                })
            }
            $.each(files, function (hash, f) {
                if (!raw[hash] && (!onlydir || f.phash === onlydir)) {
                    removed.push(hash)
                }
            });
            $.each(raw, function (hash, file) {
                var origin = files[hash], orgKeys = {}, chkKeyLen;
                if (!origin) {
                    added.push(file)
                } else {
                    $.each(Object.keys(origin), function () {
                        orgKeys[this] = !0
                    });
                    $.each(file, function (prop) {
                        delete orgKeys[prop];
                        if (!excludes || !excludes[prop]) {
                            if (file[prop] !== origin[prop]) {
                                changed.push(file);
                                orgKeys = {};
                                return !1
                            }
                        }
                    });
                    chkKeyLen = Object.keys(orgKeys).length;
                    if (chkKeyLen !== 0) {
                        if (excludes) {
                            $.each(orgKeys, function (prop) {
                                if (excludes[prop]) {
                                    --chkKeyLen
                                }
                            })
                        }
                        (chkKeyLen !== 0) && changed.push(file)
                    }
                }
            });
            $.each(removed, function (i, hash) {
                var file = files[hash], phash = file.phash;
                if (phash && file.mime == 'directory' && $.inArray(phash, removed) === -1 && raw[phash] && !isChanged(phash)) {
                    changed.push(raw[phash])
                }
            });
            return {added: added, removed: removed, changed: changed}
        };
        this.sync = function (onlydir, polling) {
            this.autoSync('stop');
            var self = this, compare = function () {
                var c = '', cnt = 0, mtime = 0;
                if (onlydir && polling) {
                    $.each(files, function (h, f) {
                        if (f.phash && f.phash === onlydir) {
                            ++cnt;
                            mtime = Math.max(mtime, f.ts)
                        }
                        c = cnt + ':' + mtime
                    })
                }
                return c
            }, comp = compare(), dfrd = $.Deferred().done(function () {
                self.trigger('sync')
            }), opts = [this.request({
                data: {
                    cmd: 'open',
                    reload: 1,
                    target: cwd,
                    tree: (!onlydir && this.ui.tree) ? 1 : 0,
                    compare: comp
                }, preventDefault: !0
            })], exParents = function () {
                var parents = [], curRoot = self.file(self.root(cwd)), curId = curRoot ? curRoot.volumeid : null,
                    phash = self.cwd().phash, isroot, pdir;
                while (phash) {
                    if (pdir = self.file(phash)) {
                        if (phash.indexOf(curId) !== 0) {
                            parents.push({target: phash, cmd: 'tree'});
                            if (!self.isRoot(pdir)) {
                                parents.push({target: phash, cmd: 'parents'})
                            }
                            curRoot = self.file(self.root(phash));
                            curId = curRoot ? curRoot.volumeid : null
                        }
                        phash = pdir.phash
                    } else {
                        phash = null
                    }
                }
                return parents
            };
            if (!onlydir && self.api >= 2) {
                (cwd !== this.root()) && opts.push(this.request({
                    data: {cmd: 'parents', target: cwd},
                    preventDefault: !0
                }));
                $.each(exParents(), function (i, data) {
                    opts.push(self.request({data: {cmd: data.cmd, target: data.target}, preventDefault: !0}))
                })
            }
            $.when.apply($, opts).fail(function (error, xhr) {
                if (!polling || $.inArray('errOpen', error) !== -1) {
                    dfrd.reject(error);
                    self.parseError(error) && self.request({
                        data: {
                            cmd: 'open',
                            target: (self.lastDir('') || self.root()),
                            tree: 1,
                            init: 1
                        }, notify: {type: 'open', cnt: 1, hideCnt: !0}
                    })
                } else {
                    dfrd.reject((error && xhr.status != 0) ? error : void 0)
                }
            }).done(function (odata) {
                var pdata, argLen, i;
                if (odata.cwd.compare) {
                    if (comp === odata.cwd.compare) {
                        return dfrd.reject()
                    }
                }
                pdata = {tree: []};
                argLen = arguments.length;
                if (argLen > 1) {
                    for (i = 1; i < argLen; i++) {
                        if (arguments[i].tree && arguments[i].tree.length) {
                            pdata.tree.push.apply(pdata.tree, arguments[i].tree)
                        }
                    }
                }
                if (self.api < 2.1) {
                    if (!pdata.tree) {
                        pdata.tree = []
                    }
                    pdata.tree.push(odata.cwd)
                }
                odata = self.normalize(odata);
                if (!self.validResponse('open', odata)) {
                    return dfrd.reject((odata.norError || 'errResponse'))
                }
                pdata = self.normalize(pdata);
                if (!self.validResponse('tree', pdata)) {
                    return dfrd.reject((pdata.norError || 'errResponse'))
                }
                var diff = self.diff(odata.files.concat(pdata && pdata.tree ? pdata.tree : []), onlydir);
                diff.added.push(odata.cwd);
                self.updateCache(diff);
                diff.removed.length && self.remove(diff);
                diff.added.length && self.add(diff);
                diff.changed.length && self.change(diff);
                return dfrd.resolve(diff)
            }).always(function () {
                self.autoSync()
            });
            return dfrd
        };
        this.upload = function (files) {
            return this.transport.upload(files, this)
        };
        this.shortcut = function (s) {
            var patterns, pattern, code, i, parts;
            if (this.options.allowShortcuts && s.pattern && $.isFunction(s.callback)) {
                patterns = s.pattern.toUpperCase().split(/\s+/);
                for (i = 0; i < patterns.length; i++) {
                    pattern = patterns[i];
                    parts = pattern.split('+');
                    code = (code = parts.pop()).length == 1 ? (code > 0 ? code : code.charCodeAt(0)) : (code > 0 ? code : $.ui.keyCode[code]);
                    if (code && !shortcuts[pattern]) {
                        shortcuts[pattern] = {
                            keyCode: code,
                            altKey: $.inArray('ALT', parts) != -1,
                            ctrlKey: $.inArray('CTRL', parts) != -1,
                            shiftKey: $.inArray('SHIFT', parts) != -1,
                            type: s.type || 'keydown',
                            callback: s.callback,
                            description: s.description,
                            pattern: pattern
                        }
                    }
                }
            }
            return this
        };
        this.shortcuts = function () {
            var ret = [];
            $.each(shortcuts, function (i, s) {
                ret.push([s.pattern, self.i18n(s.description)])
            });
            return ret
        };
        this.clipboard = function (hashes, cut) {
            var map = function () {
                return $.map(clipboard, function (f) {
                    return f.hash
                })
            };
            if (hashes !== void(0)) {
                clipboard.length && this.trigger('unlockfiles', {files: map()});
                remember = {};
                clipboard = $.map(hashes || [], function (hash) {
                    var file = files[hash];
                    if (file) {
                        remember[hash] = !0;
                        return {
                            hash: hash,
                            phash: file.phash,
                            name: file.name,
                            mime: file.mime,
                            read: file.read,
                            locked: file.locked,
                            cut: !!cut
                        }
                    }
                    return null
                });
                this.trigger('changeclipboard', {clipboard: clipboard.slice(0, clipboard.length)});
                cut && this.trigger('lockfiles', {files: map()})
            }
            return clipboard.slice(0, clipboard.length)
        };
        this.isCommandEnabled = function (name, dstHash) {
            var disabled, cmd, cvid = self.cwd().volumeid || '';
            if (!dstHash && self.searchStatus.state > 1 && self.selected().length) {
                dstHash = self.selected()[0]
            }
            if (dstHash && (!cvid || dstHash.indexOf(cvid) !== 0)) {
                disabled = self.option('disabledFlip', dstHash)
            } else {
                disabled = cwdOptions.disabledFlip
            }
            cmd = this._commands[name];
            return cmd ? (cmd.alwaysEnabled || !disabled[name]) : !1
        };
        this.exec = function (cmd, files, opts, dstHash) {
            var dfrd, resType;
            if (!dstHash && this.commandMap[cmd] && this.commandMap[cmd] !== 'hidden') {
                cmd = this.commandMap[cmd]
            }
            if (cmd === 'open') {
                if (this.searchStatus.state || this.searchStatus.ininc) {
                    this.trigger('searchend', {noupdate: !0})
                }
                this.autoSync('stop')
            }
            if (!dstHash && files) {
                if ($.isArray(files)) {
                    if (files.length) {
                        dstHash = files[0]
                    }
                } else {
                    dstHash = files
                }
            }
            dfrd = this._commands[cmd] && this.isCommandEnabled(cmd, dstHash) ? this._commands[cmd].exec(files, opts) : $.Deferred().reject('errUnknownCmd');
            resType = typeof dfrd;
            if (!(resType === 'object' && dfrd.promise)) {
                self.debug('warning', '"cmd.exec()" should be returned "$.Deferred" but cmd "' + cmd + '" returned "' + resType + '"');
                dfrd = $.Deferred().resolve()
            }
            this.trigger('exec', {dfrd: dfrd, cmd: cmd, files: files, opts: opts, dstHash: dstHash});
            return dfrd
        };
        this.dialog = function (content, options) {
            var dialog = $('<div/>').append(content).appendTo(node).elfinderdialog(options, self),
                dnode = dialog.closest('.ui-dialog'), resize = function () {
                    !dialog.data('draged') && dialog.is(':visible') && dialog.elfinderdialog('posInit')
                };
            if (dnode.length) {
                self.bind('resize', resize);
                dnode.on('remove', function () {
                    self.unbind('resize', resize)
                })
            }
            return dialog
        };
        this.toast = function (options) {
            return $('<div class="ui-front"/>').appendTo(this.ui.toast).elfindertoast(options || {}, this)
        };
        this.getUI = function (ui) {
            return ui ? (this.ui[ui] || $()) : node
        };
        this.getCommand = function (name) {
            return name === void(0) ? this._commands : this._commands[name]
        };
        this.resize = function (w, h) {
            var getMargin = function () {
                var m = node.outerHeight(!0) - node.innerHeight(), p = node;
                while (p.get(0) !== heightBase.get(0)) {
                    p = p.parent();
                    m += p.outerHeight(!0) - p.innerHeight();
                    if (!p.parent().length) {
                        break
                    }
                }
                return m
            }, fit = !node.hasClass('ui-resizable'), prv = node.data('resizeSize') || {w: 0, h: 0}, mt, size = {};
            if (heightBase && heightBase.data('resizeTm')) {
                clearTimeout(heightBase.data('resizeTm'))
            }
            if (typeof h === 'string') {
                if (mt = h.match(/^([0-9.]+)%$/)) {
                    if (!heightBase || !heightBase.length) {
                        heightBase = $(window)
                    }
                    if (!heightBase.data('marginToMyNode')) {
                        heightBase.data('marginToMyNode', getMargin())
                    }
                    if (!heightBase.data('fitToBaseFunc')) {
                        heightBase.data('fitToBaseFunc', function (e) {
                            var tm = heightBase.data('resizeTm');
                            e.preventDefault();
                            e.stopPropagation();
                            tm && cancelAnimationFrame(tm);
                            if (!node.hasClass('elfinder-fullscreen') && (!self.UA.Mobile || heightBase.data('rotated') !== self.UA.Rotated)) {
                                heightBase.data('rotated', self.UA.Rotated);
                                heightBase.data('resizeTm', requestAnimationFrame(function () {
                                    self.restoreSize()
                                }))
                            }
                        })
                    }
                    if (typeof heightBase.data('rotated') === 'undefined') {
                        heightBase.data('rotated', self.UA.Rotated)
                    }
                    h = heightBase.height() * (mt[1] / 100) - heightBase.data('marginToMyNode');
                    heightBase.off('resize.' + self.namespace, heightBase.data('fitToBaseFunc'));
                    fit && heightBase.on('resize.' + self.namespace, heightBase.data('fitToBaseFunc'))
                }
            }
            node.css({width: w, height: parseInt(h)});
            size.w = Math.round(node.width());
            size.h = Math.round(node.height());
            node.data('resizeSize', size);
            if (size.w !== prv.w || size.h !== prv.h) {
                node.trigger('resize');
                this.trigger('resize', {width: size.w, height: size.h})
            }
        };
        this.restoreSize = function () {
            this.resize(width, height)
        };
        this.show = function () {
            node.show();
            this.enable().trigger('show')
        };
        this.hide = function () {
            if (this.options.enableAlways) {
                prevEnabled = enabled;
                enabled = !1
            }
            this.disable();
            this.trigger('hide');
            node.hide()
        };
        this.lazy = function (func, delay, opts) {
            var busy = function (state) {
                var cnt = node.data('lazycnt'), repaint;
                if (state) {
                    repaint = node.data('lazyrepaint') ? !1 : opts.repaint;
                    if (!cnt) {
                        node.data('lazycnt', 1).addClass('elfinder-processing')
                    } else {
                        node.data('lazycnt', ++cnt)
                    }
                    if (repaint) {
                        node.data('lazyrepaint', !0).css('display')
                    }
                } else {
                    if (cnt && cnt > 1) {
                        node.data('lazycnt', --cnt)
                    } else {
                        repaint = node.data('lazyrepaint');
                        node.data('lazycnt', 0).removeData('lazyrepaint').removeClass('elfinder-processing');
                        repaint && node.css('display');
                        self.trigger('lazydone')
                    }
                }
            }, dfd = $.Deferred(), callFunc = function () {
                dfd.resolve(func.call(dfd));
                busy(!1)
            };
            delay = delay || 0;
            opts = opts || {};
            busy(!0);
            if (delay) {
                setTimeout(callFunc, delay)
            } else {
                requestAnimationFrame(callFunc)
            }
            return dfd
        };
        this.destroy = function () {
            if (node && node[0].elfinder) {
                node.hasClass('elfinder-fullscreen') && self.toggleFullscreen(node);
                this.options.syncStart = !1;
                this.autoSync('forcestop');
                this.trigger('destroy').disable();
                clipboard = [];
                selected = [];
                listeners = {};
                shortcuts = {};
                $(window).off('.' + namespace);
                $(document).off('.' + namespace);
                self.trigger = function () {
                };
                $(beeper).remove();
                node.off().removeData().empty().append(prevContent.contents()).attr('class', prevContent.attr('class')).attr('style', prevContent.attr('style'));
                delete node[0].elfinder;
                $.each(prevEvents, function (n, arr) {
                    $.each(arr, function (i, o) {
                        node.on(o.type + (o.namespace ? '.' + o.namespace : ''), o.selector, o.handler)
                    })
                })
            }
        };
        this.autoSync = function (mode) {
            var sync;
            if (self.options.sync >= 1000) {
                if (syncInterval) {
                    clearTimeout(syncInterval);
                    syncInterval = null;
                    self.trigger('autosync', {action: 'stop'})
                }
                if (mode === 'stop') {
                    ++autoSyncStop
                } else {
                    autoSyncStop = Math.max(0, --autoSyncStop)
                }
                if (autoSyncStop || mode === 'forcestop' || !self.options.syncStart) {
                    return
                }
                sync = function (start) {
                    var timeout;
                    if (cwdOptions.syncMinMs && (start || syncInterval)) {
                        start && self.trigger('autosync', {action: 'start'});
                        timeout = Math.max(self.options.sync, cwdOptions.syncMinMs);
                        syncInterval && clearTimeout(syncInterval);
                        syncInterval = setTimeout(function () {
                            var dosync = !0, hash = cwd, cts;
                            if (cwdOptions.syncChkAsTs && files[hash] && (cts = files[hash].ts)) {
                                self.request({
                                    data: {cmd: 'info', targets: [hash], compare: cts, reload: 1},
                                    preventDefault: !0
                                }).done(function (data) {
                                    var ts;
                                    dosync = !0;
                                    if (data.compare) {
                                        ts = data.compare;
                                        if (ts == cts) {
                                            dosync = !1
                                        }
                                    }
                                    if (dosync) {
                                        self.sync(hash).always(function () {
                                            if (ts) {
                                                files[hash].ts = ts
                                            }
                                            sync()
                                        })
                                    } else {
                                        sync()
                                    }
                                }).fail(function (error, xhr) {
                                    var err = self.parseError(error);
                                    if (err && xhr.status != 0) {
                                        self.error(err);
                                        if (Array.isArray(err) && $.inArray('errOpen', err) !== -1) {
                                            self.request({
                                                data: {
                                                    cmd: 'open',
                                                    target: (self.lastDir('') || self.root()),
                                                    tree: 1,
                                                    init: 1
                                                }, notify: {type: 'open', cnt: 1, hideCnt: !0}
                                            })
                                        }
                                    } else {
                                        syncInterval = setTimeout(function () {
                                            sync()
                                        }, timeout)
                                    }
                                })
                            } else {
                                self.sync(cwd, !0).always(function () {
                                    sync()
                                })
                            }
                        }, timeout)
                    }
                };
                sync(!0)
            }
        };
        this.insideWorkzone = function (x, y, margin) {
            var rectangle = this.getUI('workzone').data('rectangle');
            margin = margin || 1;
            if (x < rectangle.left + margin || x > rectangle.left + rectangle.width + margin || y < rectangle.top + margin || y > rectangle.top + rectangle.height + margin) {
                return !1
            }
            return !0
        };
        this.toFront = function (target) {
            var nodes = node.children('.ui-front').removeClass('elfinder-frontmost'), lastnode = nodes.last();
            nodes.css('z-index', '');
            $(target).addClass('ui-front elfinder-frontmost').css('z-index', lastnode.css('z-index') + 1)
        };
        this.toHide = function (target, nohide) {
            var tgt = $(target), last;
            !nohide && tgt.hide();
            if (tgt.hasClass('elfinder-frontmost')) {
                tgt.removeClass('elfinder-frontmost');
                last = node.children('.ui-front:visible:not(.elfinder-frontmost)').last();
                if (last.length) {
                    requestAnimationFrame(function () {
                        if (!node.children('.elfinder-frontmost:visible').length) {
                            self.toFront(last);
                            last.trigger('frontmost')
                        }
                    })
                }
            }
        };
        this.getMaximizeCss = function () {
            return {
                width: '100%',
                height: '100%',
                margin: 0,
                top: 0,
                left: 0,
                display: 'block',
                position: 'fixed',
                zIndex: Math.max(self.zIndex ? (self.zIndex + 1) : 0, 1000),
                maxWidth: '',
                maxHeight: ''
            }
        };
        (function () {
            if (inFrame && self.UA.Fullscreen) {
                self.UA.Fullscreen = !1;
                if (parentIframe && typeof parentIframe.attr('allowfullscreen') !== 'undefined') {
                    self.UA.Fullscreen = !0
                }
            }
            var orgStyle, bodyOvf, resizeTm, fullElm, exitFull, toFull, funcObj, cls = 'elfinder-fullscreen',
                clsN = 'elfinder-fullscreen-native', checkDialog = function () {
                    var t = 0, l = 0;
                    $.each(node.children('.ui-dialog,.ui-draggable'), function (i, d) {
                        var $d = $(d), pos = $d.position();
                        if (pos.top < 0) {
                            $d.css('top', t);
                            t += 20
                        }
                        if (pos.left < 0) {
                            $d.css('left', l);
                            l += 20
                        }
                    })
                }, setFuncObj = function () {
                    var useFullscreen = self.storage('useFullscreen');
                    funcObj = self.UA.Fullscreen && (useFullscreen ? useFullscreen > 0 : self.options.commandsOptions.fullscreen.mode === 'screen') ? {
                        fullElm: function () {
                            return document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement || null
                        }, exitFull: function () {
                            if (document.exitFullscreen) {
                                return document.exitFullscreen()
                            } else if (document.webkitExitFullscreen) {
                                return document.webkitExitFullscreen()
                            } else if (document.mozCancelFullScreen) {
                                return document.mozCancelFullScreen()
                            } else if (document.msExitFullscreen) {
                                return document.msExitFullscreen()
                            }
                        }, toFull: function (elem) {
                            if (elem.requestFullscreen) {
                                return elem.requestFullscreen()
                            } else if (elem.webkitRequestFullscreen) {
                                return elem.webkitRequestFullscreen()
                            } else if (elem.mozRequestFullScreen) {
                                return elem.mozRequestFullScreen()
                            } else if (elem.msRequestFullscreen) {
                                return elem.msRequestFullscreen()
                            }
                            return !1
                        }
                    } : {
                        fullElm: function () {
                            var full;
                            if (node.hasClass(cls)) {
                                return node.get(0)
                            } else {
                                full = node.find('.' + cls);
                                if (full.length) {
                                    return full.get(0)
                                }
                            }
                            return null
                        }, exitFull: function () {
                            var elm;
                            $(window).off('resize.' + namespace, resize);
                            if (bodyOvf !== void(0)) {
                                $('body').css('overflow', bodyOvf)
                            }
                            bodyOvf = void(0);
                            if (orgStyle) {
                                elm = orgStyle.elm;
                                restoreStyle(elm);
                                $(elm).trigger('resize', {fullscreen: 'off'})
                            }
                            $(window).trigger('resize')
                        }, toFull: function (elem) {
                            bodyOvf = $('body').css('overflow') || '';
                            $('body').css('overflow', 'hidden');
                            $(elem).css(self.getMaximizeCss()).addClass(cls).trigger('resize', {fullscreen: 'on'});
                            checkDialog();
                            $(window).on('resize.' + namespace, resize).trigger('resize');
                            return !0
                        }
                    }
                }, restoreStyle = function (elem) {
                    if (orgStyle && orgStyle.elm == elem) {
                        $(elem).removeClass(cls + ' ' + clsN).attr('style', orgStyle.style);
                        orgStyle = null
                    }
                }, resize = function (e) {
                    var elm;
                    if (e.target === window) {
                        resizeTm && cancelAnimationFrame(resizeTm);
                        resizeTm = requestAnimationFrame(function () {
                            if (elm = funcObj.fullElm()) {
                                $(elm).trigger('resize', {fullscreen: 'on'})
                            }
                        })
                    }
                };
            setFuncObj();
            $(document).on('fullscreenchange.' + namespace + ' webkitfullscreenchange.' + namespace + ' mozfullscreenchange.' + namespace + ' MSFullscreenChange.' + namespace, function (e) {
                if (self.UA.Fullscreen) {
                    var elm = funcObj.fullElm(), win = $(window);
                    resizeTm && cancelAnimationFrame(resizeTm);
                    if (elm === null) {
                        win.off('resize.' + namespace, resize);
                        if (orgStyle) {
                            elm = orgStyle.elm;
                            restoreStyle(elm);
                            $(elm).trigger('resize', {fullscreen: 'off'})
                        }
                    } else {
                        $(elm).addClass(cls + ' ' + clsN).attr('style', 'width:100%; height:100%; margin:0; padding:0;').trigger('resize', {fullscreen: 'on'});
                        win.on('resize.' + namespace, resize);
                        checkDialog()
                    }
                    win.trigger('resize')
                }
            });
            self.toggleFullscreen = function (target, full) {
                var elm = $(target).get(0), curElm = null;
                curElm = funcObj.fullElm();
                if (curElm) {
                    if (curElm == elm) {
                        if (full === !0) {
                            return curElm
                        }
                    } else {
                        if (full === !1) {
                            return curElm
                        }
                    }
                    funcObj.exitFull();
                    return null
                } else {
                    if (full === !1) {
                        return null
                    }
                }
                setFuncObj();
                orgStyle = {elm: elm, style: $(elm).attr('style')};
                if (funcObj.toFull(elm) !== !1) {
                    return elm
                } else {
                    orgStyle = null;
                    return null
                }
            }
        })();
        (function () {
            var cls = 'elfinder-maximized', resizeTm, resize = function (e) {
                if (e.target === window && e.data && e.data.elm) {
                    var elm = e.data.elm;
                    resizeTm && cancelAnimationFrame(resizeTm);
                    resizeTm = requestAnimationFrame(function () {
                        elm.trigger('resize', {maximize: 'on'})
                    })
                }
            }, exitMax = function (elm) {
                $(window).off('resize.' + namespace, resize);
                $('body').css('overflow', elm.data('bodyOvf'));
                elm.removeClass(cls).attr('style', elm.data('orgStyle')).removeData('bodyOvf').removeData('orgStyle');
                elm.trigger('resize', {maximize: 'off'})
            }, toMax = function (elm) {
                elm.data('bodyOvf', $('body').css('overflow') || '').data('orgStyle', elm.attr('style')).addClass(cls).css(self.getMaximizeCss());
                $('body').css('overflow', 'hidden');
                $(window).on('resize.' + namespace, {elm: elm}, resize);
                elm.trigger('resize', {maximize: 'on'})
            };
            self.toggleMaximize = function (target, max) {
                var elm = $(target), maximized = elm.hasClass(cls);
                if (maximized) {
                    if (max === !0) {
                        return
                    }
                    exitMax(elm)
                } else {
                    if (max === !1) {
                        return
                    }
                    toMax(elm)
                }
            }
        })();
        Object.assign($.ui.keyCode, {
            'F1': 112,
            'F2': 113,
            'F3': 114,
            'F4': 115,
            'F5': 116,
            'F6': 117,
            'F7': 118,
            'F8': 119,
            'F9': 120,
            'F10': 121,
            'F11': 122,
            'F12': 123,
            'DIG0': 48,
            'DIG1': 49,
            'DIG2': 50,
            'DIG3': 51,
            'DIG4': 52,
            'DIG5': 53,
            'DIG6': 54,
            'DIG7': 55,
            'DIG8': 56,
            'DIG9': 57,
            'NUM0': 96,
            'NUM1': 97,
            'NUM2': 98,
            'NUM3': 99,
            'NUM4': 100,
            'NUM5': 101,
            'NUM6': 102,
            'NUM7': 103,
            'NUM8': 104,
            'NUM9': 105,
            'CONTEXTMENU': 93,
            'DOT': 190
        });
        this.dragUpload = !1;
        this.xhrUpload = (typeof XMLHttpRequestUpload != 'undefined' || typeof XMLHttpRequestEventTarget != 'undefined') && typeof File != 'undefined' && typeof FormData != 'undefined';
        this.transport = {};
        if (typeof(this.options.transport) == 'object') {
            this.transport = this.options.transport;
            if (typeof(this.transport.init) == 'function') {
                this.transport.init(this)
            }
        }
        if (typeof(this.transport.send) != 'function') {
            this.transport.send = function (opts) {
                if (!self.UA.IE) {
                    opts._xhr = new XMLHttpRequest();
                    opts.xhr = function () {
                        return opts._xhr
                    }
                }
                return $.ajax(opts)
            }
        }
        if (this.transport.upload == 'iframe') {
            this.transport.upload = $.proxy(this.uploads.iframe, this)
        } else if (typeof(this.transport.upload) == 'function') {
            this.dragUpload = !!this.options.dragUploadAllow
        } else if (this.xhrUpload && !!this.options.dragUploadAllow) {
            this.transport.upload = $.proxy(this.uploads.xhr, this);
            this.dragUpload = !0
        } else {
            this.transport.upload = $.proxy(this.uploads.iframe, this)
        }
        this.decodeRawString = function (str) {
            var charCodes = function (str) {
                var i, len, arr;
                for (i = 0, len = str.length, arr = []; i < len; i++) {
                    arr.push(str.charCodeAt(i))
                }
                return arr
            }, scalarValues = function (arr) {
                var scalars = [], i, len, c;
                if (typeof arr === 'string') {
                    arr = charCodes(arr)
                }
                for (i = 0, len = arr.length; c = arr[i], i < len; i++) {
                    if (c >= 0xd800 && c <= 0xdbff) {
                        scalars.push((c & 1023) + 64 << 10 | arr[++i] & 1023)
                    } else {
                        scalars.push(c)
                    }
                }
                return scalars
            }, decodeUTF8 = function (arr) {
                var i, len, c, str, char = String.fromCharCode;
                for (i = 0, len = arr.length, str = ""; c = arr[i], i < len; i++) {
                    if (c <= 0x7f) {
                        str += char(c)
                    } else if (c <= 0xdf && c >= 0xc2) {
                        str += char((c & 31) << 6 | arr[++i] & 63)
                    } else if (c <= 0xef && c >= 0xe0) {
                        str += char((c & 15) << 12 | (arr[++i] & 63) << 6 | arr[++i] & 63)
                    } else if (c <= 0xf7 && c >= 0xf0) {
                        str += char(0xd800 | ((c & 7) << 8 | (arr[++i] & 63) << 2 | arr[++i] >>> 4 & 3) - 64, 0xdc00 | (arr[i++] & 15) << 6 | arr[i] & 63)
                    } else {
                        str += char(0xfffd)
                    }
                }
                return str
            };
            return decodeUTF8(scalarValues(str))
        };
        this.getContents = function (hash, responseType) {
            var self = this, dfd = $.Deferred(), type = responseType || 'arraybuffer', url, req;
            dfd.fail(function () {
                req && req.state() === 'pending' && req.reject()
            });
            url = self.openUrl(hash);
            if (!self.isSameOrigin(url)) {
                url = self.openUrl(hash, !0)
            }
            req = self.request({
                data: {cmd: 'get'},
                options: {url: url, type: 'get', cache: !0, dataType: 'binary', responseType: type, processData: !1}
            }).fail(function () {
                dfd.reject()
            }).done(function (data) {
                dfd.resolve(data)
            });
            return dfd
        };
        this.getMimetype = function (name, orgMime) {
            var mime = orgMime, ext, m;
            m = (name + '').match(/\.([^.]+)$/);
            if (m && (ext = m[1])) {
                if (!extToMimeTable) {
                    extToMimeTable = self.arrayFlip(self.mimeTypes)
                }
                if (!(mime = extToMimeTable[ext.toLowerCase()])) {
                    mime = orgMime
                }
            }
            return mime
        };
        self.hashCheckers = [];
        (function (self) {
            var hashLibs = {check: !0}, md5Calc = function (arr) {
                var spark = new hashLibs.SparkMD5.ArrayBuffer(), job;
                job = self.asyncJob(function (buf) {
                    spark.append(buf)
                }, arr).done(function () {
                    job._md5 = spark.end()
                });
                return job
            }, shaCalc = function (arr, length) {
                var sha, job;
                try {
                    sha = new hashLibs.jsSHA('SHA' + (length.substr(0, 1) === '3' ? length : ('-' + length)), 'ARRAYBUFFER');
                    job = self.asyncJob(function (buf) {
                        sha.update(buf)
                    }, arr).done(function () {
                        job._sha = sha.getHash('HEX')
                    })
                } catch (e) {
                    job = $.Deferred.reject()
                }
                return job
            };
            if (self.options.cdns.sparkmd5) {
                self.hashCheckers.push('md5')
            }
            if (self.options.cdns.jssha) {
                self.hashCheckers = self.hashCheckers.concat(['sha1', 'sha224', 'sha256', 'sha384', 'sha512', 'sha3-224', 'sha3-256', 'sha3-384', 'sha3-512', 'shake128', 'shake256'])
            }
            self.getContentsHashes = function (target, needHashes) {
                var dfd = $.Deferred(), needs = self.arrayFlip(needHashes || ['md5'], !0), libs = [], jobs = [],
                    res = {}, req;
                dfd.fail(function () {
                    req && req.reject()
                });
                if (hashLibs.check) {
                    delete hashLibs.check;
                    var libsmd5 = $.Deferred();
                    if (window.ArrayBuffer && self.options.cdns.sparkmd5) {
                        libs.push(libsmd5);
                        self.loadScript([self.options.cdns.sparkmd5], function (res) {
                            var SparkMD5 = res || window.SparkMD5;
                            window.SparkMD5 && delete window.SparkMD5;
                            libsmd5.resolve();
                            if (SparkMD5) {
                                hashLibs.SparkMD5 = SparkMD5
                            }
                        }, {
                            tryRequire: !0, error: function () {
                                libsmd5.reject()
                            }
                        })
                    }
                    var libssha = $.Deferred();
                    if (window.ArrayBuffer && self.options.cdns.jssha) {
                        libs.push(libssha);
                        self.loadScript([self.options.cdns.jssha], function (res) {
                            var jsSHA = res || window.jsSHA;
                            window.jsSHA && delete window.jsSHA;
                            libssha.resolve();
                            if (jsSHA) {
                                hashLibs.jsSHA = jsSHA
                            }
                        }, {
                            tryRequire: !0, error: function () {
                                libssha.reject()
                            }
                        })
                    }
                }
                $.when.apply(null, libs).always(function () {
                    if (Object.keys(hashLibs).length) {
                        req = self.getContents(target).done(function (arrayBuffer) {
                            var arr = (arrayBuffer instanceof ArrayBuffer && arrayBuffer.byteLength > 0) ? self.sliceArrayBuffer(arrayBuffer, 1048576) : !1,
                                i;
                            if (needs.md5 && hashLibs.SparkMD5) {
                                jobs.push(function () {
                                    var job = md5Calc(arr).done(function () {
                                        var f;
                                        res.md5 = job._md5;
                                        if (f = self.file(target)) {
                                            f.md5 = job._md5
                                        }
                                        dfd.notify(res)
                                    });
                                    dfd.fail(function () {
                                        job.reject()
                                    });
                                    return job
                                })
                            }
                            if (hashLibs.jsSHA) {
                                $.each(['1', '224', '256', '384', '512', '3-224', '3-256', '3-384', '3-512', 'ke128', 'ke256'], function (i, v) {
                                    if (needs['sha' + v]) {
                                        jobs.push(function () {
                                            var job = shaCalc(arr, v).done(function () {
                                                var f;
                                                res['sha' + v] = job._sha;
                                                if (f = self.file(target)) {
                                                    f['sha' + v] = job._sha
                                                }
                                                dfd.notify(res)
                                            });
                                            return job
                                        })
                                    }
                                })
                            }
                            if (jobs.length) {
                                self.sequence(jobs).always(function () {
                                    dfd.resolve(res)
                                })
                            } else {
                                dfd.reject()
                            }
                        }).fail(function () {
                            dfd.reject()
                        })
                    } else {
                        dfd.reject()
                    }
                });
                return dfd
            }
        })(this);
        this.parseError = function (error) {
            var arg = error;
            if ($.isPlainObject(arg)) {
                arg = arg.error
            }
            return arg
        };
        this.error = function () {
            var arg = arguments[0], opts = arguments[1] || null, err;
            if (arguments.length == 1 && typeof(arg) === 'function') {
                return self.bind('error', arg)
            } else {
                err = this.parseError(arg);
                return (err === !0 || !err) ? this : self.trigger('error', {error: err, opts: opts})
            }
        };
        $.each(events, function (i, name) {
            self[name] = function () {
                var arg = arguments[0];
                return arguments.length == 1 && typeof(arg) == 'function' ? self.bind(name, arg) : self.trigger(name, $.isPlainObject(arg) ? arg : {})
            }
        });
        this.enable(function () {
            if (!enabled && self.api && self.visible() && self.ui.overlay.is(':hidden') && !node.children('.elfinder-dialog.' + self.res('class', 'editing') + ':visible').length) {
                enabled = !0;
                document.activeElement && document.activeElement.blur();
                node.removeClass('elfinder-disabled')
            }
        }).disable(function () {
            prevEnabled = enabled;
            enabled = !1;
            node.addClass('elfinder-disabled')
        }).open(function () {
            selected = []
        }).select(function (e) {
            var cnt = 0, unselects = [];
            selected = $.grep(e.data.selected || e.data.value || [], function (hash) {
                if (unselects.length || (self.maxTargets && ++cnt > self.maxTargets)) {
                    unselects.push(hash);
                    return !1
                } else {
                    return files[hash] ? !0 : !1
                }
            });
            if (unselects.length) {
                self.trigger('unselectfiles', {files: unselects, inselect: !0});
                self.toast({mode: 'warning', msg: self.i18n(['errMaxTargets', self.maxTargets])})
            }
        }).error(function (e) {
            var opts = {
                cssClass: 'elfinder-dialog-error',
                title: self.i18n('error'),
                resizable: !1,
                destroyOnClose: !0,
                buttons: {}
            }, node = self.getUI(), cnt = node.children('.elfinder-dialog-error').length, last, counter;
            if (cnt < self.options.maxErrorDialogs) {
                opts.buttons[self.i18n(self.i18n('btnClose'))] = function () {
                    $(this).elfinderdialog('close')
                };
                if (e.data.opts && $.isPlainObject(e.data.opts)) {
                    Object.assign(opts, e.data.opts)
                }
                self.dialog('<span class="elfinder-dialog-icon elfinder-dialog-icon-error"/>' + self.i18n(e.data.error), opts)
            } else {
                last = node.children('.elfinder-dialog-error:last').children('.ui-dialog-content:first');
                counter = last.children('.elfinder-error-counter');
                if (counter.length) {
                    counter.data('cnt', parseInt(counter.data('cnt')) + 1).html(self.i18n(['moreErrors', counter.data('cnt')]))
                } else {
                    counter = $('<span class="elfinder-error-counter">' + self.i18n(['moreErrors', 1]) + '</span>').data('cnt', 1);
                    last.append('<br/>', counter)
                }
            }
        }).bind('tmb', function (e) {
            $.each(e.data.images || [], function (hash, tmb) {
                if (files[hash]) {
                    files[hash].tmb = tmb
                }
            })
        }).bind('searchstart', function (e) {
            Object.assign(self.searchStatus, e.data);
            self.searchStatus.state = 1
        }).bind('search', function (e) {
            self.searchStatus.state = 2
        }).bind('searchend', function () {
            self.searchStatus.state = 0;
            self.searchStatus.ininc = !1;
            self.searchStatus.mixed = !1
        }).bind('canMakeEmptyFile', function (e) {
            var data = e.data, obj = {};
            if (data && Array.isArray(data.mimes)) {
                if (!data.unshift) {
                    obj = self.mimesCanMakeEmpty
                }
                $.each(data.mimes, function () {
                    if (!obj[this]) {
                        obj[this] = self.mimeTypes[this]
                    }
                });
                if (data.unshift) {
                    self.mimesCanMakeEmpty = Object.assign(obj, self.mimesCanMakeEmpty)
                }
            }
        }).bind('themechange', function () {
            requestAnimationFrame(function () {
                self.trigger('uiresize')
            })
        });
        if (!0 === this.options.sound) {
            this.bind('playsound', function (e) {
                var play = beeper.canPlayType && beeper.canPlayType('audio/wav; codecs="1"'),
                    file = e.data && e.data.soundFile;
                play && file && play != '' && play != 'no' && $(beeper).html('<source src="' + soundPath + file + '" type="audio/wav">')[0].play()
            })
        }
        $.each(this.options.handlers, function (event, callback) {
            self.bind(event, callback)
        });
        this.history = new this.history(this);
        this.roots = {};
        this.leafRoots = {};
        this.volumeExpires = {};
        this._commands = {};
        if (!Array.isArray(this.options.commands)) {
            this.options.commands = []
        }
        if ($.inArray('*', this.options.commands) !== -1) {
            this.options.commands = Object.keys(this.commands)
        }
        this.commandMap = {};
        this.volOptions = {};
        this.hasVolOptions = !1;
        this.trashes = {};
        this.optionsByHashes = {};
        this.uiAutoHide = [];
        this.one('open', function () {
            if (self.uiAutoHide.length) {
                setTimeout(function () {
                    self.trigger('uiautohide')
                }, 500)
            }
        });
        this.bind('uiautohide', function () {
            if (self.uiAutoHide.length) {
                self.uiAutoHide.shift()()
            }
        });
        if (this.options.width) {
            width = this.options.width
        }
        if (this.options.height) {
            height = this.options.height
        }
        if (this.options.heightBase) {
            heightBase = $(this.options.heightBase)
        }
        if (this.options.soundPath) {
            soundPath = this.options.soundPath.replace(/\/+$/, '') + '/'
        } else {
            soundPath = this.baseUrl + soundPath
        }
        self.one('opendone', function () {
            var tm;
            $(document).on('click.' + namespace, function (e) {
                enabled && !self.options.enableAlways && !$(e.target).closest(node).length && self.disable()
            }).on(keydown + ' ' + keypress + ' ' + keyup + ' ' + mousedown, execShortcut);
            self.options.useBrowserHistory && $(window).on('popstate.' + namespace, function (ev) {
                var state = ev.originalEvent.state || {}, hasThash = state.thash ? !0 : !1,
                    dialog = node.find('.elfinder-frontmost:visible'),
                    input = node.find('.elfinder-navbar-dir,.elfinder-cwd-filename').find('input,textarea'), onOpen,
                    toast;
                if (!hasThash) {
                    state = {thash: self.cwd().hash};
                    $('html,body').animate({scrollTop: node.offset().top})
                }
                if (dialog.length || input.length) {
                    history.pushState(state, null, location.pathname + location.search + '#elf_' + state.thash);
                    if (dialog.length) {
                        if (!dialog.hasClass(self.res('class', 'preventback'))) {
                            if (dialog.hasClass('elfinder-contextmenu')) {
                                $(document).trigger($.Event('keydown', {
                                    keyCode: $.ui.keyCode.ESCAPE,
                                    ctrlKey: !1,
                                    shiftKey: !1,
                                    altKey: !1,
                                    metaKey: !1
                                }))
                            } else if (dialog.hasClass('elfinder-dialog')) {
                                dialog.elfinderdialog('close')
                            } else {
                                dialog.trigger('close')
                            }
                        }
                    } else {
                        input.trigger($.Event('keydown', {
                            keyCode: $.ui.keyCode.ESCAPE,
                            ctrlKey: !1,
                            shiftKey: !1,
                            altKey: !1,
                            metaKey: !1
                        }))
                    }
                } else {
                    if (hasThash) {
                        !$.isEmptyObject(self.files()) && self.request({
                            data: {
                                cmd: 'open',
                                target: state.thash,
                                onhistory: 1
                            }, notify: {type: 'open', cnt: 1, hideCnt: !0}, syncOnFail: !0
                        })
                    } else {
                        onOpen = function () {
                            toast.trigger('click')
                        };
                        self.one('open', onOpen, !0);
                        toast = self.toast({
                            msg: self.i18n('pressAgainToExit'), onHidden: function () {
                                self.unbind('open', onOpen);
                                history.pushState(state, null, location.pathname + location.search + '#elf_' + state.thash)
                            }
                        })
                    }
                }
            });
            $(window).on('resize.' + namespace, function (e) {
                if (e.target === this) {
                    tm && cancelAnimationFrame(tm);
                    tm = requestAnimationFrame(function () {
                        var prv = node.data('resizeSize') || {w: 0, h: 0},
                            size = {w: Math.round(node.width()), h: Math.round(node.height())};
                        node.data('resizeSize', size);
                        if (size.w !== prv.w || size.h !== prv.h) {
                            node.trigger('resize');
                            self.trigger('resize', {width: size.w, height: size.h})
                        }
                    })
                }
            }).on('beforeunload.' + namespace, function (e) {
                var msg, cnt;
                if (!self.pauseUnloadCheck()) {
                    if (node.is(':visible')) {
                        if (self.ui.notify.children().length && $.inArray('hasNotifyDialog', self.options.windowCloseConfirm) !== -1) {
                            msg = self.i18n('ntfsmth')
                        } else if (node.find('.' + self.res('class', 'editing')).length && $.inArray('editingFile', self.options.windowCloseConfirm) !== -1) {
                            msg = self.i18n('editingFile')
                        } else if ((cnt = Object.keys(self.selected()).length) && $.inArray('hasSelectedItem', self.options.windowCloseConfirm) !== -1) {
                            msg = self.i18n('hasSelected', '' + cnt)
                        } else if ((cnt = Object.keys(self.clipboard()).length) && $.inArray('hasClipboardData', self.options.windowCloseConfirm) !== -1) {
                            msg = self.i18n('hasClipboard', '' + cnt)
                        }
                        if (msg) {
                            e.returnValue = msg;
                            return msg
                        }
                    }
                    self.trigger('unload')
                }
            });
            $(window).on('message.' + namespace, function (e) {
                var res = e.originalEvent || null, obj, data;
                if (res && self.uploadURL.indexOf(res.origin) === 0) {
                    try {
                        obj = JSON.parse(res.data);
                        data = obj.data || null;
                        if (data) {
                            if (data.error) {
                                if (obj.bind) {
                                    self.trigger(obj.bind + 'fail', data)
                                }
                                self.error(data.error)
                            } else {
                                data.warning && self.error(data.warning);
                                self.updateCache(data);
                                data.removed && data.removed.length && self.remove(data);
                                data.added && data.added.length && self.add(data);
                                data.changed && data.changed.length && self.change(data);
                                if (obj.bind) {
                                    self.trigger(obj.bind, data);
                                    self.trigger(obj.bind + 'done')
                                }
                                data.sync && self.sync()
                            }
                        }
                    } catch (e) {
                        self.sync()
                    }
                }
            });
            if (self.options.enableAlways) {
                $(window).on('focus.' + namespace, function (e) {
                    (e.target === this) && self.enable()
                });
                if (inFrame) {
                    $(window.top).on('focus.' + namespace, function () {
                        if (self.enable() && (!parentIframe || parentIframe.is(':visible'))) {
                            requestAnimationFrame(function () {
                                $(window).trigger('focus')
                            })
                        }
                    })
                }
            } else if (inFrame) {
                $(window).on('blur.' + namespace, function (e) {
                    enabled && e.target === this && self.disable()
                })
            }
            if (inFrame) {
                node.on('click', function (e) {
                    $(window).trigger('focus')
                })
            }
            if (self.options.enableByMouseOver) {
                node.on('mouseenter touchstart', function (e) {
                    (inFrame) && $(window).trigger('focus');
                    !self.enabled() && self.enable()
                })
            }
            $(window).on('visibilitychange.' + namespace, function (e) {
                var background = document.hidden || document.webkitHidden || document.msHidden;
                if (self.options.syncStart) {
                    self.autoSync(background ? 'stop' : void(0))
                }
            })
        });
        node[0].elfinder = this;
        dfrdsBeforeBootup.push((function () {
            var lang = self.lang, langJs = self.i18nBaseUrl + 'elfinder.' + lang + '.js',
                dfd = $.Deferred().done(function () {
                    if (self.i18[lang]) {
                        self.lang = lang
                    }
                    self.trigger('i18load');
                    i18n = self.lang === 'en' ? self.i18.en : $.extend(!0, {}, self.i18.en, self.i18[self.lang])
                });
            if (!self.i18[lang]) {
                self.lang = 'en';
                if (self.hasRequire) {
                    require([langJs], function () {
                        dfd.resolve()
                    }, function () {
                        dfd.resolve()
                    })
                } else {
                    self.loadScript([langJs], function () {
                        dfd.resolve()
                    }, {
                        loadType: 'tag', error: function () {
                            dfd.resolve()
                        }
                    })
                }
            } else {
                dfd.resolve()
            }
            return dfd
        })());
        bootUp = function () {
            var columnNames;
            self.messages = i18n.messages;
            if (!($.fn.selectable && $.fn.draggable && $.fn.droppable && $.fn.resizable && $.fn.button && $.fn.slider)) {
                return alert(self.i18n('errJqui'))
            }
            if (!node.length) {
                return alert(self.i18n('errNode'))
            }
            if (!self.options.url) {
                return alert(self.i18n('errURL'))
            }
            columnNames = Object.assign({
                name: self.i18n('name'),
                perm: self.i18n('perms'),
                date: self.i18n('modify'),
                size: self.i18n('size'),
                kind: self.i18n('kind'),
                modestr: self.i18n('mode'),
                modeoct: self.i18n('mode'),
                modeboth: self.i18n('mode')
            }, self.options.uiOptions.cwd.listView.columnsCustomName);
            self.getColumnName = function (key) {
                return columnNames[key] || self.i18n(key)
            };
            self.direction = i18n.direction;
            self.dateFormat = self.options.dateFormat || i18n.dateFormat;
            self.fancyFormat = self.options.fancyDateFormat || i18n.fancyDateFormat;
            self.nonameDateFormat = (self.options.nonameDateFormat || i18n.nonameDateFormat).replace(/[\/\\]/g, '_');
            self.cssClass = 'ui-helper-reset ui-helper-clearfix ui-widget ui-widget-content ui-corner-all elfinder elfinder-' + (self.direction == 'rtl' ? 'rtl' : 'ltr') + (self.UA.Touch ? (' elfinder-touch' + (self.options.resizable ? ' touch-punch' : '')) : '') + (self.UA.Mobile ? ' elfinder-mobile' : '') + (self.UA.iOS ? ' elfinder-ios' : '') + ' ' + self.options.cssClass;
            node.addClass(self.cssClass).on(mousedown, function () {
                !enabled && self.enable()
            });
            (function () {
                var ltr, wzRect, wzBottom, wzBottom2, nodeStyle,
                    keyEvt = keydown + 'draggable' + ' keyup.' + namespace + 'draggable';
                self.draggable = {
                    appendTo: node,
                    addClasses: !1,
                    distance: 4,
                    revert: !0,
                    refreshPositions: !1,
                    cursor: 'crosshair',
                    cursorAt: {left: 50, top: 47},
                    scroll: !1,
                    start: function (e, ui) {
                        var helper = ui.helper, targets = $.grep(helper.data('files') || [], function (h) {
                            if (h) {
                                remember[h] = !0;
                                return !0
                            }
                            return !1
                        }), locked = !1, cnt, h;
                        nodeStyle = node.attr('style');
                        node.width(node.width()).height(node.height());
                        ltr = (self.direction === 'ltr');
                        wzRect = self.getUI('workzone').data('rectangle');
                        wzBottom = wzRect.top + wzRect.height;
                        wzBottom2 = wzBottom - self.getUI('navdock').outerHeight(!0);
                        self.draggingUiHelper = helper;
                        cnt = targets.length;
                        while (cnt--) {
                            h = targets[cnt];
                            if (files[h].locked) {
                                locked = !0;
                                helper.data('locked', !0);
                                break
                            }
                        }
                        !locked && self.trigger('lockfiles', {files: targets});
                        helper.data('autoScrTm', setInterval(function () {
                            if (helper.data('autoScr')) {
                                self.autoScroll[helper.data('autoScr')](helper.data('autoScrVal'))
                            }
                        }, 50))
                    },
                    drag: function (e, ui) {
                        var helper = ui.helper, autoScr, autoUp, bottom;
                        if ((autoUp = wzRect.top > e.pageY) || wzBottom2 < e.pageY) {
                            if (wzRect.cwdEdge > e.pageX) {
                                autoScr = (ltr ? 'navbar' : 'cwd') + (autoUp ? 'Up' : 'Down')
                            } else {
                                autoScr = (ltr ? 'cwd' : 'navbar') + (autoUp ? 'Up' : 'Down')
                            }
                            if (!autoUp) {
                                if (autoScr.substr(0, 3) === 'cwd') {
                                    if (wzBottom < e.pageY) {
                                        bottom = wzBottom
                                    } else {
                                        autoScr = null
                                    }
                                } else {
                                    bottom = wzBottom2
                                }
                            }
                            if (autoScr) {
                                helper.data('autoScr', autoScr);
                                helper.data('autoScrVal', Math.pow((autoUp ? wzRect.top - e.pageY : e.pageY - bottom), 1.3))
                            }
                        }
                        if (!autoScr) {
                            if (helper.data('autoScr')) {
                                helper.data('refreshPositions', 1).data('autoScr', null)
                            }
                        }
                        if (helper.data('refreshPositions') && $(this).elfUiWidgetInstance('draggable')) {
                            if (helper.data('refreshPositions') > 0) {
                                $(this).draggable('option', {refreshPositions: !0, elfRefresh: !0});
                                helper.data('refreshPositions', -1)
                            } else {
                                $(this).draggable('option', {refreshPositions: !1, elfRefresh: !1});
                                helper.data('refreshPositions', null)
                            }
                        }
                    },
                    stop: function (e, ui) {
                        var helper = ui.helper, files;
                        $(document).off(keyEvt);
                        $(this).elfUiWidgetInstance('draggable') && $(this).draggable('option', {refreshPositions: !1});
                        self.draggingUiHelper = null;
                        self.trigger('focus').trigger('dragstop');
                        if (!helper.data('droped')) {
                            files = $.grep(helper.data('files') || [], function (h) {
                                return h ? !0 : !1
                            });
                            self.trigger('unlockfiles', {files: files});
                            self.trigger('selectfiles', {files: self.selected()})
                        }
                        self.enable();
                        node.attr('style', nodeStyle);
                        helper.data('autoScrTm') && clearInterval(helper.data('autoScrTm'))
                    },
                    helper: function (e, ui) {
                        var element = this.id ? $(this) : $(this).parents('[id]:first'),
                            helper = $('<div class="elfinder-drag-helper"><span class="elfinder-drag-helper-icon-status"/></div>'),
                            icon = function (f) {
                                var mime = f.mime, i, tmb = self.tmb(f);
                                i = '<div class="elfinder-cwd-icon elfinder-cwd-icon-drag ' + self.mime2class(mime) + ' ui-corner-all"/>';
                                if (tmb) {
                                    i = $(i).addClass(tmb.className).css('background-image', "url('" + tmb.url + "')").get(0).outerHTML
                                } else if (f.icon) {
                                    i = $(i).css(self.getIconStyle(f, !0)).get(0).outerHTML
                                }
                                if (f.csscls) {
                                    i = '<div class="' + f.csscls + '">' + i + '</div>'
                                }
                                return i
                            }, hashes, l, ctr;
                        self.draggingUiHelper && self.draggingUiHelper.stop(!0, !0);
                        self.trigger('dragstart', {target: element[0], originalEvent: e}, !0);
                        hashes = element.hasClass(self.res('class', 'cwdfile')) ? self.selected() : [self.navId2Hash(element.attr('id'))];
                        helper.append(icon(files[hashes[0]])).data('files', hashes).data('locked', !1).data('droped', !1).data('namespace', namespace).data('dropover', 0);
                        if ((l = hashes.length) > 1) {
                            helper.append(icon(files[hashes[l - 1]]) + '<span class="elfinder-drag-num">' + l + '</span>')
                        }
                        $(document).on(keyEvt, function (e) {
                            var chk = (e.shiftKey || e.ctrlKey || e.metaKey);
                            if (ctr !== chk) {
                                ctr = chk;
                                if (helper.is(':visible') && helper.data('dropover') && !helper.data('droped')) {
                                    helper.toggleClass('elfinder-drag-helper-plus', helper.data('locked') ? !0 : ctr);
                                    self.trigger(ctr ? 'unlockfiles' : 'lockfiles', {files: hashes, helper: helper})
                                }
                            }
                        });
                        return helper
                    }
                }
            })();
            if (self.commands.getfile) {
                if (typeof(self.options.getFileCallback) == 'function') {
                    self.bind('dblclick', function (e) {
                        e.preventDefault();
                        self.exec('getfile').fail(function () {
                            self.exec('open', e.data && e.data.file ? [e.data.file] : void(0))
                        })
                    });
                    self.shortcut({
                        pattern: 'enter', description: self.i18n('cmdgetfile'), callback: function () {
                            self.exec('getfile').fail(function () {
                                self.exec(self.OS == 'mac' ? 'rename' : 'open')
                            })
                        }
                    }).shortcut({
                        pattern: 'ctrl+enter',
                        description: self.i18n(self.OS == 'mac' ? 'cmdrename' : 'cmdopen'),
                        callback: function () {
                            self.exec(self.OS == 'mac' ? 'rename' : 'open')
                        }
                    })
                } else {
                    self.options.getFileCallback = null
                }
            }
            $.each(self.commands, function (name, cmd) {
                var proto = Object.assign({}, cmd.prototype), extendsCmd, opts;
                if ($.isFunction(cmd) && !self._commands[name] && (cmd.prototype.forceLoad || $.inArray(name, self.options.commands) !== -1)) {
                    extendsCmd = cmd.prototype.extendsCmd || '';
                    if (extendsCmd) {
                        if ($.isFunction(self.commands[extendsCmd])) {
                            cmd.prototype = Object.assign({}, base, new self.commands[extendsCmd](), cmd.prototype)
                        } else {
                            return !0
                        }
                    } else {
                        cmd.prototype = Object.assign({}, base, cmd.prototype)
                    }
                    self._commands[name] = new cmd();
                    cmd.prototype = proto;
                    opts = self.options.commandsOptions[name] || {};
                    if (extendsCmd && self.options.commandsOptions[extendsCmd]) {
                        opts = $.extend(!0, {}, self.options.commandsOptions[extendsCmd], opts)
                    }
                    self._commands[name].setup(name, opts);
                    if (self._commands[name].linkedCmds.length) {
                        $.each(self._commands[name].linkedCmds, function (i, n) {
                            var lcmd = self.commands[n];
                            if ($.isFunction(lcmd) && !self._commands[n]) {
                                lcmd.prototype = base;
                                self._commands[n] = new lcmd();
                                self._commands[n].setup(n, self.options.commandsOptions[n] || {})
                            }
                        })
                    }
                }
            });
            self.ui = {
                workzone: $('<div/>').appendTo(node).elfinderworkzone(self),
                navbar: $('<div/>').appendTo(node).elfindernavbar(self, self.options.uiOptions.navbar || {}),
                navdock: $('<div/>').appendTo(node).elfindernavdock(self, self.options.uiOptions.navdock || {}),
                contextmenu: $('<div/>').appendTo(node).elfindercontextmenu(self),
                overlay: $('<div/>').appendTo(node).elfinderoverlay({
                    show: function () {
                        self.disable()
                    }, hide: function () {
                        prevEnabled && self.enable()
                    }
                }),
                cwd: $('<div/>').appendTo(node).elfindercwd(self, self.options.uiOptions.cwd || {}),
                notify: self.dialog('', {
                    cssClass: 'elfinder-dialog-notify',
                    position: self.options.notifyDialog.position,
                    absolute: !0,
                    resizable: !1,
                    autoOpen: !1,
                    closeOnEscape: !1,
                    title: '&nbsp;',
                    width: self.options.notifyDialog.width ? parseInt(self.options.notifyDialog.width) : null,
                    minHeight: null
                }),
                statusbar: $('<div class="ui-widget-header ui-helper-clearfix ui-corner-bottom elfinder-statusbar"/>').hide().appendTo(node),
                toast: $('<div class="elfinder-toast"/>').appendTo(node),
                bottomtray: $('<div class="elfinder-bottomtray">').appendTo(node)
            };
            self.trigger('uiready');
            $.each(self.options.ui || [], function (i, ui) {
                var name = 'elfinder' + ui, opts = self.options.uiOptions[ui] || {};
                if (!self.ui[ui] && $.fn[name]) {
                    self.ui[ui] = $('<' + (opts.tag || 'div') + '/>').appendTo(node);
                    self.ui[ui][name](self, opts)
                }
            });
            self.resize(width, height);
            if (self.options.resizable) {
                node.resizable({
                    resize: function (e, ui) {
                        self.resize(ui.size.width, ui.size.height)
                    }, handles: 'se', minWidth: 300, minHeight: 200
                });
                if (self.UA.Touch) {
                    node.addClass('touch-punch')
                }
            }
            (function () {
                var navbar = self.getUI('navbar'), cwd = self.getUI('cwd').parent();
                self.autoScroll = {
                    navbarUp: function (v) {
                        navbar.scrollTop(Math.max(0, navbar.scrollTop() - v))
                    }, navbarDown: function (v) {
                        navbar.scrollTop(navbar.scrollTop() + v)
                    }, cwdUp: function (v) {
                        cwd.scrollTop(Math.max(0, cwd.scrollTop() - v))
                    }, cwdDown: function (v) {
                        cwd.scrollTop(cwd.scrollTop() + v)
                    }
                }
            })();
            if (self.UA.Touch) {
                (function () {
                    var lastX, lastY, nodeOffset, nodeWidth, nodeTop, navbarW, toolbarH, navbar = self.getUI('navbar'),
                        toolbar = self.getUI('toolbar'), moveEv = 'touchmove.stopscroll', moveTm,
                        moveUpOn = function (e) {
                            var touches = e.originalEvent.touches || [{}], y = touches[0].pageY || null;
                            if (!lastY || y < lastY) {
                                e.preventDefault();
                                moveTm && clearTimeout(moveTm)
                            }
                        }, moveDownOn = function (e) {
                            e.preventDefault();
                            moveTm && clearTimeout(moveTm)
                        }, moveOff = function () {
                            moveTm = setTimeout(function () {
                                node.off(moveEv)
                            }, 100)
                        }, handleW, handleH = 50;
                    navbar = navbar.children().length ? navbar : null;
                    toolbar = toolbar.length ? toolbar : null;
                    node.on('touchstart touchmove touchend', function (e) {
                        if (e.type === 'touchend') {
                            lastX = !1;
                            lastY = !1;
                            moveOff();
                            return
                        }
                        var touches = e.originalEvent.touches || [{}], x = touches[0].pageX || null,
                            y = touches[0].pageY || null, ltr = (self.direction === 'ltr'), navbarMode, treeWidth,
                            swipeX, moveX, toolbarT, mode;
                        if (x === null || y === null || (e.type === 'touchstart' && touches.length > 1)) {
                            return
                        }
                        if (e.type === 'touchstart') {
                            nodeOffset = node.offset();
                            nodeWidth = node.width();
                            if (navbar) {
                                lastX = !1;
                                if (navbar.is(':hidden')) {
                                    if (!handleW) {
                                        handleW = Math.max(50, nodeWidth / 10)
                                    }
                                    if ((ltr ? (x - nodeOffset.left) : (nodeWidth + nodeOffset.left - x)) < handleW) {
                                        lastX = x
                                    }
                                } else if (!e.originalEvent._preventSwipeX) {
                                    navbarW = navbar.width();
                                    if (ltr) {
                                        swipeX = (x < nodeOffset.left + navbarW)
                                    } else {
                                        swipeX = (x > nodeOffset.left + nodeWidth - navbarW)
                                    }
                                    if (swipeX) {
                                        handleW = Math.max(50, nodeWidth / 10);
                                        lastX = x
                                    } else {
                                        lastX = !1
                                    }
                                }
                            }
                            if (toolbar) {
                                lastY = !1;
                                if (!e.originalEvent._preventSwipeY) {
                                    toolbarH = toolbar.height();
                                    nodeTop = nodeOffset.top;
                                    if (y - nodeTop < (toolbar.is(':hidden') ? handleH : (toolbarH + 30))) {
                                        lastY = y;
                                        node.on(moveEv, toolbar.is(':hidden') ? moveDownOn : moveUpOn)
                                    }
                                }
                            }
                        } else {
                            if (navbar && lastX !== !1) {
                                navbarMode = (ltr ? (lastX > x) : (lastX < x)) ? 'navhide' : 'navshow';
                                moveX = Math.abs(lastX - x);
                                if (navbarMode === 'navhide' && moveX > navbarW * 0.6 || (moveX > (navbarMode === 'navhide' ? navbarW / 3 : 45) && (navbarMode === 'navshow' || (ltr ? x < nodeOffset.left + 20 : x > nodeOffset.left + nodeWidth - 20)))) {
                                    self.getUI('navbar').trigger(navbarMode, {handleW: handleW});
                                    lastX = !1
                                }
                            }
                            if (toolbar && lastY !== !1) {
                                toolbarT = toolbar.offset().top;
                                if (Math.abs(lastY - y) > Math.min(45, toolbarH / 3)) {
                                    mode = (lastY > y) ? 'slideUp' : 'slideDown';
                                    if (mode === 'slideDown' || toolbarT + 20 > y) {
                                        if (toolbar.is(mode === 'slideDown' ? ':hidden' : ':visible')) {
                                            toolbar.stop(!0, !0).trigger('toggle', {duration: 100, handleH: handleH})
                                        }
                                        lastY = !1
                                    }
                                }
                            }
                        }
                    })
                })()
            }
            if (self.dragUpload) {
                (function () {
                    var isin = function (e) {
                            return (e.target.nodeName !== 'TEXTAREA' && e.target.nodeName !== 'INPUT' && $(e.target).closest('div.ui-dialog-content').length === 0)
                        }, ent = 'native-drag-enter', disable = 'native-drag-disable', c = 'class',
                        navdir = self.res(c, 'navdir'), droppable = self.res(c, 'droppable'),
                        dropover = self.res(c, 'adroppable'), arrow = self.res(c, 'navarrow'),
                        clDropActive = self.res(c, 'adroppable'), wz = self.getUI('workzone'),
                        ltr = (self.direction === 'ltr'), clearTm = function () {
                            autoScrTm && cancelAnimationFrame(autoScrTm);
                            autoScrTm = null
                        }, wzRect, autoScrFn, autoScrTm;
                    node.on('dragenter', function (e) {
                        clearTm();
                        if (isin(e)) {
                            e.preventDefault();
                            e.stopPropagation();
                            wzRect = wz.data('rectangle')
                        }
                    }).on('dragleave', function (e) {
                        clearTm();
                        if (isin(e)) {
                            e.preventDefault();
                            e.stopPropagation()
                        }
                    }).on('dragover', function (e) {
                        var autoUp;
                        if (isin(e)) {
                            e.preventDefault();
                            e.stopPropagation();
                            e.originalEvent.dataTransfer.dropEffect = 'none';
                            if (!autoScrTm) {
                                autoScrTm = requestAnimationFrame(function () {
                                    var wzBottom = wzRect.top + wzRect.height,
                                        wzBottom2 = wzBottom - self.getUI('navdock').outerHeight(!0), fn;
                                    if ((autoUp = e.pageY < wzRect.top) || e.pageY > wzBottom2) {
                                        if (wzRect.cwdEdge > e.pageX) {
                                            fn = (ltr ? 'navbar' : 'cwd') + (autoUp ? 'Up' : 'Down')
                                        } else {
                                            fn = (ltr ? 'cwd' : 'navbar') + (autoUp ? 'Up' : 'Down')
                                        }
                                        if (!autoUp) {
                                            if (fn.substr(0, 3) === 'cwd') {
                                                if (wzBottom < e.pageY) {
                                                    wzBottom2 = wzBottom
                                                } else {
                                                    fn = ''
                                                }
                                            }
                                        }
                                        fn && self.autoScroll[fn](Math.pow((autoUp ? wzRect.top - e.pageY : e.pageY - wzBottom2), 1.3))
                                    }
                                    autoScrTm = null
                                })
                            }
                        } else {
                            clearTm()
                        }
                    }).on('drop', function (e) {
                        clearTm();
                        if (isin(e)) {
                            e.stopPropagation();
                            e.preventDefault()
                        }
                    });
                    node.on('dragenter', '.native-droppable', function (e) {
                        if (e.originalEvent.dataTransfer) {
                            var $elm = $(e.currentTarget), id = e.currentTarget.id || null, cwd = null, elfFrom;
                            if (!id) {
                                cwd = self.cwd();
                                $elm.data(disable, !1);
                                try {
                                    $.each(e.originalEvent.dataTransfer.types, function (i, v) {
                                        if (v.substr(0, 13) === 'elfinderfrom:') {
                                            elfFrom = v.substr(13).toLowerCase()
                                        }
                                    })
                                } catch (e) {
                                }
                            }
                            if (!cwd || (cwd.write && (!elfFrom || elfFrom !== (window.location.href + cwd.hash).toLowerCase()))) {
                                e.preventDefault();
                                e.stopPropagation();
                                $elm.data(ent, !0);
                                $elm.addClass(clDropActive)
                            } else {
                                $elm.data(disable, !0)
                            }
                        }
                    }).on('dragleave', '.native-droppable', function (e) {
                        if (e.originalEvent.dataTransfer) {
                            var $elm = $(e.currentTarget);
                            e.preventDefault();
                            e.stopPropagation();
                            if ($elm.data(ent)) {
                                $elm.data(ent, !1)
                            } else {
                                $elm.removeClass(clDropActive)
                            }
                        }
                    }).on('dragover', '.native-droppable', function (e) {
                        if (e.originalEvent.dataTransfer) {
                            var $elm = $(e.currentTarget);
                            e.preventDefault();
                            e.stopPropagation();
                            e.originalEvent.dataTransfer.dropEffect = $elm.data(disable) ? 'none' : 'copy';
                            $elm.data(ent, !1)
                        }
                    }).on('drop', '.native-droppable', function (e) {
                        if (e.originalEvent && e.originalEvent.dataTransfer) {
                            var $elm = $(e.currentTarget), id;
                            e.preventDefault();
                            e.stopPropagation();
                            $elm.removeClass(clDropActive);
                            if (e.currentTarget.id) {
                                id = $elm.hasClass(navdir) ? self.navId2Hash(e.currentTarget.id) : self.cwdId2Hash(e.currentTarget.id)
                            } else {
                                id = self.cwd().hash
                            }
                            e.originalEvent._target = id;
                            self.exec('upload', {dropEvt: e.originalEvent, target: id}, void 0, id)
                        }
                    })
                })()
            }
            if (self.cssloaded === !1) {
                self.cssloaded = !0;
                self.trigger('cssloaded')
            }
            self.zIndexCalc();
            self.trigger('init').request({
                data: {cmd: 'open', target: self.startDir(), init: 1, tree: 1},
                preventDone: !0,
                notify: {type: 'open', cnt: 1, hideCnt: !0},
                freeze: !0
            }).fail(function () {
                self.trigger('fail').disable().lastDir('');
                listeners = {};
                shortcuts = {};
                $(document).add(node).off('.' + namespace);
                self.trigger = function () {
                }
            }).done(function (data) {
                var trashDisable = function (th) {
                    var src = self.file(self.trashes[th]), d = self.options.debug, error;
                    if (src && src.volumeid) {
                        delete self.volOptions[src.volumeid].trashHash
                    }
                    self.trashes[th] = !1;
                    self.debug('backend-error', 'Trash hash "' + th + '" was not found or not writable.')
                }, toChkTh = {};
                if (self.options.rawStringDecoder) {
                    self.registRawStringDecoder(self.options.rawStringDecoder)
                }
                self.zIndexCalc();
                self.load().debug('api', self.api);
                node.trigger('resize');
                open(data);
                self.trigger('open', data, !1);
                self.trigger('opendone');
                if (inFrame && self.options.enableAlways) {
                    $(window).trigger('focus')
                }
                $.each(self.trashes, function (th) {
                    var dir = self.file(th), src;
                    if (!dir) {
                        toChkTh[th] = !0
                    } else if (dir.mime !== 'directory' || !dir.write) {
                        trashDisable(th)
                    }
                });
                if (Object.keys(toChkTh).length) {
                    self.request({
                        data: {cmd: 'info', targets: Object.keys(toChkTh)},
                        preventDefault: !0
                    }).done(function (data) {
                        if (data && data.files) {
                            $.each(data.files, function (i, dir) {
                                if (dir.mime === 'directory' && dir.write) {
                                    delete toChkTh[dir.hash]
                                }
                            })
                        }
                    }).always(function () {
                        $.each(toChkTh, trashDisable)
                    })
                }
                self[self.options.enableAlways ? 'enable' : 'disable']()
            })
        };
        if (bootCallback && typeof bootCallback === 'function') {
            self.bootCallback = bootCallback;
            bootCallback.call(node.get(0), self, {dfrdsBeforeBootup: dfrdsBeforeBootup})
        }
        $.when.apply(null, dfrdsBeforeBootup).done(function () {
            bootUp()
        }).fail(function (error) {
            self.error(error)
        })
    };
    if (typeof toGlobal === 'undefined' || toGlobal) {
        window.elFinder = elFinder
    }
    elFinder.prototype = {
        uniqueid: 0,
        res: function (type, id) {
            return this.resources[type] && this.resources[type][id]
        },
        OS: navigator.userAgent.indexOf('Mac') !== -1 ? 'mac' : navigator.userAgent.indexOf('Win') !== -1 ? 'win' : 'other',
        UA: (function () {
            var self = this,
                webkit = !document.unqueID && !window.opera && !window.sidebar && window.localStorage && 'WebkitAppearance' in document.documentElement.style,
                chrome = webkit && window.chrome, UA = {
                    ltIE6: typeof window.addEventListener == "undefined" && typeof document.documentElement.style.maxHeight == "undefined",
                    ltIE7: typeof window.addEventListener == "undefined" && typeof document.querySelectorAll == "undefined",
                    ltIE8: typeof window.addEventListener == "undefined" && typeof document.getElementsByClassName == "undefined",
                    ltIE9: document.uniqueID && document.documentMode <= 9,
                    ltIE10: document.uniqueID && document.documentMode <= 10,
                    gtIE11: document.uniqueID && document.documentMode >= 11,
                    IE: document.uniqueID,
                    Firefox: window.sidebar,
                    Opera: window.opera,
                    Webkit: webkit,
                    Chrome: chrome,
                    Edge: (chrome && window.msCredentials) ? !0 : !1,
                    Safari: webkit && !window.chrome,
                    Mobile: typeof window.orientation != "undefined",
                    Touch: typeof window.ontouchstart != "undefined",
                    iOS: navigator.platform.match(/^iP(?:[ao]d|hone)/),
                    Fullscreen: (typeof(document.exitFullscreen || document.webkitExitFullscreen || document.mozCancelFullScreen || document.msExitFullscreen) !== 'undefined'),
                    Angle: 0,
                    Rotated: !1,
                    CSS: (function () {
                        var aStyle = document.createElement('a').style, pStyle = document.createElement('p').style, css;
                        css = 'position:sticky;position:-webkit-sticky;';
                        css += 'width:-webkit-max-content;width:-moz-max-content;width:-ms-max-content;width:max-content;';
                        aStyle.cssText = css;
                        return {
                            positionSticky: aStyle.position.indexOf('sticky') !== -1,
                            widthMaxContent: aStyle.width.indexOf('max-content') !== -1,
                            flex: typeof pStyle.flex !== 'undefined'
                        }
                    })()
                };
            return UA
        })(),
        hasRequire: (typeof define === 'function' && define.amd),
        currentReqCmd: '',
        keyState: {},
        i18: {
            en: {
                translator: '',
                language: 'English',
                direction: 'ltr',
                dateFormat: 'd.m.Y H:i',
                fancyDateFormat: '$1 H:i',
                nonameDateFormat: 'ymd-His',
                messages: {}
            },
            months: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
            monthsShort: ['msJan', 'msFeb', 'msMar', 'msApr', 'msMay', 'msJun', 'msJul', 'msAug', 'msSep', 'msOct', 'msNov', 'msDec'],
            days: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
            daysShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']
        },
        kinds: {
            'unknown': 'Unknown',
            'directory': 'Folder',
            'group': 'Selects',
            'symlink': 'Alias',
            'symlink-broken': 'AliasBroken',
            'application/x-empty': 'TextPlain',
            'application/postscript': 'Postscript',
            'application/vnd.ms-office': 'MsOffice',
            'application/msword': 'MsWord',
            'application/vnd.ms-word': 'MsWord',
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'MsWord',
            'application/vnd.ms-word.document.macroEnabled.12': 'MsWord',
            'application/vnd.openxmlformats-officedocument.wordprocessingml.template': 'MsWord',
            'application/vnd.ms-word.template.macroEnabled.12': 'MsWord',
            'application/vnd.ms-excel': 'MsExcel',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'MsExcel',
            'application/vnd.ms-excel.sheet.macroEnabled.12': 'MsExcel',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.template': 'MsExcel',
            'application/vnd.ms-excel.template.macroEnabled.12': 'MsExcel',
            'application/vnd.ms-excel.sheet.binary.macroEnabled.12': 'MsExcel',
            'application/vnd.ms-excel.addin.macroEnabled.12': 'MsExcel',
            'application/vnd.ms-powerpoint': 'MsPP',
            'application/vnd.openxmlformats-officedocument.presentationml.presentation': 'MsPP',
            'application/vnd.ms-powerpoint.presentation.macroEnabled.12': 'MsPP',
            'application/vnd.openxmlformats-officedocument.presentationml.slideshow': 'MsPP',
            'application/vnd.ms-powerpoint.slideshow.macroEnabled.12': 'MsPP',
            'application/vnd.openxmlformats-officedocument.presentationml.template': 'MsPP',
            'application/vnd.ms-powerpoint.template.macroEnabled.12': 'MsPP',
            'application/vnd.ms-powerpoint.addin.macroEnabled.12': 'MsPP',
            'application/vnd.openxmlformats-officedocument.presentationml.slide': 'MsPP',
            'application/vnd.ms-powerpoint.slide.macroEnabled.12': 'MsPP',
            'application/pdf': 'PDF',
            'application/xml': 'XML',
            'application/vnd.oasis.opendocument.text': 'OO',
            'application/vnd.oasis.opendocument.text-template': 'OO',
            'application/vnd.oasis.opendocument.text-web': 'OO',
            'application/vnd.oasis.opendocument.text-master': 'OO',
            'application/vnd.oasis.opendocument.graphics': 'OO',
            'application/vnd.oasis.opendocument.graphics-template': 'OO',
            'application/vnd.oasis.opendocument.presentation': 'OO',
            'application/vnd.oasis.opendocument.presentation-template': 'OO',
            'application/vnd.oasis.opendocument.spreadsheet': 'OO',
            'application/vnd.oasis.opendocument.spreadsheet-template': 'OO',
            'application/vnd.oasis.opendocument.chart': 'OO',
            'application/vnd.oasis.opendocument.formula': 'OO',
            'application/vnd.oasis.opendocument.database': 'OO',
            'application/vnd.oasis.opendocument.image': 'OO',
            'application/vnd.openofficeorg.extension': 'OO',
            'application/x-shockwave-flash': 'AppFlash',
            'application/flash-video': 'Flash video',
            'application/x-bittorrent': 'Torrent',
            'application/javascript': 'JS',
            'application/rtf': 'RTF',
            'application/rtfd': 'RTF',
            'application/x-font-ttf': 'TTF',
            'application/x-font-otf': 'OTF',
            'application/x-rpm': 'RPM',
            'application/x-web-config': 'TextPlain',
            'application/xhtml+xml': 'HTML',
            'application/docbook+xml': 'DOCBOOK',
            'application/x-awk': 'AWK',
            'application/x-gzip': 'GZIP',
            'application/x-bzip2': 'BZIP',
            'application/x-xz': 'XZ',
            'application/zip': 'ZIP',
            'application/x-zip': 'ZIP',
            'application/x-rar': 'RAR',
            'application/x-tar': 'TAR',
            'application/x-7z-compressed': '7z',
            'application/x-jar': 'JAR',
            'text/plain': 'TextPlain',
            'text/x-php': 'PHP',
            'text/html': 'HTML',
            'text/javascript': 'JS',
            'text/css': 'CSS',
            'text/rtf': 'RTF',
            'text/rtfd': 'RTF',
            'text/x-c': 'C',
            'text/x-csrc': 'C',
            'text/x-chdr': 'CHeader',
            'text/x-c++': 'CPP',
            'text/x-c++src': 'CPP',
            'text/x-c++hdr': 'CPPHeader',
            'text/x-shellscript': 'Shell',
            'application/x-csh': 'Shell',
            'text/x-python': 'Python',
            'text/x-java': 'Java',
            'text/x-java-source': 'Java',
            'text/x-ruby': 'Ruby',
            'text/x-perl': 'Perl',
            'text/x-sql': 'SQL',
            'text/xml': 'XML',
            'text/x-comma-separated-values': 'CSV',
            'text/x-markdown': 'Markdown',
            'image/x-ms-bmp': 'BMP',
            'image/jpeg': 'JPEG',
            'image/gif': 'GIF',
            'image/png': 'PNG',
            'image/tiff': 'TIFF',
            'image/x-targa': 'TGA',
            'image/vnd.adobe.photoshop': 'PSD',
            'image/xbm': 'XBITMAP',
            'image/pxm': 'PXM',
            'audio/mpeg': 'AudioMPEG',
            'audio/midi': 'AudioMIDI',
            'audio/ogg': 'AudioOGG',
            'audio/mp4': 'AudioMPEG4',
            'audio/x-m4a': 'AudioMPEG4',
            'audio/wav': 'AudioWAV',
            'audio/x-mp3-playlist': 'AudioPlaylist',
            'video/x-dv': 'VideoDV',
            'video/mp4': 'VideoMPEG4',
            'video/mpeg': 'VideoMPEG',
            'video/x-msvideo': 'VideoAVI',
            'video/quicktime': 'VideoMOV',
            'video/x-ms-wmv': 'VideoWM',
            'video/x-flv': 'VideoFlash',
            'video/x-matroska': 'VideoMKV',
            'video/ogg': 'VideoOGG'
        },
        mimeTypes: {},
        rules: {
            defaults: function (data) {
                if (!data || (data.added && !Array.isArray(data.added)) || (data.removed && !Array.isArray(data.removed)) || (data.changed && !Array.isArray(data.changed))) {
                    return !1
                }
                return !0
            }, open: function (data) {
                return data && data.cwd && data.files && $.isPlainObject(data.cwd) && Array.isArray(data.files)
            }, tree: function (data) {
                return data && data.tree && Array.isArray(data.tree)
            }, parents: function (data) {
                return data && data.tree && Array.isArray(data.tree)
            }, tmb: function (data) {
                return data && data.images && ($.isPlainObject(data.images) || Array.isArray(data.images))
            }, upload: function (data) {
                return data && ($.isPlainObject(data.added) || Array.isArray(data.added))
            }, search: function (data) {
                return data && data.files && Array.isArray(data.files)
            }
        },
        commands: {},
        cmdsToAdd: 'archive duplicate extract mkdir mkfile paste rm upload',
        parseUploadData: function (text) {
            var self = this, data;
            if (!$.trim(text)) {
                return {error: ['errResponse', 'errDataEmpty']}
            }
            try {
                data = JSON.parse(text)
            } catch (e) {
                return {error: ['errResponse', 'errDataNotJSON']}
            }
            data = self.normalize(data);
            if (!self.validResponse('upload', data)) {
                return {error: (response.norError || ['errResponse'])}
            }
            data.removed = $.merge((data.removed || []), $.map(data.added || [], function (f) {
                return self.file(f.hash) ? f.hash : null
            }));
            return data
        },
        iframeCnt: 0,
        uploads: {
            xhrUploading: !1, failSyncTm: null, chunkfailReq: {}, checkExists: function (files, target, fm, isDir) {
                var dfrd = $.Deferred(), names, renames = [], hashes = {}, chkFiles = [], cancel = function () {
                    var i = files.length;
                    while (--i > -1) {
                        files[i]._remove = !0
                    }
                }, resolve = function () {
                    dfrd.resolve(renames, hashes)
                }, check = function () {
                    var existed = [], exists = [], i, c,
                        pathStr = target !== fm.cwd().hash ? fm.path(target, !0) + fm.option('separator', target) : '',
                        confirm = function (ndx) {
                            var last = ndx == exists.length - 1, opts = {
                                cssClass: 'elfinder-confirm-upload',
                                title: fm.i18n('cmdupload'),
                                text: ['errExists', pathStr + exists[ndx].name, 'confirmRepl'],
                                all: !last,
                                accept: {
                                    label: 'btnYes', callback: function (all) {
                                        !last && !all ? confirm(++ndx) : resolve()
                                    }
                                },
                                reject: {
                                    label: 'btnNo', callback: function (all) {
                                        var i;
                                        if (all) {
                                            i = exists.length;
                                            while (ndx < i--) {
                                                files[exists[i].i]._remove = !0
                                            }
                                        } else {
                                            files[exists[ndx].i]._remove = !0
                                        }
                                        !last && !all ? confirm(++ndx) : resolve()
                                    }
                                },
                                cancel: {
                                    label: 'btnCancel', callback: function () {
                                        cancel();
                                        resolve()
                                    }
                                },
                                buttons: [{
                                    label: 'btnBackup',
                                    cssClass: 'elfinder-confirm-btn-backup',
                                    callback: function (all) {
                                        var i;
                                        if (all) {
                                            i = exists.length;
                                            while (ndx < i--) {
                                                renames.push(exists[i].name)
                                            }
                                        } else {
                                            renames.push(exists[ndx].name)
                                        }
                                        !last && !all ? confirm(++ndx) : resolve()
                                    }
                                }]
                            };
                            if (!isDir) {
                                opts.buttons.push({
                                    label: 'btnRename' + (last ? '' : 'All'),
                                    cssClass: 'elfinder-confirm-btn-rename',
                                    callback: function () {
                                        renames = null;
                                        resolve()
                                    }
                                })
                            }
                            if (fm.iframeCnt > 0) {
                                delete opts.reject
                            }
                            fm.confirm(opts)
                        };
                    if (!fm.file(target).read) {
                        resolve();
                        return
                    }
                    names = $.map(files, function (file, i) {
                        return file.name && (!fm.UA.iOS || file.name !== 'image.jpg') ? {i: i, name: file.name} : null
                    });
                    fm.request({
                        data: {
                            cmd: 'ls', target: target, intersect: $.map(names, function (item) {
                                return item.name
                            })
                        }, notify: {type: 'preupload', cnt: 1, hideCnt: !0}, preventDefault: !0
                    }).done(function (data) {
                        var existedArr, cwdItems;
                        if (data) {
                            if (data.error) {
                                cancel()
                            } else {
                                if (fm.options.overwriteUploadConfirm && fm.option('uploadOverwrite', target)) {
                                    if (data.list) {
                                        if (Array.isArray(data.list)) {
                                            existed = data.list || []
                                        } else {
                                            existedArr = [];
                                            existed = $.map(data.list, function (n) {
                                                if (typeof n === 'string') {
                                                    return n
                                                } else {
                                                    existedArr = existedArr.concat(n);
                                                    return !1
                                                }
                                            });
                                            if (existedArr.length) {
                                                existed = existed.concat(existedArr)
                                            }
                                            hashes = data.list
                                        }
                                        exists = $.grep(names, function (name) {
                                            return $.inArray(name.name, existed) !== -1 ? !0 : !1
                                        });
                                        if (exists.length && existed.length && target == fm.cwd().hash) {
                                            cwdItems = $.map(fm.files(target), function (file) {
                                                return file.name
                                            });
                                            if ($.grep(existed, function (n) {
                                                    return $.inArray(n, cwdItems) === -1 ? !0 : !1
                                                }).length) {
                                                fm.sync()
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if (exists.length > 0) {
                            confirm(0)
                        } else {
                            resolve()
                        }
                    }).fail(function (error) {
                        cancel();
                        resolve();
                        error && fm.error(error)
                    })
                };
                if (fm.api >= 2.1 && typeof files[0] == 'object') {
                    check()
                } else {
                    resolve()
                }
                return dfrd
            }, checkFile: function (data, fm, target) {
                if (!!data.checked || data.type == 'files') {
                    return data.files
                } else if (data.type == 'data') {
                    var dfrd = $.Deferred(), scanDfd = $.Deferred(), files = [], paths = [], dirctorys = [],
                        processing = 0, items, mkdirs = [], cancel = !1, toArray = function (list) {
                            return Array.prototype.slice.call(list || [], 0)
                        }, doScan = function (items) {
                            var entry, readEntries, excludes = fm.options.folderUploadExclude[fm.OS] || null,
                                length = items.length, check = function () {
                                    if (--processing < 1 && scanDfd.state() === 'pending') {
                                        scanDfd.resolve()
                                    }
                                }, pushItem = function (file) {
                                    if (!excludes || !file.name.match(excludes)) {
                                        paths.push(entry.fullPath || '');
                                        files.push(file)
                                    }
                                    check()
                                }, readEntries = function (dirReader) {
                                    var entries = [], read = function () {
                                        dirReader.readEntries(function (results) {
                                            if (cancel || !results.length) {
                                                for (var i = 0; i < entries.length; i++) {
                                                    if (cancel) {
                                                        scanDfd.reject();
                                                        break
                                                    }
                                                    doScan([entries[i]])
                                                }
                                                check()
                                            } else {
                                                entries = entries.concat(toArray(results));
                                                read()
                                            }
                                        }, check)
                                    };
                                    read()
                                };
                            processing++;
                            for (var i = 0; i < length; i++) {
                                if (cancel) {
                                    scanDfd.reject();
                                    break
                                }
                                entry = items[i];
                                if (entry) {
                                    if (entry.isFile) {
                                        processing++;
                                        entry.file(pushItem, check)
                                    } else if (entry.isDirectory) {
                                        if (fm.api >= 2.1) {
                                            processing++;
                                            mkdirs.push(entry.fullPath);
                                            readEntries(entry.createReader())
                                        }
                                    }
                                }
                            }
                            check();
                            return scanDfd
                        }, hasDirs;
                    items = $.map(data.files.items, function (item) {
                        return item.getAsEntry ? item.getAsEntry() : item.webkitGetAsEntry()
                    });
                    $.each(items, function (i, item) {
                        if (item.isDirectory) {
                            hasDirs = !0;
                            return !1
                        }
                    });
                    if (items.length > 0) {
                        fm.uploads.checkExists(items, target, fm, hasDirs).done(function (renames, hashes) {
                            var dfds = [];
                            if (fm.options.overwriteUploadConfirm && fm.option('uploadOverwrite', target)) {
                                if (renames === null) {
                                    data.overwrite = 0;
                                    renames = []
                                }
                                items = $.grep(items, function (item) {
                                    var i, bak, hash, dfd, hi;
                                    if (item.isDirectory && renames.length) {
                                        i = $.inArray(item.name, renames);
                                        if (i !== -1) {
                                            renames.splice(i, 1);
                                            bak = fm.uniqueName(item.name + fm.options.backupSuffix, null, '');
                                            $.each(hashes, function (h, name) {
                                                if (item.name == name) {
                                                    hash = h;
                                                    return !1
                                                }
                                            });
                                            if (!hash) {
                                                hash = fm.fileByName(item.name, target).hash
                                            }
                                            fm.lockfiles({files: [hash]});
                                            dfd = fm.request({
                                                data: {cmd: 'rename', target: hash, name: bak},
                                                notify: {type: 'rename', cnt: 1}
                                            }).fail(function () {
                                                item._remove = !0;
                                                fm.sync()
                                            }).always(function () {
                                                fm.unlockfiles({files: [hash]})
                                            });
                                            dfds.push(dfd)
                                        }
                                    }
                                    return !item._remove ? !0 : !1
                                })
                            }
                            $.when.apply($, dfds).done(function () {
                                var notifyto, msg, id = +new Date();
                                if (items.length > 0) {
                                    msg = fm.escape(items[0].name);
                                    if (items.length > 1) {
                                        msg += ' ... ' + items.length + fm.i18n('items')
                                    }
                                    notifyto = setTimeout(function () {
                                        fm.notify({
                                            type: 'readdir',
                                            id: id,
                                            cnt: 1,
                                            hideCnt: !0,
                                            msg: fm.i18n('ntfreaddir') + ' (' + msg + ')',
                                            cancel: function () {
                                                cancel = !0
                                            }
                                        })
                                    }, fm.options.notifyDelay);
                                    doScan(items).done(function () {
                                        notifyto && clearTimeout(notifyto);
                                        fm.notify({type: 'readdir', id: id, cnt: -1});
                                        if (cancel) {
                                            dfrd.reject()
                                        } else {
                                            dfrd.resolve([files, paths, renames, hashes, mkdirs])
                                        }
                                    }).fail(function () {
                                        dfrd.reject()
                                    })
                                } else {
                                    dfrd.reject()
                                }
                            })
                        });
                        return dfrd.promise()
                    } else {
                        return dfrd.reject()
                    }
                } else {
                    var ret = [];
                    var check = [];
                    var str = data.files[0];
                    if (data.type == 'html') {
                        var tmp = $("<html/>").append($.parseHTML(str.replace(/ src=/ig, ' _elfsrc='))), atag;
                        $('img[_elfsrc]', tmp).each(function () {
                            var url, purl, self = $(this), pa = self.closest('a');
                            if (pa && pa.attr('href') && pa.attr('href').match(/\.(?:jpe?g|gif|bmp|png)/i)) {
                                purl = pa.attr('href')
                            }
                            url = self.attr('_elfsrc');
                            if (url) {
                                if (purl) {
                                    $.inArray(purl, ret) == -1 && ret.push(purl);
                                    $.inArray(url, check) == -1 && check.push(url)
                                } else {
                                    $.inArray(url, ret) == -1 && ret.push(url)
                                }
                            }
                            if (ret.length === 1 && ret[0].match(/^data:image\/png/)) {
                                data.clipdata = !0
                            }
                        });
                        atag = $('a[href]', tmp);
                        atag.each(function () {
                            var text, loc, parseUrl = function (url) {
                                var a = document.createElement('a');
                                a.href = url;
                                return a
                            };
                            if (text = $(this).text()) {
                                loc = parseUrl($(this).attr('href'));
                                if (loc.href && loc.href.match(/^(?:ht|f)tp/i) && (atag.length === 1 || !loc.pathname.match(/(?:\.html?|\/[^\/.]*)$/i) || $.trim(text).match(/\.[a-z0-9-]{1,10}$/i))) {
                                    if ($.inArray(loc.href, ret) == -1 && $.inArray(loc.href, check) == -1) ret.push(loc.href)
                                }
                            }
                        })
                    } else {
                        var regex, m, url;
                        regex = /((?:ht|f)tps?:\/\/[-_.!~*\'()a-z0-9;/?:\@&=+\$,%#\*\[\]]+)/ig;
                        while (m = regex.exec(str)) {
                            url = m[1].replace(/&amp;/g, '&');
                            if ($.inArray(url, ret) == -1) ret.push(url)
                        }
                    }
                    return ret
                }
            }, xhr: function (data, fm) {
                var self = fm ? fm : this, node = self.getUI(), xhr = new XMLHttpRequest(), notifyto = null,
                    notifyto2 = null, dataChecked = data.checked, isDataType = (data.isDataType || data.type == 'data'),
                    target = (data.target || self.cwd().hash), dropEvt = (data.dropEvt || null),
                    extraData = data.extraData || null, chunkEnable = (self.option('uploadMaxConn', target) != -1),
                    multiMax = Math.min(5, Math.max(1, self.option('uploadMaxConn', target))), retryWait = 10000,
                    retryMax = 30, retry = 0, getFile = function (files) {
                        var dfd = $.Deferred(), file;
                        if (files.promise) {
                            files.always(function (f) {
                                dfd.resolve(Array.isArray(f) && f.length ? (isDataType ? f[0][0] : f[0]) : {})
                            })
                        } else {
                            dfd.resolve(files.length ? (isDataType ? files[0][0] : files[0]) : {})
                        }
                        return dfd
                    }, dfrd = $.Deferred().fail(function (err) {
                        var error = self.parseError(err), userAbort;
                        if (error === 'userabort') {
                            userAbort = !0;
                            error = void 0
                        }
                        if (files && (self.uploads.xhrUploading || userAbort)) {
                            getFile(files).done(function (file) {
                                if (!userAbort) {
                                    triggerError(error, file)
                                }
                                if (!file._cid) {
                                    self.uploads.failSyncTm && clearTimeout(self.uploads.failSyncTm);
                                    self.uploads.failSyncTm = setTimeout(function () {
                                        self.sync(target)
                                    }, 1000)
                                } else if (!self.uploads.chunkfailReq[file._cid]) {
                                    self.uploads.chunkfailReq[file._cid] = !0;
                                    setTimeout(function () {
                                        fm.request({
                                            data: {
                                                cmd: 'upload',
                                                target: target,
                                                chunk: file._chunk,
                                                cid: file._cid,
                                                upload: ['chunkfail'],
                                                mimes: 'chunkfail'
                                            }, options: {type: 'post', url: self.uploadURL}, preventDefault: !0
                                        }).always(function () {
                                            delete self.uploads.chunkfailReq[file._chunk]
                                        })
                                    }, 1000)
                                }
                            })
                        } else {
                            triggerError(error)
                        }
                        !userAbort && self.sync();
                        self.uploads.xhrUploading = !1;
                        files = null
                    }).done(function (data) {
                        self.uploads.xhrUploading = !1;
                        files = null;
                        if (data) {
                            self.currentReqCmd = 'upload';
                            data.warning && triggerError(data.warning);
                            self.updateCache(data);
                            data.removed && data.removed.length && self.remove(data);
                            data.added && data.added.length && self.add(data);
                            data.changed && data.changed.length && self.change(data);
                            self.trigger('upload', data, !1);
                            self.trigger('uploaddone');
                            if (data.toasts && Array.isArray(data.toasts)) {
                                $.each(data.toasts, function () {
                                    this.msg && self.toast(this)
                                })
                            }
                            data.sync && self.sync();
                            data.debug && fm.debug('backend-debug', data)
                        }
                    }).always(function () {
                        self.abortXHR(xhr);
                        node.off('uploadabort', fnAbort);
                        $(window).off('unload', fnAbort);
                        notifyto && clearTimeout(notifyto);
                        notifyto2 && clearTimeout(notifyto2);
                        dataChecked && !data.multiupload && checkNotify() && self.notify({
                            type: 'upload',
                            cnt: -cnt,
                            progress: 0,
                            size: 0
                        });
                        chunkMerge && notifyElm.children('.elfinder-notify-chunkmerge').length && self.notify({
                            type: 'chunkmerge',
                            cnt: -1
                        })
                    }), formData = new FormData(),
                    files = data.input ? data.input.files : self.uploads.checkFile(data, self, target),
                    cnt = data.checked ? (isDataType ? files[0].length : files.length) : files.length, loaded = 0,
                    prev = 0, filesize = 0, notify = !1, notifyElm = self.ui.notify, cancelBtn = !0, abort = !1,
                    checkNotify = function () {
                        if (!notify && (ntfUpload = notifyElm.children('.elfinder-notify-upload')).length) {
                            notify = !0
                        }
                        return notify
                    }, fnAbort = function (e, error) {
                        abort = !0;
                        self.abortXHR(xhr, {quiet: !0, abort: !0});
                        dfrd.reject(error);
                        if (checkNotify()) {
                            self.notify({type: 'upload', cnt: ntfUpload.data('cnt') * -1, progress: 0, size: 0})
                        }
                    }, cancelToggle = function (show) {
                        ntfUpload.children('.elfinder-notify-cancel')[show ? 'show' : 'hide']()
                    }, startNotify = function (size) {
                        if (!size) size = filesize;
                        return setTimeout(function () {
                            notify = !0;
                            self.notify({
                                type: 'upload',
                                cnt: cnt,
                                progress: loaded - prev,
                                size: size,
                                cancel: function () {
                                    node.trigger('uploadabort', 'userabort')
                                }
                            });
                            ntfUpload = notifyElm.children('.elfinder-notify-upload');
                            prev = loaded;
                            if (data.multiupload) {
                                cancelBtn && cancelToggle(!0)
                            } else {
                                cancelToggle(cancelBtn && loaded < size)
                            }
                        }, self.options.notifyDelay)
                    }, doRetry = function () {
                        if (retry++ <= retryMax) {
                            if (checkNotify() && prev) {
                                self.notify({type: 'upload', cnt: 0, progress: 0, size: prev})
                            }
                            self.abortXHR(xhr, {quiet: !0});
                            prev = loaded = 0;
                            setTimeout(function () {
                                var reqId;
                                if (!abort) {
                                    xhr.open('POST', self.uploadURL, !0);
                                    if (self.api >= 2.1029) {
                                        reqId = (+new Date()).toString(16) + Math.floor(1000 * Math.random()).toString(16);
                                        (typeof formData['delete'] === 'function') && formData['delete']('reqid');
                                        formData.append('reqid', reqId);
                                        xhr._requestId = reqId
                                    }
                                    xhr.send(formData)
                                }
                            }, retryWait)
                        } else {
                            node.trigger('uploadabort', ['errAbort', 'errTimeout'])
                        }
                    }, progress = function () {
                        var node;
                        if (notify) {
                            dfrd.notifyWith(ntfUpload, [{
                                cnt: ntfUpload.data('cnt'),
                                progress: ntfUpload.data('progress'),
                                total: ntfUpload.data('total')
                            }])
                        }
                    }, triggerError = function (err, file, unite) {
                        err && self.trigger('xhruploadfail', {error: err, file: file});
                        if (unite) {
                            if (err) {
                                if (errCnt < self.options.maxErrorDialogs) {
                                    if (Array.isArray(err)) {
                                        errors = errors.concat(err)
                                    } else {
                                        errors.push(err)
                                    }
                                }
                                errCnt++
                            }
                        } else {
                            if (err) {
                                self.error(err)
                            } else {
                                if (errors.length) {
                                    if (errCnt >= self.options.maxErrorDialogs) {
                                        errors = errors.concat('moreErrors', errCnt - self.options.maxErrorDialogs)
                                    }
                                    self.error(errors)
                                }
                                errors = [];
                                errCnt = 0
                            }
                        }
                    }, errors = [], errCnt = 0, renames = (data.renames || null), hashes = (data.hashes || null),
                    chunkMerge = !1, ntfUpload = $();
                node.one('uploadabort', fnAbort);
                $(window).one('unload.' + fm.namespace, fnAbort);
                !chunkMerge && (prev = loaded);
                if (!isDataType && !cnt) {
                    return dfrd.reject(['errUploadNoFiles'])
                }
                xhr.addEventListener('error', function () {
                    if (xhr.status == 0) {
                        if (abort) {
                            dfrd.reject()
                        } else {
                            if (!isDataType && data.files && $.grep(data.files, function (f) {
                                    return !f.type && f.size === (self.UA.Safari ? 1802 : 0) ? !0 : !1
                                }).length) {
                                dfrd.reject(['errAbort', 'errFolderUpload'])
                            } else if (data.input && $.grep(data.input.files, function (f) {
                                    return !f.type && f.size === (self.UA.Safari ? 1802 : 0) ? !0 : !1
                                }).length) {
                                dfrd.reject(['errUploadNoFiles'])
                            } else {
                                doRetry()
                            }
                        }
                    } else {
                        node.trigger('uploadabort', 'errConnect')
                    }
                }, !1);
                xhr.addEventListener('load', function (e) {
                    var status = xhr.status, res, curr = 0, error = '', errData, errObj;
                    if (status >= 400) {
                        if (status > 500) {
                            error = 'errResponse'
                        } else {
                            error = ['errResponse', 'errServerError']
                        }
                    } else {
                        if (!xhr.responseText) {
                            error = ['errResponse', 'errDataEmpty']
                        }
                    }
                    if (error) {
                        node.trigger('uploadabort');
                        getFile(files).done(function (file) {
                            return dfrd.reject(file._cid ? null : error)
                        })
                    }
                    loaded = filesize;
                    if (checkNotify() && (curr = loaded - prev)) {
                        self.notify({type: 'upload', cnt: 0, progress: curr, size: 0});
                        progress()
                    }
                    res = self.parseUploadData(xhr.responseText);
                    if (res._chunkmerged) {
                        formData = new FormData();
                        var _file = [{_chunkmerged: res._chunkmerged, _name: res._name, _mtime: res._mtime}];
                        chunkMerge = !0;
                        node.off('uploadabort', fnAbort);
                        notifyto2 = setTimeout(function () {
                            self.notify({type: 'chunkmerge', cnt: 1})
                        }, self.options.notifyDelay);
                        isDataType ? send(_file, files[1]) : send(_file);
                        return
                    }
                    res._multiupload = data.multiupload ? !0 : !1;
                    if (res.error) {
                        errData = {cmd: 'upload', err: res, xhr: xhr, rc: xhr.status};
                        self.trigger('uploadfail', res);
                        self.trigger('requestError', errData);
                        if (errData._event && errData._event.isDefaultPrevented()) {
                            res.error = ''
                        }
                        if (res._chunkfailure || res._multiupload) {
                            abort = !0;
                            self.uploads.xhrUploading = !1;
                            notifyto && clearTimeout(notifyto);
                            if (ntfUpload.length) {
                                self.notify({type: 'upload', cnt: -cnt, progress: 0, size: 0});
                                dfrd.reject(res)
                            } else {
                                dfrd.reject()
                            }
                        } else {
                            dfrd.reject(res)
                        }
                    } else {
                        dfrd.resolve(res)
                    }
                }, !1);
                xhr.upload.addEventListener('loadstart', function (e) {
                    if (!chunkMerge && e.lengthComputable) {
                        loaded = e.loaded;
                        retry && (loaded = 0);
                        filesize = e.total;
                        if (!loaded) {
                            loaded = parseInt(filesize * 0.05)
                        }
                        if (checkNotify()) {
                            self.notify({
                                type: 'upload',
                                cnt: 0,
                                progress: loaded - prev,
                                size: data.multiupload ? 0 : filesize
                            });
                            prev = loaded;
                            progress()
                        }
                    }
                }, !1);
                xhr.upload.addEventListener('progress', function (e) {
                    var curr;
                    if (e.lengthComputable && !chunkMerge && xhr.readyState < 2) {
                        loaded = e.loaded;
                        if (!data.checked && loaded > 0 && !notifyto) {
                            notifyto = startNotify(xhr._totalSize - loaded)
                        }
                        if (!filesize) {
                            filesize = e.total;
                            if (!loaded) {
                                loaded = parseInt(filesize * 0.05)
                            }
                        }
                        curr = loaded - prev;
                        if (checkNotify() && (curr / e.total) >= 0.05) {
                            self.notify({type: 'upload', cnt: 0, progress: curr, size: 0});
                            prev = loaded;
                            progress()
                        }
                        if (!data.multiupload && loaded >= filesize) {
                            cancelBtn = !1;
                            cancelToggle(!1)
                        }
                    }
                }, !1);
                var send = function (files, paths) {
                    var size = 0, fcnt = 1, sfiles = [], c = 0, total = cnt, maxFileSize, totalSize = 0, chunked = [],
                        chunkID = new Date().getTime().toString().substr(-9),
                        BYTES_PER_CHUNK = Math.min((fm.uplMaxSize ? fm.uplMaxSize : 2097152) - 8190, fm.options.uploadMaxChunkSize),
                        blobSlice = chunkEnable ? !1 : '', blobSize, blobMtime, blobName, i, start, end, chunks, blob,
                        chunk, added, done, last, failChunk, multi = function (files, num) {
                            var sfiles = [], cid, sfilesLen = 0, cancelChk;
                            if (!abort) {
                                while (files.length && sfiles.length < num) {
                                    sfiles.push(files.shift())
                                }
                                sfilesLen = sfiles.length;
                                if (sfilesLen) {
                                    cancelChk = sfilesLen;
                                    for (var i = 0; i < sfilesLen; i++) {
                                        if (abort) {
                                            break
                                        }
                                        cid = isDataType ? (sfiles[i][0][0]._cid || null) : (sfiles[i][0]._cid || null);
                                        if (!!failChunk[cid]) {
                                            last--;
                                            continue
                                        }
                                        fm.exec('upload', {
                                            type: data.type,
                                            isDataType: isDataType,
                                            files: sfiles[i],
                                            checked: !0,
                                            target: target,
                                            dropEvt: dropEvt,
                                            renames: renames,
                                            hashes: hashes,
                                            multiupload: !0,
                                            overwrite: data.overwrite === 0 ? 0 : void 0,
                                            clipdata: data.clipdata
                                        }, void 0, target).fail(function (error) {
                                            if (error && error === 'No such command') {
                                                abort = !0;
                                                fm.error(['errUpload', 'errPerm'])
                                            }
                                            if (cid) {
                                                failChunk[cid] = !0
                                            }
                                        }).always(function (e) {
                                            if (e && e.added) added = $.merge(added, e.added);
                                            if (last <= ++done) {
                                                fm.trigger('multiupload', {added: added});
                                                notifyto && clearTimeout(notifyto);
                                                if (checkNotify()) {
                                                    self.notify({type: 'upload', cnt: -cnt, progress: 0, size: 0})
                                                }
                                            }
                                            if (files.length) {
                                                multi(files, 1)
                                            } else {
                                                if (--cancelChk <= 1) {
                                                    cancelBtn = !1;
                                                    cancelToggle(!1)
                                                }
                                            }
                                        })
                                    }
                                }
                            }
                            if (sfiles.length < 1 || abort) {
                                if (abort) {
                                    notifyto && clearTimeout(notifyto);
                                    if (cid) {
                                        failChunk[cid] = !0
                                    }
                                    dfrd.reject()
                                } else {
                                    dfrd.resolve();
                                    self.uploads.xhrUploading = !1
                                }
                            }
                        }, check = function () {
                            if (!self.uploads.xhrUploading) {
                                self.uploads.xhrUploading = !0;
                                multi(sfiles, multiMax)
                            } else {
                                setTimeout(check, 100)
                            }
                        }, reqId, err;
                    if (!dataChecked && (isDataType || data.type == 'files')) {
                        if (!(maxFileSize = fm.option('uploadMaxSize', target))) {
                            maxFileSize = 0
                        }
                        for (i = 0; i < files.length; i++) {
                            try {
                                blob = files[i];
                                blobSize = blob.size;
                                if (blobSlice === !1) {
                                    blobSlice = '';
                                    if (self.api >= 2.1) {
                                        if ('slice' in blob) {
                                            blobSlice = 'slice'
                                        } else if ('mozSlice' in blob) {
                                            blobSlice = 'mozSlice'
                                        } else if ('webkitSlice' in blob) {
                                            blobSlice = 'webkitSlice'
                                        }
                                    }
                                }
                            } catch (e) {
                                cnt--;
                                total--;
                                continue
                            }
                            if ((maxFileSize && blobSize > maxFileSize) || (!blobSlice && fm.uplMaxSize && blobSize > fm.uplMaxSize)) {
                                triggerError(['errUploadFile', blob.name, 'errUploadFileSize'], blob, !0);
                                cnt--;
                                total--;
                                continue
                            }
                            if (blob.type && !self.uploadMimeCheck(blob.type, target)) {
                                triggerError(['errUploadFile', blob.name, 'errUploadMime', '(' + blob.type + ')'], blob, !0);
                                cnt--;
                                total--;
                                continue
                            }
                            if (blobSlice && blobSize > BYTES_PER_CHUNK) {
                                start = 0;
                                end = BYTES_PER_CHUNK;
                                chunks = -1;
                                total = Math.floor((blobSize - 1) / BYTES_PER_CHUNK);
                                blobMtime = blob.lastModified ? Math.round(blob.lastModified / 1000) : 0;
                                blobName = data.clipdata ? fm.date(fm.nonameDateFormat) + '.png' : blob.name;
                                totalSize += blobSize;
                                chunked[chunkID] = 0;
                                while (start < blobSize) {
                                    chunk = blob[blobSlice](start, end);
                                    chunk._chunk = blobName + '.' + (++chunks) + '_' + total + '.part';
                                    chunk._cid = chunkID;
                                    chunk._range = start + ',' + chunk.size + ',' + blobSize;
                                    chunk._mtime = blobMtime;
                                    chunked[chunkID]++;
                                    if (size) {
                                        c++
                                    }
                                    if (typeof sfiles[c] == 'undefined') {
                                        sfiles[c] = [];
                                        if (isDataType) {
                                            sfiles[c][0] = [];
                                            sfiles[c][1] = []
                                        }
                                    }
                                    size = BYTES_PER_CHUNK;
                                    fcnt = 1;
                                    if (isDataType) {
                                        sfiles[c][0].push(chunk);
                                        sfiles[c][1].push(paths[i])
                                    } else {
                                        sfiles[c].push(chunk)
                                    }
                                    start = end;
                                    end = start + BYTES_PER_CHUNK
                                }
                                if (chunk == null) {
                                    triggerError(['errUploadFile', blob.name, 'errUploadFileSize'], blob, !0);
                                    cnt--;
                                    total--
                                } else {
                                    total += chunks;
                                    size = 0;
                                    fcnt = 1;
                                    c++
                                }
                                continue
                            }
                            if ((fm.uplMaxSize && size + blobSize > fm.uplMaxSize) || fcnt > fm.uplMaxFile) {
                                size = 0;
                                fcnt = 1;
                                c++
                            }
                            if (typeof sfiles[c] == 'undefined') {
                                sfiles[c] = [];
                                if (isDataType) {
                                    sfiles[c][0] = [];
                                    sfiles[c][1] = []
                                }
                            }
                            if (isDataType) {
                                sfiles[c][0].push(blob);
                                sfiles[c][1].push(paths[i])
                            } else {
                                sfiles[c].push(blob)
                            }
                            size += blobSize;
                            totalSize += blobSize;
                            fcnt++
                        }
                        if (errors.length) {
                            triggerError()
                        }
                        if (sfiles.length == 0) {
                            data.checked = !0;
                            return !1
                        }
                        if (sfiles.length > 1) {
                            notifyto = startNotify(totalSize);
                            added = [];
                            done = 0;
                            last = sfiles.length;
                            failChunk = [];
                            check();
                            return !0
                        }
                        if (isDataType) {
                            files = sfiles[0][0];
                            paths = sfiles[0][1]
                        } else {
                            files = sfiles[0]
                        }
                    }
                    if (!dataChecked) {
                        if (!fm.UA.Safari || !data.files) {
                            notifyto = startNotify(totalSize)
                        } else {
                            xhr._totalSize = totalSize
                        }
                    }
                    dataChecked = !0;
                    if (!files.length) {
                        dfrd.reject(['errUploadNoFiles'])
                    }
                    xhr.open('POST', self.uploadURL, !0);
                    if (fm.customHeaders) {
                        $.each(fm.customHeaders, function (key) {
                            xhr.setRequestHeader(key, this)
                        })
                    }
                    if (fm.xhrFields) {
                        $.each(fm.xhrFields, function (key) {
                            if (key in xhr) {
                                xhr[key] = this
                            }
                        })
                    }
                    if (self.api >= 2.1029) {
                        reqId = (+new Date()).toString(16) + Math.floor(1000 * Math.random()).toString(16);
                        formData.append('reqid', reqId);
                        xhr._requestId = reqId
                    }
                    formData.append('cmd', 'upload');
                    formData.append(self.newAPI ? 'target' : 'current', target);
                    if (renames && renames.length) {
                        $.each(renames, function (i, v) {
                            formData.append('renames[]', v)
                        });
                        formData.append('suffix', fm.options.backupSuffix)
                    }
                    if (hashes) {
                        $.each(hashes, function (i, v) {
                            formData.append('hashes[' + i + ']', v)
                        })
                    }
                    $.each(self.customData, function (key, val) {
                        formData.append(key, val)
                    });
                    $.each(self.options.onlyMimes, function (i, mime) {
                        formData.append('mimes[]', mime)
                    });
                    $.each(files, function (i, file) {
                        var name;
                        if (file._chunkmerged) {
                            formData.append('chunk', file._chunkmerged);
                            formData.append('upload[]', file._name);
                            formData.append('mtime[]', file._mtime);
                            data.clipdata && formData.append('overwrite', 0)
                        } else {
                            if (file._chunkfail) {
                                formData.append('upload[]', 'chunkfail');
                                formData.append('mimes', 'chunkfail')
                            } else {
                                if (data.clipdata) {
                                    if (!file._chunk) {
                                        data.overwrite = 0;
                                        name = fm.date(fm.nonameDateFormat) + '.png'
                                    }
                                } else {
                                    if (file.name) {
                                        name = file.name;
                                        if (fm.UA.iOS) {
                                            if (name.match(/^image\.jpe?g$/i)) {
                                                data.overwrite = 0;
                                                name = fm.date(fm.nonameDateFormat) + '.jpg'
                                            } else if (name.match(/^capturedvideo\.mov$/i)) {
                                                data.overwrite = 0;
                                                name = fm.date(fm.nonameDateFormat) + '.mov'
                                            }
                                        }
                                    }
                                }
                                name ? formData.append('upload[]', file, name) : formData.append('upload[]', file)
                            }
                            if (file._chunk) {
                                formData.append('chunk', file._chunk);
                                formData.append('cid', file._cid);
                                formData.append('range', file._range);
                                formData.append('mtime[]', file._mtime)
                            } else {
                                formData.append('mtime[]', file.lastModified ? Math.round(file.lastModified / 1000) : 0)
                            }
                        }
                    });
                    if (isDataType) {
                        $.each(paths, function (i, path) {
                            formData.append('upload_path[]', path)
                        })
                    }
                    if (data.overwrite === 0) {
                        formData.append('overwrite', 0)
                    }
                    if (dropEvt) {
                        formData.append('dropWith', parseInt((dropEvt.altKey ? '1' : '0') + (dropEvt.ctrlKey ? '1' : '0') + (dropEvt.metaKey ? '1' : '0') + (dropEvt.shiftKey ? '1' : '0'), 2))
                    }
                    if (extraData) {
                        $.each(extraData, function (key, val) {
                            formData.append(key, val)
                        })
                    }
                    xhr.send(formData);
                    return !0
                };
                if (!isDataType) {
                    if (files.length > 0) {
                        if (!data.clipdata && renames == null) {
                            var mkdirs = [], paths = [], excludes = fm.options.folderUploadExclude[fm.OS] || null;
                            $.each(files, function (i, file) {
                                var relPath = file.webkitRelativePath || file.relativePath || '', idx, rootDir;
                                if (!relPath) {
                                    return !1
                                }
                                if (excludes && file.name.match(excludes)) {
                                    file._remove = !0;
                                    relPath = void(0)
                                } else {
                                    relPath = '/' + relPath.replace(/\/[^\/]*$/, '').replace(/^\//, '');
                                    if (relPath && $.inArray(relPath, mkdirs) === -1) {
                                        mkdirs.push(relPath);
                                        idx = relPath.substr(1).indexOf('/');
                                        if (idx !== -1 && (rootDir = relPath.substr(0, idx + 1)) && $.inArray(rootDir, mkdirs) === -1) {
                                            mkdirs.unshift(rootDir)
                                        }
                                    }
                                }
                                paths.push(relPath)
                            });
                            renames = [];
                            hashes = {};
                            if (mkdirs.length) {
                                (function () {
                                    var checkDirs = $.map(mkdirs, function (name) {
                                        return name.substr(1).indexOf('/') === -1 ? {name: name.substr(1)} : null
                                    }), cancelDirs = [];
                                    fm.uploads.checkExists(checkDirs, target, fm, !0).done(function (res, res2) {
                                        var dfds = [], dfd, bak, hash;
                                        if (fm.options.overwriteUploadConfirm && fm.option('uploadOverwrite', target)) {
                                            cancelDirs = $.map(checkDirs, function (dir) {
                                                return dir._remove ? dir.name : null
                                            });
                                            checkDirs = $.grep(checkDirs, function (dir) {
                                                return !dir._remove ? !0 : !1
                                            })
                                        }
                                        if (cancelDirs.length) {
                                            $.each(paths.concat(), function (i, path) {
                                                if ($.inArray(path, cancelDirs) === 0) {
                                                    files[i]._remove = !0;
                                                    paths[i] = void(0)
                                                }
                                            })
                                        }
                                        files = $.grep(files, function (file) {
                                            return file._remove ? !1 : !0
                                        });
                                        paths = $.grep(paths, function (path) {
                                            return path === void 0 ? !1 : !0
                                        });
                                        if (checkDirs.length) {
                                            dfd = $.Deferred();
                                            if (res.length) {
                                                $.each(res, function (i, existName) {
                                                    bak = fm.uniqueName(existName + fm.options.backupSuffix, null, '');
                                                    $.each(res2, function (h, name) {
                                                        if (res[0] == name) {
                                                            hash = h;
                                                            return !1
                                                        }
                                                    });
                                                    if (!hash) {
                                                        hash = fm.fileByName(res[0], target).hash
                                                    }
                                                    fm.lockfiles({files: [hash]});
                                                    dfds.push(fm.request({
                                                        data: {
                                                            cmd: 'rename',
                                                            target: hash,
                                                            name: bak
                                                        }, notify: {type: 'rename', cnt: 1}
                                                    }).fail(function (error) {
                                                        dfrd.reject(error);
                                                        fm.sync()
                                                    }).always(function () {
                                                        fm.unlockfiles({files: [hash]})
                                                    }))
                                                })
                                            } else {
                                                dfds.push(null)
                                            }
                                            $.when.apply($, dfds).done(function () {
                                                fm.request({
                                                    data: {cmd: 'mkdir', target: target, dirs: mkdirs},
                                                    notify: {type: 'mkdir', cnt: mkdirs.length},
                                                    preventFail: !0
                                                }).fail(function (error) {
                                                    error = error || ['errUnknown'];
                                                    if (error[0] === 'errCmdParams') {
                                                        multiMax = 1
                                                    } else {
                                                        multiMax = 0;
                                                        dfrd.reject(error)
                                                    }
                                                }).done(function (data) {
                                                    var rm = !1;
                                                    if (!data.hashes) {
                                                        data.hashes = {}
                                                    }
                                                    paths = $.map(paths.concat(), function (p, i) {
                                                        if (p === '/') {
                                                            return target
                                                        } else {
                                                            if (data.hashes[p]) {
                                                                return data.hashes[p]
                                                            } else {
                                                                rm = !0;
                                                                files[i]._remove = !0;
                                                                return null
                                                            }
                                                        }
                                                    });
                                                    if (rm) {
                                                        files = $.grep(files, function (file) {
                                                            return file._remove ? !1 : !0
                                                        })
                                                    }
                                                }).always(function (data) {
                                                    if (multiMax) {
                                                        isDataType = !0;
                                                        if (!send(files, paths)) {
                                                            dfrd.reject()
                                                        }
                                                    }
                                                })
                                            })
                                        } else {
                                            dfrd.reject()
                                        }
                                    })
                                })()
                            } else {
                                fm.uploads.checkExists(files, target, fm).done(function (res, res2) {
                                    if (fm.options.overwriteUploadConfirm && fm.option('uploadOverwrite', target)) {
                                        hashes = res2;
                                        if (res === null) {
                                            data.overwrite = 0
                                        } else {
                                            renames = res
                                        }
                                        files = $.grep(files, function (file) {
                                            return !file._remove ? !0 : !1
                                        })
                                    }
                                    cnt = files.length;
                                    if (cnt > 0) {
                                        if (!send(files)) {
                                            dfrd.reject()
                                        }
                                    } else {
                                        dfrd.reject()
                                    }
                                })
                            }
                        } else {
                            if (!send(files)) {
                                dfrd.reject()
                            }
                        }
                    } else {
                        dfrd.reject()
                    }
                } else {
                    if (dataChecked) {
                        send(files[0], files[1])
                    } else {
                        files.done(function (result) {
                            renames = [];
                            cnt = result[0].length;
                            if (cnt) {
                                if (result[4] && result[4].length) {
                                    fm.request({
                                        data: {cmd: 'mkdir', target: target, dirs: result[4]},
                                        notify: {type: 'mkdir', cnt: result[4].length},
                                        preventFail: !0
                                    }).fail(function (error) {
                                        error = error || ['errUnknown'];
                                        if (error[0] === 'errCmdParams') {
                                            multiMax = 1
                                        } else {
                                            multiMax = 0;
                                            dfrd.reject(error)
                                        }
                                    }).done(function (data) {
                                        var rm = !1;
                                        if (!data.hashes) {
                                            data.hashes = {}
                                        }
                                        result[1] = $.map(result[1], function (p, i) {
                                            p = p.replace(/\/[^\/]*$/, '');
                                            if (p === '') {
                                                return target
                                            } else {
                                                if (data.hashes[p]) {
                                                    return data.hashes[p]
                                                } else {
                                                    rm = !0;
                                                    result[0][i]._remove = !0;
                                                    return null
                                                }
                                            }
                                        });
                                        if (rm) {
                                            result[0] = $.grep(result[0], function (file) {
                                                return file._remove ? !1 : !0
                                            })
                                        }
                                    }).always(function (data) {
                                        if (multiMax) {
                                            renames = result[2];
                                            hashes = result[3];
                                            send(result[0], result[1])
                                        }
                                    });
                                    return
                                } else {
                                    result[1] = $.map(result[1], function () {
                                        return target
                                    })
                                }
                                renames = result[2];
                                hashes = result[3];
                                send(result[0], result[1])
                            } else {
                                dfrd.reject(['errUploadNoFiles'])
                            }
                        }).fail(function () {
                            dfrd.reject()
                        })
                    }
                }
                return dfrd
            }, iframe: function (data, fm) {
                var self = fm ? fm : this, input = data.input ? data.input : !1,
                    files = !input ? self.uploads.checkFile(data, self) : !1,
                    dfrd = $.Deferred().fail(function (error) {
                        error && self.error(error)
                    }), name = 'iframe-' + fm.namespace + (++self.iframeCnt),
                    form = $('<form action="' + self.uploadURL + '" method="post" enctype="multipart/form-data" encoding="multipart/form-data" target="' + name + '" style="display:none"><input type="hidden" name="cmd" value="upload" /></form>'),
                    msie = this.UA.IE, onload = function () {
                        abortto && clearTimeout(abortto);
                        notifyto && clearTimeout(notifyto);
                        notify && self.notify({type: 'upload', cnt: -cnt});
                        setTimeout(function () {
                            msie && $('<iframe src="javascript:false;"/>').appendTo(form);
                            form.remove();
                            iframe.remove()
                        }, 100)
                    },
                    iframe = $('<iframe src="' + (msie ? 'javascript:false;' : 'about:blank') + '" name="' + name + '" style="position:absolute;left:-1000px;top:-1000px" />').on('load', function () {
                        iframe.off('load').on('load', function () {
                            onload();
                            dfrd.resolve()
                        });
                        notifyto = setTimeout(function () {
                            notify = !0;
                            self.notify({type: 'upload', cnt: cnt})
                        }, self.options.notifyDelay);
                        if (self.options.iframeTimeout > 0) {
                            abortto = setTimeout(function () {
                                onload();
                                dfrd.reject(['errConnect', 'errTimeout'])
                            }, self.options.iframeTimeout)
                        }
                        form.submit()
                    }), target = (data.target || self.cwd().hash), names = [], dfds = [], renames = [], hashes = {},
                    cnt, notify, notifyto, abortto;
                if (files && files.length) {
                    $.each(files, function (i, val) {
                        form.append('<input type="hidden" name="upload[]" value="' + val + '"/>')
                    });
                    cnt = 1
                } else if (input && $(input).is(':file') && $(input).val()) {
                    if (fm.options.overwriteUploadConfirm && fm.option('uploadOverwrite', target)) {
                        names = input.files ? input.files : [{name: $(input).val().replace(/^(?:.+[\\\/])?([^\\\/]+)$/, '$1')}];
                        dfds.push(self.uploads.checkExists(names, target, self).done(function (res, res2) {
                            hashes = res2;
                            if (res === null) {
                                data.overwrite = 0
                            } else {
                                renames = res;
                                cnt = $.grep(names, function (file) {
                                    return !file._remove ? !0 : !1
                                }).length;
                                if (cnt != names.length) {
                                    cnt = 0
                                }
                            }
                        }))
                    }
                    cnt = input.files ? input.files.length : 1;
                    form.append(input)
                } else {
                    return dfrd.reject()
                }
                $.when.apply($, dfds).done(function () {
                    if (cnt < 1) {
                        return dfrd.reject()
                    }
                    form.append('<input type="hidden" name="' + (self.newAPI ? 'target' : 'current') + '" value="' + target + '"/>').append('<input type="hidden" name="html" value="1"/>').append('<input type="hidden" name="node" value="' + self.id + '"/>').append($(input).attr('name', 'upload[]'));
                    if (renames.length > 0) {
                        $.each(renames, function (i, rename) {
                            form.append('<input type="hidden" name="renames[]" value="' + self.escape(rename) + '"/>')
                        });
                        form.append('<input type="hidden" name="suffix" value="' + fm.options.backupSuffix + '"/>')
                    }
                    if (hashes) {
                        $.each(renames, function (i, v) {
                            form.append('<input type="hidden" name="[' + i + ']" value="' + self.escape(v) + '"/>')
                        })
                    }
                    if (data.overwrite === 0) {
                        form.append('<input type="hidden" name="overwrite" value="0"/>')
                    }
                    $.each(self.options.onlyMimes || [], function (i, mime) {
                        form.append('<input type="hidden" name="mimes[]" value="' + self.escape(mime) + '"/>')
                    });
                    $.each(self.customData, function (key, val) {
                        form.append('<input type="hidden" name="' + key + '" value="' + self.escape(val) + '"/>')
                    });
                    form.appendTo('body');
                    iframe.appendTo('body')
                });
                return dfrd
            }
        },
        one: function (ev, callback, priorityFirst) {
            var self = this, event = ev.toLowerCase(), h = function (e, f) {
                if (!self.toUnbindEvents[event]) {
                    self.toUnbindEvents[event] = []
                }
                self.toUnbindEvents[event].push({type: event, callback: h});
                return (callback.done ? callback.done : callback).apply(this, arguments)
            };
            if (callback.done) {
                h = {done: h}
            }
            return this.bind(event, h, priorityFirst)
        },
        localStorage: function (key, val) {
            var self = this, s = window.localStorage, oldkey = 'elfinder-' + (key || '') + this.id,
                prefix = window.location.pathname + '-elfinder-', suffix = this.id, clrs = [], retval, oldval, t,
                precnt, sufcnt;
            if (typeof(key) === 'undefined') {
                precnt = prefix.length;
                sufcnt = suffix.length * -1;
                $.each(s, function (key) {
                    if (key.substr(0, precnt) === prefix && key.substr(sufcnt) === suffix) {
                        clrs.push(key)
                    }
                });
                $.each(clrs, function (i, key) {
                    s.removeItem(key)
                });
                return !0
            }
            key = prefix + key + suffix;
            if (val === null) {
                return s.removeItem(key)
            }
            if (val === void(0) && !(retval = s.getItem(key)) && (oldval = s.getItem(oldkey))) {
                val = oldval;
                s.removeItem(oldkey)
            }
            if (val !== void(0)) {
                t = typeof val;
                if (t !== 'string' && t !== 'number') {
                    val = JSON.stringify(val)
                }
                try {
                    s.setItem(key, val)
                } catch (e) {
                    try {
                        s.clear();
                        s.setItem(key, val)
                    } catch (e) {
                        self.debug('error', e.toString())
                    }
                }
                retval = s.getItem(key)
            }
            if (retval && (retval.substr(0, 1) === '{' || retval.substr(0, 1) === '[')) {
                try {
                    return JSON.parse(retval)
                } catch (e) {
                }
            }
            return retval
        },
        cookie: function (name, value) {
            var d, o, c, i, retval, t;
            name = 'elfinder-' + name + this.id;
            if (value === void(0)) {
                if (document.cookie && document.cookie != '') {
                    c = document.cookie.split(';');
                    name += '=';
                    for (i = 0; i < c.length; i++) {
                        c[i] = $.trim(c[i]);
                        if (c[i].substring(0, name.length) == name) {
                            retval = decodeURIComponent(c[i].substring(name.length));
                            if (retval.substr(0, 1) === '{' || retval.substr(0, 1) === '[') {
                                try {
                                    return JSON.parse(retval)
                                } catch (e) {
                                }
                            }
                            return retval
                        }
                    }
                }
                return null
            }
            o = Object.assign({}, this.options.cookie);
            if (value === null) {
                value = '';
                o.expires = -1
            } else {
                t = typeof value;
                if (t !== 'string' && t !== 'number') {
                    value = JSON.stringify(value)
                }
            }
            if (typeof(o.expires) == 'number') {
                d = new Date();
                d.setTime(d.getTime() + (o.expires * 86400000));
                o.expires = d
            }
            document.cookie = name + '=' + encodeURIComponent(value) + '; expires=' + o.expires.toUTCString() + (o.path ? '; path=' + o.path : '') + (o.domain ? '; domain=' + o.domain : '') + (o.secure ? '; secure' : '');
            if (value && (value.substr(0, 1) === '{' || value.substr(0, 1) === '[')) {
                try {
                    return JSON.parse(value)
                } catch (e) {
                }
            }
            return value
        },
        startDir: function () {
            var locHash = window.location.hash;
            if (locHash && locHash.match(/^#elf_/)) {
                return locHash.replace(/^#elf_/, '')
            } else if (this.options.startPathHash) {
                return this.options.startPathHash
            } else {
                return this.lastDir()
            }
        },
        lastDir: function (hash) {
            return this.options.rememberLastDir ? this.storage('lastdir', hash) : ''
        },
        _node: $('<span/>'),
        escape: function (name) {
            return this._node.text(name).html().replace(/"/g, '&quot;').replace(/'/g, '&#039;')
        },
        normalize: function (data) {
            var self = this, fileFilter = (function () {
                var func, filter;
                if (filter = self.options.fileFilter) {
                    if (typeof filter === 'function') {
                        func = function (file) {
                            return filter.call(self, file)
                        }
                    } else if (filter instanceof RegExp) {
                        func = function (file) {
                            return filter.test(file.name)
                        }
                    }
                }
                return func ? func : null
            })(), chkCmdMap = function (opts) {
                var disabled;
                if (opts.uiCmdMap) {
                    if ($.isPlainObject(opts.uiCmdMap) && Object.keys(opts.uiCmdMap).length) {
                        if (!opts.disabledFlip) {
                            opts.disabledFlip = {}
                        }
                        disabled = opts.disabledFlip;
                        $.each(opts.uiCmdMap, function (f, t) {
                            if (t === 'hidden' && !disabled[f]) {
                                opts.disabled.push(f);
                                opts.disabledFlip[f] = !0
                            }
                        })
                    } else {
                        delete opts.uiCmdMap
                    }
                }
            }, normalizeOptions = function (opts) {
                var getType = function (v) {
                    var type = typeof v;
                    if (type === 'object' && Array.isArray(v)) {
                        type = 'array'
                    }
                    return type
                };
                $.each(self.optionProperties, function (k, empty) {
                    if (empty !== void(0)) {
                        if (opts[k] && getType(opts[k]) !== getType(empty)) {
                            opts[k] = empty
                        }
                    }
                });
                if (opts.disabled) {
                    opts.disabledFlip = self.arrayFlip(opts.disabled, !0)
                } else {
                    opts.disabledFlip = {}
                }
                return opts
            }, filter = function (file, asMap, type) {
                var res = asMap ? file : !0, ign = asMap ? null : !1, vid, targetOptions, isRoot, rootNames;
                if (file && file.hash && file.name && file.mime) {
                    if (file.mime === 'application/x-empty') {
                        file.mime = 'text/plain'
                    }
                    isRoot = self.isRoot(file);
                    if (isRoot && !file.volumeid) {
                        self.debug('warning', 'The volume root statuses requires `volumeid` property.')
                    }
                    if (isRoot || file.mime === 'directory') {
                        if (file.phash) {
                            if (file.phash === file.hash) {
                                error = error.concat(['Parent folder of "$1" is itself.', file.name]);
                                return ign
                            }
                            if (isRoot && file.volumeid && file.phash.indexOf(file.volumeid) === 0) {
                                error = error.concat(['Parent folder of "$1" is inner itself.', file.name]);
                                return ign
                            }
                        }
                        if (file.volumeid) {
                            vid = file.volumeid;
                            if (isRoot) {
                                if (file.phash) {
                                    if (!self.leafRoots[file.phash]) {
                                        self.leafRoots[file.phash] = [file.hash]
                                    } else {
                                        if ($.inArray(file.hash, self.leafRoots[file.phash]) === -1) {
                                            self.leafRoots[file.phash].push(file.hash)
                                        }
                                    }
                                }
                                self.hasVolOptions = !0;
                                if (!self.volOptions[vid]) {
                                    self.volOptions[vid] = {dispInlineRegex: self.options.dispInlineRegex}
                                }
                                targetOptions = self.volOptions[vid];
                                if (file.options) {
                                    Object.assign(targetOptions, file.options)
                                }
                                if (file.disabled) {
                                    targetOptions.disabled = file.disabled;
                                    targetOptions.disabledFlip = self.arrayFlip(file.disabled, !0)
                                }
                                if (file.tmbUrl) {
                                    targetOptions.tmbUrl = file.tmbUrl
                                }
                                if (targetOptions.url && targetOptions.url.substr(-1) !== '/') {
                                    targetOptions.url += '/'
                                }
                                chkCmdMap(targetOptions);
                                if (targetOptions.trashHash) {
                                    if (self.trashes[targetOptions.trashHash] === !1) {
                                        delete targetOptions.trashHash
                                    } else {
                                        self.trashes[targetOptions.trashHash] = file.hash
                                    }
                                }
                                $.each(self.optionProperties, function (k) {
                                    if (targetOptions[k]) {
                                        file[k] = targetOptions[k]
                                    }
                                });
                                if (type !== 'cwd') {
                                    self.roots[vid] = file.hash
                                }
                                if (file.expires) {
                                    self.volumeExpires[vid] = file.expires
                                }
                            }
                            if (prevId !== vid) {
                                prevId = vid;
                                i18nFolderName = self.option('i18nFolderName', vid)
                            }
                        }
                        if (isRoot && !file.i18) {
                            name = 'volume_' + file.name, i18 = self.i18n(!1, name);
                            if (name !== i18) {
                                file.i18 = i18
                            }
                        }
                        if (i18nFolderName && !file.i18) {
                            name = 'folder_' + file.name, i18 = self.i18n(!1, name);
                            if (name !== i18) {
                                file.i18 = i18
                            }
                        }
                        if (isRoot) {
                            if (rootNames = self.storage('rootNames')) {
                                if (rootNames[file.hash]) {
                                    file._name = file.name;
                                    file._i18 = file.i18;
                                    file.name = rootNames[file.hash] = rootNames[file.hash];
                                    delete file.i18
                                }
                                self.storage('rootNames', rootNames)
                            }
                        }
                        if (self.trashes[file.hash]) {
                            file.locked = !0
                        }
                    } else {
                        if (fileFilter) {
                            try {
                                if (!fileFilter(file)) {
                                    return ign
                                }
                            } catch (e) {
                                self.debug(e)
                            }
                        }
                        if (file.size == 0) {
                            file.mime = self.getMimetype(file.name, file.mime)
                        }
                    }
                    if (file.options) {
                        self.optionsByHashes[file.hash] = normalizeOptions(file.options)
                    }
                    delete file.options;
                    return res
                }
                return ign
            }, getDescendants = function (hashes) {
                var res = [];
                $.each(self.files(), function (h, f) {
                    $.each(self.parents(h), function (i, ph) {
                        if ($.inArray(ph, hashes) !== -1 && $.inArray(h, hashes) === -1) {
                            res.push(h);
                            return !1
                        }
                    })
                });
                return res
            }, applyLeafRootStats = function (dataArr, type) {
                $.each(dataArr, function (i, f) {
                    var pfile, done;
                    if (self.leafRoots[f.hash]) {
                        self.applyLeafRootStats(f)
                    }
                    if (type !== 'change' && f.phash && self.isRoot(f) && (pfile = self.file(f.phash))) {
                        self.applyLeafRootStats(pfile);
                        if (!data.changed) {
                            data.changed = [pfile]
                        } else {
                            $.each(data.changed, function (i, f) {
                                if (f.hash === pfile.hash) {
                                    data.changed[i] = pfile;
                                    done = !0;
                                    return !1
                                }
                            });
                            if (!done) {
                                data.changed.push(pfile)
                            }
                        }
                    }
                })
            }, error = [], name, i18, i18nFolderName, prevId, cData;
            if (data.customData && data.customData !== self.prevCustomData) {
                self.prevCustomData = data.customData;
                try {
                    cData = JSON.parse(data.customData);
                    if ($.isPlainObject(cData)) {
                        self.prevCustomData = cData;
                        $.each(Object.keys(cData), function (i, key) {
                            if (cData[key] === null) {
                                delete cData[key];
                                delete self.optsCustomData[key]
                            }
                        });
                        self.customData = Object.assign({}, self.optsCustomData, cData)
                    }
                } catch (e) {
                }
            }
            if (data.options) {
                normalizeOptions(data.options)
            }
            if (data.cwd) {
                if (data.cwd.volumeid && data.options && Object.keys(data.options).length && self.isRoot(data.cwd)) {
                    self.hasVolOptions = !0;
                    self.volOptions[data.cwd.volumeid] = data.options
                }
                data.cwd = filter(data.cwd, !0, 'cwd')
            }
            if (data.files) {
                data.files = $.grep(data.files, filter)
            }
            if (data.tree) {
                data.tree = $.grep(data.tree, filter)
            }
            if (data.added) {
                data.added = $.grep(data.added, filter)
            }
            if (data.changed) {
                data.changed = $.grep(data.changed, filter)
            }
            if (data.removed && data.removed.length && self.searchStatus.state === 2) {
                data.removed = data.removed.concat(getDescendants(data.removed))
            }
            if (data.api) {
                data.init = !0
            }
            if (Object.keys(self.leafRoots).length) {
                data.files && applyLeafRootStats(data.files);
                data.tree && applyLeafRootStats(data.tree);
                data.added && applyLeafRootStats(data.added);
                data.changed && applyLeafRootStats(data.changed, 'change')
            }
            if (data.cwd && data.cwd.options && data.options) {
                Object.assign(data.options, normalizeOptions(data.cwd.options))
            }
            if (data.options && data.options.url && data.options.url.substr(-1) !== '/') {
                data.options.url += '/'
            }
            if (error.length) {
                data.norError = ['errResponse'].concat(error)
            }
            return data
        },
        setSort: function (type, order, stickFolders, alsoTreeview) {
            this.storage('sortType', (this.sortType = this.sortRules[type] ? type : 'name'));
            this.storage('sortOrder', (this.sortOrder = /asc|desc/.test(order) ? order : 'asc'));
            this.storage('sortStickFolders', (this.sortStickFolders = !!stickFolders) ? 1 : '');
            this.storage('sortAlsoTreeview', (this.sortAlsoTreeview = !!alsoTreeview) ? 1 : '');
            this.trigger('sortchange')
        },
        _sortRules: {
            name: function (file1, file2) {
                return elFinder.prototype.naturalCompare(file1.i18 || file1.name, file2.i18 || file2.name)
            }, size: function (file1, file2) {
                var size1 = parseInt(file1.size) || 0, size2 = parseInt(file2.size) || 0;
                return size1 === size2 ? 0 : size1 > size2 ? 1 : -1
            }, kind: function (file1, file2) {
                return elFinder.prototype.naturalCompare(file1.mime, file2.mime)
            }, date: function (file1, file2) {
                var date1 = file1.ts || file1.date || 0, date2 = file2.ts || file2.date || 0;
                return date1 === date2 ? 0 : date1 > date2 ? 1 : -1
            }, perm: function (file1, file2) {
                var val = function (file) {
                    return (file.write ? 2 : 0) + (file.read ? 1 : 0)
                }, v1 = val(file1), v2 = val(file2);
                return v1 === v2 ? 0 : v1 > v2 ? 1 : -1
            }, mode: function (file1, file2) {
                var v1 = file1.mode || (file1.perm || ''), v2 = file2.mode || (file2.perm || '');
                return elFinder.prototype.naturalCompare(v1, v2)
            }, owner: function (file1, file2) {
                var v1 = file1.owner || '', v2 = file2.owner || '';
                return elFinder.prototype.naturalCompare(v1, v2)
            }, group: function (file1, file2) {
                var v1 = file1.group || '', v2 = file2.group || '';
                return elFinder.prototype.naturalCompare(v1, v2)
            }
        },
        sorters: {},
        naturalCompare: function (a, b) {
            var self = elFinder.prototype.naturalCompare;
            if (typeof self.loc == 'undefined') {
                self.loc = (navigator.userLanguage || navigator.browserLanguage || navigator.language || 'en-US')
            }
            if (typeof self.sort == 'undefined') {
                if ('11'.localeCompare('2', self.loc, {numeric: !0}) > 0) {
                    if (window.Intl && window.Intl.Collator) {
                        self.sort = new Intl.Collator(self.loc, {numeric: !0}).compare
                    } else {
                        self.sort = function (a, b) {
                            return a.localeCompare(b, self.loc, {numeric: !0})
                        }
                    }
                } else {
                    self.sort = function (a, b) {
                        var re = /(^-?[0-9]+(\.?[0-9]*)[df]?e?[0-9]?$|^0x[0-9a-f]+$|[0-9]+)/gi, sre = /(^[ ]*|[ ]*$)/g,
                            dre = /(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,
                            hre = /^0x[0-9a-f]+$/i, ore = /^0/, syre = /^[\x01\x21-\x2f\x3a-\x40\x5b-\x60\x7b-\x7e]/,
                            i = function (s) {
                                return self.sort.insensitive && ('' + s).toLowerCase() || '' + s
                            }, x = i(a).replace(sre, '').replace(/^_/, "\x01") || '',
                            y = i(b).replace(sre, '').replace(/^_/, "\x01") || '',
                            xN = x.replace(re, '\0$1\0').replace(/\0$/, '').replace(/^\0/, '').split('\0'),
                            yN = y.replace(re, '\0$1\0').replace(/\0$/, '').replace(/^\0/, '').split('\0'),
                            xD = parseInt(x.match(hre)) || (xN.length != 1 && x.match(dre) && Date.parse(x)),
                            yD = parseInt(y.match(hre)) || xD && y.match(dre) && Date.parse(y) || null, oFxNcL, oFyNcL,
                            locRes = 0;
                        if (yD) {
                            if (xD < yD) return -1; else if (xD > yD) return 1
                        }
                        for (var cLoc = 0, numS = Math.max(xN.length, yN.length); cLoc < numS; cLoc++) {
                            oFxNcL = !(xN[cLoc] || '').match(ore) && parseFloat(xN[cLoc]) || xN[cLoc] || 0;
                            oFyNcL = !(yN[cLoc] || '').match(ore) && parseFloat(yN[cLoc]) || yN[cLoc] || 0;
                            if (isNaN(oFxNcL) !== isNaN(oFyNcL)) {
                                if (isNaN(oFxNcL) && (typeof oFxNcL !== 'string' || !oFxNcL.match(syre))) {
                                    return 1
                                } else if (typeof oFyNcL !== 'string' || !oFyNcL.match(syre)) {
                                    return -1
                                }
                            }
                            if (parseInt(oFxNcL, 10) === 0) oFxNcL = 0;
                            if (parseInt(oFyNcL, 10) === 0) oFyNcL = 0;
                            if (typeof oFxNcL !== typeof oFyNcL) {
                                oFxNcL += '';
                                oFyNcL += ''
                            }
                            if (self.sort.insensitive && typeof oFxNcL === 'string' && typeof oFyNcL === 'string') {
                                locRes = oFxNcL.localeCompare(oFyNcL, self.loc);
                                if (locRes !== 0) return locRes
                            }
                            if (oFxNcL < oFyNcL) return -1;
                            if (oFxNcL > oFyNcL) return 1
                        }
                        return 0
                    };
                    self.sort.insensitive = !0
                }
            }
            return self.sort(a, b)
        },
        compare: function (file1, file2) {
            var self = this, type = self.sortType, asc = self.sortOrder == 'asc', stick = self.sortStickFolders,
                rules = self.sortRules, sort = rules[type], d1 = file1.mime == 'directory',
                d2 = file2.mime == 'directory', res;
            if (stick) {
                if (d1 && !d2) {
                    return -1
                } else if (!d1 && d2) {
                    return 1
                }
            }
            res = asc ? sort(file1, file2) : sort(file2, file1);
            return type !== 'name' && res === 0 ? res = asc ? rules.name(file1, file2) : rules.name(file2, file1) : res
        },
        sortFiles: function (files) {
            return files.sort(this.compare)
        },
        notify: function (opts) {
            var type = opts.type, id = opts.id ? 'elfinder-notify-' + opts.id : '',
                msg = this.i18n((typeof opts.msg !== 'undefined') ? opts.msg : (this.messages['ntf' + type] ? 'ntf' + type : 'ntfsmth')),
                ndialog = this.ui.notify,
                notify = ndialog.children('.elfinder-notify-' + type + (id ? ('.' + id) : '')),
                button = notify.children('div.elfinder-notify-cancel').children('button'),
                ntpl = '<div class="elfinder-notify elfinder-notify-{type}' + (id ? (' ' + id) : '') + '"><span class="elfinder-dialog-icon elfinder-dialog-icon-{type}"/><span class="elfinder-notify-msg">{msg}</span> <span class="elfinder-notify-cnt"/><div class="elfinder-notify-progressbar"><div class="elfinder-notify-progress"/></div><div class="elfinder-notify-cancel"/></div>',
                delta = opts.cnt, size = (typeof opts.size != 'undefined') ? parseInt(opts.size) : null,
                progress = (typeof opts.progress != 'undefined' && opts.progress >= 0) ? opts.progress : null,
                cancel = opts.cancel, clhover = 'ui-state-hover', close = function () {
                    notify._esc && $(document).off('keydown', notify._esc);
                    notify.remove();
                    !ndialog.children().length && ndialog.elfinderdialog('close')
                }, cnt, total, prc;
            if (!type) {
                return this
            }
            if (!notify.length) {
                notify = $(ntpl.replace(/\{type\}/g, type).replace(/\{msg\}/g, msg)).appendTo(ndialog).data('cnt', 0);
                if (progress != null) {
                    notify.data({progress: 0, total: 0})
                }
                if (cancel) {
                    button = $('<button type="button" class="ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only"><span class="ui-button-text">' + this.i18n('btnCancel') + '</span></button>').on('mouseenter mouseleave', function (e) {
                        $(this).toggleClass(clhover, e.type === 'mouseenter')
                    });
                    notify.children('div.elfinder-notify-cancel').append(button)
                }
            } else if (typeof opts.msg !== 'undefined') {
                notify.children('span.elfinder-notify-msg').html(msg)
            }
            cnt = delta + parseInt(notify.data('cnt'));
            if (cnt > 0) {
                if (cancel && button.length) {
                    if ($.isFunction(cancel) || (typeof cancel === 'object' && cancel.promise)) {
                        notify._esc = function (e) {
                            if (e.type == 'keydown' && e.keyCode != $.ui.keyCode.ESCAPE) {
                                return
                            }
                            e.preventDefault();
                            e.stopPropagation();
                            close();
                            if (cancel.promise) {
                                cancel.reject(0)
                            } else {
                                cancel(e)
                            }
                        };
                        button.on('click', function (e) {
                            notify._esc(e)
                        });
                        $(document).on('keydown.' + this.namespace, notify._esc)
                    }
                }
                !opts.hideCnt && notify.children('.elfinder-notify-cnt').text('(' + cnt + ')');
                ndialog.is(':hidden') && ndialog.elfinderdialog('open', this).height('auto');
                notify.data('cnt', cnt);
                if ((progress != null) && (total = notify.data('total')) >= 0 && (prc = notify.data('progress')) >= 0) {
                    total += size != null ? size : delta;
                    prc += progress;
                    (size == null && delta < 0) && (prc += delta * 100);
                    notify.data({progress: prc, total: total});
                    if (size != null) {
                        prc *= 100;
                        total = Math.max(1, total)
                    }
                    progress = parseInt(prc / total);
                    notify.find('.elfinder-notify-progress').animate({width: (progress < 100 ? progress : 100) + '%'}, 20)
                }
            } else {
                close()
            }
            return this
        },
        confirm: function (opts) {
            var self = this, complete = !1, options = {
                cssClass: 'elfinder-dialog-confirm',
                modal: !0,
                resizable: !1,
                title: this.i18n(opts.title || 'confirmReq'),
                buttons: {},
                close: function () {
                    !complete && opts.cancel.callback();
                    $(this).elfinderdialog('destroy')
                }
            }, apply = this.i18n('apllyAll'), label, checkbox, btnNum;
            if (opts.cssClass) {
                options.cssClass += ' ' + opts.cssClass
            }
            options.buttons[this.i18n(opts.accept.label)] = function () {
                opts.accept.callback(!!(checkbox && checkbox.prop('checked')));
                complete = !0;
                $(this).elfinderdialog('close')
            };
            options.buttons[this.i18n(opts.accept.label)]._cssClass = 'elfinder-confirm-accept';
            if (opts.reject) {
                options.buttons[this.i18n(opts.reject.label)] = function () {
                    opts.reject.callback(!!(checkbox && checkbox.prop('checked')));
                    complete = !0;
                    $(this).elfinderdialog('close')
                };
                options.buttons[this.i18n(opts.reject.label)]._cssClass = 'elfinder-confirm-reject'
            }
            if (opts.buttons && opts.buttons.length > 0) {
                btnNum = 1;
                $.each(opts.buttons, function (i, v) {
                    options.buttons[self.i18n(v.label)] = function () {
                        v.callback(!!(checkbox && checkbox.prop('checked')));
                        complete = !0;
                        $(this).elfinderdialog('close')
                    };
                    options.buttons[self.i18n(v.label)]._cssClass = 'elfinder-confirm-extbtn' + (btnNum++);
                    if (v.cssClass) {
                        options.buttons[self.i18n(v.label)]._cssClass += ' ' + v.cssClass
                    }
                })
            }
            options.buttons[this.i18n(opts.cancel.label)] = function () {
                $(this).elfinderdialog('close')
            };
            options.buttons[this.i18n(opts.cancel.label)]._cssClass = 'elfinder-confirm-cancel';
            if (opts.all) {
                options.create = function () {
                    var base = $('<div class="elfinder-dialog-confirm-applyall"/>');
                    checkbox = $('<input type="checkbox" />');
                    $(this).next().find('.ui-dialog-buttonset').prepend(base.append($('<label>' + apply + '</label>').prepend(checkbox)))
                }
            }
            if (opts.optionsCallback && $.isFunction(opts.optionsCallback)) {
                opts.optionsCallback(options)
            }
            return this.dialog('<span class="elfinder-dialog-icon elfinder-dialog-icon-confirm"/>' + this.i18n(opts.text), options)
        },
        uniqueName: function (prefix, phash, glue) {
            var i = 0, ext = '', p, name;
            prefix = this.i18n(!1, prefix);
            phash = phash || this.cwd().hash;
            glue = (typeof glue === 'undefined') ? ' ' : glue;
            if (p = prefix.match(/^(.+)(\.[^.]+)$/)) {
                ext = p[2];
                prefix = p[1]
            }
            name = prefix + ext;
            if (!this.fileByName(name, phash)) {
                return name
            }
            while (i < 10000) {
                name = prefix + glue + (++i) + ext;
                if (!this.fileByName(name, phash)) {
                    return name
                }
            }
            return prefix + Math.random() + ext
        },
        i18n: function () {
            var self = this, messages = this.messages, input = [], ignore = [], message = function (m) {
                var file;
                if (m.indexOf('#') === 0) {
                    if ((file = self.file(m.substr(1)))) {
                        return file.name
                    }
                }
                return m
            }, i, j, m, escFunc, start = 0, isErr;
            if (arguments.length && arguments[0] === !1) {
                escFunc = function (m) {
                    return m
                };
                start = 1
            }
            for (i = start; i < arguments.length; i++) {
                m = arguments[i];
                if (Array.isArray(m)) {
                    for (j = 0; j < m.length; j++) {
                        if (m[j] instanceof jQuery) {
                            input.push(m[j])
                        } else if (typeof m[j] !== 'undefined') {
                            input.push(message('' + m[j]))
                        }
                    }
                } else if (m instanceof jQuery) {
                    input.push(m[j])
                } else if (typeof m !== 'undefined') {
                    input.push(message('' + m))
                }
            }
            for (i = 0; i < input.length; i++) {
                if ($.inArray(i, ignore) !== -1) {
                    continue
                }
                m = input[i];
                if (typeof m == 'string') {
                    isErr = !!(messages[m] && m.match(/^err/));
                    m = messages[m] || (escFunc ? escFunc(m) : self.escape(m));
                    m = m.replace(/\$(\d+)/g, function (match, placeholder) {
                        var res;
                        placeholder = i + parseInt(placeholder);
                        if (placeholder > 0 && input[placeholder]) {
                            ignore.push(placeholder)
                        }
                        res = escFunc ? escFunc(input[placeholder]) : self.escape(input[placeholder]);
                        if (isErr) {
                            res = '<span class="elfinder-err-var elfinder-err-var' + placeholder + '">' + res + '</span>'
                        }
                        return res
                    })
                } else {
                    m = m.get(0).outerHTML
                }
                input[i] = m
            }
            return $.grep(input, function (m, i) {
                return $.inArray(i, ignore) === -1 ? !0 : !1
            }).join('<br>')
        },
        getIconStyle: function (file, asObject) {
            var self = this, template = {'background': 'url(\'{url}\') 0 0 no-repeat', 'background-size': 'contain'},
                style = '', cssObj = {}, i = 0;
            if (file.icon) {
                style = 'style="';
                $.each(template, function (k, v) {
                    if (i++ === 0) {
                        v = v.replace('{url}', self.escape(file.icon))
                    }
                    if (asObject) {
                        cssObj[k] = v
                    } else {
                        style += k + ':' + v + ';'
                    }
                });
                style += '"'
            }
            return asObject ? cssObj : style
        },
        mime2class: function (mimeType) {
            var prefix = 'elfinder-cwd-icon-', mime = mimeType.toLowerCase(), isText = this.textMimes[mime];
            mime = mime.split('/');
            if (isText) {
                mime[0] += ' ' + prefix + 'text'
            } else if (mime[1] && mime[1].match(/\+xml$/)) {
                mime[0] += ' ' + prefix + 'xml'
            }
            return prefix + mime[0] + (mime[1] ? ' ' + prefix + mime[1].replace(/(\.|\+)/g, '-') : '')
        },
        mime2kind: function (f) {
            var isObj = typeof(f) == 'object' ? !0 : !1, mime = isObj ? f.mime : f, kind;
            if (isObj && f.alias && mime != 'symlink-broken') {
                kind = 'Alias'
            } else if (this.kinds[mime]) {
                if (isObj && mime === 'directory' && (!f.phash || f.isroot)) {
                    kind = 'Root'
                } else {
                    kind = this.kinds[mime]
                }
            }
            if (!kind) {
                if (mime.indexOf('text') === 0) {
                    kind = 'Text'
                } else if (mime.indexOf('image') === 0) {
                    kind = 'Image'
                } else if (mime.indexOf('audio') === 0) {
                    kind = 'Audio'
                } else if (mime.indexOf('video') === 0) {
                    kind = 'Video'
                } else if (mime.indexOf('application') === 0) {
                    kind = 'App'
                } else {
                    kind = mime
                }
            }
            return this.messages['kind' + kind] ? this.i18n('kind' + kind) : mime
        },
        mimeIsText: function (mime) {
            return (this.textMimes[mime.toLowerCase()] || (mime.indexOf('text/') === 0 && mime.substr(5, 3) !== 'rtf') || mime.match(/^application\/.+\+xml$/)) ? !0 : !1
        },
        date: function (format, date) {
            var self = this, output, d, dw, m, y, h, g, i, s;
            if (!date) {
                date = new Date()
            }
            h = date[self.getHours]();
            g = h > 12 ? h - 12 : h;
            i = date[self.getMinutes]();
            s = date[self.getSeconds]();
            d = date[self.getDate]();
            dw = date[self.getDay]();
            m = date[self.getMonth]() + 1;
            y = date[self.getFullYear]();
            output = format.replace(/[a-z]/gi, function (val) {
                switch (val) {
                    case 'd':
                        return d > 9 ? d : '0' + d;
                    case 'j':
                        return d;
                    case 'D':
                        return self.i18n(self.i18.daysShort[dw]);
                    case 'l':
                        return self.i18n(self.i18.days[dw]);
                    case 'm':
                        return m > 9 ? m : '0' + m;
                    case 'n':
                        return m;
                    case 'M':
                        return self.i18n(self.i18.monthsShort[m - 1]);
                    case 'F':
                        return self.i18n(self.i18.months[m - 1]);
                    case 'Y':
                        return y;
                    case 'y':
                        return ('' + y).substr(2);
                    case 'H':
                        return h > 9 ? h : '0' + h;
                    case 'G':
                        return h;
                    case 'g':
                        return g;
                    case 'h':
                        return g > 9 ? g : '0' + g;
                    case 'a':
                        return h >= 12 ? 'pm' : 'am';
                    case 'A':
                        return h >= 12 ? 'PM' : 'AM';
                    case 'i':
                        return i > 9 ? i : '0' + i;
                    case 's':
                        return s > 9 ? s : '0' + s
                }
                return val
            });
            return output
        },
        formatDate: function (file, t) {
            var self = this, ts = t || file.ts, i18 = self.i18, date, format, output, d, dw, m, y, h, g, i, s;
            if (self.options.clientFormatDate && ts > 0) {
                date = new Date(ts * 1000);
                format = ts >= this.yesterday ? this.fancyFormat : this.dateFormat;
                output = self.date(format, date);
                return ts >= this.yesterday ? output.replace('$1', this.i18n(ts >= this.today ? 'Today' : 'Yesterday')) : output
            } else if (file.date) {
                return file.date.replace(/([a-z]+)\s/i, function (a1, a2) {
                    return self.i18n(a2) + ' '
                })
            }
            return self.i18n('dateUnknown')
        },
        toLocaleString: function (num) {
            var v = new Number(num);
            if (v) {
                if (v.toLocaleString) {
                    return v.toLocaleString()
                } else {
                    return String(num).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, '$1,')
                }
            }
            return num
        },
        perms2class: function (o) {
            var c = '';
            if (!o.read && !o.write) {
                c = 'elfinder-na'
            } else if (!o.read) {
                c = 'elfinder-wo'
            } else if (!o.write) {
                c = 'elfinder-ro'
            }
            if (o.type) {
                c += ' elfinder-' + this.escape(o.type)
            }
            return c
        },
        formatPermissions: function (f) {
            var p = [];
            f.read && p.push(this.i18n('read'));
            f.write && p.push(this.i18n('write'));
            return p.length ? p.join(' ' + this.i18n('and') + ' ') : this.i18n('noaccess')
        },
        formatSize: function (s) {
            var n = 1, u = 'b';
            if (s == 'unknown') {
                return this.i18n('unknown')
            }
            if (s > 1073741824) {
                n = 1073741824;
                u = 'GB'
            } else if (s > 1048576) {
                n = 1048576;
                u = 'MB'
            } else if (s > 1024) {
                n = 1024;
                u = 'KB'
            }
            s = s / n;
            return (s > 0 ? n >= 1048576 ? s.toFixed(2) : Math.round(s) : 0) + ' ' + u
        },
        formatFileMode: function (p, style) {
            var i, o, s, b, sticy, suid, sgid, str, oct;
            if (!style) {
                style = this.options.fileModeStyle.toLowerCase()
            }
            p = $.trim(p);
            if (p.match(/[rwxs-]{9}$/i)) {
                str = p = p.substr(-9);
                if (style == 'string') {
                    return str
                }
                oct = '';
                s = 0;
                for (i = 0; i < 7; i = i + 3) {
                    o = p.substr(i, 3);
                    b = 0;
                    if (o.match(/[r]/i)) {
                        b += 4
                    }
                    if (o.match(/[w]/i)) {
                        b += 2
                    }
                    if (o.match(/[xs]/i)) {
                        if (o.match(/[xs]/)) {
                            b += 1
                        }
                        if (o.match(/[s]/i)) {
                            if (i == 0) {
                                s += 4
                            } else if (i == 3) {
                                s += 2
                            }
                        }
                    }
                    oct += b.toString(8)
                }
                if (s) {
                    oct = s.toString(8) + oct
                }
            } else {
                p = parseInt(p, 8);
                oct = p ? p.toString(8) : '';
                if (!p || style == 'octal') {
                    return oct
                }
                o = p.toString(8);
                s = 0;
                if (o.length > 3) {
                    o = o.substr(-4);
                    s = parseInt(o.substr(0, 1), 8);
                    o = o.substr(1)
                }
                sticy = ((s & 1) == 1);
                sgid = ((s & 2) == 2);
                suid = ((s & 4) == 4);
                str = '';
                for (i = 0; i < 3; i++) {
                    if ((parseInt(o.substr(i, 1), 8) & 4) == 4) {
                        str += 'r'
                    } else {
                        str += '-'
                    }
                    if ((parseInt(o.substr(i, 1), 8) & 2) == 2) {
                        str += 'w'
                    } else {
                        str += '-'
                    }
                    if ((parseInt(o.substr(i, 1), 8) & 1) == 1) {
                        str += ((i == 0 && suid) || (i == 1 && sgid)) ? 's' : 'x'
                    } else {
                        str += '-'
                    }
                }
            }
            if (style == 'both') {
                return str + ' (' + oct + ')'
            } else if (style == 'string') {
                return str
            } else {
                return oct
            }
        },
        registRawStringDecoder: function (rawStringDecoder) {
            if ($.isFunction(rawStringDecoder)) {
                this.decodeRawString = this.options.rawStringDecoder = rawStringDecoder
            }
        },
        uploadMimeCheck: function (mime, target) {
            target = target || this.cwd().hash;
            var res = !0, mimeChecker = this.option('uploadMime', target), allow, deny, check = function (checker) {
                var ret = !1;
                if (typeof checker === 'string' && checker.toLowerCase() === 'all') {
                    ret = !0
                } else if (Array.isArray(checker) && checker.length) {
                    $.each(checker, function (i, v) {
                        v = v.toLowerCase();
                        if (v === 'all' || mime.indexOf(v) === 0) {
                            ret = !0;
                            return !1
                        }
                    })
                }
                return ret
            };
            if (mime && $.isPlainObject(mimeChecker)) {
                mime = mime.toLowerCase();
                allow = check(mimeChecker.allow);
                deny = check(mimeChecker.deny);
                if (mimeChecker.firstOrder === 'allow') {
                    res = !1;
                    if (!deny && allow === !0) {
                        res = !0
                    }
                } else {
                    res = !0;
                    if (deny === !0 && !allow) {
                        res = !1
                    }
                }
            }
            return res
        },
        sequence: function (tasks) {
            var l = tasks.length, chain = function (task, idx) {
                ++idx;
                if (tasks[idx]) {
                    return chain(task.then(tasks[idx]), idx)
                } else {
                    return task
                }
            };
            if (l > 1) {
                return chain(tasks[0](), 0)
            } else {
                return tasks[0]()
            }
        },
        reloadContents: function (url) {
            var dfd = $.Deferred(), ifm;
            try {
                ifm = $('<iframe width="1" height="1" scrolling="no" frameborder="no" style="position:absolute; top:-1px; left:-1px" crossorigin="use-credentials">').attr('src', url).one('load', function () {
                    var ifm = $(this);
                    try {
                        this.contentDocument.location.reload(!0);
                        ifm.one('load', function () {
                            ifm.remove();
                            dfd.resolve()
                        })
                    } catch (e) {
                        ifm.attr('src', '').attr('src', url).one('load', function () {
                            ifm.remove();
                            dfd.resolve()
                        })
                    }
                }).appendTo('body')
            } catch (e) {
                ifm && ifm.remove();
                dfd.reject()
            }
            return dfd
        },
        makeNetmountOptionOauth: function (protocol, name, host, opt) {
            var noOffline = typeof opt === 'boolean' ? opt : null, opts = Object.assign({
                noOffline: !1,
                root: 'root',
                pathI18n: 'folderId',
                folders: !0
            }, (noOffline === null ? (opt || {}) : {noOffline: noOffline})), addFolders = function (fm, bro, folders) {
                var self = this, cnt = Object.keys($.isPlainObject(folders) ? folders : {}).length, select;
                bro.next().remove();
                if (cnt) {
                    select = $('<select class="ui-corner-all elfinder-tabstop" style="max-width:200px;">').append($($.map(folders, function (n, i) {
                        return '<option value="' + fm.escape((i + '').trim()) + '">' + fm.escape(n) + '</option>'
                    }).join(''))).on('change click', function (e) {
                        var node = $(this), path = node.val(), spn;
                        self.inputs.path.val(path);
                        if (opts.folders && (e.type === 'change' || node.data('current') !== path)) {
                            node.next().remove();
                            node.data('current', path);
                            if (path != opts.root) {
                                spn = spinner();
                                if (xhr && xhr.state() === 'pending') {
                                    fm.abortXHR(xhr, {quiet: !0, abort: !0})
                                }
                                node.after(spn);
                                xhr = fm.request({
                                    data: {
                                        cmd: 'netmount',
                                        protocol: protocol,
                                        host: host,
                                        user: 'init',
                                        path: path,
                                        pass: 'folders'
                                    }, preventDefault: !0
                                }).done(function (data) {
                                    addFolders.call(self, fm, node, data.folders)
                                }).always(function () {
                                    fm.abortXHR(xhr, {quiet: !0});
                                    spn.remove()
                                }).xhr
                            }
                        }
                    });
                    bro.after($('<div/>').append(select)).closest('.ui-dialog').trigger('tabstopsInit');
                    select.trigger('focus')
                }
            }, spinner = function () {
                return $('<div class="elfinder-netmount-spinner"/>').append('<span class="elfinder-spinner"/>')
            }, xhr;
            return {
                vars: {}, name: name, inputs: {
                    offline: $('<input type="checkbox"/>').on('change', function () {
                        $(this).parents('table.elfinder-netmount-tb').find('select:first').trigger('change', 'reset')
                    }),
                    host: $('<span><span class="elfinder-spinner"/></span><input type="hidden"/>'),
                    path: $('<input type="text" value="' + opts.root + '"/>'),
                    user: $('<input type="hidden"/>'),
                    pass: $('<input type="hidden"/>')
                }, select: function (fm, ev, d) {
                    var f = this.inputs, oline = f.offline, f0 = $(f.host[0]), data = d || null;
                    this.vars.mbtn = f.host.closest('.ui-dialog').children('.ui-dialog-buttonpane:first').find('button.elfinder-btncnt-0');
                    if (!f0.data('inrequest') && (f0.find('span.elfinder-spinner').length || data === 'reset' || (data === 'winfocus' && !f0.siblings('span.elfinder-button-icon-reload').length))) {
                        if (oline.parent().children().length === 1) {
                            f.path.parent().prev().html(fm.i18n(opts.pathI18n));
                            oline.attr('title', fm.i18n('offlineAccess'));
                            oline.uniqueId().after($('<label/>').attr('for', oline.attr('id')).html(' ' + fm.i18n('offlineAccess')))
                        }
                        f0.data('inrequest', !0).empty().addClass('elfinder-spinner').parent().find('span.elfinder-button-icon').remove();
                        fm.request({
                            data: {
                                cmd: 'netmount',
                                protocol: protocol,
                                host: host,
                                user: 'init',
                                options: {id: fm.id, offline: oline.prop('checked') ? 1 : 0, pass: f.host[1].value}
                            }, preventDefault: !0
                        }).done(function (data) {
                            f0.removeClass("elfinder-spinner").html(data.body.replace(/\{msg:([^}]+)\}/g, function (whole, s1) {
                                return fm.i18n(s1, host)
                            }))
                        });
                        opts.noOffline && oline.closest('tr').hide()
                    } else {
                        oline.closest('tr')[(opts.noOffline || f.user.val()) ? 'hide' : 'show']();
                        f0.data('funcexpup') && f0.data('funcexpup')()
                    }
                    this.vars.mbtn[$(f.host[1]).val() ? 'show' : 'hide']()
                }, done: function (fm, data) {
                    var f = this.inputs, p = this.protocol, f0 = $(f.host[0]), f1 = $(f.host[1]), expires = '&nbsp;';
                    opts.noOffline && f.offline.closest('tr').hide();
                    if (data.mode == 'makebtn') {
                        f0.removeClass('elfinder-spinner').removeData('expires').removeData('funcexpup');
                        f.host.find('input').on('mouseenter mouseleave', function () {
                            $(this).toggleClass('ui-state-hover')
                        });
                        f1.val('');
                        f.path.val(opts.root).next().remove();
                        f.user.val('');
                        f.pass.val('');
                        !opts.noOffline && f.offline.closest('tr').show();
                        this.vars.mbtn.hide()
                    } else if (data.mode == 'folders') {
                        if (data.folders) {
                            addFolders.call(this, fm, f.path.nextAll(':last'), data.folders)
                        }
                    } else {
                        if (data.expires) {
                            expires = '()';
                            f0.data('expires', data.expires)
                        }
                        f0.html(host + expires).removeClass('elfinder-spinner');
                        if (data.expires) {
                            f0.data('funcexpup', function () {
                                var rem = Math.floor((f0.data('expires') - (+new Date()) / 1000) / 60);
                                if (rem < 3) {
                                    f0.parent().children('.elfinder-button-icon-reload').click()
                                } else {
                                    f0.text(f0.text().replace(/\(.*\)/, '(' + fm.i18n(['minsLeft', rem]) + ')'));
                                    setTimeout(function () {
                                        if (f0.is(':visible')) {
                                            f0.data('funcexpup')()
                                        }
                                    }, 60000)
                                }
                            });
                            f0.data('funcexpup')()
                        }
                        if (data.reset) {
                            p.trigger('change', 'reset');
                            return
                        }
                        f0.parent().append($('<span class="elfinder-button-icon elfinder-button-icon-reload" title="' + fm.i18n('reAuth') + '">').on('click', function () {
                            f1.val('reauth');
                            p.trigger('change', 'reset')
                        }));
                        f1.val(protocol);
                        this.vars.mbtn.show();
                        if (data.folders) {
                            addFolders.call(this, fm, f.path, data.folders)
                        }
                        f.user.val('done');
                        f.pass.val('done');
                        f.offline.closest('tr').hide()
                    }
                    f0.removeData('inrequest')
                }, fail: function (fm, err) {
                    $(this.inputs.host[0]).removeData('inrequest');
                    this.protocol.trigger('change', 'reset')
                }, integrateInfo: opts.integrate
            }
        },
        findCwdNodes: function (files, opts) {
            var self = this, cwd = this.getUI('cwd'), cwdHash = this.cwd().hash, newItem = $();
            opts = opts || {};
            $.each(files, function (i, f) {
                if (f.phash === cwdHash || self.searchStatus.state > 1) {
                    newItem = newItem.add(self.cwdHash2Elm(f.hash));
                    if (opts.firstOnly) {
                        return !1
                    }
                }
            });
            return newItem
        },
        convAbsUrl: function (url) {
            if (url.match(/^http/i)) {
                return url
            }
            if (url.substr(0, 2) === '//') {
                return window.location.protocol + url
            }
            var root = window.location.protocol + '//' + window.location.host, reg = /[^\/]+\/\.\.\//, ret;
            if (url.substr(0, 1) === '/') {
                ret = root + url
            } else {
                ret = root + window.location.pathname.replace(/\/[^\/]+$/, '/') + url
            }
            ret = ret.replace('/./', '/');
            while (reg.test(ret)) {
                ret = ret.replace(reg, '')
            }
            return ret
        },
        isSameOrigin: function (checkUrl) {
            var url;
            checkUrl = this.convAbsUrl(checkUrl);
            if (location.origin && window.URL) {
                try {
                    url = new URL(checkUrl);
                    return location.origin === url.origin
                } catch (e) {
                }
            }
            url = document.createElement('a');
            url.href = checkUrl;
            return location.protocol === url.protocol && location.host === url.host && location.port && url.port
        },
        navHash2Id: function (hash) {
            return this.navPrefix + hash
        },
        navId2Hash: function (id) {
            return typeof(id) == 'string' ? id.substr(this.navPrefix.length) : !1
        },
        cwdHash2Id: function (hash) {
            return this.cwdPrefix + hash
        },
        cwdId2Hash: function (id) {
            return typeof(id) == 'string' ? id.substr(this.cwdPrefix.length) : !1
        },
        navHash2Elm: function (hash) {
            return $(document.getElementById(this.navHash2Id(hash)))
        },
        cwdHash2Elm: function (hash) {
            return $(document.getElementById(this.cwdHash2Id(hash)))
        },
        isInWindow: function (elem, nochkHide) {
            var elm, rect;
            if (!(elm = elem.get(0))) {
                return !1
            }
            if (!nochkHide && elm.offsetParent === null) {
                return !1
            }
            rect = elm.getBoundingClientRect();
            return document.elementFromPoint(rect.left, rect.top) ? !0 : !1
        },
        zIndexCalc: function () {
            var self = this, node = this.getUI(), ni = node.css('z-index');
            if (ni && ni !== 'auto' && ni !== 'inherit') {
                self.zIndex = ni
            } else {
                node.parents().each(function (i, n) {
                    var z = $(n).css('z-index');
                    if (z !== 'auto' && z !== 'inherit' && (z = parseInt(z))) {
                        self.zIndex = z;
                        return !1
                    }
                })
            }
        },
        loadScript: function (urls, callback, opts, check) {
            var defOpts = {dataType: 'script', cache: !0}, success, cnt, scripts = {}, results = {};
            opts = opts || {};
            if (opts.tryRequire && this.hasRequire) {
                require(urls, callback, opts.error)
            } else {
                success = function () {
                    var cnt, fi, hasError;
                    $.each(results, function (i, status) {
                        if (status !== 'success' && status !== 'notmodified') {
                            hasError = !0;
                            return !1
                        }
                    });
                    if (!hasError) {
                        if ($.isFunction(callback)) {
                            if (check) {
                                if (typeof check.obj[check.name] === 'undefined') {
                                    cnt = check.timeout ? (check.timeout / 10) : 1;
                                    fi = setInterval(function () {
                                        if (--cnt < 0 || typeof check.obj[check.name] !== 'undefined') {
                                            clearInterval(fi);
                                            callback()
                                        }
                                    }, 10)
                                } else {
                                    callback()
                                }
                            } else {
                                callback()
                            }
                        }
                    } else {
                        if (opts.error && $.isFunction(opts.error)) {
                            opts.error({loadResults: results})
                        }
                    }
                };
                if (opts.loadType === 'tag') {
                    $('head > script').each(function () {
                        scripts[this.src] = this
                    });
                    cnt = urls.length;
                    $.each(urls, function (i, url) {
                        var done = !1, script;
                        if (scripts[url]) {
                            results[i] = scripts[url]._error || 'success';
                            (--cnt < 1) && success()
                        } else {
                            script = document.createElement('script');
                            script.charset = opts.charset || 'UTF-8';
                            $('head').append(script);
                            script.onload = script.onreadystatechange = function () {
                                if (!done && (!this.readyState || this.readyState === 'loaded' || this.readyState === 'complete')) {
                                    done = !0;
                                    results[i] = 'success';
                                    (--cnt < 1) && success()
                                }
                            };
                            script.onerror = function (err) {
                                results[i] = script._error = (err && err.type) ? err.type : 'error';
                                (--cnt < 1) && success()
                            };
                            script.src = url
                        }
                    })
                } else {
                    opts = $.isPlainObject(opts) ? Object.assign(defOpts, opts) : defOpts;
                    cnt = 0;
                    (function appendScript(d, status) {
                        if (d !== void(0)) {
                            results[cnt++] = status
                        }
                        if (urls.length) {
                            $.ajax(Object.assign({}, opts, {
                                url: urls.shift(),
                                success: appendScript,
                                error: appendScript
                            }))
                        } else {
                            success()
                        }
                    })()
                }
            }
            return this
        },
        loadCss: function (urls, opts) {
            var self = this, clName, dfds;
            if (typeof urls === 'string') {
                urls = [urls]
            }
            if (opts) {
                if (opts.className) {
                    clName = opts.className
                }
                if (opts.dfd && opts.dfd.promise) {
                    dfds = []
                }
            }
            $.each(urls, function (i, url) {
                var link, df;
                url = self.convAbsUrl(url).replace(/^https?:/i, '');
                if (dfds) {
                    dfds[i] = $.Deferred()
                }
                if (!$("head > link[href='+url+']").length) {
                    link = document.createElement('link');
                    link.type = 'text/css';
                    link.rel = 'stylesheet';
                    link.href = url;
                    if (clName) {
                        link.className = clName
                    }
                    if (dfds) {
                        link.onload = function () {
                            dfds[i].resolve()
                        };
                        link.onerror = function () {
                            dfds[i].reject()
                        }
                    }
                    $('head').append(link)
                } else {
                    dfds && dfds[i].resolve()
                }
            });
            if (dfds) {
                $.when.apply(null, dfds).done(function () {
                    opts.dfd.resolve()
                }).fail(function () {
                    opts.dfd.reject()
                })
            }
            return this
        },
        asyncJob: function (func, arr, opts) {
            var dfrd = $.Deferred(), abortFlg = !1, parms = Object.assign({interval: 0, numPerOnce: 1}, opts || {}),
                resArr = [], vars = [], curVars = [], exec, tm;
            dfrd._abort = function (resolve) {
                tm && clearTimeout(tm);
                vars = [];
                abortFlg = !0;
                if (dfrd.state() === 'pending') {
                    dfrd[resolve ? 'resolve' : 'reject'](resArr)
                }
            };
            dfrd.fail(function () {
                dfrd._abort()
            }).always(function () {
                dfrd._abort = function () {
                }
            });
            if (typeof func === 'function' && Array.isArray(arr)) {
                vars = arr.concat();
                exec = function () {
                    var i, len, res;
                    if (abortFlg) {
                        return
                    }
                    curVars = vars.splice(0, parms.numPerOnce);
                    len = curVars.length;
                    for (i = 0; i < len; i++) {
                        if (abortFlg) {
                            break
                        }
                        res = func(curVars[i]);
                        (res !== null) && resArr.push(res)
                    }
                    if (abortFlg) {
                        return
                    }
                    if (vars.length) {
                        tm = setTimeout(exec, parms.interval)
                    } else {
                        dfrd.resolve(resArr)
                    }
                };
                if (vars.length) {
                    tm = setTimeout(exec, 0)
                } else {
                    dfrd.resolve(resArr)
                }
            } else {
                dfrd.reject()
            }
            return dfrd
        },
        getSize: function (targets) {
            var self = this, reqs = [], tgtlen = targets.length, dfrd = $.Deferred().fail(function () {
                $.each(reqs, function (i, req) {
                    if (req) {
                        req.syncOnFail && req.syncOnFail(!1);
                        req.reject()
                    }
                })
            }), getLeafRoots = function (file) {
                var targets = [];
                if (file.mime === 'directory') {
                    $.each(self.leafRoots, function (hash, roots) {
                        var phash;
                        if (hash === file.hash) {
                            targets.push.apply(targets, roots)
                        } else {
                            phash = (self.file(hash) || {}).phash;
                            while (phash) {
                                if (phash === file.hash) {
                                    targets.push.apply(targets, roots)
                                }
                                phash = (self.file(phash) || {}).phash
                            }
                        }
                    })
                }
                return targets
            }, checkPhash = function (hash) {
                var dfd = $.Deferred(), dir = self.file(hash), target = dir ? dir.phash : hash;
                if (target && !self.file(target)) {
                    self.request({data: {cmd: 'parents', target: target}, preventFail: !0}).done(function () {
                        self.one('parentsdone', function () {
                            dfd.resolve()
                        })
                    }).fail(function () {
                        dfd.resolve()
                    })
                } else {
                    dfd.resolve()
                }
                return dfd
            }, cache = function () {
                var dfd = $.Deferred(), cnt = Object.keys(self.leafRoots).length;
                if (cnt > 0) {
                    $.each(self.leafRoots, function (hash) {
                        checkPhash(hash).done(function () {
                            --cnt;
                            if (cnt < 1) {
                                dfd.resolve()
                            }
                        })
                    })
                } else {
                    dfd.resolve()
                }
                return dfd
            };
            self.autoSync('stop');
            cache().done(function () {
                var files = [], grps = {}, dfds = [], cache = [], singles = {};
                $.each(targets, function () {
                    files.push.apply(files, getLeafRoots(self.file(this)))
                });
                targets.push.apply(targets, files);
                $.each(targets, function () {
                    var root = self.root(this), file = self.file(this);
                    if (file && (file.sizeInfo || file.mime !== 'directory')) {
                        cache.push($.Deferred().resolve(file.sizeInfo ? file.sizeInfo : {
                            size: file.size,
                            dirCnt: 0,
                            fileCnt: 1
                        }))
                    } else {
                        if (!grps[root]) {
                            grps[root] = [this.toString()]
                        } else {
                            grps[root].push(this.toString())
                        }
                    }
                });
                $.each(grps, function () {
                    var idx = dfds.length;
                    if (this.length === 1) {
                        singles[idx] = this[0]
                    }
                    dfds.push(self.request({data: {cmd: 'size', targets: this}, preventDefault: !0}))
                });
                reqs.push.apply(reqs, dfds);
                dfds.push.apply(dfds, cache);
                $.when.apply($, dfds).fail(function () {
                    dfrd.reject()
                }).done(function () {
                    var cache = function (h, data) {
                            var file;
                            if (file = self.file(h)) {
                                file.sizeInfo = {isCache: !0};
                                $.each(['size', 'dirCnt', 'fileCnt'], function () {
                                    file.sizeInfo[this] = data[this] || 0
                                });
                                file.size = parseInt(file.sizeInfo.size);
                                changed.push(file)
                            }
                        }, size = 0, fileCnt = 0, dirCnt = 0, argLen = arguments.length, cnts = [], cntsTxt = '',
                        changed = [], i, file, data;
                    for (i = 0; i < argLen; i++) {
                        data = arguments[i];
                        file = null;
                        if (!data.isCache) {
                            if (singles[i] && (file = self.file(singles[i]))) {
                                cache(singles[i], data)
                            } else if (data.sizes && $.isPlainObject(data.sizes)) {
                                $.each(data.sizes, function (h, sizeInfo) {
                                    cache(h, sizeInfo)
                                })
                            }
                        }
                        size += parseInt(data.size);
                        if (fileCnt !== !1) {
                            if (typeof data.fileCnt === 'undefined') {
                                fileCnt = !1
                            }
                            fileCnt += parseInt(data.fileCnt || 0)
                        }
                        if (dirCnt !== !1) {
                            if (typeof data.dirCnt === 'undefined') {
                                dirCnt = !1
                            }
                            dirCnt += parseInt(data.dirCnt || 0)
                        }
                    }
                    changed.length && self.change({changed: changed});
                    if (dirCnt !== !1) {
                        cnts.push(self.i18n('folders') + ': ' + (dirCnt - (tgtlen > 1 ? 0 : 1)))
                    }
                    if (fileCnt !== !1) {
                        cnts.push(self.i18n('files') + ': ' + fileCnt)
                    }
                    if (cnts.length) {
                        cntsTxt = '<br>' + cnts.join(', ')
                    }
                    dfrd.resolve({
                        size: size,
                        fileCnt: fileCnt,
                        dirCnt: dirCnt,
                        formated: (size >= 0 ? self.formatSize(size) : self.i18n('unknown')) + cntsTxt
                    })
                });
                self.autoSync()
            });
            return dfrd
        },
        getTheme: function (themeid) {
            var self = this, dfd = $.Deferred(), absUrl = function (url, base) {
                if (!base) {
                    base = self.convAbsUrl(self.baseUrl)
                }
                if (Array.isArray(url)) {
                    return $.map(url, function (v) {
                        return absUrl(v, base)
                    })
                } else {
                    return url.match(/^(?:http|\/\/)/i) ? url : base + url.replace(/^(?:\.\/|\/)/, '')
                }
            }, themeObj, m;
            if (themeid && (themeObj = self.options.themes[themeid])) {
                if (typeof themeObj === 'string') {
                    url = absUrl(themeObj);
                    if (m = url.match(/^(.+\/)[^/]+\.json$/i)) {
                        $.getJSON(url).done(function (data) {
                            themeObj = data;
                            themeObj.id = themeid;
                            if (themeObj.cssurls) {
                                themeObj.cssurls = absUrl(themeObj.cssurls, m[1])
                            }
                            dfd.resolve(themeObj)
                        }).fail(function () {
                            dfd.reject()
                        })
                    } else {
                        dfd.resolve({id: themeid, name: themeid, cssurls: [url]})
                    }
                } else if ($.isPlainObject(themeObj) && themeObj.cssurls) {
                    themeObj.id = themeid;
                    themeObj.cssurls = absUrl(themeObj.cssurls);
                    if (!Array.isArray(themeObj.cssurls)) {
                        themeObj.cssurls = [themeObj.cssurls]
                    }
                    if (!themeObj.name) {
                        themeObj.name = themeid
                    }
                    dfd.resolve(themeObj)
                } else {
                    dfd.reject()
                }
            } else {
                dfd.reject()
            }
            return dfd
        },
        changeTheme: function (themeid) {
            var self = this;
            if (themeid) {
                if (self.options.themes[themeid] && (!self.theme || self.theme.id !== themeid)) {
                    self.getTheme(themeid).done(function (themeObj) {
                        if (themeObj.cssurls) {
                            $('head>link.elfinder-theme-ext').remove();
                            self.loadCss(themeObj.cssurls, {
                                className: 'elfinder-theme-ext',
                                dfd: $.Deferred().done(function () {
                                    self.theme = themeObj;
                                    self.trigger && self.trigger('themechange')
                                })
                            })
                        }
                    })
                } else if (themeid === 'default' && self.theme && self.theme.id !== 'default') {
                    $('head>link.elfinder-theme-ext').remove();
                    self.theme = null;
                    self.trigger && self.trigger('themechange')
                }
            }
            return this
        },
        applyLeafRootStats: function (dir, update) {
            var self = this, prev = update ? dir : (self.file(dir.hash) || dir), prevTs = prev.ts, change = !1;
            if (update || !dir._realStats) {
                dir._realStats = {locked: dir.locked || 0, dirs: dir.dirs || 0, ts: dir.ts}
            }
            dir.locked = 1;
            if (!prev.locked) {
                change = !0
            }
            dir.dirs = 1;
            if (!prev.dirs) {
                change = !0
            }
            $.each(self.leafRoots[dir.hash], function () {
                var f = self.file(this);
                if (f && f.ts && (dir.ts || 0) < f.ts) {
                    dir.ts = f.ts
                }
            });
            if (prevTs !== dir.ts) {
                change = !0
            }
            return change
        },
        abortXHR: function (xhr, o) {
            var opts = o || {};
            if (xhr) {
                opts.quiet && (xhr.quiet = !0);
                if (opts.abort && xhr._requestId) {
                    this.request({data: {cmd: 'abort', id: xhr._requestId}, preventDefault: !0})
                }
                xhr.abort();
                xhr = void 0
            }
        },
        getRequestId: function () {
            return (+new Date()).toString(16) + Math.floor(1000 * Math.random()).toString(16)
        },
        arrayFlip: function (trans, val) {
            var key, tmpArr = {}, isArr = $.isArray(trans);
            for (key in trans) {
                if (isArr || trans.hasOwnProperty(key)) {
                    tmpArr[trans[key]] = val || key
                }
            }
            return tmpArr
        },
        splitFileExtention: function (name) {
            var m;
            if (m = name.match(/^(.+?)?\.((?:tar\.(?:gz|bz|bz2|z|lzo))|cpio\.gz|ps\.gz|xcf\.(?:gz|bz2)|[a-z0-9]{1,10})$/i)) {
                if (typeof m[1] === 'undefined') {
                    m[1] = ''
                }
                return [m[1], m[2]]
            } else {
                return [name, '']
            }
        },
        sliceArrayBuffer: function (arrayBuffer, sliceSize) {
            var segments = [], fi = 0;
            while (fi * sliceSize < arrayBuffer.byteLength) {
                segments.push(arrayBuffer.slice(fi * sliceSize, (fi + 1) * sliceSize));
                fi++
            }
            return segments
        },
        arrayBufferToBase64: function (ab) {
            if (!window.btoa) {
                return ''
            }
            var dView = new Uint8Array(ab), arr = Array.prototype.slice.call(dView), arr1 = arr.map(function (item) {
                return String.fromCharCode(item)
            });
            return window.btoa(arr1.join(''))
        },
        log: function (m) {
            window.console && window.console.log && window.console.log(m);
            return this
        },
        debug: function (type, m) {
            var d = this.options.debug;
            if (d && (d === 'all' || d[type])) {
                window.console && window.console.log && window.console.log('elfinder debug: [' + type + '] [' + this.id + ']', m)
            }
            if (type === 'backend-error') {
                if (!this.cwd().hash || (d && (d === 'all' || d['backend-error']))) {
                    m = Array.isArray(m) ? m : [m];
                    this.error(m)
                }
            } else if (type === 'backend-debug') {
                this.trigger('backenddebug', m)
            }
            return this
        },
        time: function (l) {
            window.console && window.console.time && window.console.time(l)
        },
        timeEnd: function (l) {
            window.console && window.console.timeEnd && window.console.timeEnd(l)
        }
    };
    if (!Object.keys) {
        Object.keys = (function () {
            var hasOwnProperty = Object.prototype.hasOwnProperty,
                hasDontEnumBug = !({toString: null}).propertyIsEnumerable('toString'),
                dontEnums = ['toString', 'toLocaleString', 'valueOf', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'constructor'],
                dontEnumsLength = dontEnums.length;
            return function (obj) {
                if (typeof obj !== 'object' && typeof obj !== 'function' || obj === null) throw new TypeError('Object.keys called on non-object');
                var result = [];
                for (var prop in obj) {
                    if (hasOwnProperty.call(obj, prop)) result.push(prop)
                }
                if (hasDontEnumBug) {
                    for (var i = 0; i < dontEnumsLength; i++) {
                        if (hasOwnProperty.call(obj, dontEnums[i])) result.push(dontEnums[i])
                    }
                }
                return result
            }
        })()
    }
    if (!Array.isArray) {
        Array.isArray = function (arr) {
            return jQuery.isArray(arr)
        }
    }
    if (!Object.assign) {
        Object.assign = function () {
            return jQuery.extend.apply(null, arguments)
        }
    }
    if (!String.prototype.repeat) {
        String.prototype.repeat = function (count) {
            'use strict';
            if (this == null) {
                throw new TypeError('can\'t convert ' + this + ' to object')
            }
            var str = '' + this;
            count = +count;
            if (count != count) {
                count = 0
            }
            if (count < 0) {
                throw new RangeError('repeat count must be non-negative')
            }
            if (count == Infinity) {
                throw new RangeError('repeat count must be less than infinity')
            }
            count = Math.floor(count);
            if (str.length == 0 || count == 0) {
                return ''
            }
            if (str.length * count >= 1 << 28) {
                throw new RangeError('repeat count must not overflow maximum string size')
            }
            var rpt = '';
            for (var i = 0; i < count; i++) {
                rpt += str
            }
            return rpt
        }
    }
    if (!String.prototype.trim) {
        String.prototype.trim = function () {
            return this.replace(/^\s+|\s+$/g, '')
        }
    }
    (function () {
        try {
            Array.apply(null, {});
            return
        } catch (e) {
        }
        var toString = Object.prototype.toString, arrayType = '[object Array]', _apply = Function.prototype.apply,
            slice = Array.prototype.slice;
        Function.prototype.apply = function apply(thisArg, argArray) {
            return _apply.call(this, thisArg, toString.call(argArray) === arrayType ? argArray : slice.call(argArray))
        }
    })();
    if (!Array.from) {
        Array.from = function (obj) {
            return obj.length === 1 ? [obj[0]] : Array.apply(null, obj)
        }
    }
    if (!window.cancelAnimationFrame) {
        (function () {
            var lastTime = 0;
            var vendors = ['ms', 'moz', 'webkit', 'o'];
            for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
                window.requestAnimationFrame = window[vendors[x] + 'RequestAnimationFrame'];
                window.cancelAnimationFrame = window[vendors[x] + 'CancelAnimationFrame'] || window[vendors[x] + 'CancelRequestAnimationFrame']
            }
            if (!window.requestAnimationFrame)
                window.requestAnimationFrame = function (callback, element) {
                    var currTime = new Date().getTime();
                    var timeToCall = Math.max(0, 16 - (currTime - lastTime));
                    var id = window.setTimeout(function () {
                        callback(currTime + timeToCall)
                    }, timeToCall);
                    lastTime = currTime + timeToCall;
                    return id
                };
            if (!window.cancelAnimationFrame)
                window.cancelAnimationFrame = function (id) {
                    clearTimeout(id)
                }
        }())
    }
    elFinder.prototype.version = '2.1.49';
    (function () {
        if ($.ui) {
            if ($.ui.ddmanager) {
                var origin = $.ui.ddmanager.prepareOffsets;
                $.ui.ddmanager.prepareOffsets = function (t, event) {
                    var isOutView = function (elem) {
                        if (elem.is(':hidden')) {
                            return !0
                        }
                        var rect = elem[0].getBoundingClientRect();
                        return document.elementFromPoint(rect.left, rect.top) || document.elementFromPoint(rect.left + rect.width, rect.top + rect.height) ? !1 : !0
                    };
                    if (event.type === 'mousedown' || t.options.elfRefresh) {
                        var i, d, m = $.ui.ddmanager.droppables[t.options.scope] || [], l = m.length;
                        for (i = 0; i < l; i++) {
                            d = m[i];
                            if (d.options.autoDisable && (!d.options.disabled || d.options.autoDisable > 1)) {
                                d.options.disabled = isOutView(d.element);
                                d.options.autoDisable = d.options.disabled ? 2 : 1
                            }
                        }
                    }
                    return origin(t, event)
                }
            }
        }
    })();
    $.ajaxTransport('+binary', function (options, originalOptions, jqXHR) {
        if (window.FormData && ((options.dataType && (options.dataType == 'binary')) || (options.data && ((window.ArrayBuffer && options.data instanceof ArrayBuffer) || (window.Blob && options.data instanceof Blob))))) {
            var xhr;
            return {
                send: function (headers, callback) {
                    xhr = new XMLHttpRequest();
                    var url = options.url, type = options.type, async = options.async || !0,
                        dataType = options.responseType || 'blob', data = options.data || null,
                        username = options.username, password = options.password;
                    xhr.addEventListener('load', function () {
                        var data = {};
                        data[options.dataType] = xhr.response;
                        callback(xhr.status, xhr.statusText, data, xhr.getAllResponseHeaders())
                    });
                    xhr.open(type, url, async, username, password);
                    for (var i in headers) {
                        xhr.setRequestHeader(i, headers[i])
                    }
                    if (options.xhrFields) {
                        for (var key in options.xhrFields) {
                            if (key in xhr) {
                                xhr[key] = options.xhrFields[key]
                            }
                        }
                    }
                    xhr.responseType = dataType;
                    xhr.send(data)
                }, abort: function () {
                    xhr.abort()
                }
            }
        }
    });
    (function ($) {
        $.support.touch = 'ontouchend' in document;
        if (!$.support.touch) {
            return
        }
        var mouseProto = $.ui.mouse.prototype, _mouseInit = mouseProto._mouseInit,
            _mouseDestroy = mouseProto._mouseDestroy, touchHandled, posX, posY;

        function simulateMouseEvent(event, simulatedType) {
            if (event.originalEvent.touches.length > 1) {
                return
            }
            if (!$(event.currentTarget).hasClass('touch-punch-keep-default')) {
                event.preventDefault()
            }
            var touch = event.originalEvent.changedTouches[0], simulatedEvent = document.createEvent('MouseEvents');
            simulatedEvent.initMouseEvent(simulatedType, !0, !0, window, 1, touch.screenX, touch.screenY, touch.clientX, touch.clientY, !1, !1, !1, !1, 0, null);
            event.target.dispatchEvent(simulatedEvent)
        }

        mouseProto._touchStart = function (event) {
            var self = this;
            if (touchHandled || !self._mouseCapture(event.originalEvent.changedTouches[0])) {
                return
            }
            posX = event.originalEvent.changedTouches[0].screenX.toFixed(0);
            posY = event.originalEvent.changedTouches[0].screenY.toFixed(0);
            touchHandled = !0;
            self._touchMoved = !1;
            simulateMouseEvent(event, 'mouseover');
            simulateMouseEvent(event, 'mousemove');
            simulateMouseEvent(event, 'mousedown')
        };
        mouseProto._touchMove = function (event) {
            if (!touchHandled) {
                return
            }
            var x = event.originalEvent.changedTouches[0].screenX.toFixed(0);
            var y = event.originalEvent.changedTouches[0].screenY.toFixed(0);
            if (Math.abs(posX - x) <= 4 && Math.abs(posY - y) <= 4) {
                return
            }
            this._touchMoved = !0;
            simulateMouseEvent(event, 'mousemove')
        };
        mouseProto._touchEnd = function (event) {
            if (!touchHandled) {
                return
            }
            simulateMouseEvent(event, 'mouseup');
            simulateMouseEvent(event, 'mouseout');
            if (!this._touchMoved) {
                simulateMouseEvent(event, 'click')
            }
            touchHandled = !1;
            this._touchMoved = !1
        };
        mouseProto._mouseInit = function () {
            var self = this;
            if (self.element.hasClass('touch-punch')) {
                self.element.on({
                    touchstart: $.proxy(self, '_touchStart'),
                    touchmove: $.proxy(self, '_touchMove'),
                    touchend: $.proxy(self, '_touchEnd')
                })
            }
            _mouseInit.call(self)
        };
        mouseProto._mouseDestroy = function () {
            var self = this;
            if (self.element.hasClass('touch-punch')) {
                self.element.off({
                    touchstart: $.proxy(self, '_touchStart'),
                    touchmove: $.proxy(self, '_touchMove'),
                    touchend: $.proxy(self, '_touchEnd')
                })
            }
            _mouseDestroy.call(self)
        }
    })(jQuery);
    $.fn.elfinder = function (o, o2) {
        if (o === 'instance') {
            return this.getElFinder()
        } else if (o === 'ondemand') {
        }
        return this.each(function () {
            var cmd = typeof o === 'string' ? o : '', bootCallback = typeof o2 === 'function' ? o2 : void(0),
                elfinder = this.elfinder, opts, reloadCallback;
            if (!elfinder) {
                if ($.isPlainObject(o)) {
                    new elFinder(this, o, bootCallback)
                }
            } else {
                switch (cmd) {
                    case 'close':
                    case 'hide':
                        elfinder.hide();
                        break;
                    case 'open':
                    case 'show':
                        elfinder.show();
                        break;
                    case 'destroy':
                        elfinder.destroy();
                        break;
                    case 'reload':
                    case 'restart':
                        if (elfinder) {
                            opts = $.extend(!0, elfinder.options, $.isPlainObject(o2) ? o2 : {});
                            bootCallback = elfinder.bootCallback;
                            if (elfinder.reloadCallback && $.isFunction(elfinder.reloadCallback)) {
                                elfinder.reloadCallback(opts, bootCallback)
                            } else {
                                elfinder.destroy();
                                new elFinder(this, opts, bootCallback)
                            }
                        }
                        break
                }
            }
        })
    };
    $.fn.getElFinder = function () {
        var instance;
        this.each(function () {
            if (this.elfinder) {
                instance = this.elfinder;
                return !1
            }
        });
        return instance
    };
    $.fn.elfUiWidgetInstance = function (name) {
        try {
            return this[name]('instance')
        } catch (e) {
            var data = this.data('ui-' + name);
            if (data && typeof data === 'object' && data.widgetFullName === 'ui-' + name) {
                return data
            }
            return null
        }
    };
    if (!$.fn.scrollRight) {
        $.fn.extend({
            scrollRight: function (val) {
                var node = this.get(0);
                if (val === undefined) {
                    return Math.max(0, node.scrollWidth - (node.scrollLeft + node.clientWidth))
                }
                return this.scrollLeft(node.scrollWidth - node.clientWidth - val)
            }
        })
    }
    if (!$.fn.scrollBottom) {
        $.fn.extend({
            scrollBottom: function (val) {
                var node = this.get(0);
                if (val === undefined) {
                    return Math.max(0, node.scrollHeight - (node.scrollTop + node.clientHeight))
                }
                return this.scrollTop(node.scrollHeight - node.clientHeight - val)
            }
        })
    }
    elFinder.prototype.mimeTypes = {
        "application\/x-executable": "exe",
        "application\/x-jar": "jar",
        "application\/x-gzip": "gz",
        "application\/x-bzip2": "tbz",
        "application\/x-rar": "rar",
        "text\/x-php": "php",
        "text\/javascript": "js",
        "application\/rtfd": "rtfd",
        "text\/x-python": "py",
        "text\/x-ruby": "rb",
        "text\/x-shellscript": "sh",
        "text\/x-perl": "pl",
        "text\/xml": "xml",
        "text\/x-csrc": "c",
        "text\/x-chdr": "h",
        "text\/x-c++src": "cpp",
        "text\/x-c++hdr": "hh",
        "text\/x-markdown": "md",
        "text\/x-yaml": "yml",
        "image\/x-ms-bmp": "bmp",
        "image\/x-targa": "tga",
        "image\/xbm": "xbm",
        "image\/pxm": "pxm",
        "audio\/wav": "wav",
        "video\/x-dv": "dv",
        "video\/x-ms-wmv": "wm",
        "video\/ogg": "ogm",
        "video\/MP2T": "m2ts",
        "application\/x-mpegURL": "m3u8",
        "application\/dash+xml": "mpd",
        "application\/andrew-inset": "ez",
        "application\/applixware": "aw",
        "application\/atom+xml": "atom",
        "application\/atomcat+xml": "atomcat",
        "application\/atomsvc+xml": "atomsvc",
        "application\/ccxml+xml": "ccxml",
        "application\/cdmi-capability": "cdmia",
        "application\/cdmi-container": "cdmic",
        "application\/cdmi-domain": "cdmid",
        "application\/cdmi-object": "cdmio",
        "application\/cdmi-queue": "cdmiq",
        "application\/cu-seeme": "cu",
        "application\/davmount+xml": "davmount",
        "application\/docbook+xml": "dbk",
        "application\/dssc+der": "dssc",
        "application\/dssc+xml": "xdssc",
        "application\/ecmascript": "ecma",
        "application\/emma+xml": "emma",
        "application\/epub+zip": "epub",
        "application\/exi": "exi",
        "application\/font-tdpfr": "pfr",
        "application\/gml+xml": "gml",
        "application\/gpx+xml": "gpx",
        "application\/gxf": "gxf",
        "application\/hyperstudio": "stk",
        "application\/inkml+xml": "ink",
        "application\/ipfix": "ipfix",
        "application\/java-serialized-object": "ser",
        "application\/java-vm": "class",
        "application\/json": "json",
        "application\/jsonml+json": "jsonml",
        "application\/lost+xml": "lostxml",
        "application\/mac-binhex40": "hqx",
        "application\/mac-compactpro": "cpt",
        "application\/mads+xml": "mads",
        "application\/marc": "mrc",
        "application\/marcxml+xml": "mrcx",
        "application\/mathematica": "ma",
        "application\/mathml+xml": "mathml",
        "application\/mbox": "mbox",
        "application\/mediaservercontrol+xml": "mscml",
        "application\/metalink+xml": "metalink",
        "application\/metalink4+xml": "meta4",
        "application\/mets+xml": "mets",
        "application\/mods+xml": "mods",
        "application\/mp21": "m21",
        "application\/mp4": "mp4s",
        "application\/msword": "doc",
        "application\/mxf": "mxf",
        "application\/octet-stream": "bin",
        "application\/oda": "oda",
        "application\/oebps-package+xml": "opf",
        "application\/ogg": "ogx",
        "application\/omdoc+xml": "omdoc",
        "application\/onenote": "onetoc",
        "application\/oxps": "oxps",
        "application\/patch-ops-error+xml": "xer",
        "application\/pdf": "pdf",
        "application\/pgp-encrypted": "pgp",
        "application\/pgp-signature": "asc",
        "application\/pics-rules": "prf",
        "application\/pkcs10": "p10",
        "application\/pkcs7-mime": "p7m",
        "application\/pkcs7-signature": "p7s",
        "application\/pkcs8": "p8",
        "application\/pkix-attr-cert": "ac",
        "application\/pkix-cert": "cer",
        "application\/pkix-crl": "crl",
        "application\/pkix-pkipath": "pkipath",
        "application\/pkixcmp": "pki",
        "application\/pls+xml": "pls",
        "application\/postscript": "ai",
        "application\/prs.cww": "cww",
        "application\/pskc+xml": "pskcxml",
        "application\/rdf+xml": "rdf",
        "application\/reginfo+xml": "rif",
        "application\/relax-ng-compact-syntax": "rnc",
        "application\/resource-lists+xml": "rl",
        "application\/resource-lists-diff+xml": "rld",
        "application\/rls-services+xml": "rs",
        "application\/rpki-ghostbusters": "gbr",
        "application\/rpki-manifest": "mft",
        "application\/rpki-roa": "roa",
        "application\/rsd+xml": "rsd",
        "application\/rss+xml": "rss",
        "application\/rtf": "rtf",
        "application\/sbml+xml": "sbml",
        "application\/scvp-cv-request": "scq",
        "application\/scvp-cv-response": "scs",
        "application\/scvp-vp-request": "spq",
        "application\/scvp-vp-response": "spp",
        "application\/sdp": "sdp",
        "application\/set-payment-initiation": "setpay",
        "application\/set-registration-initiation": "setreg",
        "application\/shf+xml": "shf",
        "application\/smil+xml": "smi",
        "application\/sparql-query": "rq",
        "application\/sparql-results+xml": "srx",
        "application\/srgs": "gram",
        "application\/srgs+xml": "grxml",
        "application\/sru+xml": "sru",
        "application\/ssdl+xml": "ssdl",
        "application\/ssml+xml": "ssml",
        "application\/tei+xml": "tei",
        "application\/thraud+xml": "tfi",
        "application\/timestamped-data": "tsd",
        "application\/vnd.3gpp.pic-bw-large": "plb",
        "application\/vnd.3gpp.pic-bw-small": "psb",
        "application\/vnd.3gpp.pic-bw-var": "pvb",
        "application\/vnd.3gpp2.tcap": "tcap",
        "application\/vnd.3m.post-it-notes": "pwn",
        "application\/vnd.accpac.simply.aso": "aso",
        "application\/vnd.accpac.simply.imp": "imp",
        "application\/vnd.acucobol": "acu",
        "application\/vnd.acucorp": "atc",
        "application\/vnd.adobe.air-application-installer-package+zip": "air",
        "application\/vnd.adobe.formscentral.fcdt": "fcdt",
        "application\/vnd.adobe.fxp": "fxp",
        "application\/vnd.adobe.xdp+xml": "xdp",
        "application\/vnd.adobe.xfdf": "xfdf",
        "application\/vnd.ahead.space": "ahead",
        "application\/vnd.airzip.filesecure.azf": "azf",
        "application\/vnd.airzip.filesecure.azs": "azs",
        "application\/vnd.amazon.ebook": "azw",
        "application\/vnd.americandynamics.acc": "acc",
        "application\/vnd.amiga.ami": "ami",
        "application\/vnd.android.package-archive": "apk",
        "application\/vnd.anser-web-certificate-issue-initiation": "cii",
        "application\/vnd.anser-web-funds-transfer-initiation": "fti",
        "application\/vnd.antix.game-component": "atx",
        "application\/vnd.apple.installer+xml": "mpkg",
        "application\/vnd.aristanetworks.swi": "swi",
        "application\/vnd.astraea-software.iota": "iota",
        "application\/vnd.audiograph": "aep",
        "application\/vnd.blueice.multipass": "mpm",
        "application\/vnd.bmi": "bmi",
        "application\/vnd.businessobjects": "rep",
        "application\/vnd.chemdraw+xml": "cdxml",
        "application\/vnd.chipnuts.karaoke-mmd": "mmd",
        "application\/vnd.cinderella": "cdy",
        "application\/vnd.claymore": "cla",
        "application\/vnd.cloanto.rp9": "rp9",
        "application\/vnd.clonk.c4group": "c4g",
        "application\/vnd.cluetrust.cartomobile-config": "c11amc",
        "application\/vnd.cluetrust.cartomobile-config-pkg": "c11amz",
        "application\/vnd.commonspace": "csp",
        "application\/vnd.contact.cmsg": "cdbcmsg",
        "application\/vnd.cosmocaller": "cmc",
        "application\/vnd.crick.clicker": "clkx",
        "application\/vnd.crick.clicker.keyboard": "clkk",
        "application\/vnd.crick.clicker.palette": "clkp",
        "application\/vnd.crick.clicker.template": "clkt",
        "application\/vnd.crick.clicker.wordbank": "clkw",
        "application\/vnd.criticaltools.wbs+xml": "wbs",
        "application\/vnd.ctc-posml": "pml",
        "application\/vnd.cups-ppd": "ppd",
        "application\/vnd.curl.car": "car",
        "application\/vnd.curl.pcurl": "pcurl",
        "application\/vnd.dart": "dart",
        "application\/vnd.data-vision.rdz": "rdz",
        "application\/vnd.dece.data": "uvf",
        "application\/vnd.dece.ttml+xml": "uvt",
        "application\/vnd.dece.unspecified": "uvx",
        "application\/vnd.dece.zip": "uvz",
        "application\/vnd.denovo.fcselayout-link": "fe_launch",
        "application\/vnd.dna": "dna",
        "application\/vnd.dolby.mlp": "mlp",
        "application\/vnd.dpgraph": "dpg",
        "application\/vnd.dreamfactory": "dfac",
        "application\/vnd.ds-keypoint": "kpxx",
        "application\/vnd.dvb.ait": "ait",
        "application\/vnd.dvb.service": "svc",
        "application\/vnd.dynageo": "geo",
        "application\/vnd.ecowin.chart": "mag",
        "application\/vnd.enliven": "nml",
        "application\/vnd.epson.esf": "esf",
        "application\/vnd.epson.msf": "msf",
        "application\/vnd.epson.quickanime": "qam",
        "application\/vnd.epson.salt": "slt",
        "application\/vnd.epson.ssf": "ssf",
        "application\/vnd.eszigno3+xml": "es3",
        "application\/vnd.ezpix-album": "ez2",
        "application\/vnd.ezpix-package": "ez3",
        "application\/vnd.fdf": "fdf",
        "application\/vnd.fdsn.mseed": "mseed",
        "application\/vnd.fdsn.seed": "seed",
        "application\/vnd.flographit": "gph",
        "application\/vnd.fluxtime.clip": "ftc",
        "application\/vnd.framemaker": "fm",
        "application\/vnd.frogans.fnc": "fnc",
        "application\/vnd.frogans.ltf": "ltf",
        "application\/vnd.fsc.weblaunch": "fsc",
        "application\/vnd.fujitsu.oasys": "oas",
        "application\/vnd.fujitsu.oasys2": "oa2",
        "application\/vnd.fujitsu.oasys3": "oa3",
        "application\/vnd.fujitsu.oasysgp": "fg5",
        "application\/vnd.fujitsu.oasysprs": "bh2",
        "application\/vnd.fujixerox.ddd": "ddd",
        "application\/vnd.fujixerox.docuworks": "xdw",
        "application\/vnd.fujixerox.docuworks.binder": "xbd",
        "application\/vnd.fuzzysheet": "fzs",
        "application\/vnd.genomatix.tuxedo": "txd",
        "application\/vnd.geogebra.file": "ggb",
        "application\/vnd.geogebra.tool": "ggt",
        "application\/vnd.geometry-explorer": "gex",
        "application\/vnd.geonext": "gxt",
        "application\/vnd.geoplan": "g2w",
        "application\/vnd.geospace": "g3w",
        "application\/vnd.gmx": "gmx",
        "application\/vnd.google-earth.kml+xml": "kml",
        "application\/vnd.google-earth.kmz": "kmz",
        "application\/vnd.grafeq": "gqf",
        "application\/vnd.groove-account": "gac",
        "application\/vnd.groove-help": "ghf",
        "application\/vnd.groove-identity-message": "gim",
        "application\/vnd.groove-injector": "grv",
        "application\/vnd.groove-tool-message": "gtm",
        "application\/vnd.groove-tool-template": "tpl",
        "application\/vnd.groove-vcard": "vcg",
        "application\/vnd.hal+xml": "hal",
        "application\/vnd.handheld-entertainment+xml": "zmm",
        "application\/vnd.hbci": "hbci",
        "application\/vnd.hhe.lesson-player": "les",
        "application\/vnd.hp-hpgl": "hpgl",
        "application\/vnd.hp-hpid": "hpid",
        "application\/vnd.hp-hps": "hps",
        "application\/vnd.hp-jlyt": "jlt",
        "application\/vnd.hp-pcl": "pcl",
        "application\/vnd.hp-pclxl": "pclxl",
        "application\/vnd.hydrostatix.sof-data": "sfd-hdstx",
        "application\/vnd.ibm.minipay": "mpy",
        "application\/vnd.ibm.modcap": "afp",
        "application\/vnd.ibm.rights-management": "irm",
        "application\/vnd.ibm.secure-container": "sc",
        "application\/vnd.iccprofile": "icc",
        "application\/vnd.igloader": "igl",
        "application\/vnd.immervision-ivp": "ivp",
        "application\/vnd.immervision-ivu": "ivu",
        "application\/vnd.insors.igm": "igm",
        "application\/vnd.intercon.formnet": "xpw",
        "application\/vnd.intergeo": "i2g",
        "application\/vnd.intu.qbo": "qbo",
        "application\/vnd.intu.qfx": "qfx",
        "application\/vnd.ipunplugged.rcprofile": "rcprofile",
        "application\/vnd.irepository.package+xml": "irp",
        "application\/vnd.is-xpr": "xpr",
        "application\/vnd.isac.fcs": "fcs",
        "application\/vnd.jam": "jam",
        "application\/vnd.jcp.javame.midlet-rms": "rms",
        "application\/vnd.jisp": "jisp",
        "application\/vnd.joost.joda-archive": "joda",
        "application\/vnd.kahootz": "ktz",
        "application\/vnd.kde.karbon": "karbon",
        "application\/vnd.kde.kchart": "chrt",
        "application\/vnd.kde.kformula": "kfo",
        "application\/vnd.kde.kivio": "flw",
        "application\/vnd.kde.kontour": "kon",
        "application\/vnd.kde.kpresenter": "kpr",
        "application\/vnd.kde.kspread": "ksp",
        "application\/vnd.kde.kword": "kwd",
        "application\/vnd.kenameaapp": "htke",
        "application\/vnd.kidspiration": "kia",
        "application\/vnd.kinar": "kne",
        "application\/vnd.koan": "skp",
        "application\/vnd.kodak-descriptor": "sse",
        "application\/vnd.las.las+xml": "lasxml",
        "application\/vnd.llamagraphics.life-balance.desktop": "lbd",
        "application\/vnd.llamagraphics.life-balance.exchange+xml": "lbe",
        "application\/vnd.lotus-1-2-3": 123,
        "application\/vnd.lotus-approach": "apr",
        "application\/vnd.lotus-freelance": "pre",
        "application\/vnd.lotus-notes": "nsf",
        "application\/vnd.lotus-organizer": "org",
        "application\/vnd.lotus-screencam": "scm",
        "application\/vnd.lotus-wordpro": "lwp",
        "application\/vnd.macports.portpkg": "portpkg",
        "application\/vnd.mcd": "mcd",
        "application\/vnd.medcalcdata": "mc1",
        "application\/vnd.mediastation.cdkey": "cdkey",
        "application\/vnd.mfer": "mwf",
        "application\/vnd.mfmp": "mfm",
        "application\/vnd.micrografx.flo": "flo",
        "application\/vnd.micrografx.igx": "igx",
        "application\/vnd.mif": "mif",
        "application\/vnd.mobius.daf": "daf",
        "application\/vnd.mobius.dis": "dis",
        "application\/vnd.mobius.mbk": "mbk",
        "application\/vnd.mobius.mqy": "mqy",
        "application\/vnd.mobius.msl": "msl",
        "application\/vnd.mobius.plc": "plc",
        "application\/vnd.mobius.txf": "txf",
        "application\/vnd.mophun.application": "mpn",
        "application\/vnd.mophun.certificate": "mpc",
        "application\/vnd.mozilla.xul+xml": "xul",
        "application\/vnd.ms-artgalry": "cil",
        "application\/vnd.ms-cab-compressed": "cab",
        "application\/vnd.ms-excel": "xls",
        "application\/vnd.ms-excel.addin.macroenabled.12": "xlam",
        "application\/vnd.ms-excel.sheet.binary.macroenabled.12": "xlsb",
        "application\/vnd.ms-excel.sheet.macroenabled.12": "xlsm",
        "application\/vnd.ms-excel.template.macroenabled.12": "xltm",
        "application\/vnd.ms-fontobject": "eot",
        "application\/vnd.ms-htmlhelp": "chm",
        "application\/vnd.ms-ims": "ims",
        "application\/vnd.ms-lrm": "lrm",
        "application\/vnd.ms-officetheme": "thmx",
        "application\/vnd.ms-pki.seccat": "cat",
        "application\/vnd.ms-pki.stl": "stl",
        "application\/vnd.ms-powerpoint": "ppt",
        "application\/vnd.ms-powerpoint.addin.macroenabled.12": "ppam",
        "application\/vnd.ms-powerpoint.presentation.macroenabled.12": "pptm",
        "application\/vnd.ms-powerpoint.slide.macroenabled.12": "sldm",
        "application\/vnd.ms-powerpoint.slideshow.macroenabled.12": "ppsm",
        "application\/vnd.ms-powerpoint.template.macroenabled.12": "potm",
        "application\/vnd.ms-project": "mpp",
        "application\/vnd.ms-word.document.macroenabled.12": "docm",
        "application\/vnd.ms-word.template.macroenabled.12": "dotm",
        "application\/vnd.ms-works": "wps",
        "application\/vnd.ms-wpl": "wpl",
        "application\/vnd.ms-xpsdocument": "xps",
        "application\/vnd.mseq": "mseq",
        "application\/vnd.musician": "mus",
        "application\/vnd.muvee.style": "msty",
        "application\/vnd.mynfc": "taglet",
        "application\/vnd.neurolanguage.nlu": "nlu",
        "application\/vnd.nitf": "ntf",
        "application\/vnd.noblenet-directory": "nnd",
        "application\/vnd.noblenet-sealer": "nns",
        "application\/vnd.noblenet-web": "nnw",
        "application\/vnd.nokia.n-gage.data": "ngdat",
        "application\/vnd.nokia.n-gage.symbian.install": "n-gage",
        "application\/vnd.nokia.radio-preset": "rpst",
        "application\/vnd.nokia.radio-presets": "rpss",
        "application\/vnd.novadigm.edm": "edm",
        "application\/vnd.novadigm.edx": "edx",
        "application\/vnd.novadigm.ext": "ext",
        "application\/vnd.oasis.opendocument.chart": "odc",
        "application\/vnd.oasis.opendocument.chart-template": "otc",
        "application\/vnd.oasis.opendocument.database": "odb",
        "application\/vnd.oasis.opendocument.formula": "odf",
        "application\/vnd.oasis.opendocument.formula-template": "odft",
        "application\/vnd.oasis.opendocument.graphics": "odg",
        "application\/vnd.oasis.opendocument.graphics-template": "otg",
        "application\/vnd.oasis.opendocument.image": "odi",
        "application\/vnd.oasis.opendocument.image-template": "oti",
        "application\/vnd.oasis.opendocument.presentation": "odp",
        "application\/vnd.oasis.opendocument.presentation-template": "otp",
        "application\/vnd.oasis.opendocument.spreadsheet": "ods",
        "application\/vnd.oasis.opendocument.spreadsheet-template": "ots",
        "application\/vnd.oasis.opendocument.text": "odt",
        "application\/vnd.oasis.opendocument.text-master": "odm",
        "application\/vnd.oasis.opendocument.text-template": "ott",
        "application\/vnd.oasis.opendocument.text-web": "oth",
        "application\/vnd.olpc-sugar": "xo",
        "application\/vnd.oma.dd2+xml": "dd2",
        "application\/vnd.openofficeorg.extension": "oxt",
        "application\/vnd.openxmlformats-officedocument.presentationml.presentation": "pptx",
        "application\/vnd.openxmlformats-officedocument.presentationml.slide": "sldx",
        "application\/vnd.openxmlformats-officedocument.presentationml.slideshow": "ppsx",
        "application\/vnd.openxmlformats-officedocument.presentationml.template": "potx",
        "application\/vnd.openxmlformats-officedocument.spreadsheetml.sheet": "xlsx",
        "application\/vnd.openxmlformats-officedocument.spreadsheetml.template": "xltx",
        "application\/vnd.openxmlformats-officedocument.wordprocessingml.document": "docx",
        "application\/vnd.openxmlformats-officedocument.wordprocessingml.template": "dotx",
        "application\/vnd.osgeo.mapguide.package": "mgp",
        "application\/vnd.osgi.dp": "dp",
        "application\/vnd.osgi.subsystem": "esa",
        "application\/vnd.palm": "pdb",
        "application\/vnd.pawaafile": "paw",
        "application\/vnd.pg.format": "str",
        "application\/vnd.pg.osasli": "ei6",
        "application\/vnd.picsel": "efif",
        "application\/vnd.pmi.widget": "wg",
        "application\/vnd.pocketlearn": "plf",
        "application\/vnd.powerbuilder6": "pbd",
        "application\/vnd.previewsystems.box": "box",
        "application\/vnd.proteus.magazine": "mgz",
        "application\/vnd.publishare-delta-tree": "qps",
        "application\/vnd.pvi.ptid1": "ptid",
        "application\/vnd.quark.quarkxpress": "qxd",
        "application\/vnd.realvnc.bed": "bed",
        "application\/vnd.recordare.musicxml": "mxl",
        "application\/vnd.recordare.musicxml+xml": "musicxml",
        "application\/vnd.rig.cryptonote": "cryptonote",
        "application\/vnd.rim.cod": "cod",
        "application\/vnd.rn-realmedia": "rm",
        "application\/vnd.rn-realmedia-vbr": "rmvb",
        "application\/vnd.route66.link66+xml": "link66",
        "application\/vnd.sailingtracker.track": "st",
        "application\/vnd.seemail": "see",
        "application\/vnd.sema": "sema",
        "application\/vnd.semd": "semd",
        "application\/vnd.semf": "semf",
        "application\/vnd.shana.informed.formdata": "ifm",
        "application\/vnd.shana.informed.formtemplate": "itp",
        "application\/vnd.shana.informed.interchange": "iif",
        "application\/vnd.shana.informed.package": "ipk",
        "application\/vnd.simtech-mindmapper": "twd",
        "application\/vnd.smaf": "mmf",
        "application\/vnd.smart.teacher": "teacher",
        "application\/vnd.solent.sdkm+xml": "sdkm",
        "application\/vnd.spotfire.dxp": "dxp",
        "application\/vnd.spotfire.sfs": "sfs",
        "application\/vnd.stardivision.calc": "sdc",
        "application\/vnd.stardivision.draw": "sda",
        "application\/vnd.stardivision.impress": "sdd",
        "application\/vnd.stardivision.math": "smf",
        "application\/vnd.stardivision.writer": "sdw",
        "application\/vnd.stardivision.writer-global": "sgl",
        "application\/vnd.stepmania.package": "smzip",
        "application\/vnd.stepmania.stepchart": "sm",
        "application\/vnd.sun.xml.calc": "sxc",
        "application\/vnd.sun.xml.calc.template": "stc",
        "application\/vnd.sun.xml.draw": "sxd",
        "application\/vnd.sun.xml.draw.template": "std",
        "application\/vnd.sun.xml.impress": "sxi",
        "application\/vnd.sun.xml.impress.template": "sti",
        "application\/vnd.sun.xml.math": "sxm",
        "application\/vnd.sun.xml.writer": "sxw",
        "application\/vnd.sun.xml.writer.global": "sxg",
        "application\/vnd.sun.xml.writer.template": "stw",
        "application\/vnd.sus-calendar": "sus",
        "application\/vnd.svd": "svd",
        "application\/vnd.symbian.install": "sis",
        "application\/vnd.syncml+xml": "xsm",
        "application\/vnd.syncml.dm+wbxml": "bdm",
        "application\/vnd.syncml.dm+xml": "xdm",
        "application\/vnd.tao.intent-module-archive": "tao",
        "application\/vnd.tcpdump.pcap": "pcap",
        "application\/vnd.tmobile-livetv": "tmo",
        "application\/vnd.trid.tpt": "tpt",
        "application\/vnd.triscape.mxs": "mxs",
        "application\/vnd.trueapp": "tra",
        "application\/vnd.ufdl": "ufd",
        "application\/vnd.uiq.theme": "utz",
        "application\/vnd.umajin": "umj",
        "application\/vnd.unity": "unityweb",
        "application\/vnd.uoml+xml": "uoml",
        "application\/vnd.vcx": "vcx",
        "application\/vnd.visio": "vsd",
        "application\/vnd.visionary": "vis",
        "application\/vnd.vsf": "vsf",
        "application\/vnd.wap.wbxml": "wbxml",
        "application\/vnd.wap.wmlc": "wmlc",
        "application\/vnd.wap.wmlscriptc": "wmlsc",
        "application\/vnd.webturbo": "wtb",
        "application\/vnd.wolfram.player": "nbp",
        "application\/vnd.wordperfect": "wpd",
        "application\/vnd.wqd": "wqd",
        "application\/vnd.wt.stf": "stf",
        "application\/vnd.xara": "xar",
        "application\/vnd.xfdl": "xfdl",
        "application\/vnd.yamaha.hv-dic": "hvd",
        "application\/vnd.yamaha.hv-script": "hvs",
        "application\/vnd.yamaha.hv-voice": "hvp",
        "application\/vnd.yamaha.openscoreformat": "osf",
        "application\/vnd.yamaha.openscoreformat.osfpvg+xml": "osfpvg",
        "application\/vnd.yamaha.smaf-audio": "saf",
        "application\/vnd.yamaha.smaf-phrase": "spf",
        "application\/vnd.yellowriver-custom-menu": "cmp",
        "application\/vnd.zul": "zir",
        "application\/vnd.zzazz.deck+xml": "zaz",
        "application\/voicexml+xml": "vxml",
        "application\/widget": "wgt",
        "application\/winhlp": "hlp",
        "application\/wsdl+xml": "wsdl",
        "application\/wspolicy+xml": "wspolicy",
        "application\/x-7z-compressed": "7z",
        "application\/x-abiword": "abw",
        "application\/x-ace-compressed": "ace",
        "application\/x-apple-diskimage": "dmg",
        "application\/x-authorware-bin": "aab",
        "application\/x-authorware-map": "aam",
        "application\/x-authorware-seg": "aas",
        "application\/x-bcpio": "bcpio",
        "application\/x-bittorrent": "torrent",
        "application\/x-blorb": "blb",
        "application\/x-bzip": "bz",
        "application\/x-cbr": "cbr",
        "application\/x-cdlink": "vcd",
        "application\/x-cfs-compressed": "cfs",
        "application\/x-chat": "chat",
        "application\/x-chess-pgn": "pgn",
        "application\/x-conference": "nsc",
        "application\/x-cpio": "cpio",
        "application\/x-csh": "csh",
        "application\/x-debian-package": "deb",
        "application\/x-dgc-compressed": "dgc",
        "application\/x-director": "dir",
        "application\/x-doom": "wad",
        "application\/x-dtbncx+xml": "ncx",
        "application\/x-dtbook+xml": "dtb",
        "application\/x-dtbresource+xml": "res",
        "application\/x-dvi": "dvi",
        "application\/x-envoy": "evy",
        "application\/x-eva": "eva",
        "application\/x-font-bdf": "bdf",
        "application\/x-font-ghostscript": "gsf",
        "application\/x-font-linux-psf": "psf",
        "application\/x-font-pcf": "pcf",
        "application\/x-font-snf": "snf",
        "application\/x-font-type1": "pfa",
        "application\/x-freearc": "arc",
        "application\/x-futuresplash": "spl",
        "application\/x-gca-compressed": "gca",
        "application\/x-glulx": "ulx",
        "application\/x-gnumeric": "gnumeric",
        "application\/x-gramps-xml": "gramps",
        "application\/x-gtar": "gtar",
        "application\/x-hdf": "hdf",
        "application\/x-install-instructions": "install",
        "application\/x-iso9660-image": "iso",
        "application\/x-java-jnlp-file": "jnlp",
        "application\/x-latex": "latex",
        "application\/x-lzh-compressed": "lzh",
        "application\/x-mie": "mie",
        "application\/x-mobipocket-ebook": "prc",
        "application\/x-ms-application": "application",
        "application\/x-ms-shortcut": "lnk",
        "application\/x-ms-wmd": "wmd",
        "application\/x-ms-wmz": "wmz",
        "application\/x-ms-xbap": "xbap",
        "application\/x-msaccess": "mdb",
        "application\/x-msbinder": "obd",
        "application\/x-mscardfile": "crd",
        "application\/x-msclip": "clp",
        "application\/x-msdownload": "dll",
        "application\/x-msmediaview": "mvb",
        "application\/x-msmetafile": "wmf",
        "application\/x-msmoney": "mny",
        "application\/x-mspublisher": "pub",
        "application\/x-msschedule": "scd",
        "application\/x-msterminal": "trm",
        "application\/x-mswrite": "wri",
        "application\/x-netcdf": "nc",
        "application\/x-nzb": "nzb",
        "application\/x-pkcs12": "p12",
        "application\/x-pkcs7-certificates": "p7b",
        "application\/x-pkcs7-certreqresp": "p7r",
        "application\/x-research-info-systems": "ris",
        "application\/x-shar": "shar",
        "application\/x-shockwave-flash": "swf",
        "application\/x-silverlight-app": "xap",
        "application\/x-sql": "sql",
        "application\/x-stuffit": "sit",
        "application\/x-stuffitx": "sitx",
        "application\/x-subrip": "srt",
        "application\/x-sv4cpio": "sv4cpio",
        "application\/x-sv4crc": "sv4crc",
        "application\/x-t3vm-image": "t3",
        "application\/x-tads": "gam",
        "application\/x-tar": "tar",
        "application\/x-tcl": "tcl",
        "application\/x-tex": "tex",
        "application\/x-tex-tfm": "tfm",
        "application\/x-texinfo": "texinfo",
        "application\/x-tgif": "obj",
        "application\/x-ustar": "ustar",
        "application\/x-wais-source": "src",
        "application\/x-x509-ca-cert": "der",
        "application\/x-xfig": "fig",
        "application\/x-xliff+xml": "xlf",
        "application\/x-xpinstall": "xpi",
        "application\/x-xz": "xz",
        "application\/x-zmachine": "z1",
        "application\/xaml+xml": "xaml",
        "application\/xcap-diff+xml": "xdf",
        "application\/xenc+xml": "xenc",
        "application\/xhtml+xml": "xhtml",
        "application\/xml": "xsl",
        "application\/xml-dtd": "dtd",
        "application\/xop+xml": "xop",
        "application\/xproc+xml": "xpl",
        "application\/xslt+xml": "xslt",
        "application\/xspf+xml": "xspf",
        "application\/xv+xml": "mxml",
        "application\/yang": "yang",
        "application\/yin+xml": "yin",
        "application\/zip": "zip",
        "audio\/adpcm": "adp",
        "audio\/basic": "au",
        "audio\/midi": "mid",
        "audio\/mp4": "m4a",
        "audio\/mpeg": "mpga",
        "audio\/ogg": "oga",
        "audio\/s3m": "s3m",
        "audio\/silk": "sil",
        "audio\/vnd.dece.audio": "uva",
        "audio\/vnd.digital-winds": "eol",
        "audio\/vnd.dra": "dra",
        "audio\/vnd.dts": "dts",
        "audio\/vnd.dts.hd": "dtshd",
        "audio\/vnd.lucent.voice": "lvp",
        "audio\/vnd.ms-playready.media.pya": "pya",
        "audio\/vnd.nuera.ecelp4800": "ecelp4800",
        "audio\/vnd.nuera.ecelp7470": "ecelp7470",
        "audio\/vnd.nuera.ecelp9600": "ecelp9600",
        "audio\/vnd.rip": "rip",
        "audio\/webm": "weba",
        "audio\/x-aac": "aac",
        "audio\/x-aiff": "aif",
        "audio\/x-caf": "caf",
        "audio\/x-flac": "flac",
        "audio\/x-matroska": "mka",
        "audio\/x-mpegurl": "m3u",
        "audio\/x-ms-wax": "wax",
        "audio\/x-ms-wma": "wma",
        "audio\/x-pn-realaudio": "ram",
        "audio\/x-pn-realaudio-plugin": "rmp",
        "audio\/xm": "xm",
        "chemical\/x-cdx": "cdx",
        "chemical\/x-cif": "cif",
        "chemical\/x-cmdf": "cmdf",
        "chemical\/x-cml": "cml",
        "chemical\/x-csml": "csml",
        "chemical\/x-xyz": "xyz",
        "font\/collection": "ttc",
        "font\/otf": "otf",
        "font\/ttf": "ttf",
        "font\/woff": "woff",
        "font\/woff2": "woff2",
        "image\/cgm": "cgm",
        "image\/g3fax": "g3",
        "image\/gif": "gif",
        "image\/ief": "ief",
        "image\/jpeg": "jpeg",
        "image\/ktx": "ktx",
        "image\/png": "png",
        "image\/prs.btif": "btif",
        "image\/sgi": "sgi",
        "image\/svg+xml": "svg",
        "image\/tiff": "tiff",
        "image\/vnd.adobe.photoshop": "psd",
        "image\/vnd.dece.graphic": "uvi",
        "image\/vnd.djvu": "djvu",
        "image\/vnd.dvb.subtitle": "sub",
        "image\/vnd.dwg": "dwg",
        "image\/vnd.dxf": "dxf",
        "image\/vnd.fastbidsheet": "fbs",
        "image\/vnd.fpx": "fpx",
        "image\/vnd.fst": "fst",
        "image\/vnd.fujixerox.edmics-mmr": "mmr",
        "image\/vnd.fujixerox.edmics-rlc": "rlc",
        "image\/vnd.ms-modi": "mdi",
        "image\/vnd.ms-photo": "wdp",
        "image\/vnd.net-fpx": "npx",
        "image\/vnd.wap.wbmp": "wbmp",
        "image\/vnd.xiff": "xif",
        "image\/webp": "webp",
        "image\/x-3ds": "3ds",
        "image\/x-cmu-raster": "ras",
        "image\/x-cmx": "cmx",
        "image\/x-freehand": "fh",
        "image\/x-icon": "ico",
        "image\/x-mrsid-image": "sid",
        "image\/x-pcx": "pcx",
        "image\/x-pict": "pic",
        "image\/x-portable-anymap": "pnm",
        "image\/x-portable-bitmap": "pbm",
        "image\/x-portable-graymap": "pgm",
        "image\/x-portable-pixmap": "ppm",
        "image\/x-rgb": "rgb",
        "image\/x-xpixmap": "xpm",
        "image\/x-xwindowdump": "xwd",
        "message\/rfc822": "eml",
        "model\/iges": "igs",
        "model\/mesh": "msh",
        "model\/vnd.collada+xml": "dae",
        "model\/vnd.dwf": "dwf",
        "model\/vnd.gdl": "gdl",
        "model\/vnd.gtw": "gtw",
        "model\/vnd.vtu": "vtu",
        "model\/vrml": "wrl",
        "model\/x3d+binary": "x3db",
        "model\/x3d+vrml": "x3dv",
        "model\/x3d+xml": "x3d",
        "text\/cache-manifest": "appcache",
        "text\/calendar": "ics",
        "text\/css": "css",
        "text\/csv": "csv",
        "text\/html": "html",
        "text\/n3": "n3",
        "text\/plain": "txt",
        "text\/prs.lines.tag": "dsc",
        "text\/richtext": "rtx",
        "text\/sgml": "sgml",
        "text\/tab-separated-values": "tsv",
        "text\/troff": "t",
        "text\/turtle": "ttl",
        "text\/uri-list": "uri",
        "text\/vcard": "vcard",
        "text\/vnd.curl": "curl",
        "text\/vnd.curl.dcurl": "dcurl",
        "text\/vnd.curl.mcurl": "mcurl",
        "text\/vnd.curl.scurl": "scurl",
        "text\/vnd.fly": "fly",
        "text\/vnd.fmi.flexstor": "flx",
        "text\/vnd.graphviz": "gv",
        "text\/vnd.in3d.3dml": "3dml",
        "text\/vnd.in3d.spot": "spot",
        "text\/vnd.sun.j2me.app-descriptor": "jad",
        "text\/vnd.wap.wml": "wml",
        "text\/vnd.wap.wmlscript": "wmls",
        "text\/x-asm": "s",
        "text\/x-c": "cc",
        "text\/x-fortran": "f",
        "text\/x-java-source": "java",
        "text\/x-nfo": "nfo",
        "text\/x-opml": "opml",
        "text\/x-pascal": "p",
        "text\/x-setext": "etx",
        "text\/x-sfv": "sfv",
        "text\/x-uuencode": "uu",
        "text\/x-vcalendar": "vcs",
        "text\/x-vcard": "vcf",
        "video\/3gpp": "3gp",
        "video\/3gpp2": "3g2",
        "video\/h261": "h261",
        "video\/h263": "h263",
        "video\/h264": "h264",
        "video\/jpeg": "jpgv",
        "video\/jpm": "jpm",
        "video\/mj2": "mj2",
        "video\/mp4": "mp4",
        "video\/mpeg": "mpeg",
        "video\/quicktime": "qt",
        "video\/vnd.dece.hd": "uvh",
        "video\/vnd.dece.mobile": "uvm",
        "video\/vnd.dece.pd": "uvp",
        "video\/vnd.dece.sd": "uvs",
        "video\/vnd.dece.video": "uvv",
        "video\/vnd.dvb.file": "dvb",
        "video\/vnd.fvt": "fvt",
        "video\/vnd.mpegurl": "mxu",
        "video\/vnd.ms-playready.media.pyv": "pyv",
        "video\/vnd.uvvu.mp4": "uvu",
        "video\/vnd.vivo": "viv",
        "video\/webm": "webm",
        "video\/x-f4v": "f4v",
        "video\/x-fli": "fli",
        "video\/x-flv": "flv",
        "video\/x-m4v": "m4v",
        "video\/x-matroska": "mkv",
        "video\/x-mng": "mng",
        "video\/x-ms-asf": "asf",
        "video\/x-ms-vob": "vob",
        "video\/x-ms-wmx": "wmx",
        "video\/x-ms-wvx": "wvx",
        "video\/x-msvideo": "avi",
        "video\/x-sgi-movie": "movie",
        "video\/x-smv": "smv",
        "x-conference\/x-cooltalk": "ice",
        "text\/x-sql": "sql",
        "image\/x-pixlr-data": "pxd",
        "image\/x-adobe-dng": "dng",
        "image\/x-sketch": "sketch",
        "image\/x-xcf": "xcf",
        "audio\/amr": "amr",
        "application\/plt": "plt",
        "application\/sat": "sat",
        "application\/step": "step",
        "text\/x-httpd-cgi": "cgi",
        "text\/x-asap": "asp",
        "text\/x-jsp": "jsp"
    };
    elFinder.prototype._options = {
        cdns: {
            ace: 'https://cdnjs.cloudflare.com/ajax/libs/ace/1.4.2',
            codemirror: 'https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.43.0',
            ckeditor: 'https://cdnjs.cloudflare.com/ajax/libs/ckeditor/4.11.2',
            ckeditor5: 'https://cdn.ckeditor.com/ckeditor5/11.2.0',
            tinymce: 'https://cdnjs.cloudflare.com/ajax/libs/tinymce/5.0.0',
            simplemde: 'https://cdnjs.cloudflare.com/ajax/libs/simplemde/1.11.2',
            fabric16: 'https://cdnjs.cloudflare.com/ajax/libs/fabric.js/1.6.7',
            tui: 'https://uicdn.toast.com',
            hls: 'https://cdnjs.cloudflare.com/ajax/libs/hls.js/0.10.1/hls.min.js',
            dash: 'https://cdnjs.cloudflare.com/ajax/libs/dashjs/2.9.3/dash.all.min.js',
            flv: 'https://cdnjs.cloudflare.com/ajax/libs/flv.js/1.5.0/flv.min.js',
            prettify: 'https://cdn.jsdelivr.net/gh/google/code-prettify@453bd5f51e61245339b738b1bbdd42d7848722ba/loader/run_prettify.js',
            psd: 'https://cdnjs.cloudflare.com/ajax/libs/psd.js/3.2.0/psd.min.js',
            rar: 'https://cdn.jsdelivr.net/gh/nao-pon/rar.js@6cef13ec66dd67992fc7f3ea22f132d770ebaf8b/rar.min.js',
            zlibUnzip: 'https://cdn.jsdelivr.net/gh/imaya/zlib.js@0.3.1/bin/unzip.min.js',
            zlibGunzip: 'https://cdn.jsdelivr.net/gh/imaya/zlib.js@0.3.1/bin/gunzip.min.js',
            marked: 'https://cdnjs.cloudflare.com/ajax/libs/marked/0.6.1:/marked.min.js',
            sparkmd5: 'https://cdnjs.cloudflare.com/ajax/libs/spark-md5/3.0.0/spark-md5.min.js',
            jssha: 'https://cdnjs.cloudflare.com/ajax/libs/jsSHA/2.3.1/sha.js',
            amr: 'https://cdn.jsdelivr.net/gh/yxl/opencore-amr-js@dcf3d2b5f384a1d9ded2a54e4c137a81747b222b/js/amrnb.js'
        },
        url: '',
        requestType: 'get',
        cors: null,
        requestMaxConn: 3,
        transport: {},
        urlUpload: '',
        dragUploadAllow: 'auto',
        overwriteUploadConfirm: !0,
        uploadMaxChunkSize: 10485760,
        folderUploadExclude: {win: /^(?:desktop\.ini|thumbs\.db)$/i, mac: /^\.ds_store$/i},
        iframeTimeout: 0,
        customData: {},
        handlers: {},
        customHeaders: {},
        xhrFields: {},
        lang: 'en',
        baseUrl: '',
        i18nBaseUrl: '',
        cssAutoLoad: !0,
        themes: {},
        theme: null,
        maxErrorDialogs: 5,
        cssClass: '',
        commands: ['*'],
        commandsOptions: {
            getfile: {
                onlyURL: !1,
                multiple: !1,
                folders: !1,
                oncomplete: '',
                onerror: '',
                getPath: !0,
                getImgSize: !1
            },
            open: {method: 'post', into: 'window', selectAction: 'open'},
            opennew: {url: '', useOriginQuery: !0},
            upload: {ui: 'button'},
            download: {maxRequests: 10, minFilesZipdl: 2},
            quicklook: {
                autoplay: !0,
                width: 450,
                height: 300,
                mediaControlsList: '',
                pdfToolbar: !0,
                textMaxlen: 2000,
                contain: !1,
                docked: 0,
                dockHeight: 'auto',
                dockAutoplay: !1,
                googleMapsApiKey: '',
                googleMapsOpts: {maps: {}, kml: {suppressInfoWindows: !1, preserveViewport: !1}},
                viewerjs: {
                    url: '',
                    mimes: ['application/pdf', 'application/vnd.oasis.opendocument.text', 'application/vnd.oasis.opendocument.spreadsheet', 'application/vnd.oasis.opendocument.presentation']
                },
                sharecadMimes: [],
                googleDocsMimes: [],
                officeOnlineMimes: [],
                getDimThreshold: 200000,
                mimeRegexNotEmptyCheck: /^application\/vnd\.google-apps\./
            },
            edit: {
                dialogWidth: void(0),
                mimes: [],
                makeTextMimes: ['text/plain', 'text/css', 'text/html'],
                useStoredEditor: !1,
                editorMaximized: !1,
                editors: [],
                encodings: ['Big5', 'Big5-HKSCS', 'Cp437', 'Cp737', 'Cp775', 'Cp850', 'Cp852', 'Cp855', 'Cp857', 'Cp858', 'Cp862', 'Cp866', 'Cp874', 'EUC-CN', 'EUC-JP', 'EUC-KR', 'GB18030', 'ISO-2022-CN', 'ISO-2022-JP', 'ISO-2022-KR', 'ISO-8859-1', 'ISO-8859-2', 'ISO-8859-3', 'ISO-8859-4', 'ISO-8859-5', 'ISO-8859-6', 'ISO-8859-7', 'ISO-8859-8', 'ISO-8859-9', 'ISO-8859-13', 'ISO-8859-15', 'KOI8-R', 'KOI8-U', 'Shift-JIS', 'Windows-1250', 'Windows-1251', 'Windows-1252', 'Windows-1253', 'Windows-1254', 'Windows-1257'],
                extraOptions: {
                    uploadOpts: {},
                    tuiImgEditOpts: {iconsPath: void(0), theme: {}},
                    pixo: {apikey: ''},
                    creativeCloudApiKey: '',
                    managerUrl: null,
                    ckeditor: {},
                    ckeditor5: {mode: 'inline'},
                    tinymce: {},
                    onlineConvert: {maxSize: 100, showLink: !0}
                }
            },
            fullscreen: {mode: 'screen'},
            search: {
                incsearch: {enable: !0, minlen: 1, wait: 500},
                searchTypes: {SearchMime: {name: 'btnMime', title: 'searchMime', incsearch: 'mime'}}
            },
            info: {
                nullUrlDirLinkSelf: !0,
                hideItems: [],
                showHashMaxsize: 104857600,
                showHashAlgorisms: ['md5', 'sha256'],
                custom: {}
            },
            mkdir: {intoNewFolderToolbtn: !1},
            resize: {
                grid8px: 'disable',
                presetSize: [[320, 240], [400, 400], [640, 480], [800, 600]],
                getDimThreshold: 204800,
                dimSubImgSize: 307200
            },
            rm: {quickTrash: !0, infoCheckWait: 10, toTrashMaxItems: 1000},
            help: {view: ['about', 'shortcuts', 'help', 'integrations', 'debug'], helpSource: ''},
            preference: {
                width: 600,
                height: 400,
                categories: null,
                prefs: null,
                langs: null,
                selectActions: ['open', 'edit/download', 'resize/edit/download', 'download', 'quicklook']
            }
        },
        bootCallback: null,
        getFileCallback: null,
        defaultView: 'icons',
        startPathHash: '',
        sound: !0,
        ui: ['toolbar', 'places', 'tree', 'path', 'stat'],
        uiOptions: {
            toolbar: [['home'], ['mkdir', 'mkfile', 'upload'], ['open'], ['quicklook'], ['search'], ['view', 'sort'], ['preference'], ['fullscreen']],
            toolbarExtra: {
                displayTextLabel: !1,
                labelExcludeUA: ['Mobile'],
                autoHideUA: ['Mobile'],
                defaultHides: ['home', 'reload'],
                showPreferenceButton: 'none',
                preferenceInContextmenu: !0
            },
            tree: {
                attrTitle: !0,
                openRootOnLoad: !0,
                openCwdOnOpen: !0,
                syncTree: !0,
                subTreeMax: 100,
                subdirsMaxConn: 2,
                subdirsAtOnce: 5,
                durations: {slideUpDown: 'fast', autoScroll: 'fast'}
            },
            navbar: {minWidth: 150, maxWidth: 500, autoHideUA: []},
            navdock: {disabled: !1, initMaxHeight: '50%', maxHeight: '90%'},
            cwd: {
                oldSchool: !1,
                showSelectCheckboxUA: ['Touch'],
                metakeyDragout: !0,
                listView: {columns: ['perm', 'date', 'size', 'kind'], columnsCustomName: {}, fixedHeader: !0},
                iconsView: {
                    size: 0,
                    sizeMax: 3,
                    sizeNames: {0: 'viewSmall', 1: 'viewMedium', 2: 'viewLarge', 3: 'viewExtraLarge'}
                },
            },
            path: {toWorkzoneWithoutNavbar: !0},
            dialog: {focusOnMouseOver: !0},
            toast: {
                animate: {
                    showMethod: 'fadeIn',
                    showDuration: 300,
                    showEasing: 'swing',
                    timeOut: 3000,
                    hideMethod: 'fadeOut',
                    hideDuration: 1500,
                    hideEasing: 'swing'
                }
            }
        },
        dispInlineRegex: '^(?:(?:image|video|audio)|application/(?:x-mpegURL|dash\+xml)|(?:text/plain|application/pdf)$)',
        onlyMimes: [],
        sortRules: {},
        sortType: 'name',
        sortOrder: 'asc',
        sortStickFolders: !0,
        sortAlsoTreeview: !1,
        clientFormatDate: !0,
        UTCDate: !1,
        dateFormat: '',
        fancyDateFormat: '',
        fileModeStyle: 'both',
        width: 'auto',
        height: 400,
        heightBase: null,
        resizable: !0,
        notifyDelay: 500,
        notifyDialog: {position: {}, width: null},
        dialogContained: !1,
        allowShortcuts: !0,
        rememberLastDir: !0,
        reloadClearHistory: !1,
        useBrowserHistory: !0,
        showFiles: 50,
        showThreshold: 50,
        validName: !1,
        fileFilter: !1,
        backupSuffix: '~',
        sync: 0,
        syncStart: !0,
        loadTmbs: 5,
        cookie: {expires: 30, domain: '', path: '/', secure: !1},
        contextmenu: {
            navbar: ['open', 'opennew', 'download', '|', 'upload', 'mkdir', '|', 'copy', 'cut', 'paste', 'duplicate', '|', 'rm', 'empty', 'hide', '|', 'rename', '|', 'archive', '|', 'places', 'info', 'chmod', 'netunmount'],
            cwd: ['undo', 'redo', '|', 'back', 'up', 'reload', '|', 'upload', 'mkdir', 'mkfile', 'paste', '|', '|', 'view', 'sort', 'selectall', 'colwidth', '|', 'places', 'info', 'chmod', 'netunmount', '|', 'fullscreen', '|', 'preference'],
            files: ['getfile', '|', 'open', 'opennew', 'download', 'opendir', 'quicklook', 'upload', 'copy', 'cut', 'paste', 'duplicate', 'rm', 'rename', 'resize', '|', 'archive', 'extract', '|', 'selectall', 'selectinvert', '|', 'places', 'info', 'chmod', 'netunmount']
        },
        enableAlways: !1,
        enableByMouseOver: !0,
        windowCloseConfirm: ['hasNotifyDialog', 'editingFile'],
        rawStringDecoder: typeof Encoding === 'object' && $.isFunction(Encoding.convert) ? function (str) {
            return Encoding.convert(str, {to: 'UNICODE', type: 'string'})
        } : null,
        debug: ['error', 'warning', 'event-destroy']
    };
    elFinder.prototype._options.commandsOptions.netmount = {
        ftp: {
            name: 'FTP',
            inputs: {
                host: $('<input type="text"/>'),
                port: $('<input type="number" placeholder="21" class="elfinder-input-optional"/>'),
                path: $('<input type="text" value="/"/>'),
                user: $('<input type="text"/>'),
                pass: $('<input type="password" autocomplete="new-password"/>'),
                FTPS: $('<input type="checkbox" value="1" title="File Transfer Protocol over SSL/TLS"/>'),
                encoding: $('<input type="text" placeholder="Optional" class="elfinder-input-optional"/>'),
                locale: $('<input type="text" placeholder="Optional" class="elfinder-input-optional"/>')
            }
        },
        dropbox2: elFinder.prototype.makeNetmountOptionOauth('dropbox2', 'Dropbox', 'Dropbox', {
            noOffline: !0,
            root: '/',
            pathI18n: 'path',
            integrate: {title: 'Dropbox.com', link: 'https://www.dropbox.com'}
        }),
        googledrive: elFinder.prototype.makeNetmountOptionOauth('googledrive', 'Google Drive', 'Google', {
            integrate: {
                title: 'Google Drive',
                link: 'https://www.google.com/drive/'
            }
        }),
        onedrive: elFinder.prototype.makeNetmountOptionOauth('onedrive', 'One Drive', 'OneDrive', {
            integrate: {
                title: 'Microsoft OneDrive',
                link: 'https://onedrive.live.com'
            }
        }),
        box: elFinder.prototype.makeNetmountOptionOauth('box', 'Box', 'Box', {
            noOffline: !0,
            integrate: {title: 'Box.com', link: 'https://www.box.com'}
        })
    };
    elFinder.prototype.history = function (fm) {
        var self = this, update = !0, history = [], current, reset = function () {
                history = [fm.cwd().hash];
                current = 0;
                update = !0
            },
            nativeHistory = (fm.options.useBrowserHistory && window.history && window.history.pushState) ? window.history : null,
            go = function (fwd) {
                if ((fwd && self.canForward()) || (!fwd && self.canBack())) {
                    update = !1;
                    return fm.exec('open', history[fwd ? ++current : --current]).fail(reset)
                }
                return $.Deferred().reject()
            }, setNativeHistory = function (thash) {
                if (nativeHistory && (!nativeHistory.state || nativeHistory.state.thash !== thash)) {
                    nativeHistory.pushState({thash: thash}, null, location.pathname + location.search + (thash ? '#elf_' + thash : ''))
                }
            };
        this.canBack = function () {
            return current > 0
        };
        this.canForward = function () {
            return current < history.length - 1
        };
        this.back = go;
        this.forward = function () {
            return go(!0)
        };
        fm.bind('init', function () {
            if (nativeHistory && !nativeHistory.state) {
                setNativeHistory(fm.startDir())
            }
        }).open(function () {
            var l = history.length, cwd = fm.cwd().hash;
            if (update) {
                current >= 0 && l > current + 1 && history.splice(current + 1);
                history[history.length - 1] != cwd && history.push(cwd);
                current = history.length - 1
            }
            update = !0;
            setNativeHistory(cwd)
        }).reload(fm.options.reloadClearHistory && reset)
    };
    elFinder.prototype.command = function (fm) {
        this.fm = fm;
        this.name = '';
        this.dialogClass = '';
        this.className = '';
        this.title = '';
        this.linkedCmds = [];
        this.state = -1;
        this.alwaysEnabled = !1;
        this.noChangeDirOnRemovedCwd = !1;
        this._disabled = !1;
        this.disableOnSearch = !1;
        this.updateOnSelect = !0;
        this.syncTitleOnChange = !1;
        this.keepContextmenu = !1;
        this._handlers = {
            enable: function () {
                this.update(void(0), this.value)
            }, disable: function () {
                this.update(-1, this.value)
            }, 'open reload load sync': function () {
                this._disabled = !(this.alwaysEnabled || this.fm.isCommandEnabled(this.name));
                this.update(void(0), this.value);
                this.change()
            }
        };
        this.handlers = {};
        this.shortcuts = [];
        this.options = {ui: 'button'};
        this.listeners = [];
        this.setup = function (name, opts) {
            var self = this, fm = this.fm, setCallback = function (s) {
                var cb = s.callback || function (e) {
                    fm.exec(self.name, void(0), {_userAction: !0, _currentType: 'shortcut'})
                };
                s.callback = function (e) {
                    var enabled, checks = {};
                    if (self.enabled()) {
                        if (fm.searchStatus.state < 2) {
                            enabled = fm.isCommandEnabled(self.name)
                        } else {
                            $.each(fm.selected(), function (i, h) {
                                if (fm.optionsByHashes[h]) {
                                    checks[h] = !0
                                } else {
                                    $.each(fm.volOptions, function (id) {
                                        if (!checks[id] && h.indexOf(id) === 0) {
                                            checks[id] = !0;
                                            return !1
                                        }
                                    })
                                }
                            });
                            $.each(checks, function (h) {
                                enabled = fm.isCommandEnabled(self.name, h);
                                if (!enabled) {
                                    return !1
                                }
                            })
                        }
                        if (enabled) {
                            self.event = e;
                            cb.call(self);
                            delete self.event
                        }
                    }
                }
            }, i, s, sc;
            this.name = name;
            this.title = fm.messages['cmd' + name] ? fm.i18n('cmd' + name) : ((this.extendsCmd && fm.messages['cmd' + this.extendsCmd]) ? fm.i18n('cmd' + this.extendsCmd) : name);
            this.options = Object.assign({}, this.options, opts);
            this.listeners = [];
            this.dialogClass = 'elfinder-dialog-' + name;
            if (opts.shortcuts) {
                if (typeof opts.shortcuts === 'function') {
                    sc = opts.shortcuts(this.fm, this.shortcuts)
                } else if (Array.isArray(opts.shortcuts)) {
                    sc = opts.shortcuts
                }
                this.shortcuts = sc || []
            }
            if (this.updateOnSelect) {
                this._handlers.select = function () {
                    this.update(void(0), this.value)
                }
            }
            $.each(Object.assign({}, self._handlers, self.handlers), function (cmd, handler) {
                fm.bind(cmd, $.proxy(handler, self))
            });
            for (i = 0; i < this.shortcuts.length; i++) {
                s = this.shortcuts[i];
                setCallback(s);
                !s.description && (s.description = this.title);
                fm.shortcut(s)
            }
            if (this.disableOnSearch) {
                fm.bind('search searchend', function () {
                    self._disabled = this.type === 'search' ? !0 : !(this.alwaysEnabled || fm.isCommandEnabled(name));
                    self.update(void(0), self.value)
                })
            }
            this.init()
        };
        this.init = function () {
        };
        this.exec = function (files, opts) {
            return $.Deferred().reject()
        };
        this.getUndo = function (opts, resData) {
            return !1
        };
        this.disabled = function () {
            return this.state < 0
        };
        this.enabled = function () {
            return this.state > -1
        };
        this.active = function () {
            return this.state > 0
        };
        this.getstate = function () {
            return -1
        };
        this.update = function (s, v) {
            var state = this.state, value = this.value;
            if (this._disabled && this.fm.searchStatus === 0) {
                this.state = -1
            } else {
                this.state = s !== void(0) ? s : this.getstate()
            }
            this.value = v;
            if (state != this.state || value != this.value) {
                this.change()
            }
        };
        this.change = function (c) {
            var cmd, i;
            if (typeof(c) === 'function') {
                this.listeners.push(c)
            } else {
                for (i = 0; i < this.listeners.length; i++) {
                    cmd = this.listeners[i];
                    try {
                        cmd(this.state, this.value)
                    } catch (e) {
                        this.fm.debug('error', e)
                    }
                }
            }
            return this
        };
        this.hashes = function (hashes) {
            return hashes ? $.grep(Array.isArray(hashes) ? hashes : [hashes], function (hash) {
                return fm.file(hash) ? !0 : !1
            }) : fm.selected()
        };
        this.files = function (hashes) {
            var fm = this.fm;
            return hashes ? $.map(Array.isArray(hashes) ? hashes : [hashes], function (hash) {
                return fm.file(hash) || null
            }) : fm.selectedFiles()
        };
        this.fmDialog = function (content, options) {
            if (options.cssClass) {
                options.cssClass += ' ' + this.dialogClass
            } else {
                options.cssClass = this.dialogClass
            }
            return this.fm.dialog(content, options)
        }
    };
    elFinder.prototype.resources = {
        'class': {
            hover: 'ui-state-hover',
            active: 'ui-state-active',
            disabled: 'ui-state-disabled',
            draggable: 'ui-draggable',
            droppable: 'ui-droppable',
            adroppable: 'elfinder-droppable-active',
            cwdfile: 'elfinder-cwd-file',
            cwd: 'elfinder-cwd',
            tree: 'elfinder-tree',
            treeroot: 'elfinder-navbar-root',
            navdir: 'elfinder-navbar-dir',
            navdirwrap: 'elfinder-navbar-dir-wrapper',
            navarrow: 'elfinder-navbar-arrow',
            navsubtree: 'elfinder-navbar-subtree',
            navcollapse: 'elfinder-navbar-collapsed',
            navexpand: 'elfinder-navbar-expanded',
            treedir: 'elfinder-tree-dir',
            placedir: 'elfinder-place-dir',
            searchbtn: 'elfinder-button-search',
            editing: 'elfinder-to-editing',
            preventback: 'elfinder-prevent-back',
            tabstab: 'ui-state-default ui-tabs-tab ui-corner-top ui-tab',
            tabsactive: 'ui-tabs-active ui-state-active'
        },
        tpl: {
            perms: '<span class="elfinder-perms"/>',
            lock: '<span class="elfinder-lock"/>',
            symlink: '<span class="elfinder-symlink"/>',
            navicon: '<span class="elfinder-nav-icon"/>',
            navspinner: '<span class="elfinder-spinner elfinder-navbar-spinner"/>',
            navdir: '<div class="elfinder-navbar-wrapper{root}"><span id="{id}" class="ui-corner-all elfinder-navbar-dir {cssclass}"{title}><span class="elfinder-navbar-arrow"/><span class="elfinder-navbar-icon" {style}/>{symlink}{permissions}{name}</span><div class="elfinder-navbar-subtree" style="display:none"/></div>',
            placedir: ''
        },
        mimes: {text: ['application/dash+xml', 'application/docbook+xml', 'application/javascript', 'application/json', 'application/plt', 'application/sat', 'application/sql', 'application/step', 'application/vnd.hp-hpgl', 'application/x-awk', 'application/x-config', 'application/x-csh', 'application/x-empty', 'application/x-mpegurl', 'application/x-perl', 'application/x-php', 'application/x-web-config', 'application/xhtml+xml', 'application/xml', 'audio/x-mp3-playlist', 'image/cgm', 'image/svg+xml', 'image/vnd.dxf', 'model/iges']},
        mixin: {
            make: function () {
                var self = this, fm = this.fm, cmd = this.name, req = this.requestCmd || cmd, wz = fm.getUI('workzone'),
                    org = (this.origin && this.origin === 'navbar') ? 'tree' : 'cwd', tree = (org === 'tree'),
                    find = tree ? 'navHash2Elm' : 'cwdHash2Elm', tarea = (!tree && fm.storage('view') != 'list'),
                    sel = fm.selected(), move = this.move || !1, empty = wz.hasClass('elfinder-cwd-wrapper-empty'),
                    unselect = function () {
                        requestAnimationFrame(function () {
                            input && input.trigger('blur')
                        })
                    }, rest = function () {
                        if (!overlay.is(':hidden')) {
                            overlay.elfinderoverlay('hide').off('click close', cancel)
                        }
                        if (nnode) {
                            pnode.removeClass('ui-front').css('position', '').off('unselect.' + fm.namespace, unselect);
                            if (tarea) {
                                nnode && nnode.css('max-height', '')
                            } else if (!tree) {
                                pnode.css('width', '').parent('td').css('overflow', '')
                            }
                        }
                    }, colwidth, dfrd = $.Deferred().fail(function (error) {
                        dstCls && dst.attr('class', dstCls);
                        empty && wz.addClass('elfinder-cwd-wrapper-empty');
                        if (sel) {
                            move && fm.trigger('unlockfiles', {files: sel});
                            fm.clipboard([]);
                            fm.trigger('selectfiles', {files: sel})
                        }
                        error && fm.error(error)
                    }).always(function () {
                        rest();
                        cleanup();
                        fm.enable().unbind('open', openCallback).trigger('resMixinMake')
                    }), id = 'tmp_' + parseInt(Math.random() * 100000),
                    phash = this.data && this.data.target ? this.data.target : (tree ? fm.file(sel[0]).hash : fm.cwd().hash),
                    date = new Date(), file = {
                        hash: id,
                        phash: phash,
                        name: fm.uniqueName(this.prefix, phash),
                        mime: this.mime,
                        read: !0,
                        write: !0,
                        date: 'Today ' + date.getHours() + ':' + date.getMinutes(),
                        move: move
                    }, dum = fm.getUI(org).trigger('create.' + fm.namespace, file), data = this.data || {},
                    node = fm[find](id), nnode, pnode, overlay = fm.getUI('overlay'), cleanup = function () {
                        if (node && node.length) {
                            input.off();
                            node.hide();
                            fm.unselectfiles({files: [id]}).unbind('resize', resize);
                            requestAnimationFrame(function () {
                                if (tree) {
                                    node.closest('.elfinder-navbar-wrapper').remove()
                                } else {
                                    node.remove()
                                }
                            })
                        }
                    }, cancel = function (e) {
                        if (!overlay.is(':hidden')) {
                            pnode.css('z-index', '')
                        }
                        if (!inError) {
                            cleanup();
                            dfrd.reject();
                            if (e) {
                                e.stopPropagation();
                                e.preventDefault()
                            }
                        }
                    }, input = $(tarea ? '<textarea/>' : '<input type="text"/>').on('keyup text', function () {
                        if (tarea) {
                            this.style.height = '1px';
                            this.style.height = this.scrollHeight + 'px'
                        } else if (colwidth) {
                            this.style.width = colwidth + 'px';
                            if (this.scrollWidth > colwidth) {
                                this.style.width = this.scrollWidth + 10 + 'px'
                            }
                        }
                    }).on('keydown', function (e) {
                        e.stopImmediatePropagation();
                        if (e.keyCode == $.ui.keyCode.ESCAPE) {
                            dfrd.reject()
                        } else if (e.keyCode == $.ui.keyCode.ENTER) {
                            e.preventDefault();
                            input.trigger('blur')
                        }
                    }).on('mousedown click dblclick', function (e) {
                        e.stopPropagation();
                        if (e.type === 'dblclick') {
                            e.preventDefault()
                        }
                    }).on('blur', function () {
                        var name = $.trim(input.val()), parent = input.parent(), valid = !0, cut;
                        if (!overlay.is(':hidden')) {
                            pnode.css('z-index', '')
                        }
                        if (name === '') {
                            return cancel()
                        }
                        if (!inError && parent.length) {
                            if (fm.options.validName && fm.options.validName.test) {
                                try {
                                    valid = fm.options.validName.test(name)
                                } catch (e) {
                                    valid = !1
                                }
                            }
                            if (!name || name === '.' || name === '..' || !valid) {
                                inError = !0;
                                fm.error(file.mime === 'directory' ? 'errInvDirname' : 'errInvName', {
                                    modal: !0,
                                    close: function () {
                                        setTimeout(select, 120)
                                    }
                                });
                                return !1
                            }
                            if (fm.fileByName(name, phash)) {
                                inError = !0;
                                fm.error(['errExists', name], {
                                    modal: !0, close: function () {
                                        setTimeout(select, 120)
                                    }
                                });
                                return !1
                            }
                            cut = (sel && move) ? fm.exec('cut', sel) : null;
                            $.when(cut).done(function () {
                                var toast = {}, nextAct = {};
                                rest();
                                input.hide().before($('<span>').text(name));
                                fm.lockfiles({files: [id]});
                                fm.request({
                                    data: Object.assign({cmd: req, name: name, target: phash}, data || {}),
                                    notify: {type: req, cnt: 1},
                                    preventFail: !0,
                                    syncOnFail: !0,
                                    navigate: {toast: toast},
                                }).fail(function (error) {
                                    fm.unlockfiles({files: [id]});
                                    inError = !0;
                                    input.show().prev().remove();
                                    fm.error(error, {
                                        modal: !0, close: function () {
                                            if (Array.isArray(error) && $.inArray('errUploadMime', error) !== -1) {
                                                dfrd.notify('errUploadMime').reject()
                                            } else {
                                                setTimeout(select, 120)
                                            }
                                        }
                                    })
                                }).done(function (data) {
                                    if (data && data.added && data.added[0]) {
                                        var item = data.added[0], dirhash = item.hash, newItem = fm[find](dirhash), acts = {
                                            'directory': {cmd: 'open', msg: 'cmdopendir'},
                                            'text': {cmd: 'edit', msg: 'cmdedit'},
                                            'default': {cmd: 'open', msg: 'cmdopen'}
                                        }, tmpMimes;
                                        if (sel && move) {
                                            fm.one(req + 'done', function () {
                                                fm.exec('paste', dirhash)
                                            })
                                        }
                                        if (!move) {
                                            if (fm.mimeIsText(item.mime) && !fm.mimesCanMakeEmpty[item.mime] && fm.mimeTypes[item.mime]) {
                                                fm.trigger('canMakeEmptyFile', {mimes: [item.mime], unshift: !0});
                                                tmpMimes = {};
                                                tmpMimes[item.mime] = fm.mimeTypes[item.mime];
                                                fm.storage('mkfileTextMimes', Object.assign(tmpMimes, fm.storage('mkfileTextMimes') || {}))
                                            }
                                            Object.assign(nextAct, nextAction || acts[item.mime] || acts[item.mime.split('/')[0]] || acts[(fm.mimesCanMakeEmpty[item.mime] || $.inArray(item.mime, fm.resources.mimes.text) !== -1) ? 'text' : 'none'] || acts['default']);
                                            Object.assign(toast, nextAct.cmd ? {
                                                incwd: {
                                                    msg: fm.i18n(['complete', fm.i18n('cmd' + cmd)]),
                                                    action: nextAct
                                                },
                                                inbuffer: {
                                                    msg: fm.i18n(['complete', fm.i18n('cmd' + cmd)]),
                                                    action: nextAct
                                                }
                                            } : {inbuffer: {msg: fm.i18n(['complete', fm.i18n('cmd' + cmd)])}})
                                        }
                                    }
                                    dfrd.resolve(data)
                                })
                            }).fail(function () {
                                dfrd.reject()
                            })
                        }
                    }).on('dragenter dragleave dragover drop', function (e) {
                        e.stopPropagation()
                    }), select = function () {
                        var name = fm.splitFileExtention(input.val())[0];
                        if (!inError && fm.UA.Mobile && !fm.UA.iOS) {
                            overlay.on('click close', cancel).elfinderoverlay('show');
                            pnode.css('z-index', overlay.css('z-index') + 1)
                        }
                        inError = !1;
                        !fm.enabled() && fm.enable();
                        input.trigger('focus').trigger('select');
                        input[0].setSelectionRange && input[0].setSelectionRange(0, name.length)
                    }, resize = function () {
                        node.trigger('scrolltoview', {blink: !1})
                    }, openCallback = function () {
                        dfrd && (dfrd.state() === 'pending') && dfrd.reject()
                    }, inError = !1, nextAction, dst, dstCls, collapsed, expanded, arrow, subtree;
                if (!fm.isCommandEnabled(req, phash) || !node.length) {
                    return dfrd.reject()
                }
                if ($.isPlainObject(self.nextAction)) {
                    nextAction = Object.assign({}, self.nextAction)
                }
                if (tree) {
                    dst = fm[find](phash);
                    collapsed = fm.res('class', 'navcollapse');
                    expanded = fm.res('class', 'navexpand');
                    arrow = fm.res('class', 'navarrow');
                    subtree = fm.res('class', 'navsubtree');
                    node.closest('.' + subtree).show();
                    if (!dst.hasClass(collapsed)) {
                        dstCls = dst.attr('class');
                        dst.addClass(collapsed + ' ' + expanded + ' elfinder-subtree-loaded')
                    }
                    if (dst.is('.' + collapsed + ':not(.' + expanded + ')')) {
                        dst.children('.' + arrow).trigger('click').data('dfrd').done(function () {
                            if (input.val() === file.name) {
                                input.val(fm.uniqueName(self.prefix, phash)).trigger('select').trigger('focus')
                            }
                        })
                    }
                    nnode = node.contents().filter(function () {
                        return this.nodeType == 3 && $(this).parent().attr('id') === fm.navHash2Id(file.hash)
                    });
                    pnode = nnode.parent();
                    nnode.replaceWith(input.val(file.name))
                } else {
                    empty && wz.removeClass('elfinder-cwd-wrapper-empty');
                    nnode = node.find('.elfinder-cwd-filename');
                    pnode = nnode.parent();
                    if (tarea) {
                        nnode.css('max-height', 'none')
                    } else {
                        colwidth = pnode.width();
                        pnode.width(colwidth - 15).parent('td').css('overflow', 'visible')
                    }
                    nnode.empty().append(input.val(file.name))
                }
                pnode.addClass('ui-front').css('position', 'relative').on('unselect.' + fm.namespace, unselect);
                fm.bind('resize', resize).one('open', openCallback);
                input.trigger('keyup');
                select();
                return dfrd
            }
        },
        blink: function (elm, mode) {
            var acts = {
                slowonce: function () {
                    elm.hide().delay(250).fadeIn(750).delay(500).fadeOut(3500)
                }, lookme: function () {
                    elm.show().fadeOut(500).fadeIn(750)
                }
            }, func;
            mode = mode || 'slowonce';
            func = acts[mode] || acts.lookme;
            elm.stop(!0, !0);
            func()
        }
    };
    $.fn.dialogelfinder = function (opts, opts2) {
        var position = 'elfinderPosition', destroy = 'elfinderDestroyOnClose', node, pos;
        if ($.isPlainObject(opts)) {
            this.not('.elfinder').each(function () {
                opts.handlers = opts.handlers || {};
                var node = $(this), doc = $(document),
                    toolbar = $('<div class="ui-widget-header dialogelfinder-drag ui-corner-top">' + (opts.title || 'Files') + '</div>'),
                    button = $('<a href="#" class="dialogelfinder-drag-close ui-corner-all"><span class="ui-icon ui-icon-closethick"> </span></a>').appendTo(toolbar).on('click', function (e) {
                        e.preventDefault();
                        node.dialogelfinder('close')
                    }), init = opts.handlers.init, elfinder;
                opts.handlers.init = function (e, fm) {
                    node.prepend(toolbar);
                    init && init(e, fm)
                };
                elfinder = node.addClass('elfinder dialogelfinder touch-punch').css('position', 'absolute').hide().appendTo('body').draggable({
                    handle: '.dialogelfinder-drag',
                    containment: 'window',
                    stop: function () {
                        node.trigger('resize');
                        elfinder.trigger('resize')
                    }
                }).elfinder(opts, opts2).elfinder('instance');
                elfinder.reloadCallback = function (o, o2) {
                    elfinder.destroy();
                    o.handlers.init = init;
                    node.dialogelfinder(o, o2).dialogelfinder('open')
                };
                node.width(parseInt(node.width()) || 840).data(destroy, !!opts.destroyOnClose).find('.elfinder-toolbar').removeClass('ui-corner-top');
                opts.position && node.data(position, opts.position);
                opts.autoOpen !== !1 && $(this).dialogelfinder('open')
            })
        } else {
            if (opts === 'open') {
                node = $(this);
                pos = node.data(position) || {
                    top: parseInt($(document).scrollTop() + ($(window).height() < node.height() ? 2 : ($(window).height() - node.height()) / 2)),
                    left: parseInt($(document).scrollLeft() + ($(window).width() < node.width() ? 2 : ($(window).width() - node.width()) / 2))
                };
                if (node.is(':hidden')) {
                    node.addClass('ui-front').css(pos).show().trigger('resize');
                    setTimeout(function () {
                        node.trigger('resize').trigger('mousedown')
                    }, 200)
                }
            } else if (opts === 'close') {
                node = $(this).removeClass('ui-front');
                if (node.is(':visible')) {
                    !!node.data(destroy) ? node.elfinder('destroy').remove() : node.elfinder('close')
                }
            } else if (opts === 'instance') {
                return $(this).getElFinder()
            }
        }
        return this
    };
    if (typeof elFinder === 'function' && elFinder.prototype.i18) {
        elFinder.prototype.i18.en = {
            translator: 'Troex Nevelin &lt;troex@fury.scancode.ru&gt;, Naoki Sawada &lt;hypweb+elfinder@gmail.com&gt;',
            language: 'English',
            direction: 'ltr',
            dateFormat: 'M d, Y h:i A',
            fancyDateFormat: '$1 h:i A',
            nonameDateFormat: 'ymd-His',
            messages: {
                'error': 'Error',
                'errUnknown': 'Unknown error.',
                'errUnknownCmd': 'Unknown command.',
                'errJqui': 'Invalid jQuery UI configuration. Selectable, draggable and droppable components must be included.',
                'errNode': 'elFinder requires DOM Element to be created.',
                'errURL': 'Invalid elFinder configuration! URL option is not set.',
                'errAccess': 'Access denied.',
                'errConnect': 'Unable to connect to backend.',
                'errAbort': 'Connection aborted.',
                'errTimeout': 'Connection timeout.',
                'errNotFound': 'Backend not found.',
                'errResponse': 'Invalid backend response.',
                'errConf': 'Invalid backend configuration.',
                'errJSON': 'PHP JSON module not installed.',
                'errNoVolumes': 'Readable volumes not available.',
                'errCmdParams': 'Invalid parameters for command "$1".',
                'errDataNotJSON': 'Data is not JSON.',
                'errDataEmpty': 'Data is empty.',
                'errCmdReq': 'Backend request requires command name.',
                'errOpen': 'Unable to open "$1".',
                'errNotFolder': 'Object is not a folder.',
                'errNotFile': 'Object is not a file.',
                'errRead': 'Unable to read "$1".',
                'errWrite': 'Unable to write into "$1".',
                'errPerm': 'Permission denied.',
                'errLocked': '"$1" is locked and can not be renamed, moved or removed.',
                'errExists': 'Item named "$1" already exists.',
                'errInvName': 'Invalid file name.',
                'errInvDirname': 'Invalid folder name.',
                'errFolderNotFound': 'Folder not found.',
                'errFileNotFound': 'File not found.',
                'errTrgFolderNotFound': 'Target folder "$1" not found.',
                'errPopup': 'Browser prevented opening popup window. To open file enable it in browser options.',
                'errMkdir': 'Unable to create folder "$1".',
                'errMkfile': 'Unable to create file "$1".',
                'errRename': 'Unable to rename "$1".',
                'errCopyFrom': 'Copying files from volume "$1" not allowed.',
                'errCopyTo': 'Copying files to volume "$1" not allowed.',
                'errMkOutLink': 'Unable to create a link to outside the volume root.',
                'errUpload': 'Upload error.',
                'errUploadFile': 'Unable to upload "$1".',
                'errUploadNoFiles': 'No files found for upload.',
                'errUploadTotalSize': 'Data exceeds the maximum allowed size.',
                'errUploadFileSize': 'File exceeds maximum allowed size.',
                'errUploadMime': 'File type not allowed.',
                'errUploadTransfer': '"$1" transfer error.',
                'errUploadTemp': 'Unable to make temporary file for upload.',
                'errNotReplace': 'Object "$1" already exists at this location and can not be replaced by object with another type.',
                'errReplace': 'Unable to replace "$1".',
                'errSave': 'Unable to save "$1".',
                'errCopy': 'Unable to copy "$1".',
                'errMove': 'Unable to move "$1".',
                'errCopyInItself': 'Unable to copy "$1" into itself.',
                'errRm': 'Unable to remove "$1".',
                'errTrash': 'Unable into trash.',
                'errRmSrc': 'Unable remove source file(s).',
                'errExtract': 'Unable to extract files from "$1".',
                'errArchive': 'Unable to create archive.',
                'errArcType': 'Unsupported archive type.',
                'errNoArchive': 'File is not archive or has unsupported archive type.',
                'errCmdNoSupport': 'Backend does not support this command.',
                'errReplByChild': 'The folder "$1" can\'t be replaced by an item it contains.',
                'errArcSymlinks': 'For security reason denied to unpack archives contains symlinks or files with not allowed names.',
                'errArcMaxSize': 'Archive files exceeds maximum allowed size.',
                'errResize': 'Unable to resize "$1".',
                'errResizeDegree': 'Invalid rotate degree.',
                'errResizeRotate': 'Unable to rotate image.',
                'errResizeSize': 'Invalid image size.',
                'errResizeNoChange': 'Image size not changed.',
                'errUsupportType': 'Unsupported file type.',
                'errNotUTF8Content': 'File "$1" is not in UTF-8 and cannot be edited.',
                'errNetMount': 'Unable to mount "$1".',
                'errNetMountNoDriver': 'Unsupported protocol.',
                'errNetMountFailed': 'Mount failed.',
                'errNetMountHostReq': 'Host required.',
                'errSessionExpires': 'Your session has expired due to inactivity.',
                'errCreatingTempDir': 'Unable to create temporary directory: "$1"',
                'errFtpDownloadFile': 'Unable to download file from FTP: "$1"',
                'errFtpUploadFile': 'Unable to upload file to FTP: "$1"',
                'errFtpMkdir': 'Unable to create remote directory on FTP: "$1"',
                'errArchiveExec': 'Error while archiving files: "$1"',
                'errExtractExec': 'Error while extracting files: "$1"',
                'errNetUnMount': 'Unable to unmount.',
                'errConvUTF8': 'Not convertible to UTF-8',
                'errFolderUpload': 'Try the modern browser, If you\'d like to upload the folder.',
                'errSearchTimeout': 'Timed out while searching "$1". Search result is partial.',
                'errReauthRequire': 'Re-authorization is required.',
                'errMaxTargets': 'Max number of selectable items is $1.',
                'errRestore': 'Unable to restore from the trash. Can\'t identify the restore destination.',
                'errEditorNotFound': 'Editor not found to this file type.',
                'errServerError': 'Error occurred on the server side.',
                'errEmpty': 'Unable to empty folder "$1".',
                'moreErrors': 'There are $1 more errors.',
                'cmdarchive': 'Create archive',
                'cmdback': 'Back',
                'cmdcopy': 'Copy',
                'cmdcut': 'Cut',
                'cmddownload': 'Download',
                'cmdduplicate': 'Duplicate',
                'cmdedit': 'Edit file',
                'cmdextract': 'Extract files from archive',
                'cmdforward': 'Forward',
                'cmdgetfile': 'Select files',
                'cmdhelp': 'About this software',
                'cmdhome': 'Root',
                'cmdinfo': 'Get info',
                'cmdmkdir': 'New folder',
                'cmdmkdirin': 'Into New Folder',
                'cmdmkfile': 'New file',
                'cmdopen': 'Open',
                'cmdpaste': 'Paste',
                'cmdquicklook': 'Preview',
                'cmdreload': 'Reload',
                'cmdrename': 'Rename',
                'cmdrm': 'Delete',
                'cmdtrash': 'Into trash',
                'cmdrestore': 'Restore',
                'cmdsearch': 'Find files',
                'cmdup': 'Go to parent folder',
                'cmdupload': 'Upload files',
                'cmdview': 'View',
                'cmdresize': 'Resize & Rotate',
                'cmdsort': 'Sort',
                'cmdnetmount': 'Mount network volume',
                'cmdnetunmount': 'Unmount',
                'cmdplaces': 'To Places',
                'cmdchmod': 'Change mode',
                'cmdopendir': 'Open a folder',
                'cmdcolwidth': 'Reset column width',
                'cmdfullscreen': 'Full Screen',
                'cmdmove': 'Move',
                'cmdempty': 'Empty the folder',
                'cmdundo': 'Undo',
                'cmdredo': 'Redo',
                'cmdpreference': 'Preferences',
                'cmdselectall': 'Select all',
                'cmdselectnone': 'Select none',
                'cmdselectinvert': 'Invert selection',
                'cmdopennew': 'Open in new window',
                'cmdhide': 'Hide (Preference)',
                'btnClose': 'Close',
                'btnSave': 'Save',
                'btnRm': 'Remove',
                'btnApply': 'Apply',
                'btnCancel': 'Cancel',
                'btnNo': 'No',
                'btnYes': 'Yes',
                'btnMount': 'Mount',
                'btnApprove': 'Goto $1 & approve',
                'btnUnmount': 'Unmount',
                'btnConv': 'Convert',
                'btnCwd': 'Here',
                'btnVolume': 'Volume',
                'btnAll': 'All',
                'btnMime': 'MIME Type',
                'btnFileName': 'Filename',
                'btnSaveClose': 'Save & Close',
                'btnBackup': 'Backup',
                'btnRename': 'Rename',
                'btnRenameAll': 'Rename(All)',
                'btnPrevious': 'Prev ($1/$2)',
                'btnNext': 'Next ($1/$2)',
                'btnSaveAs': 'Save As',
                'ntfopen': 'Open folder',
                'ntffile': 'Open file',
                'ntfreload': 'Reload folder content',
                'ntfmkdir': 'Creating folder',
                'ntfmkfile': 'Creating files',
                'ntfrm': 'Delete items',
                'ntfcopy': 'Copy items',
                'ntfmove': 'Move items',
                'ntfprepare': 'Checking existing items',
                'ntfrename': 'Rename files',
                'ntfupload': 'Uploading files',
                'ntfdownload': 'Downloading files',
                'ntfsave': 'Save files',
                'ntfarchive': 'Creating archive',
                'ntfextract': 'Extracting files from archive',
                'ntfsearch': 'Searching files',
                'ntfresize': 'Resizing images',
                'ntfsmth': 'Doing something',
                'ntfloadimg': 'Loading image',
                'ntfnetmount': 'Mounting network volume',
                'ntfnetunmount': 'Unmounting network volume',
                'ntfdim': 'Acquiring image dimension',
                'ntfreaddir': 'Reading folder infomation',
                'ntfurl': 'Getting URL of link',
                'ntfchmod': 'Changing file mode',
                'ntfpreupload': 'Verifying upload file name',
                'ntfzipdl': 'Creating a file for download',
                'ntfparents': 'Getting path infomation',
                'ntfchunkmerge': 'Processing the uploaded file',
                'ntftrash': 'Doing throw in the trash',
                'ntfrestore': 'Doing restore from the trash',
                'ntfchkdir': 'Checking destination folder',
                'ntfundo': 'Undoing previous operation',
                'ntfredo': 'Redoing previous undone',
                'ntfchkcontent': 'Checking contents',
                'volume_Trash': 'Trash',
                'dateUnknown': 'unknown',
                'Today': 'Today',
                'Yesterday': 'Yesterday',
                'msJan': 'Jan',
                'msFeb': 'Feb',
                'msMar': 'Mar',
                'msApr': 'Apr',
                'msMay': 'May',
                'msJun': 'Jun',
                'msJul': 'Jul',
                'msAug': 'Aug',
                'msSep': 'Sep',
                'msOct': 'Oct',
                'msNov': 'Nov',
                'msDec': 'Dec',
                'January': 'January',
                'February': 'February',
                'March': 'March',
                'April': 'April',
                'May': 'May',
                'June': 'June',
                'July': 'July',
                'August': 'August',
                'September': 'September',
                'October': 'October',
                'November': 'November',
                'December': 'December',
                'Sunday': 'Sunday',
                'Monday': 'Monday',
                'Tuesday': 'Tuesday',
                'Wednesday': 'Wednesday',
                'Thursday': 'Thursday',
                'Friday': 'Friday',
                'Saturday': 'Saturday',
                'Sun': 'Sun',
                'Mon': 'Mon',
                'Tue': 'Tue',
                'Wed': 'Wed',
                'Thu': 'Thu',
                'Fri': 'Fri',
                'Sat': 'Sat',
                'sortname': 'by name',
                'sortkind': 'by kind',
                'sortsize': 'by size',
                'sortdate': 'by date',
                'sortFoldersFirst': 'Folders first',
                'sortperm': 'by permission',
                'sortmode': 'by mode',
                'sortowner': 'by owner',
                'sortgroup': 'by group',
                'sortAlsoTreeview': 'Also Treeview',
                'untitled file.txt': 'NewFile.txt',
                'untitled folder': 'NewFolder',
                'Archive': 'NewArchive',
                'untitled file': 'NewFile.$1',
                'extentionfile': '$1: File',
                'extentiontype': '$1: $2',
                'confirmReq': 'Confirmation required',
                'confirmRm': 'Are you sure you want to permanently remove items?<br/>This cannot be undone!',
                'confirmRepl': 'Replace old file with new one? (If it contains folders, it will be merged. To backup and replace, select Backup.)',
                'confirmRest': 'Replace existing item with the item in trash?',
                'confirmConvUTF8': 'Not in UTF-8<br/>Convert to UTF-8?<br/>Contents become UTF-8 by saving after conversion.',
                'confirmNonUTF8': 'Character encoding of this file couldn\'t be detected. It need to temporarily convert to UTF-8 for editting.<br/>Please select character encoding of this file.',
                'confirmNotSave': 'It has been modified.<br/>Losing work if you do not save changes.',
                'confirmTrash': 'Are you sure you want to move items to trash bin?',
                'apllyAll': 'Apply to all',
                'name': 'Name',
                'size': 'Size',
                'perms': 'Permissions',
                'modify': 'Modified',
                'kind': 'Kind',
                'read': 'read',
                'write': 'write',
                'noaccess': 'no access',
                'and': 'and',
                'unknown': 'unknown',
                'selectall': 'Select all items',
                'selectfiles': 'Select item(s)',
                'selectffile': 'Select first item',
                'selectlfile': 'Select last item',
                'viewlist': 'List view',
                'viewicons': 'Icons view',
                'viewSmall': 'Small icons',
                'viewMedium': 'Medium icons',
                'viewLarge': 'Large icons',
                'viewExtraLarge': 'Extra large icons',
                'places': 'Places',
                'calc': 'Calculate',
                'path': 'Path',
                'aliasfor': 'Alias for',
                'locked': 'Locked',
                'dim': 'Dimensions',
                'files': 'Files',
                'folders': 'Folders',
                'items': 'Items',
                'yes': 'yes',
                'no': 'no',
                'link': 'Link',
                'searcresult': 'Search results',
                'selected': 'selected items',
                'about': 'About',
                'shortcuts': 'Shortcuts',
                'help': 'Help',
                'webfm': 'Web file manager',
                'ver': 'Version',
                'protocolver': 'protocol version',
                'homepage': 'Project home',
                'docs': 'Documentation',
                'github': 'Fork us on GitHub',
                'twitter': 'Follow us on Twitter',
                'facebook': 'Join us on Facebook',
                'team': 'Team',
                'chiefdev': 'chief developer',
                'developer': 'developer',
                'contributor': 'contributor',
                'maintainer': 'maintainer',
                'translator': 'translator',
                'icons': 'Icons',
                'dontforget': 'and don\'t forget to take your towel',
                'shortcutsof': 'Shortcuts disabled',
                'dropFiles': 'Drop files here',
                'or': 'or',
                'selectForUpload': 'Select files',
                'moveFiles': 'Move items',
                'copyFiles': 'Copy items',
                'restoreFiles': 'Restore items',
                'rmFromPlaces': 'Remove from places',
                'aspectRatio': 'Aspect ratio',
                'scale': 'Scale',
                'width': 'Width',
                'height': 'Height',
                'resize': 'Resize',
                'crop': 'Crop',
                'rotate': 'Rotate',
                'rotate-cw': 'Rotate 90 degrees CW',
                'rotate-ccw': 'Rotate 90 degrees CCW',
                'degree': '°',
                'netMountDialogTitle': 'Mount network volume',
                'protocol': 'Protocol',
                'host': 'Host',
                'port': 'Port',
                'user': 'User',
                'pass': 'Password',
                'confirmUnmount': 'Are you sure to unmount $1?',
                'dropFilesBrowser': 'Drop or Paste files from browser',
                'dropPasteFiles': 'Drop files, Paste URLs or images(clipboard) here',
                'encoding': 'Encoding',
                'locale': 'Locale',
                'searchTarget': 'Target: $1',
                'searchMime': 'Search by input MIME Type',
                'owner': 'Owner',
                'group': 'Group',
                'other': 'Other',
                'execute': 'Execute',
                'perm': 'Permission',
                'mode': 'Mode',
                'emptyFolder': 'Folder is empty',
                'emptyFolderDrop': 'Folder is empty\\A Drop to add items',
                'emptyFolderLTap': 'Folder is empty\\A Long tap to add items',
                'quality': 'Quality',
                'autoSync': 'Auto sync',
                'moveUp': 'Move up',
                'getLink': 'Get URL link',
                'selectedItems': 'Selected items ($1)',
                'folderId': 'Folder ID',
                'offlineAccess': 'Allow offline access',
                'reAuth': 'To re-authenticate',
                'nowLoading': 'Now loading...',
                'openMulti': 'Open multiple files',
                'openMultiConfirm': 'You are trying to open the $1 files. Are you sure you want to open in browser?',
                'emptySearch': 'Search results is empty in search target.',
                'editingFile': 'It is editing a file.',
                'hasSelected': 'You have selected $1 items.',
                'hasClipboard': 'You have $1 items in the clipboard.',
                'incSearchOnly': 'Incremental search is only from the current view.',
                'reinstate': 'Reinstate',
                'complete': '$1 complete',
                'contextmenu': 'Context menu',
                'pageTurning': 'Page turning',
                'volumeRoots': 'Volume roots',
                'reset': 'Reset',
                'bgcolor': 'Background color',
                'colorPicker': 'Color picker',
                '8pxgrid': '8px Grid',
                'enabled': 'Enabled',
                'disabled': 'Disabled',
                'emptyIncSearch': 'Search results is empty in current view.\\A Press [Enter] to expand search target.',
                'emptyLetSearch': 'First letter search results is empty in current view.',
                'textLabel': 'Text label',
                'minsLeft': '$1 mins left',
                'openAsEncoding': 'Reopen with selected encoding',
                'saveAsEncoding': 'Save with the selected encoding',
                'selectFolder': 'Select folder',
                'firstLetterSearch': 'First letter search',
                'presets': 'Presets',
                'tooManyToTrash': 'It\'s too many items so it can\'t into trash.',
                'TextArea': 'TextArea',
                'folderToEmpty': 'Empty the folder "$1".',
                'filderIsEmpty': 'There are no items in a folder "$1".',
                'preference': 'Preference',
                'language': 'Language',
                'clearBrowserData': 'Initialize the settings saved in this browser',
                'toolbarPref': 'Toolbar settings',
                'charsLeft': '... $1 chars left.',
                'sum': 'Sum',
                'roughFileSize': 'Rough file size',
                'autoFocusDialog': 'Focus on the element of dialog with mouseover',
                'select': 'Select',
                'selectAction': 'Action when select file',
                'useStoredEditor': 'Open with the editor used last time',
                'selectinvert': 'Invert selection',
                'renameMultiple': 'Are you sure you want to rename $1 selected items like $2?<br/>This cannot be undone!',
                'batchRename': 'Batch rename',
                'plusNumber': '+ Number',
                'asPrefix': 'Add prefix',
                'asSuffix': 'Add suffix',
                'changeExtention': 'Change extention',
                'columnPref': 'Columns settings (List view)',
                'reflectOnImmediate': 'All changes will reflect immediately to the archive.',
                'reflectOnUnmount': 'Any changes will not reflect until un-mount this volume.',
                'unmountChildren': 'The following volume(s) mounted on this volume also unmounted. Are you sure to unmount it?',
                'selectionInfo': 'Selection Info',
                'hashChecker': 'Algorithms to show the file hash',
                'infoItems': 'Info Items (Selection Info Panel)',
                'pressAgainToExit': 'Press again to exit.',
                'toolbar': 'Toolbar',
                'workspace': 'Work Space',
                'dialog': 'Dialog',
                'all': 'All',
                'iconSize': 'Icon Size (Icons view)',
                'editorMaximized': 'Open the maximized editor window',
                'editorConvNoApi': 'Because conversion by API is not currently available, please convert on the website.',
                'editorConvNeedUpload': 'After conversion, you must be upload with the item URL or a downloaded file to save the converted file.',
                'convertOn': 'Convert on the site of $1',
                'integrations': 'Integrations',
                'integrationWith': 'This elFinder has the following external services integrated. Please check the terms of use, privacy policy, etc. before using it.',
                'showHidden': 'Show hidden items',
                'hideHidden': 'Hide hidden items',
                'toggleHidden': 'Show/Hide hidden items',
                'makefileTypes': 'File types to enable with "New file"',
                'typeOfTextfile': 'Type of the Text file',
                'add': 'Add',
                'theme': 'Theme',
                'default': 'Default',
                'description': 'Description',
                'website': 'Website',
                'author': 'Author',
                'email': 'Email',
                'license': 'License',
                'exportToSave': 'This item can\'t be saved. To avoid losing the edits you need to export to your PC.',
                'dblclickToSelect': 'Double click on the file to select it.',
                'useFullscreen': 'Use fullscreen mode',
                'kindUnknown': 'Unknown',
                'kindRoot': 'Volume Root',
                'kindFolder': 'Folder',
                'kindSelects': 'Selections',
                'kindAlias': 'Alias',
                'kindAliasBroken': 'Broken alias',
                'kindApp': 'Application',
                'kindPostscript': 'Postscript document',
                'kindMsOffice': 'Microsoft Office document',
                'kindMsWord': 'Microsoft Word document',
                'kindMsExcel': 'Microsoft Excel document',
                'kindMsPP': 'Microsoft Powerpoint presentation',
                'kindOO': 'Open Office document',
                'kindAppFlash': 'Flash application',
                'kindPDF': 'Portable Document Format (PDF)',
                'kindTorrent': 'Bittorrent file',
                'kind7z': '7z archive',
                'kindTAR': 'TAR archive',
                'kindGZIP': 'GZIP archive',
                'kindBZIP': 'BZIP archive',
                'kindXZ': 'XZ archive',
                'kindZIP': 'ZIP archive',
                'kindRAR': 'RAR archive',
                'kindJAR': 'Java JAR file',
                'kindTTF': 'True Type font',
                'kindOTF': 'Open Type font',
                'kindRPM': 'RPM package',
                'kindText': 'Text document',
                'kindTextPlain': 'Plain text',
                'kindPHP': 'PHP source',
                'kindCSS': 'Cascading style sheet',
                'kindHTML': 'HTML document',
                'kindJS': 'Javascript source',
                'kindRTF': 'Rich Text Format',
                'kindC': 'C source',
                'kindCHeader': 'C header source',
                'kindCPP': 'C++ source',
                'kindCPPHeader': 'C++ header source',
                'kindShell': 'Unix shell script',
                'kindPython': 'Python source',
                'kindJava': 'Java source',
                'kindRuby': 'Ruby source',
                'kindPerl': 'Perl script',
                'kindSQL': 'SQL source',
                'kindXML': 'XML document',
                'kindAWK': 'AWK source',
                'kindCSV': 'Comma separated values',
                'kindDOCBOOK': 'Docbook XML document',
                'kindMarkdown': 'Markdown text',
                'kindImage': 'Image',
                'kindBMP': 'BMP image',
                'kindJPEG': 'JPEG image',
                'kindGIF': 'GIF Image',
                'kindPNG': 'PNG Image',
                'kindTIFF': 'TIFF image',
                'kindTGA': 'TGA image',
                'kindPSD': 'Adobe Photoshop image',
                'kindXBITMAP': 'X bitmap image',
                'kindPXM': 'Pixelmator image',
                'kindAudio': 'Audio media',
                'kindAudioMPEG': 'MPEG audio',
                'kindAudioMPEG4': 'MPEG-4 audio',
                'kindAudioMIDI': 'MIDI audio',
                'kindAudioOGG': 'Ogg Vorbis audio',
                'kindAudioWAV': 'WAV audio',
                'AudioPlaylist': 'MP3 playlist',
                'kindVideo': 'Video media',
                'kindVideoDV': 'DV movie',
                'kindVideoMPEG': 'MPEG movie',
                'kindVideoMPEG4': 'MPEG-4 movie',
                'kindVideoAVI': 'AVI movie',
                'kindVideoMOV': 'Quick Time movie',
                'kindVideoWM': 'Windows Media movie',
                'kindVideoFlash': 'Flash movie',
                'kindVideoMKV': 'Matroska movie',
                'kindVideoOGG': 'Ogg movie'
            }
        }
    }
    $.fn.elfinderbutton = function (cmd) {
        return this.each(function () {
            var c = 'class', fm = cmd.fm, disabled = fm.res(c, 'disabled'), active = fm.res(c, 'active'),
                hover = fm.res(c, 'hover'), item = 'elfinder-button-menu-item',
                selected = 'elfinder-button-menu-item-selected', menu,
                text = $('<span class="elfinder-button-text">' + cmd.title + '</span>'),
                prvCname = cmd.className ? cmd.className : cmd.name,
                button = $(this).addClass('ui-state-default elfinder-button').attr('title', cmd.title).append('<span class="elfinder-button-icon elfinder-button-icon-' + prvCname + '"/>', text).on('mouseenter mouseleave', function (e) {
                    !button.hasClass(disabled) && button[e.type == 'mouseleave' ? 'removeClass' : 'addClass'](hover)
                }).on('click', function (e) {
                    if (!button.hasClass(disabled)) {
                        if (menu && cmd.variants.length >= 1) {
                            menu.is(':hidden') && fm.getUI().click();
                            e.stopPropagation();
                            menu.css(getMenuOffset()).slideToggle({
                                duration: 100, done: function (e) {
                                    fm[menu.is(':visible') ? 'toFront' : 'toHide'](menu)
                                }
                            })
                        } else {
                            fm.exec(cmd.name, getSelected(), {
                                _userAction: !0,
                                _currentType: 'toolbar',
                                _currentNode: button
                            })
                        }
                    }
                }), hideMenu = function () {
                    fm.toHide(menu)
                }, getMenuOffset = function () {
                    var fmNode = fm.getUI(), baseOffset = fmNode.offset(), buttonOffset = button.offset();
                    return {
                        top: buttonOffset.top - baseOffset.top,
                        left: buttonOffset.left - baseOffset.left,
                        maxHeight: fmNode.height() - 40
                    }
                }, getSelected = function () {
                    var sel = fm.selected(), cwd;
                    if (!sel.length) {
                        if (cwd = fm.cwd()) {
                            sel = [fm.cwd().hash]
                        } else {
                            sel = void(0)
                        }
                    }
                    return sel
                }, tm;
            text.hide();
            cmd.button = button;
            if (Array.isArray(cmd.variants)) {
                button.addClass('elfinder-menubutton');
                menu = $('<div class="ui-front ui-widget ui-widget-content elfinder-button-menu elfinder-button-' + prvCname + '-menu ui-corner-all"/>').hide().appendTo(fm.getUI()).on('mouseenter mouseleave', '.' + item, function () {
                    $(this).toggleClass(hover)
                }).on('click', '.' + item, function (e) {
                    var opts = $(this).data('value');
                    e.preventDefault();
                    e.stopPropagation();
                    button.removeClass(hover);
                    fm.toHide(menu);
                    if (typeof opts === 'undefined') {
                        opts = {}
                    }
                    if (typeof opts === 'object') {
                        opts._userAction = !0
                    }
                    fm.exec(cmd.name, getSelected(), opts)
                }).on('close', hideMenu);
                fm.bind('disable select', hideMenu).getUI().on('click', hideMenu);
                cmd.change(function () {
                    menu.html('');
                    $.each(cmd.variants, function (i, variant) {
                        menu.append($('<div class="' + item + '">' + variant[1] + '</div>').data('value', variant[0]).addClass(variant[0] == cmd.value ? selected : ''))
                    })
                })
            }
            cmd.change(function () {
                var cName;
                tm && cancelAnimationFrame(tm);
                tm = requestAnimationFrame(function () {
                    if (cmd.disabled()) {
                        button.removeClass(active + ' ' + hover).addClass(disabled)
                    } else {
                        button.removeClass(disabled);
                        button[cmd.active() ? 'addClass' : 'removeClass'](active)
                    }
                    if (cmd.syncTitleOnChange) {
                        cName = cmd.className ? cmd.className : cmd.name;
                        if (prvCname !== cName) {
                            button.children('.elfinder-button-icon').removeClass('elfinder-button-icon-' + prvCname).addClass('elfinder-button-icon-' + cName);
                            if (menu) {
                                menu.removeClass('elfinder-button-' + prvCname + '-menu').addClass('elfinder-button-' + cName + '-menu')
                            }
                            prvCname = cName
                        }
                        text.html(cmd.title);
                        button.attr('title', cmd.title)
                    }
                })
            }).change()
        })
    };
    $.fn.elfindercontextmenu = function (fm) {
        return this.each(function () {
            var self = $(this), cmItem = 'elfinder-contextmenu-item', smItem = 'elfinder-contextsubmenu-item',
                exIcon = 'elfinder-contextmenu-extra-icon', cHover = fm.res('class', 'hover'), dragOpt = {
                    distance: 8, start: function () {
                        menu.data('drag', !0).data('touching') && menu.find('.' + cHover).removeClass(cHover)
                    }, stop: function () {
                        menu.data('draged', !0).removeData('drag')
                    }
                },
                menu = $(this).addClass('touch-punch ui-helper-reset ui-front ui-widget ui-state-default ui-corner-all elfinder-contextmenu elfinder-contextmenu-' + fm.direction).hide().on('touchstart', function (e) {
                    menu.data('touching', !0).children().removeClass(cHover)
                }).on('touchend', function (e) {
                    menu.removeData('touching')
                }).on('mouseenter mouseleave', '.' + cmItem, function (e) {
                    $(this).toggleClass(cHover, (e.type === 'mouseenter' || (!menu.data('draged') && menu.data('submenuKeep')) ? !0 : !1));
                    if (menu.data('draged') && menu.data('submenuKeep')) {
                        menu.find('.elfinder-contextmenu-sub:visible').parent().addClass(cHover)
                    }
                }).on('mouseenter mouseleave', '.' + exIcon, function (e) {
                    $(this).parent().toggleClass(cHover, e.type === 'mouseleave')
                }).on('mouseenter mouseleave', '.' + cmItem + ',.' + smItem, function (e) {
                    var setIndex = function (target, sub) {
                        $.each(sub ? subnodes : nodes, function (i, n) {
                            if (target[0] === n) {
                                (sub ? subnodes : nodes)._cur = i;
                                if (sub) {
                                    subselected = target
                                } else {
                                    selected = target
                                }
                                return !1
                            }
                        })
                    };
                    if (e.originalEvent) {
                        var target = $(this), unHover = function () {
                            if (selected && !selected.children('div.elfinder-contextmenu-sub:visible').length) {
                                selected.removeClass(cHover)
                            }
                        };
                        if (e.type === 'mouseenter') {
                            if (target.hasClass(smItem)) {
                                if (subselected) {
                                    subselected.removeClass(cHover)
                                }
                                if (selected) {
                                    subnodes = selected.find('div.' + smItem)
                                }
                                setIndex(target, !0)
                            } else {
                                unHover();
                                setIndex(target)
                            }
                        } else {
                            if (target.hasClass(smItem)) {
                                subselected = null;
                                subnodes = null
                            } else {
                                unHover();
                                (function (sel) {
                                    setTimeout(function () {
                                        if (sel === selected) {
                                            selected = null
                                        }
                                    }, 250)
                                })(selected)
                            }
                        }
                    }
                }).on('contextmenu', function () {
                    return !1
                }).on('mouseup', function () {
                    setTimeout(function () {
                        menu.removeData('draged')
                    }, 100)
                }).draggable(dragOpt), ltr = fm.direction === 'ltr', subpos = ltr ? 'left' : 'right',
                types = Object.assign({}, fm.options.contextmenu),
                tpl = '<div class="' + cmItem + '{className}"><span class="elfinder-button-icon {icon} elfinder-contextmenu-icon"{style}/><span>{label}</span></div>',
                item = function (label, icon, callback, opts) {
                    var className = '', style = '', iconClass = '', v, pos;
                    if (opts) {
                        if (opts.className) {
                            className = ' ' + opts.className
                        }
                        if (opts.iconClass) {
                            iconClass = opts.iconClass;
                            icon = ''
                        }
                        if (opts.iconImg) {
                            v = opts.iconImg.split(/ +/);
                            pos = v[1] && v[2] ? fm.escape(v[1] + 'px ' + v[2] + 'px') : '';
                            style = ' style="background:url(\'' + fm.escape(v[0]) + '\') ' + (pos ? pos : '0 0') + ' no-repeat;' + (pos ? '' : 'posbackground-size:contain;') + '"'
                        }
                    }
                    return $(tpl.replace('{icon}', icon ? 'elfinder-button-icon-' + icon : (iconClass ? iconClass : '')).replace('{label}', label).replace('{style}', style).replace('{className}', className)).on('click', function (e) {
                        e.stopPropagation();
                        e.preventDefault();
                        callback()
                    })
                }, urlIcon = function (iconUrl) {
                    var v = iconUrl.split(/ +/), pos = v[1] && v[2] ? (v[1] + 'px ' + v[2] + 'px') : '';
                    return {
                        backgroundImage: 'url("' + v[0] + '")',
                        backgroundRepeat: 'no-repeat',
                        backgroundPosition: pos ? pos : '',
                        backgroundSize: pos ? '' : 'contain'
                    }
                }, base, cwd, nodes, selected, subnodes, subselected, autoSyncStop, subHoverTm, autoToggle = function () {
                    var evTouchStart = 'touchstart.contextmenuAutoToggle';
                    menu.data('hideTm') && clearTimeout(menu.data('hideTm'));
                    if (menu.is(':visible')) {
                        menu.on('touchstart', function (e) {
                            if (e.originalEvent.touches.length > 1) {
                                return
                            }
                            menu.stop();
                            fm.toFront(menu);
                            menu.data('hideTm') && clearTimeout(menu.data('hideTm'))
                        }).data('hideTm', setTimeout(function () {
                            if (menu.is(':visible')) {
                                cwd.find('.elfinder-cwd-file').off(evTouchStart);
                                cwd.find('.elfinder-cwd-file.ui-selected').one(evTouchStart, function (e) {
                                    if (e.originalEvent.touches.length > 1) {
                                        return
                                    }
                                    var tgt = $(e.target);
                                    if (menu.first().length && !tgt.is('input:checkbox') && !tgt.hasClass('elfinder-cwd-select')) {
                                        e.stopPropagation();
                                        open(e.originalEvent.touches[0].pageX, e.originalEvent.touches[0].pageY);
                                        cwd.data('longtap', !0)
                                        tgt.one('touchend', function () {
                                            setTimeout(function () {
                                                cwd.removeData('longtap')
                                            }, 80)
                                        });
                                        return
                                    }
                                    cwd.find('.elfinder-cwd-file').off(evTouchStart)
                                }).one('unselect.' + fm.namespace, function () {
                                    cwd.find('.elfinder-cwd-file').off(evTouchStart)
                                });
                                menu.fadeOut({
                                    duration: 300, fail: function () {
                                        menu.css('opacity', '1').show()
                                    }, done: function () {
                                        fm.toHide(menu)
                                    }
                                })
                            }
                        }, 4500))
                    }
                }, keyEvts = function (e) {
                    var code = e.keyCode, ESC = $.ui.keyCode.ESCAPE, ENT = $.ui.keyCode.ENTER, LEFT = $.ui.keyCode.LEFT,
                        RIGHT = $.ui.keyCode.RIGHT, UP = $.ui.keyCode.UP, DOWN = $.ui.keyCode.DOWN,
                        subent = fm.direction === 'ltr' ? RIGHT : LEFT, sublev = subent === RIGHT ? LEFT : RIGHT;
                    if ($.inArray(code, [ESC, ENT, LEFT, RIGHT, UP, DOWN]) !== -1) {
                        e.preventDefault();
                        e.stopPropagation();
                        e.stopImmediatePropagation();
                        if (code == ESC || code === sublev) {
                            if (selected && subnodes && subselected) {
                                subselected.trigger('mouseleave').trigger('submenuclose');
                                selected.addClass(cHover);
                                subnodes = null;
                                subselected = null
                            } else {
                                code == ESC && close()
                            }
                        } else if (code == UP || code == DOWN) {
                            if (subnodes) {
                                if (subselected) {
                                    subselected.trigger('mouseleave')
                                }
                                if (code == DOWN && (!subselected || subnodes.length <= ++subnodes._cur)) {
                                    subnodes._cur = 0
                                } else if (code == UP && (!subselected || --subnodes._cur < 0)) {
                                    subnodes._cur = subnodes.length - 1
                                }
                                subselected = subnodes.eq(subnodes._cur).trigger('mouseenter')
                            } else {
                                subnodes = null;
                                if (selected) {
                                    selected.trigger('mouseleave')
                                }
                                if (code == DOWN && (!selected || nodes.length <= ++nodes._cur)) {
                                    nodes._cur = 0
                                } else if (code == UP && (!selected || --nodes._cur < 0)) {
                                    nodes._cur = nodes.length - 1
                                }
                                selected = nodes.eq(nodes._cur).addClass(cHover)
                            }
                        } else if (selected && (code == ENT || code === subent)) {
                            if (selected.hasClass('elfinder-contextmenu-group')) {
                                if (subselected) {
                                    code == ENT && subselected.click()
                                } else {
                                    selected.trigger('mouseenter');
                                    subnodes = selected.find('div.' + smItem);
                                    subnodes._cur = 0;
                                    subselected = subnodes.first().addClass(cHover)
                                }
                            } else {
                                code == ENT && selected.click()
                            }
                        }
                    }
                }, open = function (x, y, css) {
                    var width = menu.outerWidth(), height = menu.outerHeight(), bstyle = base.attr('style'),
                        bpos = base.offset(), bwidth = base.width(), bheight = base.height(), mw = fm.UA.Mobile ? 40 : 2,
                        mh = fm.UA.Mobile ? 20 : 2, x = x - (bpos ? bpos.left : 0), y = y - (bpos ? bpos.top : 0),
                        css = Object.assign(css || {}, {
                            top: Math.max(0, y + mh + height < bheight ? y + mh : y - (y + height - bheight)),
                            left: Math.max(0, (x < width + mw || x + mw + width < bwidth) ? x + mw : x - mw - width),
                            opacity: '1'
                        }), evts;
                    autoSyncStop = !0;
                    fm.autoSync('stop');
                    base.width(bwidth);
                    menu.stop().removeAttr('style').css(css);
                    fm.toFront(menu);
                    menu.show();
                    base.attr('style', bstyle);
                    css[subpos] = parseInt(menu.width());
                    menu.find('.elfinder-contextmenu-sub').css(css);
                    if (fm.UA.iOS) {
                        $('div.elfinder div.overflow-scrolling-touch').css('-webkit-overflow-scrolling', 'auto')
                    }
                    selected = null;
                    subnodes = null;
                    subselected = null;
                    $(document).on('keydown.' + fm.namespace, keyEvts);
                    evts = $._data(document).events;
                    if (evts && evts.keydown) {
                        evts.keydown.unshift(evts.keydown.pop())
                    }
                    fm.UA.Mobile && autoToggle();
                    requestAnimationFrame(function () {
                        fm.getUI().one('click.' + fm.namespace, close)
                    })
                }, close = function () {
                    fm.getUI().off('click.' + fm.namespace, close);
                    $(document).off('keydown.' + fm.namespace, keyEvts);
                    currentType = currentTargets = null;
                    if (menu.is(':visible') || menu.children().length) {
                        fm.toHide(menu.removeAttr('style').empty().removeData('submenuKeep'));
                        try {
                            if (!menu.draggable('instance')) {
                                menu.draggable(dragOpt)
                            }
                        } catch (e) {
                            if (!menu.hasClass('ui-draggable')) {
                                menu.draggable(dragOpt)
                            }
                        }
                        if (menu.data('prevNode')) {
                            menu.data('prevNode').after(menu);
                            menu.removeData('prevNode')
                        }
                        fm.trigger('closecontextmenu');
                        if (fm.UA.iOS) {
                            $('div.elfinder div.overflow-scrolling-touch').css('-webkit-overflow-scrolling', 'touch')
                        }
                    }
                    autoSyncStop && fm.searchStatus.state < 1 && !fm.searchStatus.ininc && fm.autoSync();
                    autoSyncStop = !1
                }, create = function (type, targets) {
                    var sep = !1, insSep = !1, disabled = [], isCwd = type === 'cwd', selcnt = 0, cmdMap;
                    currentType = type;
                    currentTargets = targets;
                    if (!(cmdMap = fm.option('uiCmdMap', isCwd ? void(0) : targets[0]))) {
                        cmdMap = {}
                    }
                    if (!isCwd) {
                        disabled = fm.getDisabledCmds(targets)
                    }
                    selcnt = fm.selected().length;
                    if (selcnt > 1) {
                        menu.append('<div class="ui-corner-top ui-widget-header elfinder-contextmenu-header"><span>' + fm.i18n('selectedItems', '' + selcnt) + '</span></div>')
                    }
                    nodes = $();
                    $.each(types[type] || [], function (i, name) {
                        var cmd, cmdName, useMap, node, submenu, hover;
                        if (name === '|') {
                            if (sep) {
                                insSep = !0
                            }
                            return
                        }
                        if (cmdMap[name]) {
                            cmdName = cmdMap[name];
                            useMap = !0
                        } else {
                            cmdName = name
                        }
                        cmd = fm.getCommand(cmdName);
                        if (cmd && !isCwd && (!fm.searchStatus.state || !cmd.disableOnSearch)) {
                            cmd.__disabled = cmd._disabled;
                            cmd._disabled = !(cmd.alwaysEnabled || (fm._commands[cmdName] ? $.inArray(name, disabled) === -1 && (!useMap || !disabled[cmdName]) : !1));
                            $.each(cmd.linkedCmds, function (i, n) {
                                var c;
                                if (c = fm.getCommand(n)) {
                                    c.__disabled = c._disabled;
                                    c._disabled = !(c.alwaysEnabled || (fm._commands[n] ? !disabled[n] : !1))
                                }
                            })
                        }
                        if (cmd && !cmd._disabled && cmd.getstate(targets) != -1) {
                            if (cmd.variants) {
                                if (!cmd.variants.length) {
                                    return
                                }
                                node = item(cmd.title, cmd.className ? cmd.className : cmd.name, function () {
                                }, cmd.contextmenuOpts);
                                submenu = $('<div class="ui-front ui-corner-all elfinder-contextmenu-sub"/>').hide().css('max-height', fm.getUI().height() - 30).appendTo(node.append('<span class="elfinder-contextmenu-arrow"/>'));
                                hover = function (show) {
                                    if (!show) {
                                        submenu.hide()
                                    } else {
                                        var bstyle = base.attr('style');
                                        base.width(base.width());
                                        submenu.css({top: '-1000px', left: 'auto', right: 'auto'});
                                        var nodeOffset = node.offset(), nodeleft = nodeOffset.left,
                                            nodetop = nodeOffset.top, nodewidth = node.outerWidth(),
                                            width = submenu.outerWidth(!0), height = submenu.outerHeight(!0),
                                            baseOffset = base.offset(), wwidth = baseOffset.left + base.width(),
                                            wheight = baseOffset.top + base.height(), cltr = ltr, x = nodewidth, y, over;
                                        if (ltr) {
                                            over = (nodeleft + nodewidth + width) - wwidth;
                                            if (over > 10) {
                                                if (nodeleft > width - 5) {
                                                    x = x - 5;
                                                    cltr = !1
                                                } else {
                                                    if (!fm.UA.Mobile) {
                                                        x = nodewidth - over
                                                    }
                                                }
                                            }
                                        } else {
                                            over = width - nodeleft;
                                            if (over > 0) {
                                                if ((nodeleft + nodewidth + width - 15) < wwidth) {
                                                    x = x - 5;
                                                    cltr = !0
                                                } else {
                                                    if (!fm.UA.Mobile) {
                                                        x = nodewidth - over
                                                    }
                                                }
                                            }
                                        }
                                        over = (nodetop + 5 + height) - wheight;
                                        y = (over > 0 && nodetop < wheight) ? 5 - over : (over > 0 ? 30 - height : 5);
                                        menu.find('.elfinder-contextmenu-sub:visible').hide();
                                        submenu.css({
                                            top: y,
                                            left: cltr ? x : 'auto',
                                            right: cltr ? 'auto' : x,
                                            overflowY: 'auto'
                                        }).show();
                                        base.attr('style', bstyle)
                                    }
                                };
                                node.addClass('elfinder-contextmenu-group').on('mouseleave', '.elfinder-contextmenu-sub', function (e) {
                                    if (!menu.data('draged')) {
                                        menu.removeData('submenuKeep')
                                    }
                                }).on('submenuclose', '.elfinder-contextmenu-sub', function (e) {
                                    hover(!1)
                                }).on('click', '.' + smItem, function (e) {
                                    var opts, $this;
                                    e.stopPropagation();
                                    if (!menu.data('draged')) {
                                        $this = $(this);
                                        if (!cmd.keepContextmenu) {
                                            menu.hide()
                                        } else {
                                            $this.removeClass(cHover);
                                            node.addClass(cHover)
                                        }
                                        opts = $this.data('exec');
                                        if (typeof opts === 'undefined') {
                                            opts = {}
                                        }
                                        if (typeof opts === 'object') {
                                            opts._userAction = !0;
                                            opts._currentType = type;
                                            opts._currentNode = $this
                                        }
                                        !cmd.keepContextmenu && close();
                                        fm.exec(cmd.name, targets, opts)
                                    }
                                }).on('touchend', function (e) {
                                    if (!menu.data('drag')) {
                                        hover(!0);
                                        menu.data('submenuKeep', !0)
                                    }
                                }).on('mouseenter mouseleave', function (e) {
                                    if (!menu.data('touching')) {
                                        if (node.data('timer')) {
                                            clearTimeout(node.data('timer'));
                                            node.removeData('timer')
                                        }
                                        if (!$(e.target).closest('.elfinder-contextmenu-sub', menu).length) {
                                            if (e.type === 'mouseleave') {
                                                if (!menu.data('submenuKeep')) {
                                                    node.data('timer', setTimeout(function () {
                                                        node.removeData('timer');
                                                        hover(!1)
                                                    }, 250))
                                                }
                                            } else {
                                                node.data('timer', setTimeout(function () {
                                                    node.removeData('timer');
                                                    hover(!0)
                                                }, nodes.find('div.elfinder-contextmenu-sub:visible').length ? 250 : 0))
                                            }
                                        }
                                    }
                                });
                                $.each(cmd.variants, function (i, variant) {
                                    var item = variant === '|' ? '<div class="elfinder-contextmenu-separator"/>' : $('<div class="' + cmItem + ' ' + smItem + '"><span>' + variant[1] + '</span></div>').data('exec', variant[0]),
                                        iconClass, icon;
                                    if (typeof variant[2] !== 'undefined') {
                                        icon = $('<span/>').addClass('elfinder-button-icon elfinder-contextmenu-icon');
                                        if (!/\//.test(variant[2])) {
                                            icon.addClass('elfinder-button-icon-' + variant[2])
                                        } else {
                                            icon.css(urlIcon(variant[2]))
                                        }
                                        item.prepend(icon).addClass(smItem + '-icon')
                                    }
                                    submenu.append(item)
                                })
                            } else {
                                node = item(cmd.title, cmd.className ? cmd.className : cmd.name, function () {
                                    if (!menu.data('draged')) {
                                        !cmd.keepContextmenu && close();
                                        fm.exec(cmd.name, targets, {
                                            _userAction: !0,
                                            _currentType: type,
                                            _currentNode: node
                                        })
                                    }
                                }, cmd.contextmenuOpts);
                                if (cmd.extra && cmd.extra.node) {
                                    $('<span class="elfinder-button-icon elfinder-button-icon-' + (cmd.extra.icon || '') + ' ' + exIcon + '"/>').append(cmd.extra.node).appendTo(node);
                                    $(cmd.extra.node).trigger('ready', {targets: targets})
                                } else {
                                    node.remove('.' + exIcon)
                                }
                            }
                            if (cmd.extendsCmd) {
                                node.children('span.elfinder-button-icon').addClass('elfinder-button-icon-' + cmd.extendsCmd)
                            }
                            if (insSep) {
                                menu.append('<div class="elfinder-contextmenu-separator"/>')
                            }
                            menu.append(node);
                            sep = !0;
                            insSep = !1
                        }
                        if (cmd && typeof cmd.__disabled !== 'undefined') {
                            cmd._disabled = cmd.__disabled;
                            delete cmd.__disabled;
                            $.each(cmd.linkedCmds, function (i, n) {
                                var c;
                                if (c = fm.getCommand(n)) {
                                    c._disabled = c.__disabled;
                                    delete c.__disabled
                                }
                            })
                        }
                    });
                    nodes = menu.children('div.' + cmItem)
                }, createFromRaw = function (raw) {
                    currentType = 'raw';
                    $.each(raw, function (i, data) {
                        var node;
                        if (data === '|') {
                            menu.append('<div class="elfinder-contextmenu-separator"/>')
                        } else if (data.label && typeof data.callback == 'function') {
                            node = item(data.label, data.icon, function () {
                                if (!menu.data('draged')) {
                                    !data.remain && close();
                                    data.callback()
                                }
                            }, data.options || null);
                            menu.append(node)
                        }
                    });
                    nodes = menu.children('div.' + cmItem)
                }, currentType = null, currentTargets = null;
            fm.one('load', function () {
                base = fm.getUI();
                cwd = fm.getUI('cwd');
                fm.bind('contextmenu', function (e) {
                    var data = e.data, css = {}, prevNode;
                    if (data.type && data.type !== 'files') {
                        cwd.trigger('unselectall')
                    }
                    close();
                    if (data.type && data.targets) {
                        fm.trigger('contextmenucreate', data);
                        create(data.type, data.targets);
                        fm.trigger('contextmenucreatedone', data)
                    } else if (data.raw) {
                        createFromRaw(data.raw)
                    }
                    if (menu.children().length) {
                        prevNode = data.prevNode || null;
                        if (prevNode) {
                            menu.data('prevNode', menu.prev());
                            prevNode.after(menu)
                        }
                        if (data.fitHeight) {
                            css = {maxHeight: Math.min(fm.getUI().height(), $(window).height()), overflowY: 'auto'};
                            menu.draggable('destroy').removeClass('ui-draggable')
                        }
                        open(data.x, data.y, css);
                        if (data.opened && typeof data.opened === 'function') {
                            data.opened.call(menu)
                        }
                    }
                }).one('destroy', function () {
                    menu.remove()
                }).bind('disable', close).bind('select', function (e) {
                    (currentType === 'files' && (!e.data || e.data.selected.toString() !== currentTargets.toString())) && close()
                })
            }).shortcut({
                pattern: fm.OS === 'mac' ? 'ctrl+m' : 'contextmenu shift+f10',
                description: 'contextmenu',
                callback: function (e) {
                    e.stopPropagation();
                    e.preventDefault();
                    $(document).one('contextmenu.' + fm.namespace, function (e) {
                        e.preventDefault();
                        e.stopPropagation()
                    });
                    var sel = fm.selected(), type, targets, pos, elm;
                    if (sel.length) {
                        type = 'files';
                        targets = sel;
                        elm = fm.cwdHash2Elm(sel[0])
                    } else {
                        type = 'cwd';
                        targets = [fm.cwd().hash];
                        pos = fm.getUI('workzone').offset()
                    }
                    if (!elm || !elm.length) {
                        elm = fm.getUI('workzone')
                    }
                    pos = elm.offset();
                    pos.top += (elm.height() / 2);
                    pos.left += (elm.width() / 2);
                    fm.trigger('contextmenu', {'type': type, 'targets': targets, 'x': pos.left, 'y': pos.top})
                }
            })
        })
    };
    $.fn.elfindercwd = function (fm, options) {
        this.not('.elfinder-cwd').each(function () {
            var mobile = fm.UA.Mobile, list = fm.viewType == 'list', undef = 'undefined',
                evtSelect = 'select.' + fm.namespace, evtUnselect = 'unselect.' + fm.namespace,
                evtDisable = 'disable.' + fm.namespace, evtEnable = 'enable.' + fm.namespace, c = 'class',
                clFile = fm.res(c, 'cwdfile'), fileSelector = '.' + clFile, clSelected = 'ui-selected',
                clDisabled = fm.res(c, 'disabled'), clDraggable = fm.res(c, 'draggable'),
                clDroppable = fm.res(c, 'droppable'), clHover = fm.res(c, 'hover'), clActive = fm.res(c, 'active'),
                clDropActive = fm.res(c, 'adroppable'), clTmp = clFile + '-tmp', clSelChk = 'elfinder-cwd-selectchk',
                tmbNum = fm.options.loadTmbs > 0 ? fm.options.loadTmbs : 5, query = '', clipCuts = {}, cwdParents = [],
                cwdHashes = [], incHashes = void 0, customCols = [], curClickId = '', customColsBuild = function () {
                    var cols = '';
                    for (var i = 0; i < customCols.length; i++) {
                        cols += '<td class="elfinder-col-' + customCols[i] + '">{' + customCols[i] + '}</td>'
                    }
                    return cols
                }, makeTemplateRow = function () {
                    return '<tr id="{id}" class="' + clFile + ' {permsclass} {dirclass}" title="{tooltip}"{css}><td class="elfinder-col-name"><div class="elfinder-cwd-file-wrapper"><span class="elfinder-cwd-icon {mime}"{style}/>{marker}<span class="elfinder-cwd-filename">{name}</span></div>' + selectCheckbox + '</td>' + customColsBuild() + '</tr>'
                }, selectCheckbox = ($.map(options.showSelectCheckboxUA, function (t) {
                    return (fm.UA[t] || t.match(/^all$/i)) ? !0 : null
                }).length) ? '<div class="elfinder-cwd-select"><input type="checkbox" class="' + clSelChk + '"></div>' : '',
                colResizing = !1, colWidth = null, thHeight, templates = {
                    icon: '<div id="{id}" class="' + clFile + ' {permsclass} {dirclass} ui-corner-all" title="{tooltip}"><div class="elfinder-cwd-file-wrapper ui-corner-all"><div class="elfinder-cwd-icon {mime} ui-corner-all" unselectable="on"{style}/>{marker}</div><div class="elfinder-cwd-filename" title="{nametitle}">{name}</div>' + selectCheckbox + '</div>',
                    row: ''
                }, permsTpl = fm.res('tpl', 'perms'), lockTpl = fm.res('tpl', 'lock'),
                symlinkTpl = fm.res('tpl', 'symlink'), replacement = {
                    id: function (f) {
                        return fm.cwdHash2Id(f.hash)
                    }, name: function (f) {
                        var name = fm.escape(f.i18 || f.name);
                        !list && (name = name.replace(/([_.])/g, '&#8203;$1'));
                        return name
                    }, nametitle: function (f) {
                        return fm.escape(f.i18 || f.name)
                    }, permsclass: function (f) {
                        return fm.perms2class(f)
                    }, perm: function (f) {
                        return fm.formatPermissions(f)
                    }, dirclass: function (f) {
                        var cName = f.mime == 'directory' ? 'directory' : '';
                        f.isroot && (cName += ' isroot');
                        f.csscls && (cName += ' ' + fm.escape(f.csscls));
                        options.getClass && (cName += ' ' + options.getClass(f));
                        return cName
                    }, style: function (f) {
                        return f.icon ? fm.getIconStyle(f) : ''
                    }, mime: function (f) {
                        var cName = fm.mime2class(f.mime);
                        f.icon && (cName += ' elfinder-cwd-bgurl');
                        return cName
                    }, size: function (f) {
                        return (f.mime === 'directory' && !f.size) ? '-' : fm.formatSize(f.size)
                    }, date: function (f) {
                        return fm.formatDate(f)
                    }, kind: function (f) {
                        return fm.mime2kind(f)
                    }, mode: function (f) {
                        return f.perm ? fm.formatFileMode(f.perm) : ''
                    }, modestr: function (f) {
                        return f.perm ? fm.formatFileMode(f.perm, 'string') : ''
                    }, modeoct: function (f) {
                        return f.perm ? fm.formatFileMode(f.perm, 'octal') : ''
                    }, modeboth: function (f) {
                        return f.perm ? fm.formatFileMode(f.perm, 'both') : ''
                    }, marker: function (f) {
                        return (f.alias || f.mime == 'symlink-broken' ? symlinkTpl : '') + (!f.read || !f.write ? permsTpl : '') + (f.locked ? lockTpl : '')
                    }, tooltip: function (f) {
                        var title = fm.formatDate(f) + (f.size > 0 ? ' (' + fm.formatSize(f.size) + ')' : ''), info = '';
                        if (query && f.path) {
                            info = fm.escape(f.path.replace(/\/[^\/]*$/, ''))
                        } else {
                            info = f.tooltip ? fm.escape(f.tooltip).replace(/\r/g, '&#13;') : ''
                        }
                        if (list) {
                            info += (info ? '&#13;' : '') + fm.escape(f.i18 || f.name)
                        }
                        return info ? info + '&#13;' + title : title
                    }
                }, addedBadges = {}, addBadgeStyleSheet, addBadgeStyle = function (mime, name) {
                    var sel, ext, type;
                    if (mime && !addedBadges[mime]) {
                        if (typeof addBadgeStyleSheet === 'undefined') {
                            if ($('#elfinderAddBadgeStyle' + fm.namespace).length) {
                                $('#elfinderAddBadgeStyle' + fm.namespace).remove()
                            }
                            addBadgeStyleSheet = $('<style id="addBadgeStyle' + fm.namespace + '"/>').insertBefore($('head').children(':first')).get(0).sheet || null
                        }
                        if (addBadgeStyleSheet) {
                            mime = mime.toLowerCase();
                            type = mime.split('/');
                            ext = fm.escape(fm.mimeTypes[mime] || (name.replace(/.bac?k$/i, '').match(/\.([^.]+)$/) || ['', ''])[1]);
                            if (ext) {
                                sel = '.elfinder-cwd-icon-' + type[0].replace(/(\.|\+)/g, '-');
                                if (typeof type[1] !== 'undefined') {
                                    sel += '.elfinder-cwd-icon-' + type[1].replace(/(\.|\+)/g, '-')
                                }
                                try {
                                    addBadgeStyleSheet.insertRule(sel + ':before{content:"' + ext.toLowerCase() + '"}', 0)
                                } catch (e) {
                                }
                            }
                            addedBadges[mime] = !0
                        }
                    }
                }, itemhtml = function (f) {
                    f.mime && f.mime !== 'directory' && !addedBadges[f.mime] && addBadgeStyle(f.mime, f.name);
                    return templates[list ? 'row' : 'icon'].replace(/\{([a-z0-9_]+)\}/g, function (s, e) {
                        return replacement[e] ? replacement[e](f, fm) : (f[e] ? f[e] : '')
                    })
                }, selectedNext = $(), selectLock = !1, select = function (keyCode, append) {
                    var code = $.ui.keyCode, prev = keyCode == code.LEFT || keyCode == code.UP,
                        sel = cwd.find('[id].' + clSelected), selector = prev ? 'first:' : 'last', s, n, sib, top, left;

                    function sibling(n, direction) {
                        return n[direction + 'All']('[id]:not(.' + clDisabled + '):not(.elfinder-cwd-parent):first')
                    }

                    if (sel.length) {
                        s = sel.filter(prev ? ':first' : ':last');
                        sib = sibling(s, prev ? 'prev' : 'next');
                        if (!sib.length) {
                            n = s
                        } else if (list || keyCode == code.LEFT || keyCode == code.RIGHT) {
                            n = sib
                        } else {
                            top = s.position().top;
                            left = s.position().left;
                            n = s;
                            if (prev) {
                                do {
                                    n = n.prev('[id]')
                                } while (n.length && !(n.position().top < top && n.position().left <= left));
                                if (n.hasClass(clDisabled)) {
                                    n = sibling(n, 'next')
                                }
                            } else {
                                do {
                                    n = n.next('[id]')
                                } while (n.length && !(n.position().top > top && n.position().left >= left));
                                if (n.hasClass(clDisabled)) {
                                    n = sibling(n, 'prev')
                                }
                                if (!n.length) {
                                    sib = cwd.find('[id]:not(.' + clDisabled + '):last');
                                    if (sib.position().top > top) {
                                        n = sib
                                    }
                                }
                            }
                        }
                    } else {
                        if (selectedNext.length) {
                            n = prev ? selectedNext.prev() : selectedNext
                        } else {
                            n = cwd.find('[id]:not(.' + clDisabled + '):not(.elfinder-cwd-parent):' + (prev ? 'last' : 'first'))
                        }
                    }
                    if (n && n.length && !n.hasClass('elfinder-cwd-parent')) {
                        if (s && append) {
                            n = s.add(s[prev ? 'prevUntil' : 'nextUntil']('#' + n.attr('id'))).add(n)
                        } else {
                            sel.trigger(evtUnselect)
                        }
                        n.trigger(evtSelect);
                        scrollToView(n.filter(prev ? ':first' : ':last'));
                        trigger()
                    }
                }, selectedFiles = {}, selectFile = function (hash) {
                    fm.cwdHash2Elm(hash).trigger(evtSelect)
                }, allSelected = !1, selectAll = function () {
                    var phash = fm.cwd().hash;
                    selectCheckbox && selectAllCheckbox.find('input').prop('checked', !0);
                    fm.lazy(function () {
                        var files;
                        if (fm.maxTargets && (incHashes || cwdHashes).length > fm.maxTargets) {
                            unselectAll({notrigger: !0});
                            files = $.map(incHashes || cwdHashes, function (hash) {
                                return fm.file(hash) || null
                            });
                            files = files.slice(0, fm.maxTargets);
                            selectedFiles = {};
                            $.each(files, function (i, v) {
                                selectedFiles[v.hash] = !0;
                                fm.cwdHash2Elm(v.hash).trigger(evtSelect)
                            });
                            fm.toast({mode: 'warning', msg: fm.i18n(['errMaxTargets', fm.maxTargets])})
                        } else {
                            cwd.find('[id]:not(.' + clSelected + '):not(.elfinder-cwd-parent)').trigger(evtSelect);
                            selectedFiles = fm.arrayFlip(incHashes || cwdHashes, !0)
                        }
                        trigger();
                        selectCheckbox && selectAllCheckbox.data('pending', !1)
                    }, 0, {repaint: !0})
                }, unselectAll = function (opts) {
                    var o = opts || {};
                    selectCheckbox && selectAllCheckbox.find('input').prop('checked', !1);
                    if (Object.keys(selectedFiles).length) {
                        selectLock = !1;
                        selectedFiles = {};
                        cwd.find('[id].' + clSelected).trigger(evtUnselect);
                        selectCheckbox && cwd.find('input:checkbox.' + clSelChk).prop('checked', !1)
                    }
                    !o.notrigger && trigger();
                    selectCheckbox && selectAllCheckbox.data('pending', !1);
                    cwd.removeClass('elfinder-cwd-allselected')
                }, selectInvert = function () {
                    var invHashes = {};
                    if (allSelected) {
                        unselectAll()
                    } else if (!Object.keys(selectedFiles).length) {
                        selectAll()
                    } else {
                        $.each((incHashes || cwdHashes), function (i, h) {
                            var itemNode = fm.cwdHash2Elm(h);
                            if (!selectedFiles[h]) {
                                invHashes[h] = !0;
                                itemNode.length && itemNode.trigger(evtSelect)
                            } else {
                                itemNode.length && itemNode.trigger(evtUnselect)
                            }
                        });
                        selectedFiles = invHashes;
                        trigger()
                    }
                }, selected = function () {
                    return Object.keys(selectedFiles)
                }, lastSelect = void 0, trigger = function () {
                    var selected = Object.keys(selectedFiles), opts = {selected: selected, origin: 'cwd'};
                    if (oldSchoolItem && (selected.length > 1 || selected[0] !== fm.cwdId2Hash(oldSchoolItem.attr('id'))) && oldSchoolItem.hasClass(clSelected)) {
                        oldSchoolItem.trigger(evtUnselect)
                    }
                    allSelected = selected.length && (selected.length === (incHashes || cwdHashes).length) && (!fm.maxTargets || selected.length <= fm.maxTargets);
                    if (selectCheckbox) {
                        selectAllCheckbox.find('input').prop('checked', allSelected);
                        cwd[allSelected ? 'addClass' : 'removeClass']('elfinder-cwd-allselected')
                    }
                    if (allSelected) {
                        opts.selectall = !0
                    } else if (!selected.length) {
                        opts.unselectall = !0
                    }
                    fm.trigger('select', opts)
                }, scrollToView = function (o, blink) {
                    if (!o.length) {
                        return
                    }
                    var ftop = o.position().top, fheight = o.outerHeight(!0), wtop = wrapper.scrollTop(),
                        wheight = wrapper.get(0).clientHeight, thheight = tableHeader ? tableHeader.outerHeight(!0) : 0;
                    if (ftop + thheight + fheight > wtop + wheight) {
                        wrapper.scrollTop(parseInt(ftop + thheight + fheight - wheight))
                    } else if (ftop < wtop) {
                        wrapper.scrollTop(ftop)
                    }
                    list && wrapper.scrollLeft(0);
                    !!blink && fm.resources.blink(o, 'lookme')
                }, buffer = [], bufferExt = {}, index = function (hash) {
                    var l = buffer.length;
                    while (l--) {
                        if (buffer[l].hash == hash) {
                            return l
                        }
                    }
                    return -1
                }, scrollStartEvent = 'elfscrstart', scrollEvent = 'elfscrstop', scrolling = !1, selectableOption = {
                    disabled: !0,
                    filter: '[id]:first',
                    stop: trigger,
                    delay: 250,
                    appendTo: 'body',
                    autoRefresh: !1,
                    selected: function (e, ui) {
                        $(ui.selected).trigger(evtSelect)
                    },
                    unselected: function (e, ui) {
                        $(ui.unselected).trigger(evtUnselect)
                    }
                }, inViewHashes = {}, wrapperRepaint = function (init, recnt) {
                    if (!bufferExt.renderd) {
                        return
                    }
                    var firstNode = (list ? cwd.find('tbody:first') : cwd).children('[id]' + (options.oldSchool ? ':not(.elfinder-cwd-parent)' : '') + ':first');
                    if (!firstNode.length) {
                        return
                    }
                    var selectable = cwd.data('selectable'), rec = (function () {
                            var wos = wrapper.offset(), ww = wrapper.width(), w = $(window), x = firstNode.width() / 2,
                                l = Math.min(wos.left - w.scrollLeft() + (fm.direction === 'ltr' ? x : ww - x), wos.left + ww - 10),
                                t = wos.top - w.scrollTop() + 10 + (list ? thHeight : 0);
                            return {left: Math.max(0, Math.round(l)), top: Math.max(0, Math.round(t))}
                        })(), tgt = init ? firstNode : $(document.elementFromPoint(rec.left, rec.top)), ids = {}, tmbs = {},
                        multi = 5,
                        cnt = Math.ceil((bufferExt.hpi ? Math.ceil((wz.data('rectangle').height / bufferExt.hpi) * 1.5) : showFiles) / multi),
                        chk = function () {
                            var id, hash, file, i;
                            for (i = 0; i < multi; i++) {
                                id = tgt.attr('id');
                                if (id) {
                                    bufferExt.getTmbs = [];
                                    hash = fm.cwdId2Hash(id);
                                    inViewHashes[hash] = id;
                                    if (bufferExt.attachTmbs[hash]) {
                                        tmbs[hash] = bufferExt.attachTmbs[hash]
                                    }
                                    selectable && (ids[id] = !0)
                                }
                                tgt = tgt.next();
                                if (!tgt.length) {
                                    break
                                }
                            }
                        }, done = function () {
                            var idsArr;
                            if (cwd.data('selectable')) {
                                Object.assign(ids, selectedFiles);
                                idsArr = Object.keys(ids);
                                if (idsArr.length) {
                                    selectableOption.filter = '#' + idsArr.join(', #');
                                    cwd.selectable('enable').selectable('option', {filter: selectableOption.filter}).selectable('refresh')
                                }
                            }
                            if (Object.keys(tmbs).length) {
                                bufferExt.getTmbs = [];
                                attachThumbnails(tmbs)
                            }
                        }, setTarget = function () {
                            if (!tgt.hasClass(clFile)) {
                                tgt = tgt.closest(fileSelector)
                            }
                        }, arr, widget;
                    inViewHashes = {};
                    selectable && cwd.selectable('option', 'disabled');
                    if (tgt.length) {
                        if (!tgt.hasClass(clFile) && !tgt.closest(fileSelector).length) {
                            widget = fm.getUI().find('.ui-dialog:visible,.ui-widget:visible');
                            if (widget.length) {
                                widget.hide();
                                tgt = $(document.elementFromPoint(rec.left, rec.top));
                                widget.show()
                            } else {
                                widget = null
                            }
                        }
                        setTarget();
                        if (!tgt.length) {
                            widget && widget.hide();
                            tgt = $(document.elementFromPoint(rec.left, rec.top + 5));
                            widget && widget.show();
                            setTarget()
                        }
                    }
                    if (tgt.length) {
                        if (tgt.attr('id')) {
                            if (init) {
                                for (var i = 0; i < cnt; i++) {
                                    chk();
                                    if (!tgt.length) {
                                        break
                                    }
                                }
                                done()
                            } else {
                                bufferExt.repaintJob && bufferExt.repaintJob.state() === 'pending' && bufferExt.repaintJob.reject();
                                arr = new Array(cnt);
                                bufferExt.repaintJob = fm.asyncJob(function () {
                                    chk();
                                    if (!tgt.length) {
                                        done();
                                        bufferExt.repaintJob && bufferExt.repaintJob.state() === 'pending' && bufferExt.repaintJob.reject()
                                    }
                                }, arr).done(done)
                            }
                        }
                    } else if (init && bufferExt.renderd) {
                        recnt = recnt || 0;
                        if (recnt < 10) {
                            requestAnimationFrame(function () {
                                wrapperRepaint(init, ++recnt)
                            })
                        }
                    }
                }, oldSchoolItem = null, oldSchool = function (p) {
                    var phash = fm.cwd().phash, pdir = fm.file(phash) || null, set = function (pdir) {
                        if (pdir) {
                            oldSchoolItem = $(itemhtml($.extend(!0, {}, pdir, {
                                name: '..',
                                i18: '..',
                                mime: 'directory'
                            }))).addClass('elfinder-cwd-parent').on('dblclick', function () {
                                var hash = fm.cwdId2Hash(this.id);
                                fm.trigger('select', {selected: [hash]}).exec('open', hash)
                            });
                            (list ? oldSchoolItem.children('td:first') : oldSchoolItem).children('.elfinder-cwd-select').remove();
                            (list ? cwd.find('tbody') : cwd).prepend(oldSchoolItem);
                            fm.draggingUiHelper && fm.draggingUiHelper.data('refreshPositions', 1)
                        }
                    };
                    if (pdir) {
                        set(pdir)
                    } else {
                        if (fm.getUI('tree').length) {
                            fm.one('parents', function () {
                                set(fm.file(phash) || null);
                                wrapper.trigger(scrollEvent)
                            })
                        } else {
                            fm.request({
                                data: {cmd: 'parents', target: fm.cwd().hash},
                                preventFail: !0
                            }).done(function (data) {
                                set(fm.file(phash) || null);
                                wrapper.trigger(scrollEvent)
                            })
                        }
                    }
                }, showFiles = fm.options.showFiles, render = function () {
                    if (bufferExt.rendering || (bufferExt.renderd && !buffer.length)) {
                        return
                    }
                    var place = (list ? cwd.children('table').children('tbody') : cwd), phash, chk,
                        docFlag = $.htmlPrefilter ? !0 : !1,
                        tempDom = docFlag ? $(document.createDocumentFragment()) : $('<div/>'), go = function (o) {
                            var over = o || null, html = [], dirs = !1, atmb = {}, stmb = (fm.option('tmbUrl') === 'self'),
                                init = bufferExt.renderd ? !1 : !0, files, locks, selected;
                            files = buffer.splice(0, showFiles + (over || 0) / (bufferExt.hpi || 1));
                            bufferExt.renderd += files.length;
                            if (!buffer.length) {
                                bottomMarker.hide();
                                wrapper.off(scrollEvent, render)
                            }
                            locks = [];
                            html = $.map(files, function (f) {
                                if (f.hash && f.name) {
                                    if (f.mime == 'directory') {
                                        dirs = !0
                                    }
                                    if ((f.tmb && (f.tmb != 1 || f.size > 0)) || (stmb && f.mime.indexOf('image/') === 0)) {
                                        atmb[f.hash] = f.tmb || 'self'
                                    }
                                    clipCuts[f.hash] && locks.push(f.hash);
                                    return itemhtml(f)
                                }
                                return null
                            });
                            tempDom.empty().append(html.join(''));
                            dirs && !mobile && makeDroppable(tempDom);
                            selected = [];
                            if (Object.keys(selectedFiles).length) {
                                tempDom.find('[id]:not(.' + clSelected + '):not(.elfinder-cwd-parent)').each(function () {
                                    selectedFiles[fm.cwdId2Hash(this.id)] && selected.push($(this))
                                })
                            }
                            place.append(docFlag ? tempDom : tempDom.children());
                            if (selected.length) {
                                $.each(selected, function (i, n) {
                                    n.trigger(evtSelect)
                                });
                                trigger()
                            }
                            locks.length && fm.trigger('lockfiles', {files: locks});
                            !bufferExt.hpi && bottomMarkerShow(place, files.length);
                            if (list) {
                                cwd.find('thead').show();
                                fixTableHeader({fitWidth: !colWidth})
                            }
                            if (Object.keys(atmb).length) {
                                Object.assign(bufferExt.attachTmbs, atmb)
                            }
                            if (init) {
                                if (!mobile && !cwd.data('selectable')) {
                                    cwd.selectable(selectableOption).data('selectable', !0)
                                }
                            }
                            !scrolling && wrapper.trigger(scrollEvent)
                        };
                    if (!bufferExt.renderd) {
                        bufferExt.rendering = !0;
                        wrapper.scrollTop(0);
                        phash = fm.cwd().phash;
                        go();
                        if (options.oldSchool) {
                            if (phash && !query) {
                                oldSchool(phash)
                            } else {
                                oldSchoolItem = $()
                            }
                        }
                        if (list) {
                            colWidth && setColwidth();
                            fixTableHeader({fitWidth: !0})
                        }
                        bufferExt.itemH = (list ? place.find('tr:first') : place.find('[id]:first')).outerHeight(!0);
                        fm.trigger('cwdrender');
                        bufferExt.rendering = !1;
                        wrapperRepaint(!0)
                    }
                    if (!bufferExt.rendering && buffer.length) {
                        if ((chk = (wrapper.height() + wrapper.scrollTop() + fm.options.showThreshold + bufferExt.row) - (bufferExt.renderd * bufferExt.hpi)) > 0) {
                            bufferExt.rendering = !0;
                            fm.lazy(function () {
                                go(chk);
                                bufferExt.rendering = !1
                            })
                        } else {
                            !fm.enabled() && resize()
                        }
                    } else {
                        resize()
                    }
                }, tableHeader = null, cssSticky = fm.UA.CSS.positionSticky && fm.UA.CSS.widthMaxContent,
                fixTableHeader = function (optsArg) {
                    thHeight = 0;
                    if (!options.listView.fixedHeader) {
                        return
                    }
                    var setPos = function () {
                            var val, pos;
                            pos = (fm.direction === 'ltr') ? 'left' : 'right';
                            val = ((fm.direction === 'ltr') ? wrapper.scrollLeft() : table.outerWidth(!0) - wrapper.width() - wrapper.scrollLeft()) * -1;
                            if (base.css(pos) !== val) {
                                base.css(pos, val)
                            }
                        }, opts = optsArg || {}, cnt, base, table, htable, thead, tbody, hheight, htr, btr, htd, btd, htw,
                        btw, init;
                    tbody = cwd.find('tbody');
                    btr = tbody.children('tr:first');
                    if (btr.length && btr.is(':visible')) {
                        table = tbody.parent();
                        if (!tableHeader) {
                            init = !0;
                            tbody.addClass('elfinder-cwd-fixheader');
                            thead = cwd.find('thead').attr('id', fm.namespace + '-cwd-thead');
                            htr = thead.children('tr:first');
                            hheight = htr.outerHeight(!0);
                            cwd.css('margin-top', hheight - parseInt(table.css('padding-top')));
                            if (cssSticky) {
                                tableHeader = $('<div class="elfinder-table-header-sticky"/>').addClass(cwd.attr('class')).append($('<table/>').append(thead));
                                cwd.after(tableHeader);
                                wrapper.on('resize.fixheader', function (e) {
                                    e.stopPropagation();
                                    fixTableHeader({fitWidth: !0})
                                })
                            } else {
                                base = $('<div/>').addClass(cwd.attr('class')).append($('<table/>').append(thead));
                                tableHeader = $('<div/>').addClass(wrapper.attr('class') + ' elfinder-cwd-fixheader').removeClass('ui-droppable native-droppable').css(wrapper.position()).css({
                                    height: hheight,
                                    width: cwd.outerWidth()
                                }).append(base);
                                if (fm.direction === 'rtl') {
                                    tableHeader.css('left', (wrapper.data('width') - wrapper.width()) + 'px')
                                }
                                setPos();
                                wrapper.after(tableHeader).on('scroll.fixheader resize.fixheader', function (e) {
                                    setPos();
                                    if (e.type === 'resize') {
                                        e.stopPropagation();
                                        tableHeader.css(wrapper.position());
                                        wrapper.data('width', wrapper.css('overflow', 'hidden').width());
                                        wrapper.css('overflow', 'auto');
                                        fixTableHeader()
                                    }
                                })
                            }
                        } else {
                            thead = $('#' + fm.namespace + '-cwd-thead');
                            htr = thead.children('tr:first')
                        }
                        if (init || opts.fitWidth || Math.abs(btr.outerWidth() - htr.outerWidth()) > 2) {
                            cnt = customCols.length + 1;
                            for (var i = 0; i < cnt; i++) {
                                htd = htr.children('td:eq(' + i + ')');
                                btd = btr.children('td:eq(' + i + ')');
                                htw = htd.width();
                                btw = btd.width();
                                if (typeof htd.data('delta') === 'undefined') {
                                    htd.data('delta', (htd.outerWidth() - htw) - (btd.outerWidth() - btw))
                                }
                                btw -= htd.data('delta');
                                if (!init && !opts.fitWidth && htw === btw) {
                                    break
                                }
                                htd.css('width', btw + 'px')
                            }
                        }
                        if (!cssSticky) {
                            tableHeader.data('widthTimer') && cancelAnimationFrame(tableHeader.data('widthTimer'));
                            tableHeader.data('widthTimer', requestAnimationFrame(function () {
                                if (tableHeader) {
                                    tableHeader.css('width', mBoard.width() + 'px');
                                    if (fm.direction === 'rtl') {
                                        tableHeader.css('left', (wrapper.data('width') - wrapper.width()) + 'px')
                                    }
                                }
                            }))
                        }
                        thHeight = thead.height()
                    }
                }, setColwidth = function () {
                    if (list && colWidth) {
                        var cl = 'elfinder-cwd-colwidth', first = cwd.find('tr[id]:first'), former;
                        if (!first.hasClass(cl)) {
                            former = cwd.find('tr.' + cl);
                            former.removeClass(cl).find('td').css('width', '');
                            first.addClass(cl);
                            cwd.find('table:first').css('table-layout', 'fixed');
                            $.each($.merge(['name'], customCols), function (i, k) {
                                var w = colWidth[k] || first.find('td.elfinder-col-' + k).width();
                                first.find('td.elfinder-col-' + k).width(w)
                            })
                        }
                    }
                }, droppable = Object.assign({}, fm.droppable, {
                    over: function (e, ui) {
                        var dst = $(this), helper = ui.helper, ctr = (e.shiftKey || e.ctrlKey || e.metaKey), hash, status,
                            inParent;
                        e.stopPropagation();
                        helper.data('dropover', helper.data('dropover') + 1);
                        dst.data('dropover', !0);
                        helper.removeClass('elfinder-drag-helper-move elfinder-drag-helper-plus');
                        if (helper.data('namespace') !== fm.namespace || !fm.insideWorkzone(e.pageX, e.pageY)) {
                            dst.removeClass(clDropActive);
                            return
                        }
                        if (dst.hasClass(fm.res(c, 'cwdfile'))) {
                            hash = fm.cwdId2Hash(dst.attr('id'));
                            dst.data('dropover', hash)
                        } else {
                            hash = fm.cwd().hash;
                            fm.cwd().write && dst.data('dropover', hash)
                        }
                        inParent = (fm.file(helper.data('files')[0]).phash === hash);
                        if (dst.data('dropover') === hash) {
                            $.each(helper.data('files'), function (i, h) {
                                if (h === hash || (inParent && !ctr && !helper.hasClass('elfinder-drag-helper-plus'))) {
                                    dst.removeClass(clDropActive);
                                    return !1
                                }
                            })
                        } else {
                            dst.removeClass(clDropActive)
                        }
                        if (helper.data('locked') || inParent) {
                            status = 'elfinder-drag-helper-plus'
                        } else {
                            status = 'elfinder-drag-helper-move';
                            if (ctr) {
                                status += ' elfinder-drag-helper-plus'
                            }
                        }
                        dst.hasClass(clDropActive) && helper.addClass(status);
                        requestAnimationFrame(function () {
                            dst.hasClass(clDropActive) && helper.addClass(status)
                        })
                    }, out: function (e, ui) {
                        var helper = ui.helper;
                        e.stopPropagation();
                        helper.removeClass('elfinder-drag-helper-move elfinder-drag-helper-plus').data('dropover', Math.max(helper.data('dropover') - 1, 0));
                        $(this).removeData('dropover').removeClass(clDropActive)
                    }, deactivate: function () {
                        $(this).removeData('dropover').removeClass(clDropActive)
                    }, drop: function (e, ui) {
                        unselectAll({notrigger: !0});
                        fm.droppable.drop.call(this, e, ui)
                    }
                }), makeDroppable = function (place) {
                    place = place ? place : (list ? cwd.find('tbody') : cwd);
                    var targets = place.children('.directory:not(.' + clDroppable + ',.elfinder-na,.elfinder-ro)');
                    if (fm.isCommandEnabled('paste')) {
                        targets.droppable(droppable)
                    }
                    if (fm.isCommandEnabled('upload')) {
                        targets.addClass('native-droppable')
                    }
                    place.children('.isroot').each(function (i, n) {
                        var $n = $(n), hash = fm.cwdId2Hash(n.id);
                        if (fm.isCommandEnabled('paste', hash)) {
                            if (!$n.hasClass(clDroppable + ',elfinder-na,elfinder-ro')) {
                                $n.droppable(droppable)
                            }
                        } else {
                            if ($n.hasClass(clDroppable)) {
                                $n.droppable('destroy')
                            }
                        }
                        if (fm.isCommandEnabled('upload', hash)) {
                            if (!$n.hasClass('native-droppable,elfinder-na,elfinder-ro')) {
                                $n.addClass('native-droppable')
                            }
                        } else {
                            if ($n.hasClass('native-droppable')) {
                                $n.removeClass('native-droppable')
                            }
                        }
                    })
                }, attachThumbnails = function (tmbs, reload) {
                    var attach = function (node, tmb) {
                        $('<img/>').on('load', function () {
                            node.find('.elfinder-cwd-icon').addClass(tmb.className).css('background-image', "url('" + tmb.url + "')")
                        }).attr('src', tmb.url)
                    }, chk = function (hash, tmb) {
                        var node = fm.cwdHash2Elm(hash), file, tmbObj, reloads = [];
                        if (node.length) {
                            if (tmb != '1') {
                                file = fm.file(hash);
                                if (file.tmb !== tmb) {
                                    file.tmb = tmb
                                }
                                tmbObj = fm.tmb(file);
                                if (reload) {
                                    node.find('.elfinder-cwd-icon').addClass(tmbObj.className).css('background-image', "url('" + tmbObj.url + "')")
                                } else {
                                    attach(node, tmbObj)
                                }
                                delete bufferExt.attachTmbs[hash]
                            } else {
                                if (reload) {
                                    loadThumbnails([hash])
                                } else if (!bufferExt.tmbLoading[hash]) {
                                    bufferExt.getTmbs.push(hash)
                                }
                            }
                        }
                    };
                    if ($.isPlainObject(tmbs) && Object.keys(tmbs).length) {
                        Object.assign(bufferExt.attachTmbs, tmbs);
                        $.each(tmbs, chk);
                        if (!reload && bufferExt.getTmbs.length && !Object.keys(bufferExt.tmbLoading).length) {
                            loadThumbnails()
                        }
                    }
                }, loadThumbnails = function (reloads) {
                    var tmbs = [], reload = !1;
                    if (fm.oldAPI) {
                        fm.request({data: {cmd: 'tmb', current: fm.cwd().hash}, preventFail: !0}).done(function (data) {
                            if (data.images && Object.keys(data.images).length) {
                                attachThumbnails(data.images)
                            }
                            if (data.tmb) {
                                loadThumbnails()
                            }
                        });
                        return
                    }
                    if (reloads) {
                        reload = !0;
                        tmbs = reloads.splice(0, tmbNum)
                    } else {
                        tmbs = bufferExt.getTmbs.splice(0, tmbNum)
                    }
                    if (tmbs.length) {
                        if (reload || inViewHashes[tmbs[0]] || inViewHashes[tmbs[tmbs.length - 1]]) {
                            $.each(tmbs, function (i, h) {
                                bufferExt.tmbLoading[h] = !0
                            });
                            fm.request({data: {cmd: 'tmb', targets: tmbs}, preventFail: !0}).done(function (data) {
                                var errs = [], resLen;
                                if (data.images) {
                                    if (resLen = Object.keys(data.images).length) {
                                        if (resLen < tmbs.length) {
                                            $.each(tmbs, function (i, h) {
                                                if (!data.images[h]) {
                                                    errs.push(h)
                                                }
                                            })
                                        }
                                        attachThumbnails(data.images, reload)
                                    } else {
                                        errs = tmbs
                                    }
                                    if (errs.length) {
                                        $.each(errs, function (i, h) {
                                            delete bufferExt.attachTmbs[h]
                                        })
                                    }
                                }
                                if (reload) {
                                    if (reloads.length) {
                                        loadThumbnails(reloads)
                                    }
                                }
                            }).always(function () {
                                bufferExt.tmbLoading = {};
                                if (!reload && bufferExt.getTmbs.length) {
                                    loadThumbnails()
                                }
                            })
                        }
                    }
                }, add = function (files, mode) {
                    var place = list ? cwd.find('tbody') : cwd, l = files.length, atmb = {}, findNode = function (file) {
                            var pointer = cwd.find('[id]:first'), file2;
                            while (pointer.length) {
                                file2 = fm.file(fm.cwdId2Hash(pointer.attr('id')));
                                if (!pointer.hasClass('elfinder-cwd-parent') && file2 && fm.compare(file, file2) < 0) {
                                    return pointer
                                }
                                pointer = pointer.next('[id]')
                            }
                        }, findIndex = function (file) {
                            var l = buffer.length, i;
                            for (i = 0; i < l; i++) {
                                if (fm.compare(file, buffer[i]) < 0) {
                                    return i
                                }
                            }
                            return l || -1
                        }, docFlag = $.htmlPrefilter ? !0 : !1,
                        tempDom = docFlag ? $(document.createDocumentFragment()) : $('<div/>'), file, hash, node, nodes,
                        ndx, stmb;
                    if (l > showFiles) {
                        content();
                        selectedFiles = fm.arrayFlip($.map(files, function (f) {
                            return f.hash
                        }), !0);
                        trigger()
                    } else {
                        l && wz.removeClass('elfinder-cwd-wrapper-empty');
                        stmb = (fm.option('tmbUrl') === 'self');
                        while (l--) {
                            file = files[l];
                            hash = file.hash;
                            if (fm.cwdHash2Elm(hash).length) {
                                continue
                            }
                            if ((node = findNode(file)) && !node.length) {
                                node = null
                            }
                            if (!node && (ndx = findIndex(file)) >= 0) {
                                buffer.splice(ndx, 0, file)
                            } else {
                                tempDom.empty().append(itemhtml(file));
                                (file.mime === 'directory') && !mobile && makeDroppable(tempDom);
                                nodes = docFlag ? tempDom : tempDom.children();
                                if (node) {
                                    node.before(nodes)
                                } else {
                                    place.append(nodes)
                                }
                                ++bufferExt.renderd
                            }
                            if (fm.cwdHash2Elm(hash).length) {
                                if ((file.tmb && (file.tmb != 1 || file.size > 0)) || (stmb && file.mime.indexOf('image/') === 0)) {
                                    atmb[hash] = file.tmb || 'self'
                                }
                            }
                        }
                        if (list) {
                            setColwidth();
                            fixTableHeader({fitWidth: !colWidth})
                        }
                        bottomMarkerShow(place);
                        if (Object.keys(atmb).length) {
                            Object.assign(bufferExt.attachTmbs, atmb)
                        }
                    }
                }, remove = function (files) {
                    var l = files.length, inSearch = fm.searchStatus.state > 1,
                        curCmd = fm.getCommand(fm.currentReqCmd) || {}, hash, n, ndx, found;
                    if (!fm.cwd().hash && !curCmd.noChangeDirOnRemovedCwd) {
                        $.each(cwdParents.reverse(), function (i, h) {
                            if (fm.file(h)) {
                                found = !0;
                                fm.one(fm.currentReqCmd + 'done', function () {
                                    !fm.cwd().hash && fm.exec('open', h)
                                });
                                return !1
                            }
                        });
                        !found && !fm.cwd().hash && fm.exec('open', fm.roots[Object.keys(fm.roots)[0]]);
                        return
                    }
                    while (l--) {
                        hash = files[l];
                        if ((n = fm.cwdHash2Elm(hash)).length) {
                            try {
                                n.remove();
                                --bufferExt.renderd
                            } catch (e) {
                                fm.debug('error', e)
                            }
                        } else if ((ndx = index(hash)) !== -1) {
                            buffer.splice(ndx, 1)
                        }
                        selectedFiles[hash] && delete selectedFiles[hash];
                        if (inSearch) {
                            if ((ndx = $.inArray(hash, cwdHashes)) !== -1) {
                                cwdHashes.splice(ndx, 1)
                            }
                        }
                    }
                    inSearch && fm.trigger('cwdhasheschange', cwdHashes);
                    if (list) {
                        setColwidth();
                        fixTableHeader({fitWidth: !colWidth})
                    }
                }, customColsNameBuild = function () {
                    var name = '', customColsName = '';
                    for (var i = 0; i < customCols.length; i++) {
                        name = fm.getColumnName(customCols[i]);
                        customColsName += '<td class="elfinder-cwd-view-th-' + customCols[i] + ' sortable-item">' + name + '</td>'
                    }
                    return customColsName
                }, setItemBoxSize = function (boxSize) {
                    var place, elm;
                    if (!boxSize.height) {
                        place = (list ? cwd.find('tbody') : cwd);
                        elm = place.find(list ? 'tr:first' : '[id]:first');
                        boxSize.height = elm.outerHeight(!0);
                        if (!list) {
                            boxSize.width = elm.outerWidth(!0)
                        }
                    }
                }, bottomMarkerShow = function (cur, cnt) {
                    var place = cur || (list ? cwd.find('tbody') : cwd), boxSize = itemBoxSize[fm.viewType], col = 1, row;
                    if (buffer.length > 0) {
                        if (!bufferExt.hpi) {
                            setItemBoxSize(boxSize);
                            if (!list) {
                                col = Math.floor(place.width() / boxSize.width);
                                bufferExt.row = boxSize.height;
                                bufferExt.hpi = bufferExt.row / col
                            } else {
                                bufferExt.row = bufferExt.hpi = boxSize.height
                            }
                        } else if (!list) {
                            col = Math.floor(place.width() / boxSize.width)
                        }
                        row = Math.ceil((buffer.length + (cnt || 0)) / col);
                        if (list && tableHeader) {
                            ++row
                        }
                        bottomMarker.css({top: (bufferExt.row * row) + 'px'}).show()
                    }
                }, wrapperContextMenu = {
                    contextmenu: function (e) {
                        e.preventDefault();
                        if (cwd.data('longtap') !== void(0)) {
                            e.stopPropagation();
                            return
                        }
                        fm.trigger('contextmenu', {'type': 'cwd', 'targets': [fm.cwd().hash], 'x': e.pageX, 'y': e.pageY})
                    }, touchstart: function (e) {
                        if (e.originalEvent.touches.length > 1) {
                            return
                        }
                        if (cwd.data('longtap') !== !1) {
                            wrapper.data('touching', {
                                x: e.originalEvent.touches[0].pageX,
                                y: e.originalEvent.touches[0].pageY
                            });
                            cwd.data('tmlongtap', setTimeout(function () {
                                cwd.data('longtap', !0);
                                fm.trigger('contextmenu', {
                                    'type': 'cwd',
                                    'targets': [fm.cwd().hash],
                                    'x': wrapper.data('touching').x,
                                    'y': wrapper.data('touching').y
                                })
                            }, 500))
                        }
                        cwd.data('longtap', null)
                    }, touchend: function (e) {
                        if (e.type === 'touchmove') {
                            if (!wrapper.data('touching') || (Math.abs(wrapper.data('touching').x - e.originalEvent.touches[0].pageX) + Math.abs(wrapper.data('touching').y - e.originalEvent.touches[0].pageY)) > 4) {
                                wrapper.data('touching', null)
                            }
                        } else {
                            setTimeout(function () {
                                cwd.removeData('longtap')
                            }, 80)
                        }
                        clearTimeout(cwd.data('tmlongtap'))
                    }, click: function (e) {
                        if (cwd.data('longtap')) {
                            e.preventDefault();
                            e.stopPropagation()
                        }
                    }
                }, content = function () {
                    fm.lazy(function () {
                        var phash, emptyMethod, thtr;
                        wz.append(selectAllCheckbox).removeClass('elfinder-cwd-wrapper-empty elfinder-search-result elfinder-incsearch-result elfinder-letsearch-result');
                        if (fm.searchStatus.state > 1 || fm.searchStatus.ininc) {
                            wz.addClass('elfinder-search-result' + (fm.searchStatus.ininc ? ' elfinder-' + (query.substr(0, 1) === '/' ? 'let' : 'inc') + 'search-result' : ''))
                        }
                        bufferExt.attachThumbJob && bufferExt.attachThumbJob._abort();
                        cwd.data('selectable') && cwd.selectable('disable').selectable('destroy').removeData('selectable');
                        fm.trigger('cwdinit');
                        selectedNext = $();
                        try {
                            cwd.empty()
                        } catch (e) {
                            cwd.html('')
                        }
                        if (tableHeader) {
                            wrapper.off('scroll.fixheader resize.fixheader');
                            tableHeader.remove();
                            tableHeader = null
                        }
                        cwd.removeClass('elfinder-cwd-view-icons elfinder-cwd-view-list').addClass('elfinder-cwd-view-' + (list ? 'list' : 'icons')).attr('style', '').css('height', 'auto');
                        bottomMarker.hide();
                        wrapper[list ? 'addClass' : 'removeClass']('elfinder-cwd-wrapper-list')._padding = parseInt(wrapper.css('padding-top')) + parseInt(wrapper.css('padding-bottom'));
                        if (fm.UA.iOS) {
                            wrapper.removeClass('overflow-scrolling-touch').addClass('overflow-scrolling-touch')
                        }
                        if (list) {
                            cwd.html('<table><thead/><tbody/></table>');
                            thtr = $('<tr class="ui-state-default"><td class="elfinder-cwd-view-th-name">' + fm.getColumnName('name') + '</td>' + customColsNameBuild() + '</tr>');
                            cwd.find('thead').hide().append(thtr).find('td:first').append(selectAllCheckbox);
                            if ($.fn.sortable) {
                                thtr.addClass('touch-punch touch-punch-keep-default').sortable({
                                    axis: 'x', distance: 8, items: '> .sortable-item', start: function (e, ui) {
                                        $(ui.item[0]).data('dragging', !0);
                                        ui.placeholder.width(ui.helper.removeClass('ui-state-hover').width()).removeClass('ui-state-active').addClass('ui-state-hover').css('visibility', 'visible')
                                    }, update: function (e, ui) {
                                        var target = $(ui.item[0]).attr('class').split(' ')[0].replace('elfinder-cwd-view-th-', ''),
                                            prev, done;
                                        customCols = $.map($(this).children(), function (n) {
                                            var name = $(n).attr('class').split(' ')[0].replace('elfinder-cwd-view-th-', '');
                                            if (!done) {
                                                if (target === name) {
                                                    done = !0
                                                } else {
                                                    prev = name
                                                }
                                            }
                                            return (name === 'name') ? null : name
                                        });
                                        templates.row = makeTemplateRow();
                                        fm.storage('cwdCols', customCols);
                                        prev = '.elfinder-col-' + prev + ':first';
                                        target = '.elfinder-col-' + target + ':first';
                                        fm.lazy(function () {
                                            cwd.find('tbody tr').each(function () {
                                                var $this = $(this);
                                                $this.children(prev).after($this.children(target))
                                            })
                                        })
                                    }, stop: function (e, ui) {
                                        setTimeout(function () {
                                            $(ui.item[0]).removeData('dragging')
                                        }, 100)
                                    }
                                })
                            }
                            thtr.find('td').addClass('touch-punch').resizable({
                                handles: fm.direction === 'ltr' ? 'e' : 'w',
                                start: function (e, ui) {
                                    var target = cwd.find('td.elfinder-col-' + ui.element.attr('class').split(' ')[0].replace('elfinder-cwd-view-th-', '') + ':first');
                                    ui.element.data('dragging', !0).data('resizeTarget', target).data('targetWidth', target.width());
                                    colResizing = !0;
                                    if (cwd.find('table').css('table-layout') !== 'fixed') {
                                        cwd.find('tbody tr:first td').each(function () {
                                            $(this).width($(this).width())
                                        });
                                        cwd.find('table').css('table-layout', 'fixed')
                                    }
                                },
                                resize: function (e, ui) {
                                    ui.element.data('resizeTarget').width(ui.element.data('targetWidth') - (ui.originalSize.width - ui.size.width))
                                },
                                stop: function (e, ui) {
                                    colResizing = !1;
                                    fixTableHeader({fitWidth: !0});
                                    colWidth = {};
                                    cwd.find('tbody tr:first td').each(function () {
                                        var name = $(this).attr('class').split(' ')[0].replace('elfinder-col-', '');
                                        colWidth[name] = $(this).width()
                                    });
                                    fm.storage('cwdColWidth', colWidth);
                                    setTimeout(function () {
                                        ui.element.removeData('dragging')
                                    }, 100)
                                }
                            }).find('.ui-resizable-handle').addClass('ui-icon ui-icon-grip-dotted-vertical')
                        }
                        buffer = $.map(incHashes || cwdHashes, function (hash) {
                            return fm.file(hash) || null
                        });
                        buffer = fm.sortFiles(buffer);
                        if (incHashes) {
                            incHashes = $.map(buffer, function (f) {
                                return f.hash
                            })
                        } else {
                            cwdHashes = $.map(buffer, function (f) {
                                return f.hash
                            })
                        }
                        bufferExt = {renderd: 0, attachTmbs: {}, getTmbs: [], tmbLoading: {}, lazyOpts: {tm: 0}};
                        wz[(buffer.length < 1) ? 'addClass' : 'removeClass']('elfinder-cwd-wrapper-empty');
                        wrapper.off(scrollEvent, render).on(scrollEvent, render).trigger(scrollEvent);
                        if (!fm.cwd().write) {
                            wrapper.removeClass('native-droppable').droppable('disable').removeClass('ui-state-disabled')
                        } else {
                            wrapper[fm.isCommandEnabled('upload') ? 'addClass' : 'removeClass']('native-droppable');
                            wrapper.droppable(fm.isCommandEnabled('paste') ? 'enable' : 'disable')
                        }
                    })
                },
                cwd = $(this).addClass('ui-helper-clearfix elfinder-cwd').attr('unselectable', 'on').on('click.' + fm.namespace, fileSelector, function (e) {
                    var p = this.id ? $(this) : $(this).parents('[id]:first'), tgt = $(e.target), prev, next, pl, nl,
                        sib;
                    if (selectCheckbox && (tgt.is('input:checkbox.' + clSelChk) || tgt.hasClass('elfinder-cwd-select'))) {
                        e.stopPropagation();
                        e.preventDefault();
                        p.trigger(p.hasClass(clSelected) ? evtUnselect : evtSelect);
                        trigger();
                        requestAnimationFrame(function () {
                            tgt.prop('checked', p.hasClass(clSelected))
                        });
                        return
                    }
                    if (cwd.data('longtap') || tgt.hasClass('elfinder-cwd-nonselect')) {
                        e.stopPropagation();
                        return
                    }
                    if (!curClickId) {
                        curClickId = p.attr('id');
                        setTimeout(function () {
                            curClickId = ''
                        }, 500)
                    }
                    if (e.shiftKey) {
                        prev = p.prevAll(lastSelect || '.' + clSelected + ':first');
                        next = p.nextAll(lastSelect || '.' + clSelected + ':first');
                        pl = prev.length;
                        nl = next.length
                    }
                    if (e.shiftKey && (pl || nl)) {
                        sib = pl ? p.prevUntil('#' + prev.attr('id')) : p.nextUntil('#' + next.attr('id'));
                        sib.add(p).trigger(evtSelect)
                    } else if (e.ctrlKey || e.metaKey) {
                        p.trigger(p.hasClass(clSelected) ? evtUnselect : evtSelect)
                    } else {
                        if (wrapper.data('touching') && p.hasClass(clSelected)) {
                            wrapper.data('touching', null);
                            fm.dblclick({file: fm.cwdId2Hash(this.id)});
                            return
                        } else {
                            unselectAll({notrigger: !0});
                            p.trigger(evtSelect)
                        }
                    }
                    trigger()
                }).on('dblclick.' + fm.namespace, fileSelector, function (e) {
                    if (curClickId) {
                        var hash = fm.cwdId2Hash(curClickId);
                        e.stopPropagation();
                        if (this.id !== curClickId) {
                            $(this).trigger(evtUnselect);
                            $('#' + curClickId).trigger(evtSelect);
                            trigger()
                        }
                        fm.dblclick({file: hash})
                    }
                }).on('touchstart.' + fm.namespace, fileSelector, function (e) {
                    if (e.originalEvent.touches.length > 1) {
                        return
                    }
                    var p = this.id ? $(this) : $(this).parents('[id]:first'), tgt = $(e.target),
                        nodeName = e.target.nodeName, sel;
                    if ((nodeName === 'INPUT' && e.target.type === 'text') || nodeName === 'TEXTAREA' || tgt.hasClass('elfinder-cwd-nonselect')) {
                        e.stopPropagation();
                        return
                    }
                    if (p.find('input:text,textarea').length) {
                        e.stopPropagation();
                        e.preventDefault();
                        return
                    }
                    wrapper.data('touching', {
                        x: e.originalEvent.touches[0].pageX,
                        y: e.originalEvent.touches[0].pageY
                    });
                    if (selectCheckbox && (tgt.is('input:checkbox.' + clSelChk) || tgt.hasClass('elfinder-cwd-select'))) {
                        return
                    }
                    sel = p.prevAll('.' + clSelected + ':first').length + p.nextAll('.' + clSelected + ':first').length;
                    cwd.data('longtap', null);
                    if (Object.keys(selectedFiles).length || (list && e.target.nodeName !== 'TD') || (!list && this !== e.target)) {
                        cwd.data('longtap', !1);
                        p.addClass(clHover);
                        p.data('tmlongtap', setTimeout(function () {
                            cwd.data('longtap', !0);
                            p.trigger(evtSelect);
                            trigger();
                            fm.trigger('contextmenu', {
                                'type': 'files',
                                'targets': fm.selected(),
                                'x': e.originalEvent.touches[0].pageX,
                                'y': e.originalEvent.touches[0].pageY
                            })
                        }, 500))
                    }
                }).on('touchmove.' + fm.namespace + ' touchend.' + fm.namespace, fileSelector, function (e) {
                    var tgt = $(e.target), p;
                    if (selectCheckbox && (tgt.is('input:checkbox.' + clSelChk) || tgt.hasClass('elfinder-cwd-select'))) {
                        return
                    }
                    if (e.target.nodeName == 'INPUT' || e.target.nodeName == 'TEXTAREA') {
                        e.stopPropagation();
                        return
                    }
                    p = this.id ? $(this) : $(this).parents('[id]:first');
                    clearTimeout(p.data('tmlongtap'));
                    if (e.type === 'touchmove') {
                        wrapper.data('touching', null);
                        p.removeClass(clHover)
                    } else {
                        if (wrapper.data('touching') && !cwd.data('longtap') && p.hasClass(clSelected)) {
                            e.preventDefault();
                            wrapper.data('touching', null);
                            fm.dblclick({file: fm.cwdId2Hash(this.id)})
                        }
                        setTimeout(function () {
                            cwd.removeData('longtap')
                        }, 80)
                    }
                }).on('mouseenter.' + fm.namespace, fileSelector, function (e) {
                    if (scrolling) {
                        return
                    }
                    var $this = $(this), helper = null;
                    if (!mobile && !$this.data('dragRegisted') && !$this.hasClass(clTmp) && !$this.hasClass(clDraggable) && !$this.hasClass(clDisabled)) {
                        $this.data('dragRegisted', !0);
                        if (!fm.isCommandEnabled('copy', fm.searchStatus.state > 1 || $this.hasClass('isroot') ? fm.cwdId2Hash($this.attr('id')) : void 0)) {
                            return
                        }
                        $this.on('mousedown', function (e) {
                            var metaKey = options.metakeyDragout && !fm.UA.IE && (e.shiftKey || e.altKey), disable = !1;
                            if (metaKey && cwd.data('selectable')) {
                                cwd.selectable('disable').selectable('destroy').removeData('selectable');
                                requestAnimationFrame(function () {
                                    cwd.selectable(selectableOption).selectable('option', {disabled: !1}).selectable('refresh').data('selectable', !0)
                                })
                            }
                            $this.removeClass('ui-state-disabled');
                            if (metaKey) {
                                $this.draggable('option', 'disabled', !0).attr('draggable', 'true')
                            } else {
                                if (!$this.hasClass(clSelected)) {
                                    if (list) {
                                        disable = $(e.target).closest('span,tr').is('tr')
                                    } else {
                                        disable = $(e.target).hasClass('elfinder-cwd-file')
                                    }
                                }
                                if (disable) {
                                    $this.draggable('option', 'disabled', !0)
                                } else {
                                    $this.draggable('option', 'disabled', !1).removeAttr('draggable').draggable('option', 'cursorAt', {
                                        left: 50 - parseInt($(e.currentTarget).css('margin-left')),
                                        top: 47
                                    })
                                }
                            }
                        }).on('dragstart', function (e) {
                            var dt = e.dataTransfer || e.originalEvent.dataTransfer || null;
                            helper = null;
                            if (dt && !fm.UA.IE) {
                                var p = this.id ? $(this) : $(this).parents('[id]:first'), elm = $('<span>'), url = '',
                                    durl = null, murl = null, files = [], icon = function (f) {
                                        var mime = f.mime, i, tmb = fm.tmb(f);
                                        i = '<div class="elfinder-cwd-icon elfinder-cwd-icon-drag ' + fm.mime2class(mime) + ' ui-corner-all"/>';
                                        if (tmb) {
                                            i = $(i).addClass(tmb.className).css('background-image', "url('" + tmb.url + "')").get(0).outerHTML
                                        }
                                        return i
                                    }, l, geturl = [];
                                p.trigger(evtSelect);
                                trigger();
                                $.each(selectedFiles, function (v) {
                                    var file = fm.file(v), furl = file.url;
                                    if (file && file.mime !== 'directory') {
                                        if (!furl) {
                                            furl = fm.url(file.hash)
                                        } else if (furl == '1') {
                                            geturl.push(v);
                                            return !0
                                        }
                                        if (furl) {
                                            furl = fm.convAbsUrl(furl);
                                            files.push(v);
                                            $('<a>').attr('href', furl).text(furl).appendTo(elm);
                                            url += furl + "\n";
                                            if (!durl) {
                                                durl = file.mime + ':' + file.name + ':' + furl
                                            }
                                            if (!murl) {
                                                murl = furl + "\n" + file.name
                                            }
                                        }
                                    }
                                });
                                if (geturl.length) {
                                    $.each(geturl, function (i, v) {
                                        var rfile = fm.file(v);
                                        rfile.url = '';
                                        fm.request({
                                            data: {cmd: 'url', target: v},
                                            notify: {type: 'url', cnt: 1},
                                            preventDefault: !0
                                        }).always(function (data) {
                                            rfile.url = data.url ? data.url : '1'
                                        })
                                    });
                                    return !1
                                } else if (url) {
                                    if (dt.setDragImage) {
                                        helper = $('<div class="elfinder-drag-helper html5-native"></div>').append(icon(fm.file(files[0]))).appendTo($(document.body));
                                        if ((l = files.length) > 1) {
                                            helper.append(icon(fm.file(files[l - 1])) + '<span class="elfinder-drag-num">' + l + '</span>')
                                        }
                                        dt.setDragImage(helper.get(0), 50, 47)
                                    }
                                    dt.effectAllowed = 'copyLink';
                                    dt.setData('DownloadURL', durl);
                                    dt.setData('text/x-moz-url', murl);
                                    dt.setData('text/uri-list', url);
                                    dt.setData('text/plain', url);
                                    dt.setData('text/html', elm.html());
                                    dt.setData('elfinderfrom', window.location.href + fm.cwd().hash);
                                    dt.setData('elfinderfrom:' + dt.getData('elfinderfrom'), '')
                                } else {
                                    return !1
                                }
                            }
                        }).on('dragend', function (e) {
                            unselectAll({notrigger: !0});
                            helper && helper.remove()
                        }).draggable(fm.draggable)
                    }
                }).on(evtSelect, fileSelector, function (e) {
                    var $this = $(this), id = fm.cwdId2Hash($this.attr('id'));
                    if (!selectLock && !$this.hasClass(clDisabled)) {
                        lastSelect = '#' + this.id;
                        $this.addClass(clSelected).children().addClass(clHover).find('input:checkbox.' + clSelChk).prop('checked', !0);
                        if (!selectedFiles[id]) {
                            selectedFiles[id] = !0
                        }
                        selectedNext = cwd.find('[id].' + clSelected + ':last').next()
                    }
                }).on(evtUnselect, fileSelector, function (e) {
                    var $this = $(this), id = fm.cwdId2Hash($this.attr('id'));
                    if (!selectLock) {
                        $this.removeClass(clSelected).children().removeClass(clHover).find('input:checkbox.' + clSelChk).prop('checked', !1);
                        if (cwd.hasClass('elfinder-cwd-allselected')) {
                            selectCheckbox && selectAllCheckbox.children('input').prop('checked', !1);
                            cwd.removeClass('elfinder-cwd-allselected')
                        }
                        selectedFiles[id] && delete selectedFiles[id]
                    }
                }).on(evtDisable, fileSelector, function () {
                    var $this = $(this).removeClass(clHover + ' ' + clSelected).addClass(clDisabled),
                        child = $this.children(),
                        target = (list ? $this : child.find('div.elfinder-cwd-file-wrapper,div.elfinder-cwd-filename'));
                    child.removeClass(clHover + ' ' + clSelected);
                    $this.hasClass(clDroppable) && $this.droppable('disable');
                    target.hasClass(clDraggable) && target.draggable('disable')
                }).on(evtEnable, fileSelector, function () {
                    var $this = $(this).removeClass(clDisabled),
                        target = list ? $this : $this.children('div.elfinder-cwd-file-wrapper,div.elfinder-cwd-filename');
                    $this.hasClass(clDroppable) && $this.droppable('enable');
                    target.hasClass(clDraggable) && target.draggable('enable')
                }).on('scrolltoview', fileSelector, function (e, data) {
                    scrollToView($(this), (data && typeof data.blink !== 'undefined') ? data.blink : !0)
                }).on('mouseenter.' + fm.namespace + ' mouseleave.' + fm.namespace, fileSelector, function (e) {
                    var enter = (e.type === 'mouseenter');
                    if (enter && (scrolling || fm.UA.Mobile)) {
                        return
                    }
                    fm.trigger('hover', {hash: fm.cwdId2Hash($(this).attr('id')), type: e.type});
                    $(this).toggleClass(clHover, (e.type == 'mouseenter'))
                }).on('mouseenter.' + fm.namespace + ' mouseleave.' + fm.namespace, '.elfinder-cwd-file-wrapper,.elfinder-cwd-filename', function (e) {
                    var enter = (e.type === 'mouseenter');
                    if (enter && scrolling) {
                        return
                    }
                    $(this).closest(fileSelector).children('.elfinder-cwd-file-wrapper,.elfinder-cwd-filename').toggleClass(clActive, (e.type == 'mouseenter'))
                }).on('contextmenu.' + fm.namespace, function (e) {
                    var file = $(e.target).closest(fileSelector);
                    if (file.get(0) === e.target && !selectedFiles[fm.cwdId2Hash(file.get(0).id)]) {
                        return
                    }
                    if (file.find('input:text,textarea').length) {
                        e.stopPropagation();
                        return
                    }
                    if (file.length && (e.target.nodeName != 'TD' || selectedFiles[fm.cwdId2Hash(file.get(0).id)])) {
                        e.stopPropagation();
                        e.preventDefault();
                        if (!file.hasClass(clDisabled) && !wrapper.data('touching')) {
                            if (!file.hasClass(clSelected)) {
                                unselectAll({notrigger: !0});
                                file.trigger(evtSelect);
                                trigger()
                            }
                            fm.trigger('contextmenu', {
                                'type': 'files',
                                'targets': fm.selected(),
                                'x': e.pageX,
                                'y': e.pageY
                            })
                        }
                    }
                }).on('click.' + fm.namespace, function (e) {
                    if (e.target === this && !cwd.data('longtap')) {
                        !e.shiftKey && !e.ctrlKey && !e.metaKey && unselectAll()
                    }
                }).on('create.' + fm.namespace, function (e, f) {
                    var parent = list ? cwd.find('tbody') : cwd, p = parent.find('.elfinder-cwd-parent'),
                        lock = f.move || !1, file = $(itemhtml(f)).addClass(clTmp), selected = fm.selected();
                    if (selected.length) {
                        lock && fm.trigger('lockfiles', {files: selected})
                    } else {
                        unselectAll()
                    }
                    if (p.length) {
                        p.after(file)
                    } else {
                        parent.prepend(file)
                    }
                    setColwidth();
                    wrapper.scrollTop(0).scrollLeft(0)
                }).on('unselectall', unselectAll).on('selectfile', function (e, id) {
                    fm.cwdHash2Elm(id).trigger(evtSelect);
                    trigger()
                }).on('colwidth', function () {
                    if (list) {
                        cwd.find('table').css('table-layout', '').find('td').css('width', '');
                        fixTableHeader({fitWidth: !0});
                        fm.storage('cwdColWidth', colWidth = null)
                    }
                }).on('iconpref', function (e, data) {
                    cwd.removeClass(function (i, cName) {
                        return (cName.match(/\belfinder-cwd-size\S+/g) || []).join(' ')
                    });
                    iconSize = data ? (parseInt(data.size) || 0) : 0;
                    if (!list) {
                        if (iconSize > 0) {
                            cwd.addClass('elfinder-cwd-size' + iconSize)
                        }
                        if (bufferExt.renderd) {
                            requestAnimationFrame(function () {
                                itemBoxSize.icons = {};
                                bufferExt.hpi = null;
                                bottomMarkerShow(cwd, bufferExt.renderd);
                                wrapperRepaint()
                            })
                        }
                    }
                }).on('onwheel' in document ? 'wheel' : 'mousewheel', function (e) {
                    var tm, size, delta;
                    if (!list && ((e.ctrlKey && !e.metaKey) || (!e.ctrlKey && e.metaKey))) {
                        e.stopPropagation();
                        e.preventDefault();
                        tm = cwd.data('wheelTm');
                        if (typeof tm !== 'undefined') {
                            clearTimeout(tm);
                            cwd.data('wheelTm', setTimeout(function () {
                                cwd.removeData('wheelTm')
                            }, 200))
                        } else {
                            cwd.data('wheelTm', !1);
                            size = iconSize || 0;
                            delta = e.originalEvent.deltaY ? e.originalEvent.deltaY : -(e.originalEvent.wheelDelta);
                            if (delta > 0) {
                                if (iconSize > 0) {
                                    size = iconSize - 1
                                }
                            } else {
                                if (iconSize < options.iconsView.sizeMax) {
                                    size = iconSize + 1
                                }
                            }
                            if (size !== iconSize) {
                                fm.storage('iconsize', size);
                                cwd.trigger('iconpref', {size: size})
                            }
                        }
                    }
                }),
                wrapper = $('<div class="elfinder-cwd-wrapper"/>').droppable(Object.assign({}, droppable, {autoDisable: !1})).on('contextmenu.' + fm.namespace, wrapperContextMenu.contextmenu).on('touchstart.' + fm.namespace, wrapperContextMenu.touchstart).on('touchmove.' + fm.namespace + ' touchend.' + fm.namespace, wrapperContextMenu.touchend).on('click.' + fm.namespace, wrapperContextMenu.click).on('scroll.' + fm.namespace, function () {
                    if (!scrolling) {
                        cwd.data('selectable') && cwd.selectable('disable');
                        wrapper.trigger(scrollStartEvent)
                    }
                    scrolling = !0;
                    bufferExt.scrtm && cancelAnimationFrame(bufferExt.scrtm);
                    if (bufferExt.scrtm && Math.abs((bufferExt.scrolltop || 0) - (bufferExt.scrolltop = (this.scrollTop || $(this).scrollTop()))) < 5) {
                        bufferExt.scrtm = 0;
                        wrapper.trigger(scrollEvent)
                    }
                    bufferExt.scrtm = requestAnimationFrame(function () {
                        bufferExt.scrtm = 0;
                        wrapper.trigger(scrollEvent)
                    })
                }).on(scrollEvent, function () {
                    scrolling = !1;
                    wrapperRepaint()
                }),
                bottomMarker = $('<div>&nbsp;</div>').css({position: 'absolute', width: '1px', height: '1px'}).hide(),
                selectAllCheckbox = selectCheckbox ? $('<div class="elfinder-cwd-selectall"><input type="checkbox"/></div>').attr('title', fm.i18n('selectall')).on('touchstart mousedown click', function (e) {
                    e.stopPropagation();
                    e.preventDefault();
                    if ($(this).data('pending') || e.type === 'click') {
                        return !1
                    }
                    selectAllCheckbox.data('pending', !0);
                    if (cwd.hasClass('elfinder-cwd-allselected')) {
                        selectAllCheckbox.find('input').prop('checked', !1);
                        requestAnimationFrame(function () {
                            unselectAll()
                        })
                    } else {
                        selectAll()
                    }
                }) : $(), restm = null, resize = function (init) {
                    var initHeight = function () {
                        if (typeof bufferExt.renderd !== 'undefined') {
                            var h = 0;
                            wrapper.siblings('div.elfinder-panel:visible').each(function () {
                                h += $(this).outerHeight(!0)
                            });
                            wrapper.height(wz.height() - h - wrapper._padding)
                        }
                    };
                    init && initHeight();
                    restm && cancelAnimationFrame(restm);
                    restm = requestAnimationFrame(function () {
                        !init && initHeight();
                        var wph, cwdoh;
                        cwd.css('height', 'auto');
                        wph = wrapper[0].clientHeight - parseInt(wrapper.css('padding-top')) - parseInt(wrapper.css('padding-bottom')) - parseInt(cwd.css('margin-top')), cwdoh = cwd.outerHeight(!0);
                        if (cwdoh < wph) {
                            cwd.height(wph)
                        }
                    });
                    list && !colResizing && (init ? wrapper.trigger('resize.fixheader') : fixTableHeader());
                    wrapperRepaint()
                }, parent = $(this).parent().on('resize', resize),
                wz = parent.children('.elfinder-workzone').append(wrapper.append(this).append(bottomMarker)),
                mBoard = $('<div class="elfinder-cwd-message-board"/>').insertAfter(cwd),
                vExpires = $('<div class="elfinder-cwd-expires" />'), vExpiresTm, showVolumeExpires = function () {
                    var remain, sec, int;
                    vExpiresTm && clearTimeout(vExpiresTm);
                    if (curVolId && fm.volumeExpires[curVolId]) {
                        sec = fm.volumeExpires[curVolId] - ((+new Date()) / 1000);
                        int = (sec % 60) + 0.1;
                        remain = Math.floor(sec / 60);
                        vExpires.html(fm.i18n(['minsLeft', remain])).show();
                        if (remain) {
                            vExpiresTm = setTimeout(showVolumeExpires, int * 1000)
                        }
                    }
                }, itemBoxSize = {icons: {}, list: {}}, hasUiTree, iconSize, curVolId, winScrTm;
            if (!fm.UA.ltIE10) {
                mBoard.append($('<div class="elfinder-cwd-trash" />').html(fm.i18n('volume_Trash'))).append(vExpires)
            }
            replacement = Object.assign(replacement, options.replacement || {});
            try {
                colWidth = fm.storage('cwdColWidth') ? fm.storage('cwdColWidth') : null
            } catch (e) {
                colWidth = null
            }
            fm.bind('columnpref', function (e) {
                var opts = e.data || {};
                if (customCols = fm.storage('cwdCols')) {
                    customCols = $.grep(customCols, function (n) {
                        return (options.listView.columns.indexOf(n) !== -1) ? !0 : !1
                    });
                    if (options.listView.columns.length > customCols.length) {
                        $.each(options.listView.columns, function (i, n) {
                            if (customCols.indexOf(n) === -1) {
                                customCols.push(n)
                            }
                        })
                    }
                } else {
                    customCols = options.listView.columns
                }
                var columnhides = fm.storage('columnhides') || null;
                if (columnhides && Object.keys(columnhides).length)
                    customCols = $.grep(customCols, function (n) {
                        return columnhides[n] ? !1 : !0
                    });
                templates.row = makeTemplateRow();
                list && opts.repaint && content()
            }).trigger('columnpref');
            if (mobile) {
                $('body').on('touchstart touchmove touchend', function (e) {
                })
            }
            selectCheckbox && cwd.addClass('elfinder-has-checkbox');
            $(window).on('scroll.' + fm.namespace, function () {
                winScrTm && cancelAnimationFrame(winScrTm);
                winScrTm = requestAnimationFrame(function () {
                    wrapper.trigger(scrollEvent)
                })
            });
            $(document).on('keydown.' + fm.namespace, function (e) {
                if (e.keyCode == $.ui.keyCode.ESCAPE) {
                    if (!fm.getUI().find('.ui-widget:visible').length) {
                        unselectAll()
                    }
                }
            });
            fm.one('init', function () {
                var style = document.createElement('style'), sheet, node, base, resizeTm, iconSize, i = 0;
                if (document.head) {
                    document.head.appendChild(style);
                    sheet = style.sheet;
                    sheet.insertRule('.elfinder-cwd-wrapper-empty .elfinder-cwd:not(.elfinder-table-header-sticky):after{ content:"' + fm.i18n('emptyFolder') + '" }', i++);
                    sheet.insertRule('.elfinder-cwd-wrapper-empty .native-droppable .elfinder-cwd:not(.elfinder-table-header-sticky):after{ content:"' + fm.i18n('emptyFolder' + (mobile ? 'LTap' : 'Drop')) + '" }', i++);
                    sheet.insertRule('.elfinder-cwd-wrapper-empty .ui-droppable-disabled .elfinder-cwd:not(.elfinder-table-header-sticky):after{ content:"' + fm.i18n('emptyFolder') + '" }', i++);
                    sheet.insertRule('.elfinder-cwd-wrapper-empty.elfinder-search-result .elfinder-cwd:not(.elfinder-table-header-sticky):after{ content:"' + fm.i18n('emptySearch') + '" }', i++);
                    sheet.insertRule('.elfinder-cwd-wrapper-empty.elfinder-search-result.elfinder-incsearch-result .elfinder-cwd:not(.elfinder-table-header-sticky):after{ content:"' + fm.i18n('emptyIncSearch') + '" }', i++);
                    sheet.insertRule('.elfinder-cwd-wrapper-empty.elfinder-search-result.elfinder-letsearch-result .elfinder-cwd:not(.elfinder-table-header-sticky):after{ content:"' + fm.i18n('emptyLetSearch') + '" }', i++)
                }
                if (iconSize = (fm.storage('iconsize') || options.iconsView.size || 0)) {
                    iconSize = Math.min(iconSize, options.iconsView.sizeMax);
                    cwd.trigger('iconpref', {size: iconSize})
                }
                if (!mobile) {
                    fm.one('open', function () {
                        sheet && fm.zIndex && sheet.insertRule('.ui-selectable-helper{z-index:' + fm.zIndex + ';}', i++)
                    });
                    base = $('<div style="position:absolute"/>');
                    node = fm.getUI();
                    node.on('resize', function (e, data) {
                        var offset;
                        e.preventDefault();
                        e.stopPropagation();
                        if (data && data.fullscreen) {
                            offset = node.offset();
                            if (data.fullscreen === 'on') {
                                base.css({top: offset.top * -1, left: offset.left * -1}).appendTo(node);
                                selectableOption.appendTo = base
                            } else {
                                base.detach();
                                selectableOption.appendTo = 'body'
                            }
                            cwd.data('selectable') && cwd.selectable('option', {appendTo: selectableOption.appendTo})
                        }
                    })
                }
                hasUiTree = fm.getUI('tree').length
            }).bind('enable', function () {
                resize()
            }).bind('request.open', function () {
                bufferExt.getTmbs = []
            }).one('open', function () {
                if (fm.maxTargets) {
                    tmbNum = Math.min(fm.maxTargets, tmbNum)
                }
            }).bind('open add remove searchend', function () {
                var phash = fm.cwd().hash, type = this.type;
                if (type === 'open' || type === 'searchend' || fm.searchStatus.state < 2) {
                    cwdHashes = $.map(fm.files(phash), function (f) {
                        return f.hash
                    });
                    fm.trigger('cwdhasheschange', cwdHashes)
                }
                if (type === 'open') {
                    var inTrash = function () {
                        var isIn = !1;
                        $.each(cwdParents, function (i, h) {
                            if (fm.trashes[h]) {
                                isIn = !0;
                                return !1
                            }
                        });
                        return isIn
                    }, req = phash ? (!fm.file(phash) || hasUiTree ? (!hasUiTree ? fm.request({
                        data: {
                            cmd: 'parents',
                            target: fm.cwd().hash
                        }, preventFail: !0
                    }) : (function () {
                        var dfd = $.Deferred();
                        fm.one('treesync', function (e) {
                            e.data.always(function () {
                                dfd.resolve()
                            })
                        });
                        return dfd
                    })()) : null) : null, cwdObj = fm.cwd();
                    if (cwdObj.volumeid !== curVolId) {
                        vExpires.empty().hide();
                        if (curVolId) {
                            wrapper.removeClass('elfinder-cwd-wrapper-' + curVolId)
                        }
                        curVolId = cwdObj.volumeid;
                        showVolumeExpires();
                        wrapper.addClass('elfinder-cwd-wrapper-' + curVolId)
                    }
                    $.when(req).done(function () {
                        cwdParents = fm.parents(cwdObj.hash);
                        wrapper[inTrash() ? 'addClass' : 'removeClass']('elfinder-cwd-wrapper-trash')
                    });
                    incHashes = void 0;
                    unselectAll({notrigger: !0});
                    content()
                }
            }).bind('search', function (e) {
                cwdHashes = $.map(e.data.files, function (f) {
                    return f.hash
                });
                fm.trigger('cwdhasheschange', cwdHashes);
                incHashes = void 0;
                fm.searchStatus.ininc = !1;
                content();
                fm.autoSync('stop')
            }).bind('searchend', function (e) {
                if (query || incHashes) {
                    query = '';
                    if (incHashes) {
                        fm.trigger('incsearchend', e.data)
                    } else {
                        if (!e.data || !e.data.noupdate) {
                            content()
                        }
                    }
                }
                fm.autoSync()
            }).bind('searchstart', function (e) {
                unselectAll();
                query = e.data.query
            }).bind('incsearchstart', function (e) {
                var q = e.data.query || '', type = e.data.type || 'SearchName',
                    searchTypes = fm.options.commandsOptions.search.searchTypes || {};
                if ((searchTypes[type] && searchTypes[type].incsearch) || type === 'SearchName') {
                    selectedFiles = {};
                    fm.lazy(function () {
                        var regex, incSearch, fst = '';
                        query = q;
                        if (q) {
                            if (q.substr(0, 1) === '/') {
                                q = q.substr(1);
                                fst = '^'
                            }
                            regex = new RegExp(fst + q.replace(/([\\*\;\.\?\[\]\{\}\(\)\^\$\-\|])/g, '\\$1'), 'i');
                            if (type === 'SearchName') {
                                incHashes = $.grep(cwdHashes, function (hash) {
                                    var file = fm.file(hash);
                                    return (file && (file.name.match(regex) || (file.i18 && file.i18.match(regex)))) ? !0 : !1
                                })
                            } else {
                                incSearch = searchTypes[type].incsearch;
                                if (typeof incSearch === 'string') {
                                    incHashes = $.grep(cwdHashes, function (hash) {
                                        var file = fm.file(hash);
                                        return (file && file[incSearch] && (file[incSearch] + '').match(regex)) ? !0 : !1
                                    })
                                } else if (typeof incSearch === 'function') {
                                    try {
                                        incHashes = $.grep(incSearch({
                                            val: q,
                                            regex: regex
                                        }, cwdHashes, fm), function (hash) {
                                            return fm.file(hash) ? !0 : !1
                                        })
                                    } catch (e) {
                                        incHashes = []
                                    }
                                }
                            }
                            fm.trigger('incsearch', {hashes: incHashes, query: q}).searchStatus.ininc = !0;
                            content();
                            fm.autoSync('stop')
                        } else {
                            fm.trigger('incsearchend')
                        }
                    })
                }
            }).bind('incsearchend', function (e) {
                query = '';
                fm.searchStatus.ininc = !1;
                incHashes = void 0;
                if (!e.data || !e.data.noupdate) {
                    content()
                }
                fm.autoSync()
            }).bind('sortchange', function () {
                var lastScrollLeft = wrapper.scrollLeft(), allsel = cwd.hasClass('elfinder-cwd-allselected');
                content();
                fm.one('cwdrender', function () {
                    wrapper.scrollLeft(lastScrollLeft);
                    if (allsel) {
                        selectedFiles = fm.arrayFlip(incHashes || cwdHashes, !0)
                    }
                    (allsel || Object.keys(selectedFiles).length) && trigger()
                })
            }).bind('viewchange', function () {
                var l = fm.storage('view') == 'list', allsel = cwd.hasClass('elfinder-cwd-allselected');
                if (l != list) {
                    list = l;
                    fm.viewType = list ? 'list' : 'icons';
                    if (iconSize) {
                        fm.one('cwdinit', function () {
                            cwd.trigger('iconpref', {size: iconSize})
                        })
                    }
                    content();
                    resize();
                    if (allsel) {
                        cwd.addClass('elfinder-cwd-allselected');
                        selectAllCheckbox.find('input').prop('checked', !0)
                    }
                    Object.keys(selectedFiles).length && trigger()
                }
            }).bind('wzresize', function () {
                var place = list ? cwd.find('tbody') : cwd, cwdOffset;
                resize(!0);
                if (bufferExt.hpi) {
                    bottomMarkerShow(place, place.find('[id]').length)
                }
                cwdOffset = cwd.offset();
                wz.data('rectangle', Object.assign({
                    width: wz.width(),
                    height: wz.height(),
                    cwdEdge: (fm.direction === 'ltr') ? cwdOffset.left : cwdOffset.left + cwd.width()
                }, wz.offset()));
                bufferExt.itemH = (list ? place.find('tr:first') : place.find('[id]:first')).outerHeight(!0)
            }).bind('changeclipboard', function (e) {
                clipCuts = {};
                if (e.data && e.data.clipboard && e.data.clipboard.length) {
                    $.each(e.data.clipboard, function (i, f) {
                        if (f.cut) {
                            clipCuts[f.hash] = !0
                        }
                    })
                }
            }).bind('resMixinMake', function () {
                setColwidth()
            }).bind('tmbreload', function (e) {
                var imgs = {}, files = (e.data && e.data.files) ? e.data.files : null;
                $.each(files, function (i, f) {
                    if (f.tmb && f.tmb != '1') {
                        imgs[f.hash] = f.tmb
                    }
                });
                if (Object.keys(imgs).length) {
                    attachThumbnails(imgs, !0)
                }
            }).add(function (e) {
                var regex = query ? new RegExp(query.replace(/([\\*\;\.\?\[\]\{\}\(\)\^\$\-\|])/g, '\\$1'), 'i') : null,
                    mime = fm.searchStatus.mime, inSearch = fm.searchStatus.state > 1,
                    phash = inSearch && fm.searchStatus.target ? fm.searchStatus.target : fm.cwd().hash,
                    curPath = fm.path(phash), inTarget = function (f) {
                        var res, parents, path;
                        res = (f.phash === phash);
                        if (!res && inSearch) {
                            path = f.path || fm.path(f.hash);
                            res = (curPath && path.indexOf(curPath) === 0);
                            if (!res && fm.searchStatus.mixed) {
                                res = $.grep(fm.searchStatus.mixed, function (vid) {
                                    return f.hash.indexOf(vid) === 0 ? !0 : !1
                                }).length ? !0 : !1
                            }
                        }
                        if (res && inSearch) {
                            if (mime) {
                                res = (f.mime.indexOf(mime) === 0)
                            } else {
                                res = (f.name.match(regex) || (f.i18 && f.i18.match(regex))) ? !0 : !1
                            }
                        }
                        return res
                    }, files = $.grep(e.data.added || [], function (f) {
                        return inTarget(f) ? !0 : !1
                    });
                add(files);
                if (fm.searchStatus.state === 2) {
                    $.each(files, function (i, f) {
                        if ($.inArray(f.hash, cwdHashes) === -1) {
                            cwdHashes.push(f.hash)
                        }
                    });
                    fm.trigger('cwdhasheschange', cwdHashes)
                }
                list && resize();
                wrapper.trigger(scrollEvent)
            }).change(function (e) {
                var phash = fm.cwd().hash, sel = fm.selected(), files, added;
                if (query) {
                    $.each(e.data.changed || [], function (i, file) {
                        if (fm.cwdHash2Elm(file.hash).length) {
                            remove([file.hash]);
                            add([file], 'change');
                            $.inArray(file.hash, sel) !== -1 && selectFile(file.hash);
                            added = !0
                        }
                    })
                } else {
                    $.each($.grep(e.data.changed || [], function (f) {
                        return f.phash == phash ? !0 : !1
                    }), function (i, file) {
                        if (fm.cwdHash2Elm(file.hash).length) {
                            remove([file.hash]);
                            add([file], 'change');
                            $.inArray(file.hash, sel) !== -1 && selectFile(file.hash);
                            added = !0
                        }
                    })
                }
                if (added) {
                    fm.trigger('cwdhasheschange', cwdHashes);
                    list && resize();
                    wrapper.trigger(scrollEvent)
                }
                trigger()
            }).remove(function (e) {
                var place = list ? cwd.find('tbody') : cwd;
                remove(e.data.removed || []);
                trigger();
                if (buffer.length < 1 && place.children(fileSelector + (options.oldSchool ? ':not(.elfinder-cwd-parent)' : '')).length < 1) {
                    wz.addClass('elfinder-cwd-wrapper-empty');
                    selectCheckbox && selectAllCheckbox.find('input').prop('checked', !1);
                    bottomMarker.hide();
                    wrapper.off(scrollEvent, render);
                    resize()
                } else {
                    bottomMarkerShow(place);
                    wrapper.trigger(scrollEvent)
                }
            }).dragstart(function (e) {
                var target = $(e.data.target), oe = e.data.originalEvent;
                if (target.hasClass(clFile)) {
                    if (!target.hasClass(clSelected)) {
                        !(oe.ctrlKey || oe.metaKey || oe.shiftKey) && unselectAll({notrigger: !0});
                        target.trigger(evtSelect);
                        trigger()
                    }
                }
                cwd.removeClass(clDisabled).data('selectable') && cwd.selectable('disable');
                selectLock = !0
            }).dragstop(function () {
                cwd.data('selectable') && cwd.selectable('enable');
                selectLock = !1
            }).bind('lockfiles unlockfiles selectfiles unselectfiles', function (e) {
                var events = {
                        lockfiles: evtDisable,
                        unlockfiles: evtEnable,
                        selectfiles: evtSelect,
                        unselectfiles: evtUnselect
                    }, event = events[e.type], files = e.data.files || [], l = files.length, helper = e.data.helper || $(),
                    parents, ctr, add;
                if (l > 0) {
                    parents = fm.parents(files[0])
                }
                if (event === evtSelect || event === evtUnselect) {
                    add = (event === evtSelect), $.each(files, function (i, hash) {
                        var all = cwd.hasClass('elfinder-cwd-allselected');
                        if (!selectedFiles[hash]) {
                            add && (selectedFiles[hash] = !0)
                        } else {
                            if (all) {
                                selectCheckbox && selectAllCheckbox.children('input').prop('checked', !1);
                                cwd.removeClass('elfinder-cwd-allselected');
                                all = !1
                            }
                            !add && delete selectedFiles[hash]
                        }
                    })
                }
                if (!helper.data('locked')) {
                    while (l--) {
                        try {
                            fm.cwdHash2Elm(files[l]).trigger(event)
                        } catch (e) {
                        }
                    }
                    !e.data.inselect && trigger()
                }
                if (wrapper.data('dropover') && parents.indexOf(wrapper.data('dropover')) !== -1) {
                    ctr = e.type !== 'lockfiles';
                    helper.toggleClass('elfinder-drag-helper-plus', ctr);
                    wrapper.toggleClass(clDropActive, ctr)
                }
            }).bind('mkdir mkfile duplicate upload rename archive extract paste multiupload', function (e) {
                if (e.type == 'upload' && e.data._multiupload) return;
                var phash = fm.cwd().hash, files;
                unselectAll({notrigger: !0});
                $.each((e.data.added || []).concat(e.data.changed || []), function (i, file) {
                    file && file.phash == phash && selectFile(file.hash)
                });
                trigger()
            }).shortcut({
                pattern: 'ctrl+a',
                description: 'selectall',
                callback: selectAll
            }).shortcut({
                pattern: 'ctrl+shift+i',
                description: 'selectinvert',
                callback: selectInvert
            }).shortcut({
                pattern: 'left right up down shift+left shift+right shift+up shift+down',
                description: 'selectfiles',
                type: 'keydown',
                callback: function (e) {
                    select(e.keyCode, e.shiftKey)
                }
            }).shortcut({
                pattern: 'home', description: 'selectffile', callback: function (e) {
                    unselectAll({notrigger: !0});
                    scrollToView(cwd.find('[id]:first').trigger(evtSelect));
                    trigger()
                }
            }).shortcut({
                pattern: 'end', description: 'selectlfile', callback: function (e) {
                    unselectAll({notrigger: !0});
                    scrollToView(cwd.find('[id]:last').trigger(evtSelect));
                    trigger()
                }
            }).shortcut({
                pattern: 'page_up', description: 'pageTurning', callback: function (e) {
                    if (bufferExt.itemH) {
                        wrapper.scrollTop(Math.round(wrapper.scrollTop() - (Math.floor((wrapper.height() + (list ? bufferExt.itemH * -1 : 16)) / bufferExt.itemH)) * bufferExt.itemH))
                    }
                }
            }).shortcut({
                pattern: 'page_down', description: 'pageTurning', callback: function (e) {
                    if (bufferExt.itemH) {
                        wrapper.scrollTop(Math.round(wrapper.scrollTop() + (Math.floor((wrapper.height() + (list ? bufferExt.itemH * -1 : 16)) / bufferExt.itemH)) * bufferExt.itemH))
                    }
                }
            })
        });
        return this
    };
    $.fn.elfinderdialog = function (opts, fm) {
        var platformWin = (window.navigator.platform.indexOf('Win') != -1), delta = {},
            syncSize = {enabled: !1, width: !1, height: !1, defaultSize: null}, fitSize = function (dialog) {
                var opts, node;
                if (syncSize.enabled) {
                    node = fm.options.dialogContained ? elfNode : $(window);
                    opts = {
                        maxWidth: syncSize.width ? node.width() - delta.width : null,
                        maxHeight: syncSize.height ? node.height() - delta.height : null
                    };
                    Object.assign(restoreStyle, opts);
                    dialog.css(opts).trigger('resize');
                    if (dialog.data('hasResizable') && (dialog.resizable('option', 'maxWidth') < opts.maxWidth || dialog.resizable('option', 'maxHeight') < opts.maxHeight)) {
                        dialog.resizable('option', opts)
                    }
                }
            }, syncFunc = function (e) {
                var dialog = e.data;
                syncTm && cancelAnimationFrame(syncTm);
                syncTm = requestAnimationFrame(function () {
                    var opts, offset;
                    if (syncSize.enabled) {
                        fitSize(dialog)
                    }
                })
            }, checkEditing = function () {
                var cldialog = 'elfinder-dialog',
                    dialogs = elfNode.children('.' + cldialog + '.' + fm.res('class', 'editing') + ':visible');
                fm[dialogs.length ? 'disable' : 'enable']()
            }, propagationEvents = {}, syncTm, dialog, elfNode, restoreStyle;
        if (fm && fm.ui) {
            elfNode = fm.getUI()
        } else {
            elfNode = this.closest('.elfinder');
            if (!fm) {
                fm = elfNode.elfinder('instance')
            }
        }
        if (typeof opts === 'string') {
            if ((dialog = this.closest('.ui-dialog')).length) {
                if (opts === 'open') {
                    if (dialog.css('display') === 'none') {
                        dialog.trigger('posinit').show().trigger('open').hide();
                        dialog.fadeIn(120, function () {
                            fm.trigger('dialogopened', {dialog: dialog})
                        })
                    }
                } else if (opts === 'close' || opts === 'destroy') {
                    dialog.stop(!0);
                    if (dialog.is(':visible') || elfNode.is(':hidden')) {
                        dialog.trigger('close');
                        fm.trigger('dialogclosed', {dialog: dialog})
                    }
                    if (opts === 'destroy') {
                        dialog.remove();
                        fm.trigger('dialogremoved', {dialog: dialog})
                    }
                } else if (opts === 'toTop') {
                    dialog.trigger('totop');
                    fm.trigger('dialogtotoped', {dialog: dialog})
                } else if (opts === 'posInit') {
                    dialog.trigger('posinit');
                    fm.trigger('dialogposinited', {dialog: dialog})
                } else if (opts === 'tabstopsInit') {
                    dialog.trigger('tabstopsInit');
                    fm.trigger('dialogtabstopsinited', {dialog: dialog})
                } else if (opts === 'checkEditing') {
                    checkEditing()
                }
            }
            return this
        }
        opts = Object.assign({}, $.fn.elfinderdialog.defaults, opts);
        if (opts.allowMinimize && opts.allowMinimize === 'auto') {
            opts.allowMinimize = this.find('textarea,input').length ? !0 : !1
        }
        opts.openMaximized = opts.allowMinimize && opts.openMaximized;
        if (opts.headerBtnPos && opts.headerBtnPos === 'auto') {
            opts.headerBtnPos = platformWin ? 'right' : 'left'
        }
        if (opts.headerBtnOrder && opts.headerBtnOrder === 'auto') {
            opts.headerBtnOrder = platformWin ? 'close:maximize:minimize' : 'close:minimize:maximize'
        }
        if (opts.modal && opts.allowMinimize) {
            opts.allowMinimize = !1
        }
        if (fm.options.dialogContained) {
            syncSize.width = syncSize.height = syncSize.enabled = !0
        } else {
            syncSize.width = (opts.maxWidth === 'window');
            syncSize.height = (opts.maxHeight === 'window');
            if (syncSize.width || syncSize.height) {
                syncSize.enabled = !0
            }
        }
        propagationEvents = fm.arrayFlip(opts.propagationEvents, !0);
        this.filter(':not(.ui-dialog-content)').each(function () {
            var self = $(this).addClass('ui-dialog-content ui-widget-content'), clactive = 'elfinder-dialog-active',
                cldialog = 'elfinder-dialog', clnotify = 'elfinder-dialog-notify', clhover = 'ui-state-hover',
                cltabstop = 'elfinder-tabstop', cl1stfocus = 'elfinder-focus', clmodal = 'elfinder-dialog-modal',
                id = parseInt(Math.random() * 1000000),
                titlebar = $('<div class="ui-dialog-titlebar ui-widget-header ui-corner-top ui-helper-clearfix"><span class="elfinder-dialog-title">' + opts.title + '</span></div>'),
                buttonset = $('<div class="ui-dialog-buttonset"/>'),
                buttonpane = $('<div class=" ui-helper-clearfix ui-dialog-buttonpane ui-widget-content"/>').append(buttonset),
                btnWidth = 0, btnCnt = 0, tabstops = $(),
                evCover = $('<div style="width:100%;height:100%;position:absolute;top:0px;left:0px;"/>').hide(),
                numberToTel = function () {
                    if (opts.optimizeNumber) {
                        dialog.find('input[type=number]').each(function () {
                            $(this).attr('inputmode', 'numeric');
                            $(this).attr('pattern', '[0-9]*')
                        })
                    }
                }, tabstopsInit = function () {
                    tabstops = dialog.find('.' + cltabstop);
                    if (tabstops.length) {
                        tabstops.attr('tabindex', '-1');
                        if (!tabstops.filter('.' + cl1stfocus).length) {
                            buttonset.children('.' + cltabstop + ':' + (platformWin ? 'first' : 'last')).addClass(cl1stfocus)
                        }
                    }
                }, tabstopNext = function (cur) {
                    var elms = tabstops.filter(':visible:enabled'),
                        node = cur ? null : elms.filter('.' + cl1stfocus + ':first');
                    if (!node || !node.length) {
                        node = elms.first()
                    }
                    if (cur) {
                        $.each(elms, function (i, elm) {
                            if (elm === cur && elms[i + 1]) {
                                node = elms.eq(i + 1);
                                return !1
                            }
                        })
                    }
                    return node
                }, tabstopPrev = function (cur) {
                    var elms = tabstops.filter(':visible:enabled'), node = elms.last();
                    $.each(elms, function (i, elm) {
                        if (elm === cur && elms[i - 1]) {
                            node = elms.eq(i - 1);
                            return !1
                        }
                    });
                    return node
                }, makeHeaderBtn = function () {
                    $.each(opts.headerBtnOrder.split(':').reverse(), function (i, v) {
                        headerBtns[v] && headerBtns[v]()
                    });
                    if (platformWin) {
                        titlebar.children('.elfinder-titlebar-button').addClass('elfinder-titlebar-button-right')
                    }
                }, headerBtns = {
                    close: function () {
                        titlebar.prepend($('<span class="ui-widget-header ui-dialog-titlebar-close ui-corner-all elfinder-titlebar-button"><span class="ui-icon ui-icon-closethick"/></span>').on('mousedown', function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            self.elfinderdialog('close')
                        }))
                    }, maximize: function () {
                        if (opts.allowMaximize) {
                            dialog.on('resize', function (e, data) {
                                var full, elm;
                                e.preventDefault();
                                e.stopPropagation();
                                if (data && data.maximize) {
                                    elm = titlebar.find('.elfinder-titlebar-full');
                                    full = (data.maximize === 'on');
                                    elm.children('span.ui-icon').toggleClass('ui-icon-plusthick', !full).toggleClass('ui-icon-arrowreturnthick-1-s', full);
                                    if (full) {
                                        try {
                                            dialog.hasClass('ui-draggable') && dialog.draggable('disable');
                                            dialog.hasClass('ui-resizable') && dialog.resizable('disable')
                                        } catch (e) {
                                        }
                                        self.css('width', '100%').css('height', dialog.height() - dialog.children('.ui-dialog-titlebar').outerHeight(!0) - buttonpane.outerHeight(!0))
                                    } else {
                                        self.attr('style', elm.data('style'));
                                        elm.removeData('style');
                                        posCheck();
                                        try {
                                            dialog.hasClass('ui-draggable') && dialog.draggable('enable');
                                            dialog.hasClass('ui-resizable') && dialog.resizable('enable')
                                        } catch (e) {
                                        }
                                    }
                                    dialog.trigger('resize', {init: !0})
                                }
                            });
                            titlebar.prepend($('<span class="ui-widget-header ui-corner-all elfinder-titlebar-button elfinder-titlebar-full"><span class="ui-icon ui-icon-plusthick"/></span>').on('mousedown', function (e) {
                                var elm = $(this);
                                e.preventDefault();
                                e.stopPropagation();
                                if (!dialog.hasClass('elfinder-maximized') && typeof elm.data('style') === 'undefined') {
                                    self.height(self.height());
                                    elm.data('style', self.attr('style') || '')
                                }
                                fm.toggleMaximize(dialog);
                                typeof(opts.maximize) === 'function' && opts.maximize.call(self[0])
                            }))
                        }
                    }, minimize: function () {
                        var btn, mnode, doffset;
                        if (opts.allowMinimize) {
                            btn = $('<span class="ui-widget-header ui-corner-all elfinder-titlebar-button elfinder-titlebar-minimize"><span class="ui-icon ui-icon-minusthick"/></span>').on('mousedown', function (e) {
                                var $this = $(this), tray = fm.getUI('bottomtray'), dumStyle = {width: 70, height: 24},
                                    dum = $('<div/>').css(dumStyle).addClass(dialog.get(0).className + ' elfinder-dialog-minimized'),
                                    pos = {};
                                e.preventDefault();
                                e.stopPropagation();
                                if (!dialog.data('minimized')) {
                                    doffset = dialog.data('minimized', !0).position();
                                    mnode = dialog.clone().on('mousedown', function () {
                                        $this.trigger('mousedown')
                                    }).removeClass('ui-draggable ui-resizable elfinder-frontmost');
                                    tray.append(dum);
                                    Object.assign(pos, dum.offset(), dumStyle);
                                    dum.remove();
                                    mnode.height(dialog.height()).children('.ui-dialog-content:first').empty();
                                    fm.toHide(dialog.before(mnode));
                                    mnode.children('.ui-dialog-content:first,.ui-dialog-buttonpane,.ui-resizable-handle').remove();
                                    mnode.find('.elfinder-titlebar-minimize,.elfinder-titlebar-full').remove();
                                    mnode.find('.ui-dialog-titlebar-close').on('mousedown', function (e) {
                                        e.stopPropagation();
                                        e.preventDefault();
                                        mnode.remove();
                                        dialog.show();
                                        self.elfinderdialog('close')
                                    });
                                    mnode.animate(pos, function () {
                                        mnode.attr('style', '').css({maxWidth: dialog.width()}).addClass('elfinder-dialog-minimized').appendTo(tray);
                                        checkEditing();
                                        typeof(opts.minimize) === 'function' && opts.minimize.call(self[0])
                                    })
                                } else {
                                    dialog.removeData('minimized').before(mnode.css(Object.assign({'position': 'absolute'}, mnode.offset())));
                                    fm.toFront(mnode);
                                    mnode.animate(Object.assign({
                                        width: dialog.width(),
                                        height: dialog.height()
                                    }, doffset), function () {
                                        dialog.show();
                                        fm.toFront(dialog);
                                        mnode.remove();
                                        posCheck();
                                        checkEditing();
                                        dialog.trigger('resize', {init: !0});
                                        typeof(opts.minimize) === 'function' && opts.minimize.call(self[0])
                                    })
                                }
                            });
                            titlebar.on('dblclick', function (e) {
                                $(this).children('.elfinder-titlebar-minimize').trigger('mousedown')
                            }).prepend(btn);
                            dialog.on('togleminimize', function () {
                                btn.trigger('mousedown')
                            })
                        }
                    }
                },
                dialog = $('<div class="ui-front ui-dialog ui-widget ui-widget-content ui-corner-all ui-draggable std42-dialog touch-punch ' + cldialog + ' ' + opts.cssClass + '"/>').hide().append(self).appendTo(elfNode).draggable({
                    containment: fm.options.dialogContained ? elfNode : null,
                    handle: '.ui-dialog-titlebar',
                    start: function () {
                        evCover.show()
                    },
                    drag: function (e, ui) {
                        var top = ui.offset.top, left = ui.offset.left;
                        if (top < 0) {
                            ui.position.top = ui.position.top - top
                        }
                        if (left < 0) {
                            ui.position.left = ui.position.left - left
                        }
                        if (fm.options.dialogContained) {
                            ui.position.top < 0 && (ui.position.top = 0);
                            ui.position.left < 0 && (ui.position.left = 0)
                        }
                    },
                    stop: function (e, ui) {
                        evCover.hide();
                        dialog.css({height: opts.height});
                        self.data('draged', !0)
                    }
                }).css({
                    width: opts.width,
                    height: opts.height,
                    minWidth: opts.minWidth,
                    minHeight: opts.minHeight,
                    maxWidth: opts.maxWidth,
                    maxHeight: opts.maxHeight
                }).on('touchstart touchmove touchend click dblclick mouseup mouseenter mouseleave mouseout mouseover mousemove', function (e) {
                    !propagationEvents[e.type] && e.stopPropagation()
                }).on('mousedown', function (e) {
                    !propagationEvents[e.type] && e.stopPropagation();
                    requestAnimationFrame(function () {
                        if (dialog.is(':visible') && !dialog.hasClass('elfinder-frontmost')) {
                            toFocusNode = $(':focus');
                            if (!toFocusNode.length) {
                                toFocusNode = void(0)
                            }
                            dialog.trigger('totop')
                        }
                    })
                }).on('open', function () {
                    dialog.data('margin-y', self.outerHeight(!0) - self.height());
                    if (syncSize.enabled) {
                        if (opts.height && opts.height !== 'auto') {
                            dialog.trigger('resize', {init: !0})
                        }
                        if (!syncSize.defaultSize) {
                            syncSize.defaultSize = {width: self.width(), height: self.height()}
                        }
                        fitSize(dialog);
                        dialog.trigger('resize').trigger('posinit');
                        elfNode.on('resize.' + fm.namespace, dialog, syncFunc)
                    }
                    if (!dialog.hasClass(clnotify)) {
                        elfNode.children('.' + cldialog + ':visible:not(.' + clnotify + ')').each(function () {
                            var d = $(this), top = parseInt(d.css('top')), left = parseInt(d.css('left')),
                                _top = parseInt(dialog.css('top')), _left = parseInt(dialog.css('left')),
                                ct = Math.abs(top - _top) < 10, cl = Math.abs(left - _left) < 10;
                            if (d[0] != dialog[0] && (ct || cl)) {
                                dialog.css({top: ct ? (top + 10) : _top, left: cl ? (left + 10) : _left})
                            }
                        })
                    }
                    if (dialog.data('modal')) {
                        dialog.addClass(clmodal);
                        fm.getUI('overlay').elfinderoverlay('show')
                    }
                    dialog.trigger('totop');
                    opts.openMaximized && fm.toggleMaximize(dialog);
                    fm.trigger('dialogopen', {dialog: dialog});
                    typeof(opts.open) == 'function' && $.proxy(opts.open, self[0])();
                    if (opts.closeOnEscape) {
                        $(document).on('keydown.' + id, function (e) {
                            if (e.keyCode == $.ui.keyCode.ESCAPE && dialog.hasClass('elfinder-frontmost')) {
                                self.elfinderdialog('close')
                            }
                        })
                    }
                    dialog.hasClass(fm.res('class', 'editing')) && checkEditing()
                }).on('close', function (e) {
                    var dialogs, dfd;
                    if (opts.beforeclose && typeof opts.beforeclose === 'function') {
                        dfd = opts.beforeclose();
                        if (!dfd || !dfd.promise) {
                            dfd = !dfd ? $.Deferred().reject() : $.Deferred().resolve()
                        }
                    } else {
                        dfd = $.Deferred().resolve()
                    }
                    dfd.done(function () {
                        syncSize.enabled && elfNode.off('resize.' + fm.namespace, syncFunc);
                        if (opts.closeOnEscape) {
                            $(document).off('keyup.' + id)
                        }
                        if (opts.allowMaximize) {
                            fm.toggleMaximize(dialog, !1)
                        }
                        fm.toHide(dialog);
                        dialog.data('modal') && fm.getUI('overlay').elfinderoverlay('hide');
                        if (typeof(opts.close) == 'function') {
                            $.proxy(opts.close, self[0])()
                        }
                        if (opts.destroyOnClose && dialog.parent().length) {
                            dialog.hide().remove()
                        }
                        dialogs = elfNode.children('.' + cldialog + ':visible');
                        dialog.hasClass(fm.res('class', 'editing')) && checkEditing()
                    })
                }).on('totop frontmost', function () {
                    var s = fm.storage('autoFocusDialog');
                    dialog.data('focusOnMouseOver', s ? (s > 0) : fm.options.uiOptions.dialog.focusOnMouseOver);
                    if (dialog.data('minimized')) {
                        titlebar.children('.elfinder-titlebar-minimize').trigger('mousedown')
                    }
                    if (!dialog.data('modal') && fm.getUI('overlay').is(':visible')) {
                        fm.getUI('overlay').before(dialog)
                    } else {
                        fm.toFront(dialog)
                    }
                    elfNode.children('.' + cldialog + ':not(.' + clmodal + ')').removeClass(clactive);
                    dialog.addClass(clactive);
                    !fm.UA.Mobile && (toFocusNode || tabstopNext()).trigger('focus');
                    toFocusNode = void(0)
                }).on('posinit', function () {
                    var css = opts.position, nodeOffset, minTop, minLeft, outerSize, win, winSize, nodeFull;
                    if (dialog.hasClass('elfinder-maximized')) {
                        return
                    }
                    if (!css && !dialog.data('resizing')) {
                        nodeFull = elfNode.hasClass('elfinder-fullscreen') || fm.options.enableAlways;
                        dialog.css(nodeFull ? {maxWidth: '100%', maxHeight: '100%', overflow: 'auto'} : restoreStyle);
                        if (fm.UA.Mobile && !nodeFull && dialog.data('rotated') === fm.UA.Rotated) {
                            return
                        }
                        dialog.data('rotated', fm.UA.Rotated);
                        win = $(window);
                        nodeOffset = elfNode.offset();
                        outerSize = {width: dialog.outerWidth(!0), height: dialog.outerHeight(!0)};
                        outerSize.right = nodeOffset.left + outerSize.width;
                        outerSize.bottom = nodeOffset.top + outerSize.height;
                        winSize = {
                            scrLeft: win.scrollLeft(),
                            scrTop: win.scrollTop(),
                            width: win.width(),
                            height: win.height()
                        };
                        winSize.right = winSize.scrLeft + winSize.width;
                        winSize.bottom = winSize.scrTop + winSize.height;
                        if (fm.options.dialogContained || nodeFull) {
                            minTop = 0;
                            minLeft = 0
                        } else {
                            minTop = nodeOffset.top * -1 + winSize.scrTop;
                            minLeft = nodeOffset.left * -1 + winSize.scrLeft
                        }
                        css = {
                            top: outerSize.height >= winSize.height ? minTop : Math.max(minTop, parseInt((elfNode.height() - outerSize.height) / 2 - 42)),
                            left: outerSize.width >= winSize.width ? minLeft : Math.max(minLeft, parseInt((elfNode.width() - outerSize.width) / 2))
                        };
                        if (outerSize.right + css.left > winSize.right) {
                            css.left = Math.max(minLeft, winSize.right - outerSize.right)
                        }
                        if (outerSize.bottom + css.top > winSize.bottom) {
                            css.top = Math.max(minTop, winSize.bottom - outerSize.bottom)
                        }
                    }
                    if (opts.absolute) {
                        css.position = 'absolute'
                    }
                    css && dialog.css(css)
                }).on('resize', function (e, data) {
                    var oh = 0, init = data && data.init, h, minH, maxH;
                    if ((data && (data.minimize || data.maxmize)) || dialog.data('minimized')) {
                        return
                    }
                    e.stopPropagation();
                    e.preventDefault();
                    dialog.children('.ui-widget-header,.ui-dialog-buttonpane').each(function () {
                        oh += $(this).outerHeight(!0)
                    });
                    if (!init && syncSize.enabled && !e.originalEvent && !dialog.hasClass('elfinder-maximized')) {
                        h = dialog.height();
                        minH = dialog.css('min-height') || h;
                        maxH = dialog.css('max-height') || h;
                        if (minH.match(/%/)) {
                            minH = Math.floor((parseInt(minH) / 100) * dialog.parent().height())
                        } else {
                            minH = parseInt(minH)
                        }
                        if (maxH.match(/%/)) {
                            maxH = Math.floor((parseInt(maxH) / 100) * dialog.parent().height())
                        } else {
                            maxH = parseInt(maxH)
                        }
                        h = Math.min(syncSize.defaultSize.height, Math.max(maxH, minH) - oh - dialog.data('margin-y'))
                    } else {
                        h = dialog.height() - oh - dialog.data('margin-y')
                    }
                    self.height(h);
                    if (init) {
                        return
                    }
                    posCheck();
                    minH = self.height();
                    minH = (h < minH) ? (minH + oh + dialog.data('margin-y')) : opts.minHeight;
                    dialog.css('min-height', minH);
                    dialog.data('hasResizable') && dialog.resizable('option', {minHeight: minH});
                    if (typeof(opts.resize) === 'function') {
                        $.proxy(opts.resize, self[0])(e, data)
                    }
                }).on('tabstopsInit', tabstopsInit).on('focus', '.' + cltabstop, function () {
                    $(this).addClass(clhover).parent('label').addClass(clhover);
                    this.id && $(this).parent().find('label[for=' + this.id + ']').addClass(clhover)
                }).on('click', 'select.' + cltabstop, function () {
                    var node = $(this);
                    node.data('keepFocus') ? node.removeData('keepFocus') : node.data('keepFocus', !0)
                }).on('blur', '.' + cltabstop, function () {
                    $(this).removeClass(clhover).removeData('keepFocus').parent('label').removeClass(clhover);
                    this.id && $(this).parent().find('label[for=' + this.id + ']').removeClass(clhover)
                }).on('mouseenter mouseleave', '.' + cltabstop + ',label', function (e) {
                    var $this = $(this), labelfor;
                    if (this.nodeName === 'LABEL') {
                        if (!$this.children('.' + cltabstop).length && (!(labelfor = $this.attr('for')) || !$('#' + labelfor).hasClass(cltabstop))) {
                            return
                        }
                    }
                    if (opts.btnHoverFocus && dialog.data('focusOnMouseOver')) {
                        if (e.type === 'mouseenter' && !$(':focus').data('keepFocus')) {
                            $this.trigger('focus')
                        }
                    } else {
                        $this.toggleClass(clhover, e.type == 'mouseenter')
                    }
                }).on('keydown', '.' + cltabstop, function (e) {
                    var $this = $(this), esc, move, moveTo;
                    if ($this.is(':focus')) {
                        esc = e.keyCode === $.ui.keyCode.ESCAPE;
                        if (e.keyCode === $.ui.keyCode.ENTER) {
                            e.preventDefault();
                            $this.trigger('click')
                        } else if (((e.keyCode === $.ui.keyCode.TAB) && e.shiftKey) || e.keyCode === $.ui.keyCode.LEFT || e.keyCode == $.ui.keyCode.UP) {
                            move = 'prev'
                        } else if (e.keyCode === $.ui.keyCode.TAB || e.keyCode == $.ui.keyCode.RIGHT || e.keyCode == $.ui.keyCode.DOWN) {
                            move = 'next'
                        }
                        if (move && (($this.is('textarea') && !(e.ctrlKey || e.metaKey)) || ($this.is('select,span.ui-slider-handle') && e.keyCode !== $.ui.keyCode.TAB) || ($this.is('input:not(:checkbox,:radio)') && (!(e.ctrlKey || e.metaKey) && e.keyCode === $.ui.keyCode[move === 'prev' ? 'LEFT' : 'RIGHT'])))) {
                            e.stopPropagation();
                            return
                        }
                        if (!esc) {
                            e.stopPropagation()
                        } else if ($this.is('input:not(:checkbox,:radio),textarea')) {
                            if ($this.val() !== '') {
                                $this.val('');
                                e.stopPropagation()
                            }
                        }
                        if (move) {
                            e.preventDefault();
                            (move === 'prev' ? tabstopPrev : tabstopNext)(this).trigger('focus')
                        }
                    }
                }).data({modal: opts.modal}), posCheck = function () {
                    var node = fm.getUI(), pos;
                    if (node.hasClass('elfinder-fullscreen')) {
                        pos = dialog.position();
                        dialog.css('top', Math.max(Math.min(Math.max(pos.top, 0), node.height() - 100), 0));
                        dialog.css('left', Math.max(Math.min(Math.max(pos.left, 0), node.width() - 200), 0))
                    }
                }, maxSize, toFocusNode;
            dialog.prepend(titlebar);
            makeHeaderBtn();
            $.each(opts.buttons, function (name, cb) {
                var button = $('<button type="button" class="ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only ' + 'elfinder-btncnt-' + (btnCnt++) + ' ' + cltabstop + '"><span class="ui-button-text">' + name + '</span></button>').on('click', $.proxy(cb, self[0]));
                if (cb._cssClass) {
                    button.addClass(cb._cssClass)
                }
                if (platformWin) {
                    buttonset.append(button)
                } else {
                    buttonset.prepend(button)
                }
            });
            if (buttonset.children().length) {
                dialog.append(buttonpane);
                dialog.show();
                buttonpane.find('button').each(function (i, btn) {
                    btnWidth += $(btn).outerWidth(!0)
                });
                dialog.hide();
                btnWidth += 20;
                if (dialog.width() < btnWidth) {
                    dialog.width(btnWidth)
                }
            }
            dialog.append(evCover);
            if (syncSize.enabled) {
                delta.width = dialog.outerWidth(!0) - dialog.width() + ((dialog.outerWidth() - dialog.width()) / 2);
                delta.height = dialog.outerHeight(!0) - dialog.height() + ((dialog.outerHeight() - dialog.height()) / 2)
            }
            if (fm.options.dialogContained) {
                maxSize = {maxWidth: elfNode.width() - delta.width, maxHeight: elfNode.height() - delta.height};
                opts.maxWidth = opts.maxWidth ? Math.min(maxSize.maxWidth, opts.maxWidth) : maxSize.maxWidth;
                opts.maxHeight = opts.maxHeight ? Math.min(maxSize.maxHeight, opts.maxHeight) : maxSize.maxHeight;
                dialog.css(maxSize)
            }
            restoreStyle = {
                maxWidth: dialog.css('max-width'),
                maxHeight: dialog.css('max-height'),
                overflow: dialog.css('overflow')
            };
            if (opts.resizable) {
                dialog.resizable({
                    minWidth: opts.minWidth,
                    minHeight: opts.minHeight,
                    maxWidth: opts.maxWidth,
                    maxHeight: opts.maxHeight,
                    start: function () {
                        evCover.show();
                        if (dialog.data('resizing') !== !0 && dialog.data('resizing')) {
                            clearTimeout(dialog.data('resizing'))
                        }
                        dialog.data('resizing', !0)
                    },
                    stop: function (e, ui) {
                        evCover.hide();
                        dialog.data('resizing', setTimeout(function () {
                            dialog.data('resizing', !1)
                        }, 200));
                        if (syncSize.enabled) {
                            syncSize.defaultSize = {width: self.width(), height: self.height()}
                        }
                    }
                }).data('hasResizable', !0)
            }
            numberToTel();
            tabstopsInit();
            typeof(opts.create) == 'function' && $.proxy(opts.create, this)();
            if (opts.autoOpen) {
                if (opts.open) {
                    requestAnimationFrame(function () {
                        self.elfinderdialog('open')
                    })
                } else {
                    self.elfinderdialog('open')
                }
            }
            if (opts.resize) {
                fm.bind('themechange', function () {
                    setTimeout(function () {
                        dialog.data('margin-y', self.outerHeight(!0) - self.height());
                        dialog.trigger('resize', {init: !0})
                    }, 300)
                })
            }
        });
        return this
    };
    $.fn.elfinderdialog.defaults = {
        cssClass: '',
        title: '',
        modal: !1,
        resizable: !0,
        autoOpen: !0,
        closeOnEscape: !0,
        destroyOnClose: !1,
        buttons: {},
        btnHoverFocus: !0,
        position: null,
        absolute: !1,
        width: 360,
        height: 'auto',
        minWidth: 200,
        minHeight: 70,
        maxWidth: null,
        maxHeight: null,
        allowMinimize: 'auto',
        allowMaximize: !1,
        openMaximized: !1,
        headerBtnPos: 'auto',
        headerBtnOrder: 'auto',
        optimizeNumber: !0,
        propagationEvents: ['mousemove', 'mouseup']
    };
    $.fn.elfinderfullscreenbutton = function (cmd) {
        return this.each(function () {
            var button = $(this).elfinderbutton(cmd), icon = button.children('.elfinder-button-icon'), tm;
            cmd.change(function () {
                tm && cancelAnimationFrame(tm);
                tm = requestAnimationFrame(function () {
                    var fullscreen = cmd.value;
                    icon.addClass('elfinder-button-icon-fullscreen').toggleClass('elfinder-button-icon-unfullscreen', fullscreen);
                    cmd.className = fullscreen ? 'unfullscreen' : ''
                })
            })
        })
    };
    $.fn.elfindernavbar = function (fm, opts) {
        this.not('.elfinder-navbar').each(function () {
            var nav = $(this).hide().addClass('ui-state-default elfinder-navbar'),
                parent = nav.css('overflow', 'hidden').parent(), wz = parent.children('.elfinder-workzone').append(nav),
                ltr = fm.direction == 'ltr', delta, deltaW, handle, swipeHandle, autoHide, setWidth, navdock,
                setWzRect = function () {
                    var cwd = fm.getUI('cwd'), wz = fm.getUI('workzone'), wzRect = wz.data('rectangle'),
                        cwdOffset = cwd.offset();
                    wz.data('rectangle', Object.assign(wzRect, {cwdEdge: (fm.direction === 'ltr') ? cwdOffset.left : cwdOffset.left + cwd.width()}))
                }, setDelta = function () {
                    nav.css('overflow', 'hidden');
                    delta = Math.round(nav.outerHeight() - nav.height());
                    deltaW = Math.round(navdock.outerWidth() - navdock.innerWidth());
                    nav.css('overflow', 'auto')
                };
            fm.one('init', function () {
                navdock = fm.getUI('navdock');
                var set = function () {
                    setDelta();
                    fm.bind('wzresize', function () {
                        var navdockH = 0;
                        navdock.width(nav.outerWidth() - deltaW);
                        if (navdock.children().length > 1) {
                            navdockH = navdock.outerHeight(!0)
                        }
                        nav.height(wz.height() - navdockH - delta)
                    }).trigger('wzresize')
                };
                if (fm.cssloaded) {
                    set()
                } else {
                    fm.one('cssloaded', set)
                }
            }).one('opendone', function () {
                handle && handle.trigger('resize');
                nav.css('overflow', 'auto')
            }).bind('themechange', setDelta);
            if (fm.UA.Touch) {
                autoHide = fm.storage('autoHide') || {};
                if (typeof autoHide.navbar === 'undefined') {
                    autoHide.navbar = (opts.autoHideUA && opts.autoHideUA.length > 0 && $.grep(opts.autoHideUA, function (v) {
                        return fm.UA[v] ? !0 : !1
                    }).length);
                    fm.storage('autoHide', autoHide)
                }
                if (autoHide.navbar) {
                    fm.one('init', function () {
                        if (nav.children().length) {
                            fm.uiAutoHide.push(function () {
                                nav.stop(!0, !0).trigger('navhide', {duration: 'slow', init: !0})
                            })
                        }
                    })
                }
                fm.bind('load', function () {
                    if (nav.children().length) {
                        swipeHandle = $('<div class="elfinder-navbar-swipe-handle"/>').hide().appendTo(wz);
                        if (swipeHandle.css('pointer-events') !== 'none') {
                            swipeHandle.remove();
                            swipeHandle = null
                        }
                    }
                });
                nav.on('navshow navhide', function (e, data) {
                    var mode = (e.type === 'navshow') ? 'show' : 'hide',
                        duration = (data && data.duration) ? data.duration : 'fast',
                        handleW = (data && data.handleW) ? data.handleW : Math.max(50, fm.getUI().width() / 10);
                    nav.stop(!0, !0)[mode]({
                        duration: duration, step: function () {
                            fm.trigger('wzresize')
                        }, complete: function () {
                            if (swipeHandle) {
                                if (mode === 'show') {
                                    swipeHandle.stop(!0, !0).hide()
                                } else {
                                    swipeHandle.width(handleW ? handleW : '');
                                    fm.resources.blink(swipeHandle, 'slowonce')
                                }
                            }
                            fm.trigger('navbar' + mode);
                            data.init && fm.trigger('uiautohide');
                            setWzRect()
                        }
                    });
                    autoHide.navbar = (mode !== 'show');
                    fm.storage('autoHide', Object.assign(fm.storage('autoHide'), {navbar: autoHide.navbar}))
                }).on('touchstart', function (e) {
                    if ($(this)['scroll' + (fm.direction === 'ltr' ? 'Right' : 'Left')]() > 5) {
                        e.originalEvent._preventSwipeX = !0
                    }
                })
            }
            if (!fm.UA.Mobile) {
                handle = nav.resizable({
                    handles: ltr ? 'e' : 'w',
                    minWidth: opts.minWidth || 150,
                    maxWidth: opts.maxWidth || 500,
                    resize: function () {
                        fm.trigger('wzresize')
                    },
                    stop: function (e, ui) {
                        fm.storage('navbarWidth', ui.size.width);
                        setWzRect()
                    }
                }).on('resize scroll', function (e) {
                    var $this = $(this), tm = $this.data('posinit');
                    e.preventDefault();
                    e.stopPropagation();
                    if (!ltr && e.type === 'resize') {
                        nav.css('left', 0)
                    }
                    tm && cancelAnimationFrame(tm);
                    $this.data('posinit', requestAnimationFrame(function () {
                        var offset = (fm.UA.Opera && nav.scrollLeft()) ? 20 : 2;
                        handle.css('top', 0).css({
                            top: parseInt(nav.scrollTop()) + 'px',
                            left: ltr ? 'auto' : parseInt(nav.scrollRight() - offset) * -1,
                            right: ltr ? parseInt(nav.scrollLeft() - offset) * -1 : 'auto'
                        });
                        if (e.type === 'resize') {
                            fm.getUI('cwd').trigger('resize')
                        }
                    }))
                }).children('.ui-resizable-handle').addClass('ui-front')
            }
            if (setWidth = fm.storage('navbarWidth')) {
                nav.width(setWidth)
            } else {
                if (fm.UA.Mobile) {
                    fm.one(fm.cssloaded ? 'init' : 'cssloaded', function () {
                        var set = function () {
                            setWidth = nav.parent().width() / 2;
                            if (nav.data('defWidth') > setWidth) {
                                nav.width(setWidth)
                            } else {
                                nav.width(nav.data('defWidth'))
                            }
                            nav.data('width', nav.width());
                            fm.trigger('wzresize')
                        };
                        nav.data('defWidth', nav.width());
                        $(window).on('resize.' + fm.namespace, set);
                        set()
                    })
                }
            }
        });
        return this
    };
    $.fn.elfindernavdock = function (fm, opts) {
        this.not('.elfinder-navdock').each(function () {
            var self = $(this).hide().addClass('ui-state-default elfinder-navdock touch-punch'), node = self.parent(),
                wz = node.children('.elfinder-workzone').append(self), resize = function (to, h) {
                    var curH = h || self.height(), diff = to - curH, len = Object.keys(sizeSyncs).length,
                        calc = len ? diff / len : 0, ovf;
                    if (diff) {
                        ovf = self.css('overflow');
                        self.css('overflow', 'hidden');
                        self.height(to);
                        $.each(sizeSyncs, function (id, n) {
                            n.height(n.height() + calc).trigger('resize.' + fm.namespace)
                        });
                        fm.trigger('wzresize');
                        self.css('overflow', ovf)
                    }
                }, handle = $('<div class="ui-front ui-resizable-handle ui-resizable-n"/>').appendTo(self), sizeSyncs = {},
                resizeFn = [], initMaxHeight = (parseInt(opts.initMaxHeight) || 50) / 100,
                maxHeight = (parseInt(opts.maxHeight) || 90) / 100, basicHeight, hasNode;
            self.data('addNode', function (cNode, opts) {
                var wzH = fm.getUI('workzone').height(), imaxH = wzH * initMaxHeight, curH, tH, mH;
                opts = Object.assign({first: !1, sizeSync: !0, init: !1}, opts);
                if (!cNode.attr('id')) {
                    cNode.attr('id', fm.namespace + '-navdock-' + (+new Date()))
                }
                opts.sizeSync && (sizeSyncs[cNode.attr('id')] = cNode);
                curH = self.height();
                tH = curH + cNode.outerHeight(!0);
                if (opts.first) {
                    handle.after(cNode)
                } else {
                    self.append(cNode)
                }
                hasNode = !0;
                self.resizable('enable').height(tH).show();
                fm.trigger('wzresize');
                if (opts.init) {
                    mH = fm.storage('navdockHeight');
                    if (mH) {
                        tH = mH
                    } else {
                        tH = tH > imaxH ? imaxH : tH
                    }
                    basicHeight = tH
                }
                resize(Math.min(tH, wzH * maxHeight));
                return self
            }).data('removeNode', function (nodeId, appendTo) {
                var cNode = $('#' + nodeId);
                delete sizeSyncs[nodeId];
                self.height(self.height() - $('#' + nodeId).outerHeight(!0));
                if (appendTo) {
                    if (appendTo === 'detach') {
                        cNode = cNode.detach()
                    } else {
                        appendTo.append(cNode)
                    }
                } else {
                    cNode.remove()
                }
                if (self.children().length <= 1) {
                    hasNode = !1;
                    self.resizable('disable').height(0).hide()
                }
                fm.trigger('wzresize');
                return cNode
            });
            if (!opts.disabled) {
                fm.one('init', function () {
                    var ovf;
                    if (fm.getUI('navbar').children().not('.ui-resizable-handle').length) {
                        self.data('dockEnabled', !0);
                        self.resizable({
                            maxHeight: fm.getUI('workzone').height() * maxHeight,
                            handles: {n: handle},
                            start: function (e, ui) {
                                ovf = self.css('overflow');
                                self.css('overflow', 'hidden');
                                fm.trigger('navdockresizestart', {event: e, ui: ui}, !0)
                            },
                            resize: function (e, ui) {
                                self.css('top', '');
                                fm.trigger('wzresize', {inNavdockResize: !0})
                            },
                            stop: function (e, ui) {
                                fm.trigger('navdockresizestop', {event: e, ui: ui}, !0);
                                self.css('top', '');
                                basicHeight = ui.size.height;
                                fm.storage('navdockHeight', basicHeight);
                                resize(basicHeight, ui.originalSize.height);
                                self.css('overflow', ovf)
                            }
                        });
                        fm.bind('wzresize', function (e) {
                            var minH, maxH, h;
                            if (self.is(':visible')) {
                                maxH = fm.getUI('workzone').height() * maxHeight;
                                if (!e.data || !e.data.inNavdockResize) {
                                    h = self.height();
                                    if (maxH < basicHeight) {
                                        if (Math.abs(h - maxH) > 1) {
                                            resize(maxH)
                                        }
                                    } else {
                                        if (Math.abs(h - basicHeight) > 1) {
                                            resize(basicHeight)
                                        }
                                    }
                                }
                                self.resizable('option', 'maxHeight', maxH)
                            }
                        }).bind('themechange', function () {
                            var oldH = Math.round(self.height());
                            requestAnimationFrame(function () {
                                var curH = Math.round(self.height()), diff = oldH - curH;
                                if (diff !== 0) {
                                    resize(self.height(), curH - diff)
                                }
                            })
                        })
                    }
                    fm.bind('navbarshow navbarhide', function (e) {
                        self[hasNode && e.type === 'navbarshow' ? 'show' : 'hide']()
                    })
                })
            }
        });
        return this
    };
    $.fn.elfinderoverlay = function (opts) {
        var fm = this.parent().elfinder('instance'), o, cnt, show, hide;
        this.filter(':not(.elfinder-overlay)').each(function () {
            opts = Object.assign({}, opts);
            $(this).addClass('ui-front ui-widget-overlay elfinder-overlay').hide().on('mousedown', function (e) {
                e.preventDefault();
                e.stopPropagation()
            }).data({
                cnt: 0, show: typeof(opts.show) == 'function' ? opts.show : function () {
                }, hide: typeof(opts.hide) == 'function' ? opts.hide : function () {
                }
            })
        });
        if (opts == 'show') {
            o = this.eq(0);
            cnt = o.data('cnt') + 1;
            show = o.data('show');
            fm.toFront(o);
            o.data('cnt', cnt);
            if (o.is(':hidden')) {
                o.show();
                show()
            }
        }
        if (opts == 'hide') {
            o = this.eq(0);
            cnt = o.data('cnt') - 1;
            hide = o.data('hide');
            o.data('cnt', cnt);
            if (cnt <= 0) {
                o.hide();
                hide()
            }
        }
        return this
    };
    $.fn.elfinderpanel = function (fm) {
        return this.each(function () {
            var panel = $(this).addClass('elfinder-panel ui-state-default ui-corner-all'),
                margin = 'margin-' + (fm.direction == 'ltr' ? 'left' : 'right');
            fm.one('load', function (e) {
                var navbar = fm.getUI('navbar');
                panel.css(margin, parseInt(navbar.outerWidth(!0)));
                navbar.on('resize', function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    panel.is(':visible') && panel.css(margin, parseInt(navbar.outerWidth(!0)))
                })
            })
        })
    };
    $.fn.elfinderpath = function (fm, options) {
        return this.each(function () {
            var query = '', target = '', mimes = [], place = 'statusbar', clHover = fm.res('class', 'hover'),
                prefix = 'path' + (elFinder.prototype.uniqueid ? elFinder.prototype.uniqueid : '') + '-',
                wzbase = $('<div class="ui-widget-header ui-helper-clearfix elfinder-workzone-path"/>'),
                path = $(this).addClass('elfinder-path').html('&nbsp;').on('mousedown', 'span.elfinder-path-dir', function (e) {
                    var hash = $(this).attr('id').substr(prefix.length);
                    e.preventDefault();
                    if (hash != fm.cwd().hash) {
                        $(this).addClass(clHover);
                        if (query) {
                            fm.exec('search', query, {target: hash, mime: mimes.join(' ')})
                        } else {
                            fm.trigger('select', {selected: [hash]}).exec('open', hash)
                        }
                    }
                }).prependTo(fm.getUI('statusbar').show()),
                roots = $('<div class="elfinder-path-roots"/>').on('click', function (e) {
                    e.stopPropagation();
                    e.preventDefault();
                    var roots = $.map(fm.roots, function (h) {
                        return fm.file(h)
                    }), raw = [];
                    $.each(roots, function (i, f) {
                        if (!f.phash && fm.root(fm.cwd().hash, !0) !== f.hash) {
                            raw.push({
                                label: fm.escape(f.i18 || f.name), icon: 'home', callback: function () {
                                    fm.exec('open', f.hash)
                                }, options: {iconClass: f.csscls || '', iconImg: f.icon || ''}
                            })
                        }
                    });
                    fm.trigger('contextmenu', {raw: raw, x: e.pageX, y: e.pageY})
                }).append('<span class="elfinder-button-icon elfinder-button-icon-menu" />').appendTo(wzbase),
                render = function (cwd) {
                    var dirs = [], names = [];
                    $.each(fm.parents(cwd), function (i, hash) {
                        var c = (cwd === hash) ? 'elfinder-path-dir elfinder-path-cwd' : 'elfinder-path-dir',
                            f = fm.file(hash), name = fm.escape(f.i18 || f.name);
                        names.push(name);
                        dirs.push('<span id="' + prefix + hash + '" class="' + c + '" title="' + names.join(fm.option('separator')) + '">' + name + '</span>')
                    });
                    return dirs.join('<span class="elfinder-path-other">' + fm.option('separator') + '</span>')
                }, toWorkzone = function () {
                    var prev;
                    path.children('span.elfinder-path-dir').attr('style', '');
                    prev = fm.direction === 'ltr' ? $('#' + prefix + fm.cwd().hash).prevAll('span.elfinder-path-dir:first') : $();
                    path.scrollLeft(prev.length ? prev.position().left : 0)
                }, fit = function () {
                    if (fm.UA.CSS.flex) {
                        return
                    }
                    var dirs = path.children('span.elfinder-path-dir'), cnt = dirs.length, m, bg = 0, ids;
                    if (place === 'workzone' || cnt < 2) {
                        dirs.attr('style', '');
                        return
                    }
                    path.width(path.css('max-width'));
                    dirs.css({maxWidth: (100 / cnt) + '%', display: 'inline-block'});
                    m = path.width() - 9;
                    path.children('span.elfinder-path-other').each(function () {
                        m -= $(this).width()
                    });
                    ids = [];
                    dirs.each(function (i) {
                        var dir = $(this), w = dir.width();
                        m -= w;
                        if (w < this.scrollWidth) {
                            ids.push(i)
                        }
                    });
                    path.width('');
                    if (ids.length) {
                        if (m > 0) {
                            m = m / ids.length;
                            $.each(ids, function (i, k) {
                                var d = $(dirs[k]);
                                d.css('max-width', d.width() + m)
                            })
                        }
                        dirs.last().attr('style', '')
                    } else {
                        dirs.attr('style', '')
                    }
                }, hasUiTree, hasUiStat;
            fm.one('init', function () {
                hasUiTree = fm.getUI('tree').length;
                hasUiStat = fm.getUI('stat').length;
                if (!hasUiTree && options.toWorkzoneWithoutNavbar) {
                    wzbase.append(path).insertBefore(fm.getUI('workzone'));
                    place = 'workzone';
                    fm.bind('open', toWorkzone).one('opendone', function () {
                        fm.getUI().trigger('resize')
                    })
                }
            }).bind('open searchend parents', function () {
                var dirs = [];
                query = '';
                target = '';
                mimes = [];
                path.html(render(fm.cwd().hash));
                if (Object.keys(fm.roots).length > 1) {
                    path.css('margin', '');
                    roots.show()
                } else {
                    path.css('margin', 0);
                    roots.hide()
                }
                !hasUiStat && fit()
            }).bind('searchstart', function (e) {
                if (e.data) {
                    query = e.data.query || '';
                    target = e.data.target || '';
                    mimes = e.data.mimes || []
                }
            }).bind('search', function (e) {
                var dirs = [], html = '';
                if (target) {
                    html = render(target)
                } else {
                    html = fm.i18n('btnAll')
                }
                path.html('<span class="elfinder-path-other">' + fm.i18n('searcresult') + ': </span>' + html);
                fit()
            }).bind('navbarshow navbarhide', function () {
                var wz = fm.getUI('workzone');
                if (this.type === 'navbarshow') {
                    fm.unbind('open', toWorkzone);
                    path.prependTo(fm.getUI('statusbar'));
                    wzbase.detach();
                    place = 'statusbar'
                } else {
                    wzbase.append(path).insertBefore(wz);
                    place = 'workzone';
                    toWorkzone();
                    fm.bind('open', toWorkzone)
                }
                fm.trigger('uiresize')
            }).bind('resize uistatchange', fit)
        })
    };
    $.fn.elfinderplaces = function (fm, opts) {
        return this.each(function () {
            var dirs = {}, c = 'class', navdir = fm.res(c, 'navdir'), collapsed = fm.res(c, 'navcollapse'),
                expanded = fm.res(c, 'navexpand'), hover = fm.res(c, 'hover'), clroot = fm.res(c, 'treeroot'),
                dropover = fm.res(c, 'adroppable'), tpl = fm.res('tpl', 'placedir'), ptpl = fm.res('tpl', 'perms'),
                spinner = $(fm.res('tpl', 'navspinner')), suffix = opts.suffix ? opts.suffix : '',
                key = 'places' + suffix, menuTimer = null, id2hash = function (id) {
                    return id.substr(6)
                }, hash2id = function (hash) {
                    return 'place-' + hash
                }, hash2elm = function (hash) {
                    return $(document.getElementById(hash2id(hash)))
                }, save = function () {
                    var hashes = [], data = {};
                    hashes = $.map(subtree.children().find('[id]'), function (n) {
                        return id2hash(n.id)
                    });
                    if (hashes.length) {
                        $.each(hashes.reverse(), function (i, h) {
                            data[h] = dirs[h]
                        })
                    } else {
                        data = null
                    }
                    fm.storage(key, data)
                }, init = function () {
                    var dat, hashes;
                    key = 'places' + (opts.suffix ? opts.suffix : ''), dirs = {};
                    dat = fm.storage(key);
                    if (typeof dat === 'string') {
                        dat = $.grep(dat.split(','), function (hash) {
                            return hash ? !0 : !1
                        });
                        $.each(dat, function (i, d) {
                            var dir = d.split('#');
                            dirs[dir[0]] = dir[1] ? dir[1] : dir[0]
                        })
                    } else if ($.isPlainObject(dat)) {
                        dirs = dat
                    }
                    fm.trigger('placesload', {dirs: dirs, storageKey: key}, !0);
                    hashes = Object.keys(dirs);
                    if (hashes.length) {
                        root.prepend(spinner);
                        fm.request({data: {cmd: 'info', targets: hashes}, preventDefault: !0}).done(function (data) {
                            var exists = {};
                            data.files && data.files.length && fm.cache(data.files);
                            $.each(data.files, function (i, f) {
                                var hash = f.hash;
                                exists[hash] = f
                            });
                            $.each(dirs, function (h, f) {
                                add(exists[h] || Object.assign({notfound: !0}, f))
                            });
                            if (fm.storage('placesState') > 0) {
                                root.trigger('click')
                            }
                        }).always(function () {
                            spinner.remove()
                        })
                    }
                }, create = function (dir, hash) {
                    return $(tpl.replace(/\{id\}/, hash2id(dir ? dir.hash : hash)).replace(/\{name\}/, fm.escape(dir ? dir.i18 || dir.name : hash)).replace(/\{cssclass\}/, dir ? (fm.perms2class(dir) + (dir.notfound ? ' elfinder-na' : '') + (dir.csscls ? ' ' + dir.csscls : '')) : '').replace(/\{permissions\}/, (dir && (!dir.read || !dir.write || dir.notfound)) ? ptpl : '').replace(/\{title\}/, dir ? (' title="' + fm.escape(fm.path(dir.hash, !0) || dir.i18 || dir.name) + '"') : '').replace(/\{symlink\}/, '').replace(/\{style\}/, (dir && dir.icon) ? fm.getIconStyle(dir) : ''))
                }, add = function (dir) {
                    var node, hash;
                    if (dir.mime !== 'directory') {
                        return !1
                    }
                    hash = dir.hash;
                    if (!fm.files().hasOwnProperty(hash)) {
                        fm.trigger('tree', {tree: [dir]})
                    }
                    node = create(dir, hash);
                    dirs[hash] = dir;
                    subtree.prepend(node);
                    root.addClass(collapsed);
                    sortBtn.toggle(subtree.children().length > 1);
                    return !0
                }, remove = function (hash) {
                    var name = null, tgt, cnt;
                    if (dirs[hash]) {
                        delete dirs[hash];
                        tgt = hash2elm(hash);
                        if (tgt.length) {
                            name = tgt.text();
                            tgt.parent().remove();
                            cnt = subtree.children().length;
                            sortBtn.toggle(cnt > 1);
                            if (!cnt) {
                                root.removeClass(collapsed);
                                places.removeClass(expanded);
                                subtree.slideToggle(!1)
                            }
                        }
                    }
                    return name
                }, moveup = function (hash) {
                    var self = hash2elm(hash), tgt = self.parent(), prev = tgt.prev('div'), cls = 'ui-state-hover',
                        ctm = fm.getUI('contextmenu');
                    menuTimer && clearTimeout(menuTimer);
                    if (prev.length) {
                        ctm.find(':first').data('placesHash', hash);
                        self.addClass(cls);
                        tgt.insertBefore(prev);
                        prev = tgt.prev('div');
                        menuTimer = setTimeout(function () {
                            self.removeClass(cls);
                            if (ctm.find(':first').data('placesHash') === hash) {
                                ctm.hide().empty()
                            }
                        }, 1500)
                    }
                    if (!prev.length) {
                        self.removeClass(cls);
                        ctm.hide().empty()
                    }
                }, update = function (dir, preHash) {
                    var hash = dir.hash, tgt = hash2elm(preHash || hash), node = create(dir, hash);
                    if (tgt.length > 0) {
                        tgt.parent().replaceWith(node);
                        dirs[hash] = dir;
                        return !0
                    } else {
                        return !1
                    }
                }, clear = function () {
                    subtree.empty();
                    root.removeClass(collapsed);
                    places.removeClass(expanded);
                    subtree.slideToggle(!1)
                }, sort = function () {
                    $.each(dirs, function (h, f) {
                        var dir = fm.file(h) || f, node = create(dir, h), ret = null;
                        if (!dir) {
                            node.hide()
                        }
                        if (subtree.children().length) {
                            $.each(subtree.children(), function () {
                                var current = $(this);
                                if ((dir.i18 || dir.name).localeCompare(current.children('.' + navdir).text()) < 0) {
                                    ret = !node.insertBefore(current);
                                    return ret
                                }
                            });
                            if (ret !== null) {
                                return !0
                            }
                        }
                        !hash2elm(h).length && subtree.append(node)
                    });
                    save()
                },
                sortBtn = $('<span class="elfinder-button-icon elfinder-button-icon-sort elfinder-places-root-icon" title="' + fm.i18n('cmdsort') + '"/>').hide().on('click', function (e) {
                    e.stopPropagation();
                    subtree.empty();
                    sort()
                }), wrapper = create({
                    hash: 'root-' + fm.namespace,
                    name: fm.i18n(opts.name, 'places'),
                    read: !0,
                    write: !0
                }), root = wrapper.children('.' + navdir).addClass(clroot).on('click', function (e) {
                    e.stopPropagation();
                    if (root.hasClass(collapsed)) {
                        places.toggleClass(expanded);
                        subtree.slideToggle();
                        fm.storage('placesState', places.hasClass(expanded) ? 1 : 0)
                    }
                }).append(sortBtn), subtree = wrapper.children('.' + fm.res(c, 'navsubtree')),
                places = $(this).addClass(fm.res(c, 'tree') + ' elfinder-places ui-corner-all').hide().append(wrapper).appendTo(fm.getUI('navbar')).on('mouseenter mouseleave', '.' + navdir, function (e) {
                    $(this).toggleClass('ui-state-hover', (e.type == 'mouseenter'))
                }).on('click', '.' + navdir, function (e) {
                    var p = $(this);
                    if (p.data('longtap')) {
                        e.stopPropagation();
                        return
                    }
                    !p.hasClass('elfinder-na') && fm.exec('open', p.attr('id').substr(6))
                }).on('contextmenu', '.' + navdir + ':not(.' + clroot + ')', function (e) {
                    var self = $(this), hash = self.attr('id').substr(6);
                    e.preventDefault();
                    fm.trigger('contextmenu', {
                        raw: [{
                            label: fm.i18n('moveUp'),
                            icon: 'up',
                            remain: !0,
                            callback: function () {
                                moveup(hash);
                                save()
                            }
                        }, '|', {
                            label: fm.i18n('rmFromPlaces'), icon: 'rm', callback: function () {
                                remove(hash);
                                save()
                            }
                        }], 'x': e.pageX, 'y': e.pageY
                    });
                    self.addClass('ui-state-hover');
                    fm.getUI('contextmenu').children().on('mouseenter', function () {
                        self.addClass('ui-state-hover')
                    });
                    fm.bind('closecontextmenu', function () {
                        self.removeClass('ui-state-hover')
                    })
                }).droppable({
                    tolerance: 'pointer',
                    accept: '.elfinder-cwd-file-wrapper,.elfinder-tree-dir,.elfinder-cwd-file',
                    hoverClass: fm.res('class', 'adroppable'),
                    classes: {'ui-droppable-hover': fm.res('class', 'adroppable')},
                    over: function (e, ui) {
                        var helper = ui.helper, dir = $.grep(helper.data('files'), function (h) {
                            return (fm.file(h).mime === 'directory' && !dirs[h]) ? !0 : !1
                        });
                        e.stopPropagation();
                        helper.data('dropover', helper.data('dropover') + 1);
                        if (fm.insideWorkzone(e.pageX, e.pageY)) {
                            if (dir.length > 0) {
                                helper.addClass('elfinder-drag-helper-plus');
                                fm.trigger('unlockfiles', {files: helper.data('files'), helper: helper})
                            } else {
                                $(this).removeClass(dropover)
                            }
                        }
                    },
                    out: function (e, ui) {
                        var helper = ui.helper;
                        e.stopPropagation();
                        helper.removeClass('elfinder-drag-helper-move elfinder-drag-helper-plus').data('dropover', Math.max(helper.data('dropover') - 1, 0));
                        $(this).removeData('dropover').removeClass(dropover)
                    },
                    drop: function (e, ui) {
                        var helper = ui.helper, resolve = !0;
                        $.each(helper.data('files'), function (i, hash) {
                            var dir = fm.file(hash);
                            if (dir && dir.mime == 'directory' && !dirs[dir.hash]) {
                                add(dir)
                            } else {
                                resolve = !1
                            }
                        });
                        save();
                        resolve && helper.hide()
                    }
                }).on('touchstart', '.' + navdir + ':not(.' + clroot + ')', function (e) {
                    if (e.originalEvent.touches.length > 1) {
                        return
                    }
                    var hash = $(this).attr('id').substr(6),
                        p = $(this).addClass(hover).data('longtap', null).data('tmlongtap', setTimeout(function () {
                            p.data('longtap', !0);
                            fm.trigger('contextmenu', {
                                raw: [{
                                    label: fm.i18n('rmFromPlaces'),
                                    icon: 'rm',
                                    callback: function () {
                                        remove(hash);
                                        save()
                                    }
                                }], 'x': e.originalEvent.touches[0].pageX, 'y': e.originalEvent.touches[0].pageY
                            })
                        }, 500))
                }).on('touchmove touchend', '.' + navdir + ':not(.' + clroot + ')', function (e) {
                    clearTimeout($(this).data('tmlongtap'));
                    if (e.type == 'touchmove') {
                        $(this).removeClass(hover)
                    }
                });
            if ($.fn.sortable) {
                subtree.addClass('touch-punch').sortable({
                    appendTo: fm.getUI(), revert: !1, helper: function (e) {
                        var dir = $(e.target).parent();
                        dir.children().removeClass('ui-state-hover');
                        return $('<div class="ui-widget elfinder-place-drag elfinder-' + fm.direction + '"/>').append($('<div class="elfinder-navbar"/>').show().append(dir.clone()))
                    }, stop: function (e, ui) {
                        var target = $(ui.item[0]), top = places.offset().top, left = places.offset().left,
                            width = places.width(), height = places.height(), x = e.pageX, y = e.pageY;
                        if (!(x > left && x < left + width && y > top && y < y + height)) {
                            remove(id2hash(target.children(':first').attr('id')));
                            save()
                        }
                    }, update: function (e, ui) {
                        save()
                    }
                })
            }
            $(this).on('regist', function (e, files) {
                var added = !1;
                $.each(files, function (i, dir) {
                    if (dir && dir.mime == 'directory' && !dirs[dir.hash]) {
                        if (add(dir)) {
                            added = !0
                        }
                    }
                });
                added && save()
            });
            fm.one('load', function () {
                var dat, hashes;
                if (fm.oldAPI) {
                    return
                }
                places.show().parent().show();
                init();
                fm.change(function (e) {
                    var changed = !1;
                    $.each(e.data.changed, function (i, file) {
                        if (dirs[file.hash]) {
                            if (file.mime !== 'directory') {
                                if (remove(file.hash)) {
                                    changed = !0
                                }
                            } else {
                                if (update(file)) {
                                    changed = !0
                                }
                            }
                        }
                    });
                    changed && save()
                }).bind('rename', function (e) {
                    var changed = !1;
                    if (e.data.removed) {
                        $.each(e.data.removed, function (i, hash) {
                            if (e.data.added[i]) {
                                if (update(e.data.added[i], hash)) {
                                    changed = !0
                                }
                            }
                        })
                    }
                    changed && save()
                }).bind('rm paste', function (e) {
                    var names = [], changed = !1;
                    if (e.data.removed) {
                        $.each(e.data.removed, function (i, hash) {
                            var name = remove(hash);
                            name && names.push(name)
                        })
                    }
                    if (names.length) {
                        changed = !0
                    }
                    if (e.data.added && names.length) {
                        $.each(e.data.added, function (i, file) {
                            if ($.inArray(file.name, names) !== 1) {
                                file.mime == 'directory' && add(file)
                            }
                        })
                    }
                    changed && save()
                }).bind('sync netmount', function () {
                    var ev = this, opSuffix = opts.suffix ? opts.suffix : '', hashes;
                    if (ev.type === 'sync') {
                        if (suffix !== opSuffix) {
                            suffix = opSuffix;
                            clear();
                            init();
                            return
                        }
                    }
                    hashes = Object.keys(dirs);
                    if (hashes.length) {
                        root.prepend(spinner);
                        fm.request({data: {cmd: 'info', targets: hashes}, preventDefault: !0}).done(function (data) {
                            var exists = {}, updated = !1, cwd = fm.cwd().hash;
                            $.each(data.files || [], function (i, file) {
                                var hash = file.hash;
                                exists[hash] = file;
                                if (!fm.files().hasOwnProperty(file.hash)) {
                                    fm.trigger('tree', {tree: [file]})
                                }
                            });
                            $.each(dirs, function (h, f) {
                                if (f.notfound === Boolean(exists[h])) {
                                    if ((f.phash === cwd && ev.type !== 'netmount') || (exists[h] && exists[h].mime !== 'directory')) {
                                        if (remove(h)) {
                                            updated = !0
                                        }
                                    } else {
                                        if (update(exists[h] || Object.assign({notfound: !0}, f))) {
                                            updated = !0
                                        }
                                    }
                                } else if (exists[h] && exists[h].phash != cwd) {
                                    update(exists[h])
                                }
                            });
                            updated && save()
                        }).always(function () {
                            spinner.remove()
                        })
                    }
                })
            })
        })
    };
    $.fn.elfindersearchbutton = function (cmd) {
        return this.each(function () {
            var result = !1, fm = cmd.fm, disabled = fm.res('class', 'disabled'),
                isopts = cmd.options.incsearch || {enable: !1}, sTypes = cmd.options.searchTypes, id = function (name) {
                    return fm.namespace + fm.escape(name)
                }, toolbar = fm.getUI('toolbar'), btnCls = fm.res('class', 'searchbtn'),
                button = $(this).hide().addClass('ui-widget-content elfinder-button ' + btnCls).on('click', function (e) {
                    e.stopPropagation()
                }), getMenuOffset = function () {
                    var fmNode = fm.getUI(), baseOffset = fmNode.offset(), buttonOffset = button.offset();
                    return {top: buttonOffset.top - baseOffset.top, maxHeight: fmNode.height() - 40}
                }, search = function () {
                    input.data('inctm') && clearTimeout(input.data('inctm'));
                    var val = $.trim(input.val()), from = !$('#' + id('SearchFromAll')).prop('checked'),
                        mime = $('#' + id('SearchMime')).prop('checked'), type = '';
                    if (from) {
                        if ($('#' + id('SearchFromVol')).prop('checked')) {
                            from = fm.root(fm.cwd().hash)
                        } else {
                            from = fm.cwd().hash
                        }
                    }
                    if (mime) {
                        mime = val;
                        val = '.'
                    }
                    if (typeSet) {
                        type = typeSet.children('input:checked').val()
                    }
                    if (val) {
                        input.trigger('focus');
                        cmd.exec(val, from, mime, type).done(function () {
                            result = !0
                        }).fail(function () {
                            abort()
                        })
                    } else {
                        fm.trigger('searchend')
                    }
                }, abort = function () {
                    input.data('inctm') && clearTimeout(input.data('inctm'));
                    input.val('').trigger('blur');
                    if (result || incVal) {
                        result = !1;
                        incVal = '';
                        fm.lazy(function () {
                            fm.trigger('searchend')
                        })
                    }
                }, incVal = '', input = $('<input type="text" size="42"/>').on('focus', function () {
                    !button.hasClass('ui-state-active') && fm.getUI().click();
                    inFocus = !0;
                    incVal = '';
                    button.addClass('ui-state-active');
                    fm.trigger('uiresize');
                    opts && opts.css(getMenuOffset()).slideDown(function () {
                        button.addClass('ui-state-active');
                        fm.toFront(opts)
                    })
                }).on('blur', function () {
                    inFocus = !1;
                    if (opts) {
                        if (!opts.data('infocus')) {
                            opts.slideUp(function () {
                                button.removeClass('ui-state-active');
                                fm.trigger('uiresize');
                                fm.toHide(opts)
                            })
                        } else {
                            opts.data('infocus', !1)
                        }
                    } else {
                        button.removeClass('ui-state-active')
                    }
                }).appendTo(button).on('keypress', function (e) {
                    e.stopPropagation()
                }).on('keydown', function (e) {
                    e.stopPropagation();
                    if (e.keyCode === $.ui.keyCode.ENTER) {
                        search()
                    } else if (e.keyCode === $.ui.keyCode.ESCAPE) {
                        e.preventDefault();
                        abort()
                    }
                }), opts, typeSet, cwdReady, inFocus;
            if (isopts.enable) {
                isopts.minlen = isopts.minlen || 2;
                isopts.wait = isopts.wait || 500;
                input.attr('title', fm.i18n('incSearchOnly')).on('compositionstart', function () {
                    input.data('composing', !0)
                }).on('compositionend', function () {
                    input.removeData('composing');
                    input.trigger('input')
                }).on('input', function () {
                    if (!input.data('composing')) {
                        input.data('inctm') && clearTimeout(input.data('inctm'));
                        input.data('inctm', setTimeout(function () {
                            var val = input.val();
                            if (val.length === 0 || val.length >= isopts.minlen) {
                                (incVal !== val) && fm.trigger('incsearchstart', {
                                    query: val,
                                    type: typeSet ? typeSet.children('input:checked').val() : 'searchName'
                                });
                                incVal = val;
                                if (val === '' && fm.searchStatus.state > 1 && fm.searchStatus.query) {
                                    input.val(fm.searchStatus.query).trigger('select')
                                }
                            }
                        }, isopts.wait))
                    }
                });
                if (fm.UA.ltIE8) {
                    input.on('keydown', function (e) {
                        if (e.keyCode === 229) {
                            input.data('imetm') && clearTimeout(input.data('imetm'));
                            input.data('composing', !0);
                            input.data('imetm', setTimeout(function () {
                                input.removeData('composing')
                            }, 100))
                        }
                    }).on('keyup', function (e) {
                        input.data('imetm') && clearTimeout(input.data('imetm'));
                        if (input.data('composing')) {
                            e.keyCode === $.ui.keyCode.ENTER && input.trigger('compositionend')
                        } else {
                            input.trigger('input')
                        }
                    })
                }
            }
            $('<span class="ui-icon ui-icon-search" title="' + cmd.title + '"/>').appendTo(button).on('mousedown', function (e) {
                e.stopPropagation();
                e.preventDefault();
                if (button.hasClass('ui-state-active')) {
                    search()
                } else {
                    input.trigger('focus')
                }
            });
            $('<span class="ui-icon ui-icon-close"/>').appendTo(button).on('mousedown', function (e) {
                e.stopPropagation();
                e.preventDefault();
                if (input.val() === '' && !button.hasClass('ui-state-active')) {
                    input.trigger('focus')
                } else {
                    abort()
                }
            });
            fm.bind('toolbarload', function () {
                var parent = button.parent();
                if (parent.length) {
                    toolbar.prepend(button.show());
                    parent.remove();
                    if (fm.UA.ltIE7) {
                        var icon = button.children(fm.direction == 'ltr' ? '.ui-icon-close' : '.ui-icon-search');
                        icon.css({right: '', left: parseInt(button.width()) - icon.outerWidth(!0)})
                    }
                }
            });
            fm.one('init', function () {
                fm.getUI('cwd').on('touchstart click', function () {
                    inFocus && input.trigger('blur')
                })
            }).one('open', function () {
                opts = (fm.api < 2.1) ? null : $('<div class="ui-front ui-widget ui-widget-content elfinder-button-menu elfinder-button-search-menu ui-corner-all"/>').append($('<div class="buttonset"/>').append($('<input id="' + id('SearchFromCwd') + '" name="serchfrom" type="radio" checked="checked"/><label for="' + id('SearchFromCwd') + '">' + fm.i18n('btnCwd') + '</label>'), $('<input id="' + id('SearchFromVol') + '" name="serchfrom" type="radio"/><label for="' + id('SearchFromVol') + '">' + fm.i18n('btnVolume') + '</label>'), $('<input id="' + id('SearchFromAll') + '" name="serchfrom" type="radio"/><label for="' + id('SearchFromAll') + '">' + fm.i18n('btnAll') + '</label>')), $('<div class="buttonset elfinder-search-type"/>').append($('<input id="' + id('SearchName') + '" name="serchcol" type="radio" checked="checked" value="SearchName"/><label for="' + id('SearchName') + '">' + fm.i18n('btnFileName') + '</label>'))).hide().appendTo(fm.getUI());
                if (opts) {
                    if (sTypes) {
                        typeSet = opts.find('.elfinder-search-type');
                        $.each(cmd.options.searchTypes, function (i, v) {
                            typeSet.append($('<input id="' + id(i) + '" name="serchcol" type="radio" value="' + fm.escape(i) + '"/><label for="' + id(i) + '">' + fm.i18n(v.name) + '</label>'))
                        })
                    }
                    opts.find('div.buttonset').buttonset();
                    $('#' + id('SearchFromAll')).next('label').attr('title', fm.i18n('searchTarget', fm.i18n('btnAll')));
                    if (sTypes) {
                        $.each(sTypes, function (i, v) {
                            if (v.title) {
                                $('#' + id(i)).next('label').attr('title', fm.i18n(v.title))
                            }
                        })
                    }
                    opts.on('mousedown', 'div.buttonset', function (e) {
                        e.stopPropagation();
                        opts.data('infocus', !0)
                    }).on('click', 'input', function (e) {
                        e.stopPropagation();
                        $.trim(input.val()) ? search() : input.trigger('focus')
                    }).on('close', function () {
                        input.trigger('blur')
                    })
                }
            }).bind('searchend', function () {
                input.val('')
            }).bind('open parents', function () {
                var dirs = [], volroot = fm.file(fm.root(fm.cwd().hash));
                if (volroot) {
                    $.each(fm.parents(fm.cwd().hash), function (i, hash) {
                        dirs.push(fm.file(hash).name)
                    });
                    $('#' + id('SearchFromCwd')).next('label').attr('title', fm.i18n('searchTarget', dirs.join(fm.option('separator'))));
                    $('#' + id('SearchFromVol')).next('label').attr('title', fm.i18n('searchTarget', volroot.name))
                }
            }).bind('open', function () {
                incVal && abort()
            }).bind('cwdinit', function () {
                cwdReady = !1
            }).bind('cwdrender', function () {
                cwdReady = !0
            }).bind('keydownEsc', function () {
                if (incVal && incVal.substr(0, 1) === '/') {
                    incVal = '';
                    input.val('');
                    fm.trigger('searchend')
                }
            }).shortcut({
                pattern: 'ctrl+f f3', description: cmd.title, callback: function () {
                    input.trigger('select').trigger('focus')
                }
            }).shortcut({
                pattern: 'a b c d e f g h i j k l m n o p q r s t u v w x y z dig0 dig1 dig2 dig3 dig4 dig5 dig6 dig7 dig8 dig9 num0 num1 num2 num3 num4 num5 num6 num7 num8 num9',
                description: fm.i18n('firstLetterSearch'),
                callback: function (e) {
                    if (!cwdReady) {
                        return
                    }
                    var code = e.originalEvent.keyCode, next = function () {
                        var sel = fm.selected(),
                            key = $.ui.keyCode[(!sel.length || fm.cwdHash2Elm(sel[0]).next('[id]').length) ? 'RIGHT' : 'HOME'];
                        $(document).trigger($.Event('keydown', {
                            keyCode: key,
                            ctrlKey: !1,
                            shiftKey: !1,
                            altKey: !1,
                            metaKey: !1
                        }))
                    }, val;
                    if (code >= 96 && code <= 105) {
                        code -= 48
                    }
                    val = '/' + String.fromCharCode(code);
                    if (incVal !== val) {
                        input.val(val);
                        incVal = val;
                        fm.trigger('incsearchstart', {query: val}).one('cwdrender', next)
                    } else {
                        next()
                    }
                }
            })
        })
    };
    $.fn.elfindersortbutton = function (cmd) {
        return this.each(function () {
            var fm = cmd.fm, name = cmd.name, c = 'class', disabled = fm.res(c, 'disabled'), hover = fm.res(c, 'hover'),
                item = 'elfinder-button-menu-item', selected = item + '-selected', asc = selected + '-asc',
                desc = selected + '-desc', text = $('<span class="elfinder-button-text">' + cmd.title + '</span>'),
                button = $(this).addClass('ui-state-default elfinder-button elfinder-menubutton elfiner-button-' + name).attr('title', cmd.title).append('<span class="elfinder-button-icon elfinder-button-icon-' + name + '"/>', text).on('mouseenter mouseleave', function (e) {
                    !button.hasClass(disabled) && button.toggleClass(hover, e.type === 'mouseenter')
                }).on('click', function (e) {
                    if (!button.hasClass(disabled)) {
                        e.stopPropagation();
                        menu.is(':hidden') && fm.getUI().click();
                        menu.css(getMenuOffset()).slideToggle({
                            duration: 100, done: function (e) {
                                fm[menu.is(':visible') ? 'toFront' : 'toHide'](menu)
                            }
                        })
                    }
                }), hide = function () {
                    fm.toHide(menu)
                },
                menu = $('<div class="ui-front ui-widget ui-widget-content elfinder-button-menu elfinder-button-sort-menu ui-corner-all"/>').hide().appendTo(fm.getUI()).on('mouseenter mouseleave', '.' + item, function (e) {
                    $(this).toggleClass(hover, e.type === 'mouseenter')
                }).on('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation()
                }).on('close', hide), update = function () {
                    menu.children('[rel]').removeClass(selected + ' ' + asc + ' ' + desc).filter('[rel="' + fm.sortType + '"]').addClass(selected + ' ' + (fm.sortOrder == 'asc' ? asc : desc));
                    menu.children('.elfinder-sort-stick').toggleClass(selected, fm.sortStickFolders);
                    menu.children('.elfinder-sort-tree').toggleClass(selected, fm.sortAlsoTreeview)
                }, getMenuOffset = function () {
                    var baseOffset = fm.getUI().offset(), buttonOffset = button.offset();
                    return {top: buttonOffset.top - baseOffset.top, left: buttonOffset.left - baseOffset.left}
                }, tm;
            text.hide();
            $.each(fm.sortRules, function (name, value) {
                menu.append($('<div class="' + item + '" rel="' + name + '"><span class="ui-icon ui-icon-arrowthick-1-n"/><span class="ui-icon ui-icon-arrowthick-1-s"/>' + fm.i18n('sort' + name) + '</div>').data('type', name))
            });
            menu.children().on('click', function (e) {
                cmd.exec([], $(this).removeClass(hover).attr('rel'))
            });
            $('<div class="' + item + ' ' + item + '-separated elfinder-sort-ext elfinder-sort-stick"><span class="ui-icon ui-icon-check"/>' + fm.i18n('sortFoldersFirst') + '</div>').appendTo(menu).on('click', function () {
                cmd.exec([], 'stick')
            });
            fm.one('init', function () {
                if (fm.ui.tree && fm.options.sortAlsoTreeview !== null) {
                    $('<div class="' + item + ' ' + item + '-separated elfinder-sort-ext elfinder-sort-tree"><span class="ui-icon ui-icon-check"/>' + fm.i18n('sortAlsoTreeview') + '</div>').appendTo(menu).on('click', function () {
                        cmd.exec([], 'tree')
                    })
                }
            }).bind('disable select', hide).bind('sortchange', update).getUI().on('click', hide);
            if (menu.children().length > 1) {
                cmd.change(function () {
                    tm && cancelAnimationFrame(tm);
                    tm = requestAnimationFrame(function () {
                        button.toggleClass(disabled, cmd.disabled());
                        update()
                    })
                }).change()
            } else {
                button.addClass(disabled)
            }
        })
    };
    $.fn.elfinderstat = function (fm) {
        return this.each(function () {
            var size = $(this).addClass('elfinder-stat-size'),
                sel = $('<div class="elfinder-stat-selected"/>').on('click', 'a', function (e) {
                    var hash = $(this).data('hash');
                    e.preventDefault();
                    fm.exec('opendir', [hash])
                }), titleitems = fm.i18n('items'), titlesel = fm.i18n('selected'), titlesize = fm.i18n('size'),
                setstat = function (files) {
                    var c = 0, s = 0, cwd = fm.cwd(), calc = !0, hasSize = !0;
                    if (cwd.sizeInfo || cwd.size) {
                        s = cwd.size;
                        calc = !1
                    }
                    $.each(files, function (i, file) {
                        c++;
                        if (calc) {
                            s += parseInt(file.size) || 0;
                            if (hasSize === !0 && file.mime === 'directory' && !file.sizeInfo) {
                                hasSize = !1
                            }
                        }
                    });
                    size.html(titleitems + ': <span class="elfinder-stat-incsearch"></span>' + c + ',&nbsp;<span class="elfinder-stat-size' + (hasSize ? ' elfinder-stat-size-recursive' : '') + '">' + fm.i18n(hasSize ? 'sum' : 'size') + ': ' + fm.formatSize(s) + '</span>').attr('title', size.text());
                    fm.trigger('uistatchange')
                }, setIncsearchStat = function (data) {
                    size.find('span.elfinder-stat-incsearch').html(data ? data.hashes.length + ' / ' : '');
                    size.attr('title', size.text());
                    fm.trigger('uistatchange')
                }, setSelect = function (files) {
                    var s = 0, c = 0, dirs = [], path, file;
                    if (files.length === 1) {
                        file = files[0];
                        s = file.size;
                        if (fm.searchStatus.state === 2) {
                            path = fm.escape(file.path ? file.path.replace(/\/[^\/]*$/, '') : '..');
                            dirs.push('<a href="#elf_' + file.phash + '" data-hash="' + file.hash + '" title="' + path + '">' + path + '</a>')
                        }
                        dirs.push(fm.escape(file.i18 || file.name));
                        sel.html(dirs.join('/') + (s > 0 ? ', ' + fm.formatSize(s) : ''))
                    } else if (files.length) {
                        $.each(files, function (i, file) {
                            c++;
                            s += parseInt(file.size) || 0
                        });
                        sel.html(c ? titlesel + ': ' + c + ', ' + titlesize + ': ' + fm.formatSize(s) : '&nbsp;')
                    } else {
                        sel.html('')
                    }
                    sel.attr('title', sel.text());
                    fm.trigger('uistatchange')
                };
            fm.getUI('statusbar').prepend(size).append(sel).show();
            if (fm.UA.Mobile && $.fn.tooltip) {
                fm.getUI('statusbar').tooltip({
                    classes: {'ui-tooltip': 'elfinder-ui-tooltip ui-widget-shadow'},
                    tooltipClass: 'elfinder-ui-tooltip ui-widget-shadow',
                    track: !0
                })
            }
            fm.bind('cwdhasheschange', function (e) {
                setstat($.map(e.data, function (h) {
                    return fm.file(h)
                }))
            }).change(function (e) {
                var files = e.data.changed || [], cwdHash = fm.cwd().hash;
                $.each(files, function () {
                    if (this.hash === cwdHash) {
                        if (this.size) {
                            size.children('.elfinder-stat-size').addClass('elfinder-stat-size-recursive').html(fm.i18n('sum') + ': ' + fm.formatSize(this.size));
                            size.attr('title', size.text())
                        }
                        return !1
                    }
                })
            }).select(function () {
                setSelect(fm.selectedFiles())
            }).bind('open', function () {
                setSelect([])
            }).bind('incsearch', function (e) {
                setIncsearchStat(e.data)
            }).bind('incsearchend', function () {
                setIncsearchStat()
            })
        })
    };
    $.fn.elfindertoast = function (opts, fm) {
        var defOpts = Object.assign({
            mode: 'success',
            msg: '',
            showMethod: 'fadeIn',
            showDuration: 300,
            showEasing: 'swing',
            onShown: undefined,
            hideMethod: 'fadeOut',
            hideDuration: 1500,
            hideEasing: 'swing',
            onHidden: undefined,
            timeOut: 3000,
            extNode: undefined,
            button: undefined,
            width: undefined
        }, $.isPlainObject(fm.options.uiOptions.toast.defaults) ? fm.options.uiOptions.toast.defaults : {});
        return this.each(function () {
            opts = Object.assign({}, defOpts, opts || {});
            var self = $(this), show = function (notm) {
                self.stop();
                fm.toFront(self);
                self[opts.showMethod]({
                    duration: opts.showDuration, easing: opts.showEasing, complete: function () {
                        opts.onShown && opts.onShown();
                        if (!notm && opts.timeOut) {
                            rmTm = setTimeout(rm, opts.timeOut)
                        }
                    }
                })
            }, rm = function () {
                self[opts.hideMethod]({
                    duration: opts.hideDuration, easing: opts.hideEasing, complete: function () {
                        opts.onHidden && opts.onHidden();
                        self.remove()
                    }
                })
            }, rmTm;
            self.on('click', function (e) {
                e.stopPropagation();
                e.preventDefault();
                rmTm && clearTimeout(rmTm);
                opts.onHidden && opts.onHidden();
                self.stop().remove()
            }).on('mouseenter mouseleave', function (e) {
                if (opts.timeOut) {
                    rmTm && clearTimeout(rmTm);
                    rmTm = null;
                    if (e.type === 'mouseenter') {
                        show(!0)
                    } else {
                        rmTm = setTimeout(rm, opts.timeOut)
                    }
                }
            }).hide().addClass('toast-' + opts.mode).append($('<div class="elfinder-toast-msg"/>').html(opts.msg.replace(/%([a-zA-Z0-9]+)%/g, function (m, m1) {
                return fm.i18n(m1)
            })));
            if (opts.extNode) {
                self.append(opts.extNode)
            }
            if (opts.button) {
                self.append($('<button class="ui-button ui-widget ui-state-default ui-corner-all elfinder-tabstop"/>').append($('<span class="ui-button-text"/>').text(fm.i18n(opts.button.text))).on('mouseenter mouseleave', function (e) {
                    $(this).toggleClass('ui-state-hover', e.type == 'mouseenter')
                }).on('click', opts.button.click || function () {
                }))
            }
            if (opts.width) {
                self.css('max-width', opts.width)
            }
            show()
        })
    };
    $.fn.elfindertoolbar = function (fm, opts) {
        this.not('.elfinder-toolbar').each(function () {
            var commands = fm._commands,
                self = $(this).addClass('ui-helper-clearfix ui-widget-header elfinder-toolbar'), options = {
                    displayTextLabel: !1,
                    labelExcludeUA: ['Mobile'],
                    autoHideUA: ['Mobile'],
                    showPreferenceButton: 'none'
                }, filter = function (opts) {
                    return $.grep(opts, function (v) {
                        if ($.isPlainObject(v)) {
                            options = Object.assign(options, v);
                            return !1
                        }
                        return !0
                    })
                }, render = function (disabled) {
                    var name, cmdPref;
                    $.each(buttons, function (i, b) {
                        b.detach()
                    });
                    self.empty();
                    l = panels.length;
                    while (l--) {
                        if (panels[l]) {
                            panel = $('<div class="ui-widget-content ui-corner-all elfinder-buttonset"/>');
                            i = panels[l].length;
                            while (i--) {
                                name = panels[l][i];
                                if ((!disabled || !disabled[name]) && (cmd = commands[name])) {
                                    button = 'elfinder' + cmd.options.ui;
                                    if (!buttons[name] && $.fn[button]) {
                                        buttons[name] = $('<div/>')[button](cmd)
                                    }
                                    if (buttons[name]) {
                                        buttons[name].children('.elfinder-button-text')[textLabel ? 'show' : 'hide']();
                                        panel.prepend(buttons[name])
                                    }
                                }
                            }
                            panel.children().length && self.prepend(panel);
                            panel.children(':gt(0)').before('<span class="ui-widget-content elfinder-toolbar-button-separator"/>')
                        }
                    }
                    if (cmdPref = commands.preference) {
                        if (options.showPreferenceButton === 'always' || (!self.children().length && options.showPreferenceButton === 'auto')) {
                            panel = $('<div class="ui-widget-content ui-corner-all elfinder-buttonset"/>');
                            name = 'preference';
                            button = 'elfinder' + cmd.options.ui;
                            buttons[name] = $('<div/>')[button](cmdPref);
                            buttons[name].children('.elfinder-button-text')[textLabel ? 'show' : 'hide']();
                            panel.prepend(buttons[name]);
                            self.append(panel)
                        }
                    }
                    (!self.data('swipeClose') && self.children().length) ? self.show() : self.hide();
                    prevHeight = self[0].clientHeight;
                    fm.trigger('toolbarload').trigger('uiresize')
                }, buttons = {}, panels = filter(opts || []), dispre = null, uiCmdMapPrev = '', prevHeight = 0,
                contextRaw = [], l, i, cmd, panel, button, swipeHandle, autoHide, textLabel, resizeTm;
            options.showPreferenceButton = options.showPreferenceButton.toLowerCase();
            if (options.displayTextLabel !== 'none') {
                textLabel = fm.storage('toolbarTextLabel');
                if (textLabel === null) {
                    textLabel = (options.displayTextLabel && (!options.labelExcludeUA || !options.labelExcludeUA.length || !$.grep(options.labelExcludeUA, function (v) {
                        return fm.UA[v] ? !0 : !1
                    }).length))
                } else {
                    textLabel = (textLabel == 1)
                }
                contextRaw.push({
                    label: fm.i18n('textLabel'), icon: 'text', callback: function () {
                        textLabel = !textLabel;
                        self.css('height', '').find('.elfinder-button-text')[textLabel ? 'show' : 'hide']();
                        fm.trigger('uiresize').storage('toolbarTextLabel', textLabel ? '1' : '0')
                    },
                })
            }
            if (options.preferenceInContextmenu && commands.preference) {
                contextRaw.push({
                    label: fm.i18n('toolbarPref'), icon: 'preference', callback: function () {
                        fm.exec('preference', void(0), {tab: 'toolbar'})
                    }
                })
            }
            if (contextRaw.length) {
                self.on('contextmenu', function (e) {
                    e.stopPropagation();
                    e.preventDefault();
                    fm.trigger('contextmenu', {raw: contextRaw, x: e.pageX, y: e.pageY})
                }).on('touchstart', function (e) {
                    if (e.originalEvent.touches.length > 1) {
                        return
                    }
                    self.data('tmlongtap') && clearTimeout(self.data('tmlongtap'));
                    self.removeData('longtap').data('longtap', {
                        x: e.originalEvent.touches[0].pageX,
                        y: e.originalEvent.touches[0].pageY
                    }).data('tmlongtap', setTimeout(function () {
                        self.removeData('longtapTm').trigger({
                            type: 'contextmenu',
                            pageX: self.data('longtap').x,
                            pageY: self.data('longtap').y
                        }).data('longtap', {longtap: !0})
                    }, 500))
                }).on('touchmove touchend', function (e) {
                    if (self.data('tmlongtap')) {
                        if (e.type === 'touchend' || (Math.abs(self.data('longtap').x - e.originalEvent.touches[0].pageX) + Math.abs(self.data('longtap').y - e.originalEvent.touches[0].pageY)) > 4)
                            clearTimeout(self.data('tmlongtap'));
                        self.removeData('longtapTm')
                    }
                }).on('click', function (e) {
                    if (self.data('longtap') && self.data('longtap').longtap) {
                        e.stopImmediatePropagation();
                        e.preventDefault()
                    }
                }).on('touchend click', '.elfinder-button', function (e) {
                    if (self.data('longtap') && self.data('longtap').longtap) {
                        e.stopImmediatePropagation();
                        e.preventDefault()
                    }
                })
            }
            self.prev().length && self.parent().prepend(this);
            render();
            fm.bind('open sync select toolbarpref', function () {
                var disabled = Object.assign({}, fm.option('disabledFlip')), userHides = fm.storage('toolbarhides'),
                    doRender, sel, disabledKeys;
                if (!userHides && Array.isArray(options.defaultHides)) {
                    userHides = {};
                    $.each(options.defaultHides, function () {
                        userHides[this] = !0
                    });
                    fm.storage('toolbarhides', userHides)
                }
                if (this.type === 'select') {
                    if (fm.searchStatus.state < 2) {
                        return
                    }
                    sel = fm.selected();
                    if (sel.length) {
                        disabled = fm.getDisabledCmds(sel, !0)
                    }
                }
                $.each(userHides, function (n) {
                    if (!disabled[n]) {
                        disabled[n] = !0
                    }
                });
                if (Object.keys(fm.commandMap).length) {
                    $.each(fm.commandMap, function (from, to) {
                        if (to === 'hidden') {
                            disabled[from] = !0
                        }
                    })
                }
                disabledKeys = Object.keys(disabled);
                if (!dispre || dispre.toString() !== disabledKeys.sort().toString()) {
                    render(disabledKeys.length ? disabled : null);
                    doRender = !0
                }
                dispre = disabledKeys.sort();
                if (doRender || uiCmdMapPrev !== JSON.stringify(fm.commandMap)) {
                    uiCmdMapPrev = JSON.stringify(fm.commandMap);
                    if (!doRender) {
                        $.each($('div.elfinder-button'), function () {
                            var origin = $(this).data('origin');
                            if (origin) {
                                $(this).after(origin).detach()
                            }
                        })
                    }
                    if (Object.keys(fm.commandMap).length) {
                        $.each(fm.commandMap, function (from, to) {
                            var cmd = fm._commands[to], button = cmd ? 'elfinder' + cmd.options.ui : null, btn;
                            if (button && $.fn[button]) {
                                btn = buttons[from];
                                if (btn) {
                                    if (!buttons[to] && $.fn[button]) {
                                        buttons[to] = $('<div/>')[button](cmd);
                                        if (buttons[to]) {
                                            buttons[to].children('.elfinder-button-text')[textLabel ? 'show' : 'hide']();
                                            if (cmd.extendsCmd) {
                                                buttons[to].children('span.elfinder-button-icon').addClass('elfinder-button-icon-' + cmd.extendsCmd)
                                            }
                                        }
                                    }
                                    if (buttons[to]) {
                                        btn.after(buttons[to]);
                                        buttons[to].data('origin', btn.detach())
                                    }
                                }
                            }
                        })
                    }
                }
            }).bind('resize', function (e) {
                resizeTm && cancelAnimationFrame(resizeTm);
                resizeTm = requestAnimationFrame(function () {
                    var h = self[0].clientHeight;
                    if (prevHeight !== h) {
                        prevHeight = h;
                        fm.trigger('uiresize')
                    }
                })
            });
            if (fm.UA.Touch) {
                autoHide = fm.storage('autoHide') || {};
                if (typeof autoHide.toolbar === 'undefined') {
                    autoHide.toolbar = (options.autoHideUA && options.autoHideUA.length > 0 && $.grep(options.autoHideUA, function (v) {
                        return fm.UA[v] ? !0 : !1
                    }).length);
                    fm.storage('autoHide', autoHide)
                }
                if (autoHide.toolbar) {
                    fm.one('init', function () {
                        fm.uiAutoHide.push(function () {
                            self.stop(!0, !0).trigger('toggle', {duration: 500, init: !0})
                        })
                    })
                }
                fm.bind('load', function () {
                    swipeHandle = $('<div class="elfinder-toolbar-swipe-handle"/>').hide().appendTo(fm.getUI());
                    if (swipeHandle.css('pointer-events') !== 'none') {
                        swipeHandle.remove();
                        swipeHandle = null
                    }
                });
                self.on('toggle', function (e, data) {
                    var wz = fm.getUI('workzone'), toshow = self.is(':hidden'), wzh = wz.height(), h = self.height(),
                        tbh = self.outerHeight(!0), delta = tbh - h, opt = Object.assign({
                            step: function (now) {
                                wz.height(wzh + (toshow ? (now + delta) * -1 : h - now));
                                fm.trigger('resize')
                            }, always: function () {
                                requestAnimationFrame(function () {
                                    self.css('height', '');
                                    fm.trigger('uiresize');
                                    if (swipeHandle) {
                                        if (toshow) {
                                            swipeHandle.stop(!0, !0).hide()
                                        } else {
                                            swipeHandle.height(data.handleH ? data.handleH : '');
                                            fm.resources.blink(swipeHandle, 'slowonce')
                                        }
                                    }
                                    toshow && self.scrollTop('0px');
                                    data.init && fm.trigger('uiautohide')
                                })
                            }
                        }, data);
                    self.data('swipeClose', !toshow).stop(!0, !0).animate({height: 'toggle'}, opt);
                    autoHide.toolbar = !toshow;
                    fm.storage('autoHide', Object.assign(fm.storage('autoHide'), {toolbar: autoHide.toolbar}))
                }).on('touchstart', function (e) {
                    if (self.scrollBottom() > 5) {
                        e.originalEvent._preventSwipeY = !0
                    }
                })
            }
        });
        return this
    };
    $.fn.elfindertree = function (fm, opts) {
        var treeclass = fm.res('class', 'tree');
        this.not('.' + treeclass).each(function () {
            var c = 'class', mobile = fm.UA.Mobile, root = fm.res(c, 'treeroot'), openRoot = opts.openRootOnLoad,
                openCwd = opts.openCwdOnOpen, syncTree = openCwd || opts.syncTree, subtree = fm.res(c, 'navsubtree'),
                navdir = fm.res(c, 'treedir'), selNavdir = 'span.' + navdir, collapsed = fm.res(c, 'navcollapse'),
                expanded = fm.res(c, 'navexpand'), loaded = 'elfinder-subtree-loaded',
                chksubdir = 'elfinder-subtree-chksubdir', arrow = fm.res(c, 'navarrow'), active = fm.res(c, 'active'),
                dropover = fm.res(c, 'adroppable'), hover = fm.res(c, 'hover'), disabled = fm.res(c, 'disabled'),
                draggable = fm.res(c, 'draggable'), droppable = fm.res(c, 'droppable'),
                wrapperRoot = 'elfinder-navbar-wrapper-root', pastable = 'elfinder-navbar-wrapper-pastable',
                uploadable = 'elfinder-navbar-wrapper-uploadable', insideNavbar = function (x) {
                    var left = navbar.offset().left;
                    return left <= x && x <= left + navbar.width()
                }, subdirsQue = {}, subdirsExecQue = [], subdirs = function (ids) {
                    var targets = [];
                    $.each(ids, function (i, id) {
                        subdirsQue[id] && targets.push(fm.navId2Hash(id));
                        delete subdirsQue[id]
                    });
                    if (targets.length) {
                        return fm.request({
                            data: {
                                cmd: 'subdirs',
                                targets: targets,
                                preventDefault: !0
                            }
                        }).done(function (res) {
                            if (res && res.subdirs) {
                                $.each(res.subdirs, function (hash, subdirs) {
                                    var elm = fm.navHash2Elm(hash);
                                    elm.removeClass(chksubdir);
                                    elm[subdirs ? 'addClass' : 'removeClass'](collapsed)
                                })
                            }
                        })
                    }
                }, subdirsJobRes = null, checkSubdirs = function () {
                    var ids = Object.keys(subdirsQue);
                    if (ids.length) {
                        subdirsJobRes && subdirsJobRes._abort();
                        execSubdirsTm && clearTimeout(execSubdirsTm);
                        subdirsExecQue = [];
                        subdirsJobRes = fm.asyncJob(function (id) {
                            return fm.isInWindow($('#' + id)) ? id : null
                        }, ids, {numPerOnce: 200}).done(function (arr) {
                            if (arr.length) {
                                subdirsExecQue = arr;
                                execSubdirs()
                            }
                        })
                    }
                }, subdirsPending = 0, execSubdirsTm, execSubdirs = function () {
                    var cnt = opts.subdirsMaxConn - subdirsPending,
                        atOnce = fm.maxTargets ? Math.min(fm.maxTargets, opts.subdirsAtOnce) : opts.subdirsAtOnce, i, ids;
                    execSubdirsTm && cancelAnimationFrame(execSubdirsTm);
                    if (subdirsExecQue.length) {
                        if (cnt > 0) {
                            for (i = 0; i < cnt; i++) {
                                if (subdirsExecQue.length) {
                                    subdirsPending++;
                                    subdirs(subdirsExecQue.splice(0, atOnce)).always(function () {
                                        subdirsPending--;
                                        execSubdirs()
                                    })
                                }
                            }
                        } else {
                            execSubdirsTm = requestAnimationFrame(function () {
                                subdirsExecQue.length && execSubdirs()
                            })
                        }
                    }
                }, drop = fm.droppable.drop, droppableopts = $.extend(!0, {}, fm.droppable, {
                    over: function (e, ui) {
                        var dst = $(this), helper = ui.helper, cl = hover + ' ' + dropover, hash, status;
                        e.stopPropagation();
                        helper.data('dropover', helper.data('dropover') + 1);
                        dst.data('dropover', !0);
                        if (ui.helper.data('namespace') !== fm.namespace || !fm.insideWorkzone(e.pageX, e.pageY)) {
                            dst.removeClass(cl);
                            helper.removeClass('elfinder-drag-helper-move elfinder-drag-helper-plus');
                            return
                        }
                        if (!insideNavbar(e.clientX)) {
                            dst.removeClass(cl);
                            return
                        }
                        helper.removeClass('elfinder-drag-helper-move elfinder-drag-helper-plus');
                        dst.addClass(hover);
                        if (dst.is('.' + collapsed + ':not(.' + expanded + ')')) {
                            dst.data('expandTimer', setTimeout(function () {
                                dst.is('.' + collapsed + '.' + hover) && dst.children('.' + arrow).trigger('click')
                            }, 500))
                        }
                        if (dst.is('.elfinder-ro,.elfinder-na')) {
                            dst.removeClass(dropover);
                            return
                        }
                        hash = fm.navId2Hash(dst.attr('id'));
                        dst.data('dropover', hash);
                        $.each(ui.helper.data('files'), function (i, h) {
                            if (h === hash || (fm.file(h).phash === hash && !ui.helper.hasClass('elfinder-drag-helper-plus'))) {
                                dst.removeClass(cl);
                                return !1
                            }
                        });
                        if (helper.data('locked')) {
                            status = 'elfinder-drag-helper-plus'
                        } else {
                            status = 'elfinder-drag-helper-move';
                            if (e.shiftKey || e.ctrlKey || e.metaKey) {
                                status += ' elfinder-drag-helper-plus'
                            }
                        }
                        dst.hasClass(dropover) && helper.addClass(status);
                        requestAnimationFrame(function () {
                            dst.hasClass(dropover) && helper.addClass(status)
                        })
                    }, out: function (e, ui) {
                        var dst = $(this), helper = ui.helper;
                        e.stopPropagation();
                        if (insideNavbar(e.clientX)) {
                            helper.removeClass('elfinder-drag-helper-move elfinder-drag-helper-plus')
                        }
                        helper.data('dropover', Math.max(helper.data('dropover') - 1, 0));
                        dst.data('expandTimer') && clearTimeout(dst.data('expandTimer'));
                        dst.removeData('dropover').removeClass(hover + ' ' + dropover)
                    }, deactivate: function () {
                        $(this).removeData('dropover').removeClass(hover + ' ' + dropover)
                    }, drop: function (e, ui) {
                        insideNavbar(e.clientX) && drop.call(this, e, ui)
                    }
                }), spinner = $(fm.res('tpl', 'navspinner')), tpl = fm.res('tpl', 'navdir'), ptpl = fm.res('tpl', 'perms'),
                ltpl = fm.res('tpl', 'lock'), stpl = fm.res('tpl', 'symlink'), hasMoreDirs = {}, replace = {
                    id: function (dir) {
                        return fm.navHash2Id(dir.hash)
                    }, name: function (dir) {
                        return fm.escape(dir.i18 || dir.name)
                    }, cssclass: function (dir) {
                        var cname = (dir.phash && !dir.isroot ? '' : root) + ' ' + navdir + ' ' + fm.perms2class(dir);
                        dir.dirs && !dir.link && (cname += ' ' + collapsed) && dir.dirs == -1 && (cname += ' ' + chksubdir);
                        opts.getClass && (cname += ' ' + opts.getClass(dir));
                        dir.csscls && (cname += ' ' + fm.escape(dir.csscls));
                        return cname
                    }, title: function (dir) {
                        return opts.attrTitle ? (' title="' + fm.escape(fm.path(dir.hash, !0) || dir.i18 || dir.name) + '"') : ''
                    }, root: function (dir) {
                        var cls = '';
                        if (!dir.phash || dir.isroot) {
                            cls += ' ' + wrapperRoot;
                            if (!dir.disabled || dir.disabled.length < 1) {
                                cls += ' ' + pastable + ' ' + uploadable
                            } else {
                                if ($.inArray('paste', dir.disabled) === -1) {
                                    cls += ' ' + pastable
                                }
                                if ($.inArray('upload', dir.disabled) === -1) {
                                    cls += ' ' + uploadable
                                }
                            }
                            return cls
                        } else {
                            return ''
                        }
                    }, permissions: function (dir) {
                        return !dir.read || !dir.write ? ptpl : ''
                    }, symlink: function (dir) {
                        return dir.alias ? stpl : ''
                    }, style: function (dir) {
                        return dir.icon ? fm.getIconStyle(dir) : ''
                    }
                }, itemhtml = function (dir) {
                    return tpl.replace(/(?:\{([a-z]+)\})/ig, function (m, key) {
                        var res = replace[key] ? replace[key](dir) : (dir[key] || '');
                        if (key === 'id' && dir.dirs == -1) {
                            subdirsQue[res] = res
                        }
                        return res
                    })
                }, filter = function (files, checkExists) {
                    return $.map(files || [], function (f) {
                        return (f.mime === 'directory' && (!checkExists || fm.navHash2Elm(f.hash).length)) ? f : null
                    })
                }, findSubtree = function (hash) {
                    return hash ? fm.navHash2Elm(hash).next('.' + subtree) : tree
                }, findSibling = function (subtree, dir) {
                    var node = subtree.children(':first'), info;
                    while (node.length) {
                        info = fm.file(fm.navId2Hash(node.children('[id]').attr('id')));
                        if ((info = fm.file(fm.navId2Hash(node.children('[id]').attr('id')))) && compare(dir, info) < 0) {
                            return node
                        }
                        node = node.next()
                    }
                    return subtree.children('button.elfinder-navbar-pager-next')
                }, updateTree = function (dirs) {
                    var length = dirs.length, orphans = [], i = length, tgts = $(), done = {}, cwd = fm.cwd(),
                        append = function (parent, dirs, start, direction) {
                            var hashes = {}, curStart = 0,
                                max = fm.newAPI ? Math.min(10000, Math.max(10, opts.subTreeMax)) : 10000,
                                setHashes = function () {
                                    hashes = {};
                                    $.each(dirs, function (i, d) {
                                        hashes[d.hash] = i
                                    })
                                }, change = function (mode) {
                                    if (mode === 'prepare') {
                                        $.each(dirs, function (i, d) {
                                            d.node && parent.append(d.node.hide())
                                        })
                                    } else if (mode === 'done') {
                                        $.each(dirs, function (i, d) {
                                            d.node && d.node.detach().show()
                                        })
                                    }
                                }, update = function (e, data) {
                                    var i, changed;
                                    e.stopPropagation();
                                    if (data.select) {
                                        render(getStart(data.select));
                                        return
                                    }
                                    if (data.change) {
                                        change(data.change);
                                        return
                                    }
                                    if (data.removed && data.removed.length) {
                                        dirs = $.grep(dirs, function (d) {
                                            if (data.removed.indexOf(d.hash) === -1) {
                                                return !0
                                            } else {
                                                !changed && (changed = !0);
                                                return !1
                                            }
                                        })
                                    }
                                    if (data.added && data.added.length) {
                                        dirs = dirs.concat($.grep(data.added, function (d) {
                                            if (hashes[d.hash] === void(0)) {
                                                !changed && (changed = !0);
                                                return !0
                                            } else {
                                                return !1
                                            }
                                        }))
                                    }
                                    if (changed) {
                                        dirs.sort(compare);
                                        setHashes();
                                        render(curStart)
                                    }
                                }, getStart = function (target) {
                                    if (hashes[target] !== void(0)) {
                                        return Math.floor(hashes[target] / max) * max
                                    }
                                    return void(0)
                                }, target = fm.navId2Hash(parent.prev('[id]').attr('id')),
                                render = function (start, direction) {
                                    var html = [], nodes = {}, total, page, s, parts, prev, next, prevBtn, nextBtn;
                                    delete hasMoreDirs[target];
                                    curStart = start;
                                    parent.off('update.' + fm.namespace, update);
                                    if (dirs.length > max) {
                                        parent.on('update.' + fm.namespace, update);
                                        if (start === void(0)) {
                                            s = 0;
                                            setHashes();
                                            start = getStart(cwd.hash);
                                            if (start === void(0)) {
                                                start = 0
                                            }
                                        }
                                        parts = dirs.slice(start, start + max);
                                        hasMoreDirs[target] = parent;
                                        prev = start ? Math.max(-1, start - max) : -1;
                                        next = (start + max >= dirs.length) ? 0 : start + max;
                                        total = Math.ceil(dirs.length / max);
                                        page = Math.ceil(start / max)
                                    }
                                    $.each(parts || dirs, function (i, d) {
                                        html.push(itemhtml(d));
                                        if (d.node) {
                                            nodes[d.hash] = d.node
                                        }
                                    });
                                    if (prev > -1) {
                                        prevBtn = $('<button class="elfinder-navbar-pager elfinder-navbar-pager-prev"/>').text(fm.i18n('btnPrevious', page, total)).button({icons: {primary: "ui-icon-caret-1-n"}}).on('click', function (e) {
                                            e.preventDefault();
                                            e.stopPropagation();
                                            render(prev, 'up')
                                        })
                                    } else {
                                        prevBtn = $()
                                    }
                                    if (next) {
                                        nextBtn = $('<button class="elfinder-navbar-pager elfinder-navbar-pager-next"/>').text(fm.i18n('btnNext', page + 2, total)).button({icons: {primary: "ui-icon-caret-1-s"}}).on('click', function (e) {
                                            e.preventDefault();
                                            e.stopPropagation();
                                            render(next, 'down')
                                        })
                                    } else {
                                        nextBtn = $()
                                    }
                                    detach();
                                    parent.empty()[parts ? 'addClass' : 'removeClass']('elfinder-navbar-hasmore').append(prevBtn, html.join(''), nextBtn);
                                    $.each(nodes, function (h, n) {
                                        fm.navHash2Elm(h).parent().replaceWith(n)
                                    });
                                    if (direction) {
                                        autoScroll(fm.navHash2Id(parts[direction === 'up' ? parts.length - 1 : 0].hash))
                                    }
                                    !mobile && fm.lazy(function () {
                                        updateDroppable(null, parent)
                                    })
                                }, detach = function () {
                                    $.each(parent.children('.elfinder-navbar-wrapper'), function (i, elm) {
                                        var n = $(elm), ch = n.children('[id]:first'), h, c;
                                        if (ch.hasClass(loaded)) {
                                            h = fm.navId2Hash(ch.attr('id'));
                                            if (h && (c = hashes[h]) !== void(0)) {
                                                dirs[c].node = n.detach()
                                            }
                                        }
                                    })
                                };
                            render()
                        }, dir, html, parent, sibling, init, atonce = {}, updates = [], base, node, firstVol = !0;
                    while (i--) {
                        dir = dirs[i];
                        if (done[dir.hash] || fm.navHash2Elm(dir.hash).length) {
                            continue
                        }
                        done[dir.hash] = !0;
                        if ((parent = findSubtree(dir.phash)).length) {
                            if (dir.phash && ((init = !parent.children().length) || parent.hasClass('elfinder-navbar-hasmore') || (sibling = findSibling(parent, dir)).length)) {
                                if (init) {
                                    if (!atonce[dir.phash]) {
                                        atonce[dir.phash] = []
                                    }
                                    atonce[dir.phash].push(dir)
                                } else {
                                    if (sibling) {
                                        node = itemhtml(dir);
                                        sibling.before(node);
                                        !mobile && (tgts = tgts.add(node))
                                    } else {
                                        updates.push(dir)
                                    }
                                }
                            } else {
                                node = itemhtml(dir);
                                parent[firstVol || dir.phash ? 'append' : 'prepend'](node);
                                firstVol = !1;
                                if (!dir.phash || dir.isroot) {
                                    base = fm.navHash2Elm(dir.hash).parent()
                                }
                                !mobile && updateDroppable(null, base)
                            }
                        } else {
                            orphans.push(dir)
                        }
                    }
                    if (Object.keys(atonce).length) {
                        $.each(atonce, function (p, dirs) {
                            var parent = findSubtree(p), html = [];
                            dirs.sort(compare);
                            append(parent, dirs)
                        })
                    }
                    if (updates.length) {
                        parent.trigger('update.' + fm.namespace, {added: updates})
                    }
                    if (orphans.length && orphans.length < length) {
                        updateTree(orphans);
                        return
                    }
                    !mobile && tgts.length && fm.lazy(function () {
                        updateDroppable(tgts)
                    })
                }, compare = function (dir1, dir2) {
                    if (!fm.sortAlsoTreeview) {
                        return fm.sortRules.name(dir1, dir2)
                    } else {
                        var asc = fm.sortOrder == 'asc', type = fm.sortType, rules = fm.sortRules, res;
                        res = asc ? rules[fm.sortType](dir1, dir2) : rules[fm.sortType](dir2, dir1);
                        return type !== 'name' && res === 0 ? res = asc ? rules.name(dir1, dir2) : rules.name(dir2, dir1) : res
                    }
                }, autoScrTm, autoScroll = function (target) {
                    var dfrd = $.Deferred(), current, parent, top, treeH, bottom, tgtTop;
                    autoScrTm && clearTimeout(autoScrTm);
                    autoScrTm = setTimeout(function () {
                        current = $(document.getElementById((target || fm.navHash2Id(fm.cwd().hash))));
                        if (current.length) {
                            (openCwd ? current : current.parent()).parents('.elfinder-navbar-wrapper').children('.' + loaded).addClass(expanded).next('.' + subtree).show();
                            parent = tree.parent().stop(!1, !0);
                            top = parent.offset().top;
                            treeH = parent.height();
                            bottom = top + treeH - current.outerHeight();
                            tgtTop = current.offset().top;
                            if (tgtTop < top || tgtTop > bottom) {
                                parent.animate({scrollTop: parent.scrollTop() + tgtTop - top - treeH / 3}, {
                                    duration: opts.durations.autoScroll,
                                    complete: function () {
                                        dfrd.resolve()
                                    }
                                })
                            } else {
                                dfrd.resolve()
                            }
                        } else {
                            dfrd.reject()
                        }
                    }, 100);
                    return dfrd
                }, getEnds = function (d) {
                    var cur = d || fm.cwd(), res = cur.hash ? [cur.hash] : [], phash, root, dir;
                    root = fm.root(cur.hash);
                    dir = fm.file(root);
                    while (dir && (phash = dir.phash)) {
                        res.unshift(phash);
                        root = fm.root(phash);
                        dir = fm.file(root);
                        if (fm.navHash2Elm(dir.hash).hasClass(loaded)) {
                            break
                        }
                    }
                    return res
                }, selectPages = function (current) {
                    var cur = current || fm.cwd(), curHash = cur.hash, node = fm.navHash2Elm(curHash);
                    if (!node.length) {
                        while (cur && cur.phash) {
                            if (hasMoreDirs[cur.phash] && !fm.navHash2Elm(cur.hash).length) {
                                hasMoreDirs[cur.phash].trigger('update.' + fm.namespace, {select: cur.hash})
                            }
                            cur = fm.file(cur.phash)
                        }
                        node = fm.navHash2Elm(curHash)
                    }
                    return node
                }, syncing, sync = function (cwdDirs, aScr) {
                    var cwd = fm.cwd(), cwdhash = cwd.hash, autoScr = aScr === void(0) ? syncTree : aScr,
                        loadParents = function (dir) {
                            var dfd = $.Deferred(), reqs = [], ends = getEnds(dir), makeReq = function (cmd, h, until) {
                                var data = {cmd: cmd, target: h};
                                if (until) {
                                    data.until = until
                                }
                                return fm.request({data: data, preventFail: !0})
                            }, baseHash, baseId;
                            reqs = $.map(ends, function (h) {
                                var d = fm.file(h), isRoot = d ? fm.isRoot(d) : !1, node = fm.navHash2Elm(h),
                                    getPhash = function (h, dep) {
                                        var d, ph, depth = dep || 1;
                                        ph = (d = fm.file(h)) ? d.phash : !1;
                                        if (ph && depth > 1) {
                                            return getPhash(ph, --depth)
                                        }
                                        return ph
                                    }, until, closest = (function () {
                                        var phash = getPhash(h);
                                        until = phash;
                                        while (phash) {
                                            if (fm.navHash2Elm(phash).hasClass(loaded)) {
                                                break
                                            }
                                            until = phash;
                                            phash = getPhash(phash)
                                        }
                                        if (!phash) {
                                            until = void(0);
                                            phash = fm.root(h)
                                        }
                                        return phash
                                    })(), cmd;
                                if (!node.hasClass(loaded) && (isRoot || !d || !fm.navHash2Elm(d.phash).hasClass(loaded))) {
                                    if (isRoot || closest === getPhash(h) || closest === getPhash(h, 2)) {
                                        until = void(0);
                                        cmd = 'tree';
                                        if (!isRoot) {
                                            h = getPhash(h)
                                        }
                                    } else {
                                        cmd = 'parents'
                                    }
                                    if (!baseHash) {
                                        baseHash = (cmd === 'tree') ? h : closest
                                    }
                                    return makeReq(cmd, h, until)
                                }
                                return null
                            });
                            if (reqs.length) {
                                selectPages(fm.file(baseHash));
                                baseId = fm.navHash2Id(baseHash);
                                autoScr && autoScroll(baseId);
                                baseNode = $('#' + baseId);
                                spinner = $(fm.res('tpl', 'navspinner')).insertBefore(baseNode.children('.' + arrow));
                                baseNode.removeClass(collapsed);
                                $.when.apply($, reqs).done(function () {
                                    var res = {}, data, treeDirs, dirs, argLen, i;
                                    argLen = arguments.length;
                                    if (argLen > 0) {
                                        for (i = 0; i < argLen; i++) {
                                            data = arguments[i].tree || [];
                                            res[ends[i]] = Object.assign([], filter(data))
                                        }
                                    }
                                    dfd.resolve(res)
                                }).fail(function () {
                                    dfd.reject()
                                });
                                return dfd
                            } else {
                                return dfd.resolve()
                            }
                        }, done = function (res, dfrd) {
                            var open = function () {
                                if (openRoot && baseNode) {
                                    findSubtree(baseNode.hash).show().prev(selNavdir).addClass(expanded);
                                    openRoot = !1
                                }
                                if (autoScr) {
                                    autoScroll().done(checkSubdirs)
                                } else {
                                    checkSubdirs()
                                }
                            }, current;
                            if (res) {
                                $.each(res, function (endHash, dirs) {
                                    dirs && updateTree(dirs);
                                    selectPages(fm.file(endHash));
                                    dirs && updateArrows(dirs, loaded)
                                })
                            }
                            if (cwdDirs) {
                                (fm.api < 2.1) && cwdDirs.push(cwd);
                                updateTree(cwdDirs)
                            }
                            current = selectPages();
                            if (!current.hasClass(active)) {
                                tree.find(selNavdir + '.' + active).removeClass(active);
                                current.addClass(active)
                            }
                            current.parents('.elfinder-navbar-wrapper').children('.' + navdir).addClass(loaded);
                            if (res) {
                                fm.lazy(open).done(function () {
                                    dfrd.resolve()
                                })
                            } else {
                                open();
                                dfrd.resolve()
                            }
                        }, rmSpinner = function (fail) {
                            if (baseNode) {
                                spinner.remove();
                                baseNode.addClass(collapsed + (fail ? '' : (' ' + loaded)))
                            }
                        }, dfrd = $.Deferred(), baseNode, spinner;
                    if (!fm.navHash2Elm(cwdhash).length) {
                        syncing = !0;
                        loadParents().done(function (res) {
                            done(res, dfrd);
                            rmSpinner()
                        }).fail(function () {
                            rmSpinner(!0);
                            dfrd.reject()
                        }).always(function () {
                            syncing = !1
                        })
                    } else {
                        done(void(0), dfrd)
                    }
                    fm.trigger('treesync', dfrd);
                    return dfrd
                }, updateDroppable = function (target, node) {
                    var limit = 100, next;
                    if (!target) {
                        if (!node || node.closest('div.' + wrapperRoot).hasClass(uploadable)) {
                            (node || tree.find('div.' + uploadable)).find(selNavdir + ':not(.elfinder-ro,.elfinder-na)').addClass('native-droppable')
                        }
                        if (!node || node.closest('div.' + wrapperRoot).hasClass(pastable)) {
                            target = (node || tree.find('div.' + pastable)).find(selNavdir + ':not(.' + droppable + ')')
                        } else {
                            target = $()
                        }
                        if (node) {
                            node.children('div.' + wrapperRoot).each(function () {
                                updateDroppable(null, $(this))
                            })
                        }
                    }
                    if (target.length) {
                        fm.asyncJob(function (elm) {
                            $(elm).droppable(droppableopts)
                        }, $.makeArray(target), {interval: 20, numPerOnce: 100})
                    }
                }, updateArrows = function (dirs, cls) {
                    var sel = cls == loaded ? '.' + collapsed + ':not(.' + loaded + ')' : ':not(.' + collapsed + ')';
                    $.each(dirs, function (i, dir) {
                        fm.navHash2Elm(dir.phash).filter(sel).filter(function () {
                            return $.grep($(this).next('.' + subtree).children(), function (n) {
                                return ($(n).children().hasClass(root)) ? !1 : !0
                            }).length > 0
                        }).addClass(cls)
                    })
                }, tree = $(this).addClass(treeclass).on('mouseenter mouseleave', selNavdir, function (e) {
                    var enter = (e.type === 'mouseenter');
                    if (enter && scrolling) {
                        return
                    }
                    var link = $(this), hash, dir;
                    if (!link.hasClass(dropover + ' ' + disabled)) {
                        if (!mobile && enter && !link.data('dragRegisted') && !link.hasClass(root + ' ' + draggable + ' elfinder-na elfinder-wo')) {
                            link.data('dragRegisted', !0);
                            if (fm.isCommandEnabled('copy', (hash = fm.navId2Hash(link.attr('id'))))) {
                                link.draggable(fm.draggable)
                            }
                        }
                        link.toggleClass(hover, enter)
                    }
                    if (enter && opts.attrTitle) {
                        dir = fm.file(hash || fm.navId2Hash(link.attr('id')));
                        if (!dir.isroot && link.attr('title') === (dir.i18 || dir.name)) {
                            link.attr('title', fm.path(hash, !0))
                        }
                    }
                }).on('dragenter', selNavdir, function (e) {
                    if (e.originalEvent.dataTransfer) {
                        var dst = $(this);
                        dst.addClass(hover);
                        if (dst.is('.' + collapsed + ':not(.' + expanded + ')')) {
                            dst.data('expandTimer', setTimeout(function () {
                                dst.is('.' + collapsed + '.' + hover) && dst.children('.' + arrow).trigger('click')
                            }, 500))
                        }
                    }
                }).on('dragleave', selNavdir, function (e) {
                    if (e.originalEvent.dataTransfer) {
                        var dst = $(this);
                        dst.data('expandTimer') && clearTimeout(dst.data('expandTimer'));
                        dst.removeClass(hover)
                    }
                }).on('click', selNavdir, function (e) {
                    var link = $(this), hash = fm.navId2Hash(link.attr('id')), file = fm.file(hash);
                    if (link.data('longtap')) {
                        link.removeData('longtap');
                        e.stopPropagation();
                        return
                    }
                    if (!link.hasClass(active)) {
                        tree.find(selNavdir + '.' + active).removeClass(active);
                        link.addClass(active)
                    }
                    if (hash != fm.cwd().hash && !link.hasClass(disabled)) {
                        fm.exec('open', hash).done(function () {
                            fm.one('opendone', function () {
                                fm.select({selected: [hash], origin: 'navbar'})
                            })
                        })
                    } else {
                        if (link.hasClass(collapsed)) {
                            link.children('.' + arrow).trigger('click')
                        }
                        fm.select({selected: [hash], origin: 'navbar'})
                    }
                }).on('touchstart', selNavdir, function (e) {
                    if (e.originalEvent.touches.length > 1) {
                        return
                    }
                    var evt = e.originalEvent, p;
                    if (e.target.nodeName === 'INPUT') {
                        e.stopPropagation();
                        return
                    }
                    p = $(this).addClass(hover).removeData('longtap').data('tmlongtap', setTimeout(function (e) {
                        p.data('longtap', !0);
                        fm.trigger('contextmenu', {
                            'type': 'navbar',
                            'targets': [fm.navId2Hash(p.attr('id'))],
                            'x': evt.touches[0].pageX,
                            'y': evt.touches[0].pageY
                        })
                    }, 500))
                }).on('touchmove touchend', selNavdir, function (e) {
                    if (e.target.nodeName === 'INPUT') {
                        e.stopPropagation();
                        return
                    }
                    clearTimeout($(this).data('tmlongtap'));
                    $(this).removeData('tmlongtap');
                    if (e.type == 'touchmove') {
                        $(this).removeClass(hover)
                    }
                }).on('click', selNavdir + '.' + collapsed + ' .' + arrow, function (e) {
                    var arrow = $(this), link = arrow.parent(selNavdir), stree = link.next('.' + subtree),
                        dfrd = $.Deferred(), slideTH = 30, cnt;
                    e.stopPropagation();
                    if (link.hasClass(loaded)) {
                        link.toggleClass(expanded);
                        fm.lazy(function () {
                            cnt = link.hasClass(expanded) ? stree.children().length + stree.find('div.elfinder-navbar-subtree[style*=block]').children().length : stree.find('div:visible').length;
                            if (cnt > slideTH) {
                                stree.toggle();
                                fm.draggingUiHelper && fm.draggingUiHelper.data('refreshPositions', 1);
                                checkSubdirs()
                            } else {
                                stree.stop(!0, !0)[link.hasClass(expanded) ? 'slideDown' : 'slideUp'](opts.durations.slideUpDown, function () {
                                    fm.draggingUiHelper && fm.draggingUiHelper.data('refreshPositions', 1);
                                    checkSubdirs()
                                })
                            }
                        }).always(function () {
                            dfrd.resolve()
                        })
                    } else {
                        spinner.insertBefore(arrow);
                        link.removeClass(collapsed);
                        fm.request({cmd: 'tree', target: fm.navId2Hash(link.attr('id'))}).done(function (data) {
                            updateTree(Object.assign([], filter(data.tree)));
                            if (stree.children().length) {
                                link.addClass(collapsed + ' ' + expanded);
                                if (stree.children().length > slideTH) {
                                    stree.show();
                                    fm.draggingUiHelper && fm.draggingUiHelper.data('refreshPositions', 1);
                                    checkSubdirs()
                                } else {
                                    stree.stop(!0, !0).slideDown(opts.durations.slideUpDown, function () {
                                        fm.draggingUiHelper && fm.draggingUiHelper.data('refreshPositions', 1);
                                        checkSubdirs()
                                    })
                                }
                            }
                        }).always(function (data) {
                            spinner.remove();
                            link.addClass(loaded);
                            fm.one('treedone', function () {
                                dfrd.resolve()
                            })
                        })
                    }
                    arrow.data('dfrd', dfrd)
                }).on('contextmenu', selNavdir, function (e) {
                    var self = $(this);
                    if (self.find('input:text').length) {
                        e.stopPropagation();
                        return
                    }
                    e.preventDefault();
                    if (!self.data('tmlongtap')) {
                        fm.trigger('contextmenu', {
                            'type': 'navbar',
                            'targets': [fm.navId2Hash($(this).attr('id'))],
                            'x': e.pageX,
                            'y': e.pageY
                        })
                    }
                    self.addClass('ui-state-hover');
                    fm.getUI('contextmenu').children().on('mouseenter', function () {
                        self.addClass('ui-state-hover')
                    });
                    fm.bind('closecontextmenu', function () {
                        self.removeClass('ui-state-hover')
                    })
                }).on('scrolltoview', selNavdir, function (e, data) {
                    var self = $(this);
                    autoScroll(self.attr('id')).done(function () {
                        if (!data || data.blink === 'undefined' || data.blink) {
                            fm.resources.blink(self, 'lookme')
                        }
                    })
                }).on('create.' + fm.namespace, function (e, item) {
                    var pdir = findSubtree(item.phash), lock = item.move || !1,
                        dir = $(itemhtml(item)).addClass('elfinder-navbar-wrapper-tmp'), selected = fm.selected();
                    lock && selected.length && fm.trigger('lockfiles', {files: selected});
                    pdir.prepend(dir)
                }), scrolling = !1, navbarScrTm, navbar = fm.getUI('navbar').append(tree).show().on('scroll', function () {
                    scrolling = !0;
                    navbarScrTm && cancelAnimationFrame(navbarScrTm);
                    navbarScrTm = requestAnimationFrame(function () {
                        scrolling = !1;
                        checkSubdirs()
                    })
                }), prevSortTreeview = fm.sortAlsoTreeview;
            fm.open(function (e) {
                var data = e.data, dirs = filter(data.files), contextmenu = fm.getUI('contextmenu');
                data.init && tree.empty();
                if (fm.UA.iOS) {
                    navbar.removeClass('overflow-scrolling-touch').addClass('overflow-scrolling-touch')
                }
                if (dirs.length) {
                    fm.lazy(function () {
                        if (!contextmenu.data('cmdMaps')) {
                            contextmenu.data('cmdMaps', {})
                        }
                        updateTree(dirs);
                        updateArrows(dirs, loaded);
                        sync(dirs)
                    })
                } else {
                    sync()
                }
            }).add(function (e) {
                var dirs = filter(e.data.added);
                if (dirs.length) {
                    updateTree(dirs);
                    updateArrows(dirs, collapsed)
                }
            }).change(function (e) {
                if (syncing) {
                    return
                }
                var dirs = filter(e.data.changed, !0), length = dirs.length, l = length, tgts = $(), changed = {}, dir,
                    phash, node, tmp, realParent, reqParent, realSibling, reqSibling, isExpanded, isLoaded, parent,
                    subdirs;
                $.each(hasMoreDirs, function (h, node) {
                    node.trigger('update.' + fm.namespace, {change: 'prepare'})
                });
                while (l--) {
                    dir = dirs[l];
                    phash = dir.phash;
                    if ((node = fm.navHash2Elm(dir.hash)).length) {
                        parent = node.parent();
                        if (phash) {
                            realParent = node.closest('.' + subtree);
                            reqParent = findSubtree(phash);
                            realSibling = node.parent().next();
                            reqSibling = findSibling(reqParent, dir);
                            if (!reqParent.length) {
                                continue
                            }
                            if (reqParent[0] !== realParent[0] || realSibling.get(0) !== reqSibling.get(0)) {
                                reqSibling.length ? reqSibling.before(parent) : reqParent.append(parent)
                            }
                        }
                        isExpanded = node.hasClass(expanded);
                        isLoaded = node.hasClass(loaded);
                        tmp = $(itemhtml(dir));
                        node.replaceWith(tmp.children(selNavdir));
                        !mobile && updateDroppable(null, parent);
                        if (dir.dirs && (isExpanded || isLoaded) && (node = fm.navHash2Elm(dir.hash)) && node.next('.' + subtree).children().length) {
                            isExpanded && node.addClass(expanded);
                            isLoaded && node.addClass(loaded)
                        }
                        subdirs |= dir.dirs == -1
                    }
                }
                if (subdirs) {
                    checkSubdirs()
                }
                $.each(hasMoreDirs, function (h, node) {
                    node.trigger('update.' + fm.namespace, {change: 'done'})
                });
                length && sync(void(0), !1)
            }).remove(function (e) {
                var dirs = e.data.removed, l = dirs.length, node, stree, removed;
                $.each(hasMoreDirs, function (h, node) {
                    node.trigger('update.' + fm.namespace, {removed: dirs});
                    node.trigger('update.' + fm.namespace, {change: 'prepare'})
                });
                while (l--) {
                    if ((node = fm.navHash2Elm(dirs[l])).length) {
                        removed = !0;
                        stree = node.closest('.' + subtree);
                        node.parent().detach();
                        if (!stree.children().length) {
                            stree.hide().prev(selNavdir).removeClass(collapsed + ' ' + expanded + ' ' + loaded)
                        }
                    }
                }
                removed && fm.getUI('navbar').children('.ui-resizable-handle').trigger('resize');
                $.each(hasMoreDirs, function (h, node) {
                    node.trigger('update.' + fm.namespace, {change: 'done'})
                })
            }).bind('lockfiles unlockfiles', function (e) {
                var lock = e.type == 'lockfiles', helperLocked = e.data.helper ? e.data.helper.data('locked') : !1,
                    act = (lock && !helperLocked) ? 'disable' : 'enable',
                    dirs = $.grep(e.data.files || [], function (h) {
                        var dir = fm.file(h);
                        return dir && dir.mime == 'directory' ? !0 : !1
                    });
                $.each(dirs, function (i, hash) {
                    var dir = fm.navHash2Elm(hash);
                    if (dir.length && !helperLocked) {
                        dir.hasClass(draggable) && dir.draggable(act);
                        dir.hasClass(droppable) && dir.droppable(act);
                        dir[lock ? 'addClass' : 'removeClass'](disabled)
                    }
                })
            }).bind('sortchange', function () {
                if (fm.sortAlsoTreeview || prevSortTreeview !== fm.sortAlsoTreeview) {
                    var dirs, ends = [], endsMap = {}, endsVid = {}, topVid = '', single = !1, current;
                    fm.lazy(function () {
                        dirs = filter(fm.files());
                        prevSortTreeview = fm.sortAlsoTreeview;
                        tree.empty();
                        updateTree($.map(fm.roots, function (h) {
                            var dir = fm.file(h);
                            return dir && !dir.phash ? dir : null
                        }));
                        if (!Object.keys(hasMoreDirs).length) {
                            updateTree(dirs);
                            current = selectPages();
                            updateArrows(dirs, loaded)
                        } else {
                            ends = getEnds();
                            if (ends.length > 1) {
                                $.each(ends, function (i, end) {
                                    var vid = fm.file(fm.root(end)).volumeid;
                                    if (i === 0) {
                                        topVid = vid
                                    }
                                    endsVid[vid] = end;
                                    endsMap[end] = []
                                });
                                $.each(dirs, function (i, d) {
                                    if (!d.volumeid) {
                                        single = !0;
                                        return !1
                                    }
                                    endsMap[endsVid[d.volumeid] || endsVid[topVid]].push(d)
                                })
                            } else {
                                single = !0
                            }
                            if (single) {
                                $.each(ends, function (i, endHash) {
                                    updateTree(dirs);
                                    current = selectPages(fm.file(endHash));
                                    updateArrows(dirs, loaded)
                                })
                            } else {
                                $.each(endsMap, function (endHash, dirs) {
                                    updateTree(dirs);
                                    current = selectPages(fm.file(endHash));
                                    updateArrows(dirs, loaded)
                                })
                            }
                        }
                        sync()
                    }, 100)
                }
            })
        });
        return this
    };
    $.fn.elfinderuploadbutton = function (cmd) {
        return this.each(function () {
            var fm = cmd.fm, button = $(this).elfinderbutton(cmd).off('click'), form = $('<form/>').appendTo(button),
                input = $('<input type="file" multiple="true" title="' + cmd.fm.i18n('selectForUpload') + '"/>').on('change', function () {
                    var _input = $(this);
                    if (_input.val()) {
                        fm.exec('upload', {input: _input.remove()[0]}, void(0), fm.cwd().hash);
                        input.clone(!0).appendTo(form)
                    }
                }).on('dragover', function (e) {
                    e.originalEvent.dataTransfer.dropEffect = 'copy'
                }), tm;
            form.append(input.clone(!0));
            cmd.change(function () {
                tm && cancelAnimationFrame(tm);
                tm = requestAnimationFrame(function () {
                    var toShow = cmd.disabled();
                    if (form.is('visible')) {
                        !toShow && form.hide()
                    } else {
                        toShow && form.show()
                    }
                })
            }).change()
        })
    };
    $.fn.elfinderviewbutton = function (cmd) {
        return this.each(function () {
            var button = $(this).elfinderbutton(cmd), icon = button.children('.elfinder-button-icon'),
                text = button.children('.elfinder-button-text'), tm;
            cmd.change(function () {
                tm && cancelAnimationFrame(tm);
                tm = requestAnimationFrame(function () {
                    var icons = cmd.value == 'icons';
                    icon.toggleClass('elfinder-button-icon-view-list', icons);
                    cmd.className = icons ? 'view-list' : '';
                    cmd.title = cmd.fm.i18n(icons ? 'viewlist' : 'viewicons');
                    button.attr('title', cmd.title);
                    text.html(cmd.title)
                })
            })
        })
    };
    $.fn.elfinderworkzone = function (fm) {
        var cl = 'elfinder-workzone';
        this.not('.' + cl).each(function () {
            var wz = $(this).addClass(cl), prevH = Math.round(wz.height()), parent = wz.parent(),
                setDelta = function () {
                    wdelta = wz.outerHeight(!0) - wz.height()
                }, fitsize = function (e) {
                    var height = parent.height() - wdelta, style = parent.attr('style'), curH = Math.round(wz.height());
                    if (e) {
                        e.preventDefault();
                        e.stopPropagation()
                    }
                    parent.css('overflow', 'hidden').children(':visible:not(.' + cl + ')').each(function () {
                        var ch = $(this);
                        if (ch.css('position') != 'absolute' && ch.css('position') != 'fixed') {
                            height -= ch.outerHeight(!0)
                        }
                    });
                    parent.attr('style', style || '');
                    height = Math.max(0, Math.round(height));
                    if (prevH !== height || curH !== height) {
                        prevH = Math.round(wz.height());
                        wz.height(height);
                        fm.trigger('wzresize')
                    }
                }, cssloaded = function () {
                    wdelta = wz.outerHeight(!0) - wz.height();
                    fitsize()
                }, wdelta;
            setDelta();
            parent.on('resize.' + fm.namespace, fitsize);
            fm.one('cssloaded', cssloaded).bind('uiresize', fitsize).bind('themechange', setDelta)
        });
        return this
    };
    elFinder.prototype.commands.archive = function () {
        var self = this, fm = self.fm, mimes = [], dfrd;
        this.variants = [];
        this.disableOnSearch = !1;
        this.nextAction = {};
        fm.bind('open reload', function () {
            self.variants = [];
            $.each((mimes = fm.option('archivers')['create'] || []), function (i, mime) {
                self.variants.push([mime, fm.mime2kind(mime)])
            });
            self.change()
        });
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length,
                chk = (cnt && !fm.isRoot(sel[0]) && (fm.file(sel[0].phash) || {}).write && !$.grep(sel, function (f) {
                    return f.read ? !1 : !0
                }).length), cwdId;
            if (chk && fm.searchStatus.state > 1) {
                cwdId = fm.cwd().volumeid;
                chk = (cnt === $.grep(sel, function (f) {
                    return f.read && f.hash.indexOf(cwdId) === 0 ? !0 : !1
                }).length)
            }
            return chk && !this._disabled && mimes.length && (cnt || (dfrd && dfrd.state() == 'pending')) ? 0 : -1
        };
        this.exec = function (hashes, type) {
            var files = this.files(hashes), cnt = files.length, mime = type || mimes[0],
                cwd = fm.file(files[0].phash) || null,
                error = ['errArchive', 'errPerm', 'errCreatingTempDir', 'errFtpDownloadFile', 'errFtpUploadFile', 'errFtpMkdir', 'errArchiveExec', 'errExtractExec', 'errRm'],
                i, open;
            dfrd = $.Deferred().fail(function (error) {
                error && fm.error(error)
            });
            if (!(cnt && mimes.length && $.inArray(mime, mimes) !== -1)) {
                return dfrd.reject()
            }
            if (!cwd.write) {
                return dfrd.reject(error)
            }
            for (i = 0; i < cnt; i++) {
                if (!files[i].read) {
                    return dfrd.reject(error)
                }
            }
            self.mime = mime;
            self.prefix = ((cnt > 1) ? 'Archive' : files[0].name) + (fm.option('archivers')['createext'] ? '.' + fm.option('archivers')['createext'][mime] : '');
            self.data = {targets: self.hashes(hashes), type: mime};
            if (fm.cwd().hash !== cwd.hash) {
                open = fm.exec('open', cwd.hash).done(function () {
                    fm.one('cwdrender', function () {
                        fm.selectfiles({files: hashes});
                        dfrd = $.proxy(fm.res('mixin', 'make'), self)()
                    })
                })
            } else {
                fm.selectfiles({files: hashes});
                dfrd = $.proxy(fm.res('mixin', 'make'), self)()
            }
            return dfrd
        }
    };
    (elFinder.prototype.commands.back = function () {
        this.alwaysEnabled = !0;
        this.updateOnSelect = !1;
        this.shortcuts = [{pattern: 'ctrl+left backspace'}];
        this.getstate = function () {
            return this.fm.history.canBack() ? 0 : -1
        };
        this.exec = function () {
            return this.fm.history.back()
        }
    }).prototype = {forceLoad: !0};
    elFinder.prototype.commands.chmod = function () {
        this.updateOnSelect = !1;
        var fm = this.fm, level = {0: 'owner', 1: 'group', 2: 'other'}, msg = {
            read: fm.i18n('read'),
            write: fm.i18n('write'),
            execute: fm.i18n('execute'),
            perm: fm.i18n('perm'),
            kind: fm.i18n('kind'),
            files: fm.i18n('files')
        }, isPerm = function (perm) {
            return (!isNaN(parseInt(perm, 8) && parseInt(perm, 8) <= 511) || perm.match(/^([r-][w-][x-]){3}$/i))
        };
        this.tpl = {
            main: '<div class="ui-helper-clearfix elfinder-info-title"><span class="elfinder-cwd-icon {class} ui-corner-all"/>{title}</div>' + '{dataTable}',
            itemTitle: '<strong>{name}</strong><span id="elfinder-info-kind">{kind}</span>',
            groupTitle: '<strong>{items}: {num}</strong>',
            dataTable: '<table id="{id}-table-perm"><tr><td>{0}</td><td>{1}</td><td>{2}</td></tr></table>' + '<div class="">' + msg.perm + ': <input class="elfinder-tabstop elfinder-focus" id="{id}-perm" type="text" size="4" maxlength="3" value="{value}"></div>',
            fieldset: '<fieldset id="{id}-fieldset-{level}"><legend>{f_title}{name}</legend>' + '<input type="checkbox" value="4" class="elfinder-tabstop" id="{id}-read-{level}-perm"{checked-r}> <label for="{id}-read-{level}-perm">' + msg.read + '</label><br>' + '<input type="checkbox" value="6" class="elfinder-tabstop" id="{id}-write-{level}-perm"{checked-w}> <label for="{id}-write-{level}-perm">' + msg.write + '</label><br>' + '<input type="checkbox" value="5" class="elfinder-tabstop" id="{id}-execute-{level}-perm"{checked-x}> <label for="{id}-execute-{level}-perm">' + msg.execute + '</label><br>'
        };
        this.shortcuts = [{}];
        this.getstate = function (sel) {
            var fm = this.fm;
            sel = sel || fm.selected();
            if (sel.length == 0) {
                sel = [fm.cwd().hash]
            }
            return this.checkstate(this.files(sel)) ? 0 : -1
        };
        this.checkstate = function (sel) {
            var cnt = sel.length;
            if (!cnt) return !1;
            var chk = $.grep(sel, function (f) {
                return (f.isowner && f.perm && isPerm(f.perm) && (cnt == 1 || f.mime != 'directory')) ? !0 : !1
            }).length;
            return (cnt == chk) ? !0 : !1
        };
        this.exec = function (select) {
            var hashes = this.hashes(select), files = this.files(hashes);
            if (!files.length) {
                hashes = [this.fm.cwd().hash];
                files = this.files(hashes)
            }
            var fm = this.fm, dfrd = $.Deferred().always(function () {
                    fm.enable()
                }), tpl = this.tpl, cnt = files.length, file = files[0], id = fm.namespace + '-perm-' + file.hash,
                view = tpl.main, checked = ' checked="checked"', buttons = function () {
                    var buttons = {};
                    buttons[fm.i18n('btnApply')] = save;
                    buttons[fm.i18n('btnCancel')] = function () {
                        dialog.elfinderdialog('close')
                    };
                    return buttons
                }, save = function () {
                    var perm = $.trim($('#' + id + '-perm').val()), reqData;
                    if (!isPerm(perm)) return !1;
                    dialog.elfinderdialog('close');
                    reqData = {cmd: 'chmod', targets: hashes, mode: perm};
                    fm.request({data: reqData, notify: {type: 'chmod', cnt: cnt}}).fail(function (error) {
                        dfrd.reject(error)
                    }).done(function (data) {
                        if (data.changed && data.changed.length) {
                            data.undo = {
                                cmd: 'chmod', callback: function () {
                                    var reqs = [];
                                    $.each(prevVals, function (perm, hashes) {
                                        reqs.push(fm.request({
                                            data: {cmd: 'chmod', targets: hashes, mode: perm},
                                            notify: {type: 'undo', cnt: hashes.length}
                                        }))
                                    });
                                    return $.when.apply(null, reqs)
                                }
                            };
                            data.redo = {
                                cmd: 'chmod', callback: function () {
                                    return fm.request({data: reqData, notify: {type: 'redo', cnt: hashes.length}})
                                }
                            }
                        }
                        dfrd.resolve(data)
                    })
                }, setperm = function () {
                    var perm = '';
                    var _perm;
                    for (var i = 0; i < 3; i++) {
                        _perm = 0;
                        if ($("#" + id + "-read-" + level[i] + '-perm').is(':checked')) {
                            _perm = (_perm | 4)
                        }
                        if ($("#" + id + "-write-" + level[i] + '-perm').is(':checked')) {
                            _perm = (_perm | 2)
                        }
                        if ($("#" + id + "-execute-" + level[i] + '-perm').is(':checked')) {
                            _perm = (_perm | 1)
                        }
                        perm += _perm.toString(8)
                    }
                    $('#' + id + '-perm').val(perm)
                }, setcheck = function (perm) {
                    var _perm;
                    for (var i = 0; i < 3; i++) {
                        _perm = parseInt(perm.slice(i, i + 1), 8);
                        $("#" + id + "-read-" + level[i] + '-perm').prop("checked", !1);
                        $("#" + id + "-write-" + level[i] + '-perm').prop("checked", !1);
                        $("#" + id + "-execute-" + level[i] + '-perm').prop("checked", !1);
                        if ((_perm & 4) == 4) {
                            $("#" + id + "-read-" + level[i] + '-perm').prop("checked", !0)
                        }
                        if ((_perm & 2) == 2) {
                            $("#" + id + "-write-" + level[i] + '-perm').prop("checked", !0)
                        }
                        if ((_perm & 1) == 1) {
                            $("#" + id + "-execute-" + level[i] + '-perm').prop("checked", !0)
                        }
                    }
                    setperm()
                }, makeperm = function (files) {
                    var perm = '777', ret = '', chk, _chk, _perm;
                    var len = files.length;
                    for (var i2 = 0; i2 < len; i2++) {
                        chk = getPerm(files[i2].perm);
                        if (!prevVals[chk]) {
                            prevVals[chk] = []
                        }
                        prevVals[chk].push(files[i2].hash);
                        ret = '';
                        for (var i = 0; i < 3; i++) {
                            _chk = parseInt(chk.slice(i, i + 1), 8);
                            _perm = parseInt(perm.slice(i, i + 1), 8);
                            if ((_chk & 4) != 4 && (_perm & 4) == 4) {
                                _perm -= 4
                            }
                            if ((_chk & 2) != 2 && (_perm & 2) == 2) {
                                _perm -= 2
                            }
                            if ((_chk & 1) != 1 && (_perm & 1) == 1) {
                                _perm -= 1
                            }
                            ret += _perm.toString(8)
                        }
                        perm = ret
                    }
                    return perm
                }, makeName = function (name) {
                    return name ? ':' + name : ''
                }, makeDataTable = function (perm, f) {
                    var _perm, fieldset;
                    var value = '';
                    var dataTable = tpl.dataTable;
                    for (var i = 0; i < 3; i++) {
                        _perm = parseInt(perm.slice(i, i + 1), 8);
                        value += _perm.toString(8);
                        fieldset = tpl.fieldset.replace('{f_title}', fm.i18n(level[i])).replace('{name}', makeName(f[level[i]])).replace(/\{level\}/g, level[i]);
                        dataTable = dataTable.replace('{' + i + '}', fieldset).replace('{checked-r}', ((_perm & 4) == 4) ? checked : '').replace('{checked-w}', ((_perm & 2) == 2) ? checked : '').replace('{checked-x}', ((_perm & 1) == 1) ? checked : '')
                    }
                    dataTable = dataTable.replace('{value}', value).replace('{valueCaption}', msg.perm);
                    return dataTable
                }, getPerm = function (perm) {
                    if (isNaN(parseInt(perm, 8))) {
                        var mode_array = perm.split('');
                        var a = [];
                        for (var i = 0, l = mode_array.length; i < l; i++) {
                            if (i === 0 || i === 3 || i === 6) {
                                if (mode_array[i].match(/[r]/i)) {
                                    a.push(1)
                                } else if (mode_array[i].match(/[-]/)) {
                                    a.push(0)
                                }
                            } else if (i === 1 || i === 4 || i === 7) {
                                if (mode_array[i].match(/[w]/i)) {
                                    a.push(1)
                                } else if (mode_array[i].match(/[-]/)) {
                                    a.push(0)
                                }
                            } else {
                                if (mode_array[i].match(/[x]/i)) {
                                    a.push(1)
                                } else if (mode_array[i].match(/[-]/)) {
                                    a.push(0)
                                }
                            }
                        }
                        a.splice(3, 0, ",");
                        a.splice(7, 0, ",");
                        var b = a.join("");
                        var b_array = b.split(",");
                        var c = [];
                        for (var j = 0, m = b_array.length; j < m; j++) {
                            var p = parseInt(b_array[j], 2).toString(8);
                            c.push(p)
                        }
                        perm = c.join('')
                    } else {
                        perm = parseInt(perm, 8).toString(8)
                    }
                    return perm
                }, opts = {
                    title: this.title, width: 'auto', buttons: buttons(), close: function () {
                        $(this).elfinderdialog('destroy')
                    }
                }, dialog = fm.getUI().find('#' + id), prevVals = {}, tmb = '', title, dataTable;
            if (dialog.length) {
                dialog.elfinderdialog('toTop');
                return $.Deferred().resolve()
            }
            view = view.replace('{class}', cnt > 1 ? 'elfinder-cwd-icon-group' : fm.mime2class(file.mime));
            if (cnt > 1) {
                title = tpl.groupTitle.replace('{items}', fm.i18n('items')).replace('{num}', cnt)
            } else {
                title = tpl.itemTitle.replace('{name}', file.name).replace('{kind}', fm.mime2kind(file));
                tmb = fm.tmb(file)
            }
            dataTable = makeDataTable(makeperm(files), files.length == 1 ? files[0] : {});
            view = view.replace('{title}', title).replace('{dataTable}', dataTable).replace(/{id}/g, id);
            dialog = this.fmDialog(view, opts);
            dialog.attr('id', id);
            if (tmb) {
                $('<img/>').on('load', function () {
                    dialog.find('.elfinder-cwd-icon').addClass(tmb.className).css('background-image', "url('" + tmb.url + "')")
                }).attr('src', tmb.url)
            }
            $('#' + id + '-table-perm :checkbox').on('click', function () {
                setperm('perm')
            });
            $('#' + id + '-perm').on('keydown', function (e) {
                var c = e.keyCode;
                if (c == $.ui.keyCode.ENTER) {
                    e.stopPropagation();
                    save();
                    return
                }
            }).on('focus', function (e) {
                $(this).trigger('select')
            }).on('keyup', function (e) {
                if ($(this).val().length == 3) {
                    $(this).trigger('select');
                    setcheck($(this).val())
                }
            });
            return dfrd
        }
    };
    elFinder.prototype.commands.colwidth = function () {
        this.alwaysEnabled = !0;
        this.updateOnSelect = !1;
        this.getstate = function () {
            return this.fm.getUI('cwd').find('table').css('table-layout') === 'fixed' ? 0 : -1
        };
        this.exec = function () {
            this.fm.getUI('cwd').trigger('colwidth');
            return $.Deferred().resolve()
        }
    };
    elFinder.prototype.commands.copy = function () {
        this.shortcuts = [{pattern: 'ctrl+c ctrl+insert'}];
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length;
            return cnt && $.grep(sel, function (f) {
                return f.read ? !0 : !1
            }).length == cnt ? 0 : -1
        };
        this.exec = function (hashes) {
            var fm = this.fm, dfrd = $.Deferred().fail(function (error) {
                fm.error(error)
            });
            $.each(this.files(hashes), function (i, file) {
                if (!file.read) {
                    return !dfrd.reject(['errCopy', file.name, 'errPerm'])
                }
            });
            return dfrd.state() == 'rejected' ? dfrd : dfrd.resolve(fm.clipboard(this.hashes(hashes)))
        }
    };
    elFinder.prototype.commands.cut = function () {
        var fm = this.fm;
        this.shortcuts = [{pattern: 'ctrl+x shift+insert'}];
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length;
            return cnt && $.grep(sel, function (f) {
                return f.read && !f.locked && !fm.isRoot(f) ? !0 : !1
            }).length == cnt ? 0 : -1
        };
        this.exec = function (hashes) {
            var dfrd = $.Deferred().fail(function (error) {
                fm.error(error)
            });
            $.each(this.files(hashes), function (i, file) {
                if (!(file.read && !file.locked && !fm.isRoot(file))) {
                    return !dfrd.reject(['errCopy', file.name, 'errPerm'])
                }
                if (file.locked) {
                    return !dfrd.reject(['errLocked', file.name])
                }
            });
            return dfrd.state() == 'rejected' ? dfrd : dfrd.resolve(fm.clipboard(this.hashes(hashes), !0))
        }
    };
    elFinder.prototype.commands.zipdl = function () {
    };
    elFinder.prototype.commands.download = function () {
        var self = this, fm = this.fm, czipdl = null, zipOn = !1, mixed = !1, dlntf = !1,
            cpath = window.location.pathname || '/', filter = function (hashes, inExec) {
                var volumeid, mixedCmd;
                if (czipdl !== null) {
                    if (fm.searchStatus.state > 1) {
                        mixed = fm.searchStatus.mixed
                    } else if (fm.leafRoots[fm.cwd().hash]) {
                        volumeid = fm.cwd().volumeid;
                        $.each(hashes, function (i, h) {
                            if (h.indexOf(volumeid) !== 0) {
                                mixed = !0;
                                return !1
                            }
                        })
                    }
                    zipOn = (fm.isCommandEnabled('zipdl', hashes[0]))
                }
                if (mixed) {
                    mixedCmd = czipdl ? 'zipdl' : 'download';
                    hashes = $.grep(hashes, function (h) {
                        var f = fm.file(h),
                            res = (!f || (!czipdl && f.mime === 'directory') || !fm.isCommandEnabled(mixedCmd, h)) ? !1 : !0;
                        if (f && inExec && !res) {
                            fm.cwdHash2Elm(f.hash).trigger('unselect')
                        }
                        return res
                    });
                    if (!hashes.length) {
                        return []
                    }
                } else {
                    if (!fm.isCommandEnabled('download', hashes[0])) {
                        return []
                    }
                }
                return $.grep(self.files(hashes), function (f) {
                    var res = (!f.read || (!zipOn && f.mime == 'directory')) ? !1 : !0;
                    if (inExec && !res) {
                        fm.cwdHash2Elm(f.hash).trigger('unselect')
                    }
                    return res
                })
            };
        this.linkedCmds = ['zipdl'];
        this.shortcuts = [{pattern: 'shift+enter'}];
        this.getstate = function (select) {
            var sel = this.hashes(select), cnt = sel.length, maxReq = this.options.maxRequests || 10, mixed = !1,
                croot = '';
            if (cnt < 1) {
                return -1
            }
            cnt = filter(sel).length;
            return (cnt && (zipOn || (cnt <= maxReq && ((!fm.UA.IE && !fm.UA.Mobile) || cnt == 1))) ? 0 : -1)
        };
        fm.bind('contextmenu', function (e) {
            var fm = self.fm, helper = null, targets, file, link, getExtra = function (file) {
                var link = file.url || fm.url(file.hash);
                return {
                    icon: 'link',
                    node: $('<a/>').attr({
                        href: link,
                        target: '_blank',
                        title: fm.i18n('link')
                    }).text(file.name).on('mousedown click touchstart touchmove touchend contextmenu', function (e) {
                        e.stopPropagation()
                    }).on('dragstart', function (e) {
                        var dt = e.dataTransfer || e.originalEvent.dataTransfer || null;
                        helper = null;
                        if (dt) {
                            var icon = function (f) {
                                var mime = f.mime, i, tmb = fm.tmb(f);
                                i = '<div class="elfinder-cwd-icon ' + fm.mime2class(mime) + ' ui-corner-all"/>';
                                if (tmb) {
                                    i = $(i).addClass(tmb.className).css('background-image', "url('" + tmb.url + "')").get(0).outerHTML
                                }
                                return i
                            };
                            dt.effectAllowed = 'copyLink';
                            if (dt.setDragImage) {
                                helper = $('<div class="elfinder-drag-helper html5-native">').append(icon(file)).appendTo($(document.body));
                                dt.setDragImage(helper.get(0), 50, 47)
                            }
                            if (!fm.UA.IE) {
                                dt.setData('elfinderfrom', window.location.href + file.phash);
                                dt.setData('elfinderfrom:' + dt.getData('elfinderfrom'), '')
                            }
                        }
                    }).on('dragend', function (e) {
                        helper && helper.remove()
                    })
                }
            };
            self.extra = null;
            if (e.data) {
                targets = e.data.targets || [];
                if (targets.length === 1 && (file = fm.file(targets[0])) && file.mime !== 'directory') {
                    if (file.url != '1') {
                        self.extra = getExtra(file)
                    } else {
                        var node;
                        self.extra = {
                            icon: 'link',
                            node: $('<a/>').attr({
                                href: '#',
                                title: fm.i18n('getLink'),
                                draggable: 'false'
                            }).text(file.name).on('click touchstart', function (e) {
                                if (e.type === 'touchstart' && e.originalEvent.touches.length > 1) {
                                    return
                                }
                                var parent = node.parent();
                                e.stopPropagation();
                                e.preventDefault();
                                parent.removeClass('ui-state-disabled').addClass('elfinder-button-icon-spinner');
                                fm.request({
                                    data: {cmd: 'url', target: file.hash},
                                    preventDefault: !0
                                }).always(function (data) {
                                    parent.removeClass('elfinder-button-icon-spinner');
                                    if (data.url) {
                                        var rfile = fm.file(file.hash);
                                        rfile.url = data.url;
                                        node.replaceWith(getExtra(file).node)
                                    } else {
                                        parent.addClass('ui-state-disabled')
                                    }
                                })
                            })
                        };
                        node = self.extra.node;
                        node.ready(function () {
                            requestAnimationFrame(function () {
                                node.parent().addClass('ui-state-disabled').css('pointer-events', 'auto')
                            })
                        })
                    }
                }
            }
        }).one('open', function () {
            if (fm.api >= 2.1012) {
                czipdl = fm.getCommand('zipdl')
            }
            dlntf = fm.api > 2.1038 && !fm.isCORS
        });
        this.exec = function (select) {
            var hashes = this.hashes(select), fm = this.fm, base = fm.options.url, files = filter(hashes, !0),
                dfrd = $.Deferred(), iframes = '', cdata = '', targets = {}, i, url, linkdl = !1,
                getTask = function (hashes) {
                    return function () {
                        var dfd = $.Deferred(), root = fm.file(fm.root(hashes[0])), single = (hashes.length === 1),
                            volName = root ? (root.i18 || root.name) : null, dir, dlName, phash;
                        if (single) {
                            if (dir = fm.file(hashes[0])) {
                                dlName = (dir.i18 || dir.name)
                            }
                        } else {
                            $.each(hashes, function () {
                                var d = fm.file(this);
                                if (d && (!phash || phash === d.phash)) {
                                    phash = d.phash
                                } else {
                                    phash = null;
                                    return !1
                                }
                            });
                            if (phash && (dir = fm.file(phash))) {
                                dlName = (dir.i18 || dir.name) + '-' + hashes.length
                            }
                        }
                        if (dlName) {
                            volName = dlName
                        }
                        volName && (volName = ' (' + volName + ')');
                        fm.request({
                            data: {cmd: 'zipdl', targets: hashes},
                            notify: {type: 'zipdl', cnt: 1, hideCnt: !0, msg: fm.i18n('ntfzipdl') + volName},
                            cancel: !0,
                            eachCancel: !0,
                            preventDefault: !0
                        }).done(function (e) {
                            var zipdl, dialog, btn = {}, dllink, form, iframe, m, uniq = 'dlw' + (+new Date());
                            if (e.error) {
                                fm.error(e.error);
                                dfd.resolve()
                            } else if (e.zipdl) {
                                zipdl = e.zipdl;
                                if (dlName) {
                                    m = fm.splitFileExtention(zipdl.name || '');
                                    dlName += m[1] ? ('.' + m[1]) : '.zip'
                                } else {
                                    dlName = zipdl.name
                                }
                                if ((html5dl && (!fm.UA.Safari || fm.isSameOrigin(fm.options.url))) || linkdl) {
                                    url = fm.options.url + (fm.options.url.indexOf('?') === -1 ? '?' : '&') + 'cmd=zipdl&download=1';
                                    $.each([hashes[0], zipdl.file, dlName, zipdl.mime], function (key, val) {
                                        url += '&targets%5B%5D=' + encodeURIComponent(val)
                                    });
                                    $.each(fm.customData, function (key, val) {
                                        url += '&' + encodeURIComponent(key) + '=' + encodeURIComponent(val)
                                    });
                                    url += '&' + encodeURIComponent(dlName);
                                    dllink = $('<a/>').attr('href', url).attr('download', fm.escape(dlName)).on('click', function () {
                                        dfd.resolve();
                                        dialog && dialog.elfinderdialog('destroy')
                                    });
                                    if (linkdl) {
                                        dllink.attr('target', '_blank').append('<span class="elfinder-button-icon elfinder-button-icon-download"></span>' + fm.escape(dlName));
                                        btn[fm.i18n('btnCancel')] = function () {
                                            dialog.elfinderdialog('destroy')
                                        };
                                        dialog = self.fmDialog(dllink, {
                                            title: fm.i18n('link'),
                                            buttons: btn,
                                            width: '200px',
                                            destroyOnClose: !0,
                                            close: function () {
                                                (dfd.state() !== 'resolved') && dfd.resolve()
                                            }
                                        })
                                    } else {
                                        click(dllink.hide().appendTo('body').get(0));
                                        dllink.remove()
                                    }
                                } else {
                                    form = $('<form action="' + fm.options.url + '" method="post" target="' + uniq + '" style="display:none"/>').append('<input type="hidden" name="cmd" value="zipdl"/>').append('<input type="hidden" name="download" value="1"/>');
                                    $.each([hashes[0], zipdl.file, dlName, zipdl.mime], function (key, val) {
                                        form.append('<input type="hidden" name="targets[]" value="' + fm.escape(val) + '"/>')
                                    });
                                    $.each(fm.customData, function (key, val) {
                                        form.append('<input type="hidden" name="' + key + '" value="' + fm.escape(val) + '"/>')
                                    });
                                    form.attr('target', uniq).appendTo('body');
                                    iframe = $('<iframe style="display:none" name="' + uniq + '">').appendTo('body').ready(function () {
                                        form.submit().remove();
                                        dfd.resolve();
                                        setTimeout(function () {
                                            iframe.remove()
                                        }, 20000)
                                    })
                                }
                            }
                        }).fail(function (error) {
                            error && fm.error(error);
                            dfd.resolve()
                        });
                        return dfd.promise()
                    }
                }, click = function (a) {
                    var clickEv;
                    if (typeof MouseEvent === 'function') {
                        clickEv = new MouseEvent('click')
                    } else {
                        clickEv = document.createEvent('MouseEvents');
                        clickEv.initMouseEvent('click', !0, !0, window, 0, 0, 0, 0, 0, !1, !1, !1, !1, 0, null)
                    }
                    fm.pauseUnloadCheck(!0);
                    a.dispatchEvent(clickEv)
                }, checkCookie = function (id) {
                    var name = 'elfdl' + id, parts;
                    parts = document.cookie.split(name + "=");
                    if (parts.length === 2) {
                        ntftm && clearTimeout(ntftm);
                        document.cookie = name + '=; path=' + cpath + '; max-age=0';
                        closeNotify()
                    } else {
                        setTimeout(function () {
                            checkCookie(id)
                        }, 200)
                    }
                }, closeNotify = function () {
                    if (fm.ui.notify.children('.elfinder-notify-download').length) {
                        fm.notify({type: 'download', cnt: -1})
                    }
                }, reqids = [], link, html5dl, fileCnt, clickEv, cid, ntftm, reqid;
            if (!files.length) {
                return dfrd.reject()
            }
            fileCnt = $.grep(files, function (f) {
                return f.mime === 'directory' ? !1 : !0
            }).length;
            link = $('<a>').hide().appendTo('body');
            html5dl = (typeof link.get(0).download === 'string');
            if (zipOn && (fileCnt !== files.length || fileCnt >= (this.options.minFilesZipdl || 1))) {
                link.remove();
                linkdl = (!html5dl && fm.UA.Mobile);
                if (mixed) {
                    targets = {};
                    $.each(files, function (i, f) {
                        var p = f.hash.split('_', 2);
                        if (!targets[p[0]]) {
                            targets[p[0]] = [f.hash]
                        } else {
                            targets[p[0]].push(f.hash)
                        }
                    });
                    if (!linkdl && fm.UA.Mobile && Object.keys(targets).length > 1) {
                        linkdl = !0
                    }
                } else {
                    targets = [$.map(files, function (f) {
                        return f.hash
                    })]
                }
                dfrd = fm.sequence($.map(targets, function (t) {
                    return getTask(t)
                })).always(function () {
                    fm.trigger('download', {files: files})
                });
                return dfrd
            } else {
                reqids = [];
                for (i = 0; i < files.length; i++) {
                    url = fm.openUrl(files[i].hash, !0);
                    if (dlntf && url.substr(0, fm.options.url.length) === fm.options.url) {
                        reqid = fm.getRequestId();
                        reqids.push(reqid);
                        url += '&cpath=' + cpath + '&reqid=' + reqid;
                        ntftm = setTimeout(function () {
                            fm.notify({
                                type: 'download', cnt: 1, cancel: (fm.UA.IE || fm.UA.Edge) ? void(0) : function () {
                                    if (reqids.length) {
                                        $.each(reqids, function () {
                                            fm.request({data: {cmd: 'abort', id: this}, preventDefault: !0})
                                        })
                                    }
                                    reqids = []
                                }
                            })
                        }, fm.notifyDelay);
                        checkCookie(reqid)
                    }
                    if (html5dl && (!fm.UA.Safari || fm.isSameOrigin(url))) {
                        click(link.attr('href', url).attr('download', fm.escape(files[i].name)).get(0))
                    } else {
                        if (fm.UA.Mobile) {
                            setTimeout(function () {
                                if (!window.open(url)) {
                                    fm.error('errPopup');
                                    ntftm && cleaerTimeout(ntftm);
                                    closeNotify()
                                }
                            }, 100)
                        } else {
                            iframes += '<iframe class="downloader" id="downloader-' + files[i].hash + '" style="display:none" src="' + url + '"/>'
                        }
                    }
                }
                link.remove();
                $(iframes).appendTo('body').ready(function () {
                    setTimeout(function () {
                        $(iframes).each(function () {
                            $('#' + $(this).attr('id')).remove()
                        })
                    }, 20000 + (10000 * i))
                });
                fm.trigger('download', {files: files});
                return dfrd.resolve()
            }
        }
    };
    elFinder.prototype.commands.duplicate = function () {
        var fm = this.fm;
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length;
            return cnt && fm.cwd().write && $.grep(sel, function (f) {
                return f.read && f.phash === fm.cwd().hash && !fm.isRoot(f) ? !0 : !1
            }).length == cnt ? 0 : -1
        };
        this.exec = function (hashes) {
            var fm = this.fm, files = this.files(hashes), cnt = files.length,
                dfrd = $.Deferred().fail(function (error) {
                    error && fm.error(error)
                }), args = [];
            if (!cnt) {
                return dfrd.reject()
            }
            $.each(files, function (i, file) {
                if (!file.read || !fm.file(file.phash).write) {
                    return !dfrd.reject(['errCopy', file.name, 'errPerm'])
                }
            });
            if (dfrd.state() == 'rejected') {
                return dfrd
            }
            return fm.request({
                data: {cmd: 'duplicate', targets: this.hashes(hashes)},
                notify: {type: 'copy', cnt: cnt},
                navigate: {toast: {inbuffer: {msg: fm.i18n(['complete', fm.i18n('cmdduplicate')])}}}
            })
        }
    };
    elFinder.prototype.commands.edit = function () {
        var self = this, fm = this.fm, clsEditing = fm.res('class', 'editing'), mimesSingle = [], mimes = [],
            allowAll = !1, rtrim = function (str) {
                return str.replace(/\s+$/, '')
            }, getEncSelect = function (heads) {
                var sel = $('<select class="ui-corner-all"/>'), hval;
                if (heads) {
                    $.each(heads, function (i, head) {
                        hval = fm.escape(head.value);
                        sel.append('<option value="' + hval + '">' + (head.caption ? fm.escape(head.caption) : hval) + '</option>')
                    })
                }
                $.each(self.options.encodings, function (i, v) {
                    sel.append('<option value="' + v + '">' + v + '</option>')
                });
                return sel
            }, getDlgWidth = function () {
                var m, width;
                if (typeof self.options.dialogWidth === 'string' && (m = self.options.dialogWidth.match(/(\d+)%/))) {
                    width = parseInt(fm.getUI().width() * (m[1] / 100))
                } else {
                    width = parseInt(self.options.dialogWidth || 650)
                }
                return Math.min(width, $(window).width())
            }, filter = function (files) {
                var cnt = files.length, mime, ext, skip;
                if (cnt > 1) {
                    mime = files[0].mime;
                    ext = files[0].name.replace(/^.*(\.[^.]+)$/, '$1')
                }
                return $.grep(files, function (file) {
                    var res;
                    if (skip || file.mime === 'directory') {
                        return !1
                    }
                    res = file.read && (allowAll || fm.mimeIsText(file.mime) || $.inArray(file.mime, cnt === 1 ? mimesSingle : mimes) !== -1) && (!self.onlyMimes.length || $.inArray(file.mime, self.onlyMimes) !== -1) && (cnt === 1 || (file.mime === mime && file.name.substr(ext.length * -1) === ext)) && (fm.uploadMimeCheck(file.mime, file.phash) ? !0 : !1) && setEditors(file, cnt) && Object.keys(editors).length;
                    if (!res) {
                        skip = !0
                    }
                    return res
                })
            }, fileSync = function (hash) {
                var old = fm.file(hash), f;
                fm.request({cmd: 'info', targets: [hash], preventDefault: !0}).done(function (data) {
                    var changed;
                    if (data && data.files && data.files.length) {
                        f = data.files[0];
                        if (old.ts != f.ts || old.size != f.size) {
                            changed = {changed: [f]};
                            fm.updateCache(changed);
                            fm.change(changed)
                        }
                    }
                })
            }, dialog = function (id, file, content, encoding, editor) {
                var dfrd = $.Deferred(), _loaded = !1, loaded = function () {
                    if (!_loaded) {
                        fm.toast({mode: 'warning', msg: fm.i18n('nowLoading')});
                        return !1
                    }
                    return !0
                }, save = function () {
                    var encord = selEncoding ? selEncoding.val() : void(0), saveDfd = $.Deferred().fail(function (err) {
                        dialogNode.show().find('button.elfinder-btncnt-0,button.elfinder-btncnt-1').hide()
                    }), conf, res;
                    if (!loaded()) {
                        return saveDfd.resolve()
                    }
                    if (ta.editor) {
                        ta.editor.save(ta[0], ta.editor.instance);
                        conf = ta.editor.confObj;
                        if (conf.info && (conf.info.schemeContent || conf.info.arrayBufferContent)) {
                            encord = 'scheme'
                        }
                    }
                    res = getContent();
                    setOld(res);
                    if (res.promise) {
                        res.done(function (data) {
                            dfrd.notifyWith(ta, [encord, ta.data('hash'), old, saveDfd])
                        }).fail(function (err) {
                            saveDfd.reject(err)
                        })
                    } else {
                        dfrd.notifyWith(ta, [encord, ta.data('hash'), old, saveDfd])
                    }
                    return saveDfd
                }, saveon = function () {
                    if (!loaded()) {
                        return
                    }
                    save().fail(function (err) {
                        err && fm.error(err)
                    })
                }, cancel = function () {
                    ta.elfinderdialog('close')
                }, savecl = function () {
                    if (!loaded()) {
                        return
                    }
                    save().done(function () {
                        _loaded = !1;
                        dialogNode.show();
                        cancel()
                    }).fail(function (err) {
                        dialogNode.show();
                        err && fm.error(err)
                    });
                    dialogNode.hide()
                }, saveAs = function () {
                    if (!loaded()) {
                        return
                    }
                    var prevOld = old, phash = fm.file(file.phash) ? file.phash : fm.cwd().hash, fail = function (err) {
                        dialogs.addClass(clsEditing).fadeIn(function () {
                            err && fm.error(err)
                        });
                        old = prevOld;
                        fm.disable()
                    }, make = function () {
                        self.mime = saveAsFile.mime || file.mime;
                        self.prefix = (saveAsFile.name || file.name).replace(/ \d+(\.[^.]+)?$/, '$1');
                        self.requestCmd = 'mkfile';
                        self.nextAction = {};
                        self.data = {target: phash};
                        $.proxy(fm.res('mixin', 'make'), self)().done(function (data) {
                            if (data.added && data.added.length) {
                                ta.data('hash', data.added[0].hash);
                                save().done(function () {
                                    _loaded = !1;
                                    dialogNode.show();
                                    cancel();
                                    dialogs.fadeIn()
                                }).fail(fail)
                            } else {
                                fail()
                            }
                        }).progress(function (err) {
                            if (err && err === 'errUploadMime') {
                                ta.trigger('saveAsFail')
                            }
                        }).fail(fail).always(function () {
                            delete self.mime;
                            delete self.prefix;
                            delete self.nextAction;
                            delete self.data
                        });
                        fm.trigger('unselectfiles', {files: [file.hash]})
                    }, reqOpen = null, dialogs = fm.getUI().children('.' + self.dialogClass + ':visible');
                    if (dialogNode.is(':hidden')) {
                        dialogs = dialogs.add(dialogNode)
                    }
                    dialogs.removeClass(clsEditing).fadeOut();
                    fm.enable();
                    if (fm.searchStatus.state < 2 && phash !== fm.cwd().hash) {
                        reqOpen = fm.exec('open', [phash], {thash: phash})
                    }
                    $.when([reqOpen]).done(function () {
                        reqOpen ? fm.one('cwdrender', make) : make()
                    }).fail(fail)
                }, changed = function () {
                    var dfd = $.Deferred(), res, tm;
                    if (!_loaded) {
                        return dfd.resolve(!1)
                    }
                    ta.editor && ta.editor.save(ta[0], ta.editor.instance);
                    res = getContent();
                    if (res && res.promise) {
                        tm = setTimeout(function () {
                            fm.notify({type: 'chkcontent', cnt: 1, hideCnt: !0})
                        }, 100);
                        res.always(function () {
                            tm && clearTimeout(tm);
                            fm.notify({type: 'chkcontent', cnt: -1})
                        }).done(function (d) {
                            dfd.resolve(old !== d)
                        }).fail(function (err) {
                            dfd.resolve(err || !0)
                        })
                    } else {
                        dfd.resolve(old !== res)
                    }
                    return dfd
                }, opts = {
                    title: fm.escape(file.name),
                    width: getDlgWidth(),
                    buttons: {},
                    cssClass: clsEditing,
                    maxWidth: 'window',
                    maxHeight: 'window',
                    allowMinimize: !0,
                    allowMaximize: !0,
                    openMaximized: editorMaximized() || (editor && editor.info && editor.info.openMaximized),
                    btnHoverFocus: !1,
                    closeOnEscape: !1,
                    propagationEvents: ['mousemove', 'mouseup', 'click'],
                    minimize: function () {
                        var conf;
                        if (ta.editor && dialogNode.closest('.ui-dialog').is(':hidden')) {
                            conf = ta.editor.confObj;
                            if (conf.info && conf.info.syncInterval) {
                                fileSync(file.hash)
                            }
                        }
                    },
                    close: function () {
                        var close = function () {
                            var conf;
                            dfrd.resolve();
                            if (ta.editor) {
                                ta.editor.close(ta[0], ta.editor.instance);
                                conf = ta.editor.confObj;
                                if (conf.info && conf.info.syncInterval) {
                                    fileSync(file.hash)
                                }
                            }
                            ta.elfinderdialog('destroy')
                        }, onlySaveAs = (typeof saveAsFile.name !== 'undefined'), accept = onlySaveAs ? {
                            label: 'btnSaveAs', callback: function () {
                                requestAnimationFrame(saveAs)
                            }
                        } : {
                            label: 'btnSaveClose', callback: function () {
                                save().done(function () {
                                    close()
                                })
                            }
                        };
                        changed().done(function (change) {
                            var msgs = ['confirmNotSave'];
                            if (change) {
                                if (typeof change === 'string') {
                                    msgs.unshift(change)
                                }
                                fm.confirm({
                                    title: self.title,
                                    text: msgs,
                                    accept: accept,
                                    cancel: {label: 'btnClose', callback: close},
                                    buttons: onlySaveAs ? null : [{
                                        label: 'btnSaveAs', callback: function () {
                                            requestAnimationFrame(saveAs)
                                        }
                                    }]
                                })
                            } else {
                                close()
                            }
                        })
                    },
                    open: function () {
                        var loadRes, conf, interval;
                        ta.initEditArea.call(ta, id, file, content, fm);
                        if (ta.editor) {
                            loadRes = ta.editor.load(ta[0]) || null;
                            if (loadRes && loadRes.done) {
                                loadRes.always(function () {
                                    _loaded = !0
                                }).done(function (instance) {
                                    ta.editor.instance = instance;
                                    ta.editor.focus(ta[0], ta.editor.instance);
                                    setOld(getContent());
                                    requestAnimationFrame(function () {
                                        dialogNode.trigger('resize')
                                    })
                                }).fail(function (error) {
                                    error && fm.error(error);
                                    ta.elfinderdialog('destroy');
                                    return
                                })
                            } else {
                                _loaded = !0;
                                if (loadRes && (typeof loadRes === 'string' || Array.isArray(loadRes))) {
                                    fm.error(loadRes);
                                    ta.elfinderdialog('destroy');
                                    return
                                }
                                ta.editor.instance = loadRes;
                                ta.editor.focus(ta[0], ta.editor.instance);
                                setOld(getContent());
                                requestAnimationFrame(function () {
                                    dialogNode.trigger('resize')
                                })
                            }
                            conf = ta.editor.confObj;
                            if (conf.info && conf.info.syncInterval) {
                                if (interval = parseInt(conf.info.syncInterval)) {
                                    setTimeout(function () {
                                        autoSync(interval)
                                    }, interval)
                                }
                            }
                        } else {
                            _loaded = !0;
                            setOld(getContent())
                        }
                    },
                    resize: function (e, data) {
                        ta.editor && ta.editor.resize(ta[0], ta.editor.instance, e, data || {})
                    }
                }, getContent = function () {
                    return ta.getContent.call(ta, ta[0])
                }, setOld = function (res) {
                    if (res && res.promise) {
                        res.done(function (d) {
                            old = d
                        })
                    } else {
                        old = res
                    }
                }, autoSync = function (interval) {
                    if (dialogNode.is(':visible')) {
                        fileSync(file.hash);
                        setTimeout(function () {
                            autoSync(interval)
                        }, interval)
                    }
                }, saveAsFile = {}, ta, old, dialogNode, selEncoding, extEditor, maxW, syncInterval;
                if (editor) {
                    if (editor.html) {
                        ta = $(editor.html)
                    }
                    extEditor = {
                        init: editor.init || null,
                        load: editor.load,
                        getContent: editor.getContent || null,
                        save: editor.save,
                        beforeclose: typeof editor.beforeclose == 'function' ? editor.beforeclose : void 0,
                        close: typeof editor.close == 'function' ? editor.close : function () {
                        },
                        focus: typeof editor.focus == 'function' ? editor.focus : function () {
                        },
                        resize: typeof editor.resize == 'function' ? editor.resize : function () {
                        },
                        instance: null,
                        doSave: saveon,
                        doCancel: cancel,
                        doClose: savecl,
                        file: file,
                        fm: fm,
                        confObj: editor,
                        trigger: function (evName, data) {
                            fm.trigger('editEditor' + evName, Object.assign({}, editor.info || {}, data))
                        }
                    }
                }
                if (!ta) {
                    if (!fm.mimeIsText(file.mime)) {
                        return dfrd.reject('errEditorNotFound')
                    }
                    (function () {
                        var stateChange = function () {
                            if (selEncoding) {
                                changed().done(function (change) {
                                    if (change) {
                                        selEncoding.attr('title', fm.i18n('saveAsEncoding')).addClass('elfinder-edit-changed')
                                    } else {
                                        selEncoding.attr('title', fm.i18n('openAsEncoding')).removeClass('elfinder-edit-changed')
                                    }
                                })
                            }
                        };
                        ta = $('<textarea class="elfinder-file-edit" rows="20" id="' + id + '-ta"></textarea>').on('input propertychange', stateChange);
                        if (!ta.editor || !ta.editor.info || ta.editor.info.useTextAreaEvent) {
                            ta.on('keydown', function (e) {
                                var code = e.keyCode, value, start;
                                e.stopPropagation();
                                if (code == $.ui.keyCode.TAB) {
                                    e.preventDefault();
                                    if (this.setSelectionRange) {
                                        value = this.value;
                                        start = this.selectionStart;
                                        this.value = value.substr(0, start) + "\t" + value.substr(this.selectionEnd);
                                        start += 1;
                                        this.setSelectionRange(start, start)
                                    }
                                }
                                if (e.ctrlKey || e.metaKey) {
                                    if (code == 'Q'.charCodeAt(0) || code == 'W'.charCodeAt(0)) {
                                        e.preventDefault();
                                        cancel()
                                    }
                                    if (code == 'S'.charCodeAt(0)) {
                                        e.preventDefault();
                                        saveon()
                                    }
                                }
                            }).on('mouseenter', function () {
                                this.focus()
                            })
                        }
                        ta.initEditArea = function (id, file, content) {
                            var heads = (encoding && encoding !== 'unknown') ? [{value: encoding}] : [],
                                wfake = $('<select/>').hide(), setSelW = function (init) {
                                    init && wfake.appendTo(selEncoding.parent());
                                    wfake.empty().append($('<option/>').text(selEncoding.val()));
                                    selEncoding.width(wfake.width())
                                };
                            ta.hide().val(content);
                            if (content === '' || !encoding || encoding !== 'UTF-8') {
                                heads.push({value: 'UTF-8'})
                            }
                            selEncoding = getEncSelect(heads).on('touchstart', function (e) {
                                e.stopPropagation()
                            }).on('change', function () {
                                changed().done(function (change) {
                                    if (!change && getContent() !== '') {
                                        cancel();
                                        edit(file, selEncoding.val(), editor).fail(function (err) {
                                            err && fm.error(err)
                                        })
                                    }
                                });
                                setSelW()
                            }).on('mouseover', stateChange);
                            ta.parent().next().prepend($('<div class="ui-dialog-buttonset elfinder-edit-extras"/>').append(selEncoding));
                            setSelW(!0)
                        }
                    })()
                }
                ta.data('hash', file.hash);
                if (extEditor) {
                    ta.editor = extEditor;
                    if (typeof extEditor.beforeclose === 'function') {
                        opts.beforeclose = function () {
                            return extEditor.beforeclose(ta[0], extEditor.instance)
                        }
                    }
                    if (typeof extEditor.init === 'function') {
                        ta.initEditArea = extEditor.init
                    }
                    if (typeof extEditor.getContent === 'function') {
                        ta.getContent = extEditor.getContent
                    }
                }
                if (!ta.initEditArea) {
                    ta.initEditArea = function () {
                    }
                }
                if (!ta.getContent) {
                    ta.getContent = function () {
                        return rtrim(ta.val())
                    }
                }
                if (!editor || !editor.info || !editor.info.preventGet) {
                    opts.buttons[fm.i18n('btnSave')] = saveon;
                    opts.buttons[fm.i18n('btnSaveClose')] = savecl;
                    opts.buttons[fm.i18n('btnSaveAs')] = saveAs;
                    opts.buttons[fm.i18n('btnCancel')] = cancel
                }
                if (editor && typeof editor.prepare === 'function') {
                    editor.prepare(ta, opts, file)
                }
                dialogNode = self.fmDialog(ta, opts).attr('id', id).on('keydown keyup keypress', function (e) {
                    e.stopPropagation()
                }).css({
                    overflow: 'hidden',
                    minHeight: '7em'
                }).addClass('elfinder-edit-editor').closest('.ui-dialog').on('changeType', function (e, data) {
                    if (data.extention && data.mime) {
                        var ext = data.extention, mime = data.mime,
                            btnSet = $(this).children('.ui-dialog-buttonpane').children('.ui-dialog-buttonset');
                        btnSet.children('.elfinder-btncnt-0,.elfinder-btncnt-1').hide();
                        saveAsFile.name = fm.splitFileExtention(file.name)[0] + '.' + data.extention;
                        saveAsFile.mime = data.mime;
                        if (!data.keepEditor) {
                            btnSet.children('.elfinder-btncnt-2').trigger('click')
                        }
                    }
                });
                maxW = (fm.options.dialogContained ? elfNode : $(window)).width();
                (dialogNode.width() > maxW) && dialogNode.width(maxW);
                return dfrd.promise()
            }, edit = function (file, convert, editor) {
                var hash = file.hash, opts = fm.options, dfrd = $.Deferred(), id = 'edit-' + fm.namespace + '-' + file.hash,
                    d = fm.getUI().find('#' + id), conv = !convert ? 0 : convert, noContent = !1, req, error, res;
                if (d.length) {
                    d.elfinderdialog('toTop');
                    return dfrd.resolve()
                }
                if (!file.read || (!file.write && (!editor.info || !editor.info.converter))) {
                    error = ['errOpen', file.name, 'errPerm'];
                    return dfrd.reject(error)
                }
                if (editor && editor.info) {
                    if (typeof editor.info.edit === 'function') {
                        res = editor.info.edit.call(fm, file, editor);
                        if (res.promise) {
                            res.done(function () {
                                dfrd.resolve()
                            }).fail(function (error) {
                                dfrd.reject(error)
                            })
                        } else {
                            res ? dfrd.resolve() : dfrd.reject()
                        }
                        return dfrd
                    }
                    noContent = editor.info.preventGet || editor.info.noContent;
                    if (editor.info.urlAsContent || noContent) {
                        req = $.Deferred();
                        if (editor.info.urlAsContent) {
                            fm.url(hash, {async: !0, onetime: !0, temporary: !0}).done(function (url) {
                                req.resolve({content: url})
                            })
                        } else {
                            req.resolve({})
                        }
                    } else {
                        req = fm.request({
                            data: {cmd: 'get', target: hash, conv: conv, _t: file.ts},
                            options: {type: 'get', cache: !0},
                            notify: {type: 'file', cnt: 1},
                            preventDefault: !0
                        })
                    }
                    req.done(function (data) {
                        var selEncoding, reg, m, res;
                        if (data.doconv) {
                            fm.confirm({
                                title: self.title,
                                text: data.doconv === 'unknown' ? 'confirmNonUTF8' : 'confirmConvUTF8',
                                accept: {
                                    label: 'btnConv', callback: function () {
                                        dfrd = edit(file, selEncoding.val(), editor)
                                    }
                                },
                                cancel: {
                                    label: 'btnCancel', callback: function () {
                                        dfrd.reject()
                                    }
                                },
                                optionsCallback: function (options) {
                                    options.create = function () {
                                        var base = $('<div class="elfinder-dialog-confirm-encoding"/>'),
                                            head = {value: data.doconv}, detected;
                                        if (data.doconv === 'unknown') {
                                            head.caption = '-'
                                        }
                                        selEncoding = getEncSelect([head]);
                                        $(this).next().find('.ui-dialog-buttonset').prepend(base.append($('<label>' + fm.i18n('encoding') + ' </label>').append(selEncoding)))
                                    }
                                }
                            })
                        } else {
                            if (!noContent && fm.mimeIsText(file.mime)) {
                                reg = new RegExp('^(data:' + file.mime.replace(/([.+])/g, '\\$1') + ';base64,)', 'i');
                                if (!editor.info.dataScheme) {
                                    if (window.atob && (m = data.content.match(reg))) {
                                        data.content = atob(data.content.substr(m[1].length))
                                    }
                                } else {
                                    if (window.btoa && !data.content.match(reg)) {
                                        data.content = 'data:' + file.mime + ';base64,' + btoa(data.content)
                                    }
                                }
                            }
                            dialog(id, file, data.content, data.encoding, editor).done(function (data) {
                                dfrd.resolve(data)
                            }).progress(function (encoding, newHash, data, saveDfd) {
                                var ta = this;
                                if (newHash) {
                                    hash = newHash
                                }
                                fm.request({
                                    options: {type: 'post'},
                                    data: {cmd: 'put', target: hash, encoding: encoding || data.encoding, content: data},
                                    notify: {type: 'save', cnt: 1},
                                    syncOnFail: !0,
                                    preventFail: !0,
                                    navigate: {
                                        target: 'changed',
                                        toast: {inbuffer: {msg: fm.i18n(['complete', fm.i18n('btnSave')])}}
                                    }
                                }).fail(function (error) {
                                    dfrd.reject(error);
                                    saveDfd.reject()
                                }).done(function (data) {
                                    requestAnimationFrame(function () {
                                        ta.trigger('focus');
                                        ta.editor && ta.editor.focus(ta[0], ta.editor.instance)
                                    });
                                    saveDfd.resolve()
                                })
                            }).fail(function (error) {
                                dfrd.reject(error)
                            })
                        }
                    }).fail(function (error) {
                        var err = fm.parseError(error);
                        err = Array.isArray(err) ? err[0] : err;
                        (err !== 'errConvUTF8') && fm.sync();
                        dfrd.reject(error)
                    })
                }
                return dfrd.promise()
            }, editors = {}, fallbackEditor = {
                info: {id: 'textarea', name: 'TextArea', useTextAreaEvent: !0},
                load: function (textarea) {
                    this.trigger('Prepare', {node: textarea, editorObj: void(0), instance: void(0), opts: {}});
                    textarea.setSelectionRange && textarea.setSelectionRange(0, 0);
                    $(textarea).trigger('focus').show()
                },
                save: function () {
                }
            }, setEditors = function (file, cnt) {
                var mimeMatch = function (fileMime, editorMimes) {
                    if (!editorMimes) {
                        return fm.mimeIsText(fileMime)
                    } else {
                        if (editorMimes[0] === '*' || $.inArray(fileMime, editorMimes) !== -1) {
                            return !0
                        }
                        var i, l;
                        l = editorMimes.length;
                        for (i = 0; i < l; i++) {
                            if (fileMime.indexOf(editorMimes[i]) === 0) {
                                return !0
                            }
                        }
                        return !1
                    }
                }, extMatch = function (fileName, editorExts) {
                    if (!editorExts || !editorExts.length) {
                        return !0
                    }
                    var ext = fileName.replace(/^.+\.([^.]+)|(.+)$/, '$1$2').toLowerCase(), i, l;
                    l = editorExts.length;
                    for (i = 0; i < l; i++) {
                        if (ext === editorExts[i].toLowerCase()) {
                            return !0
                        }
                    }
                    return !1
                }, optEditors = self.options.editors || [], cwdWrite = fm.cwd().write;
                stored = fm.storage('storedEditors') || {};
                editors = {};
                if (!optEditors.length) {
                    optEditors = [fallbackEditor]
                }
                $.each(optEditors, function (i, editor) {
                    var name;
                    if ((cnt === 1 || !editor.info.single) && ((!editor.info || !editor.info.converter) ? file.write : cwdWrite) && (file.size > 0 || (!editor.info.converter && (editor.info.canMakeEmpty || (editor.info.canMakeEmpty !== !1 && fm.mimeIsText(file.mime))))) && (!editor.info.maxSize || file.size <= editor.info.maxSize) && mimeMatch(file.mime, editor.mimes || null) && extMatch(file.name, editor.exts || null) && typeof editor.load == 'function' && typeof editor.save == 'function') {
                        name = editor.info.name ? editor.info.name : ('Editor ' + i);
                        editor.id = editor.info.id ? editor.info.id : ('editor' + i), editor.name = name;
                        editor.i18n = fm.i18n(name);
                        editors[editor.id] = editor
                    }
                });
                return Object.keys(editors).length ? !0 : !1
            }, store = function (mime, editor) {
                if (mime && editor) {
                    if (!$.isPlainObject(stored)) {
                        stored = {}
                    }
                    stored[mime] = editor.id;
                    fm.storage('storedEditors', stored);
                    fm.trigger('selectfiles', {files: fm.selected()})
                }
            }, useStoredEditor = function () {
                var d = fm.storage('useStoredEditor');
                return d ? (d > 0) : self.options.useStoredEditor
            }, editorMaximized = function () {
                var d = fm.storage('editorMaximized');
                return d ? (d > 0) : self.options.editorMaximized
            }, getSubMenuRaw = function (files, callback) {
                var subMenuRaw = [];
                $.each(editors, function (id, ed) {
                    subMenuRaw.push({
                        label: fm.escape(ed.i18n),
                        icon: ed.info && ed.info.icon ? ed.info.icon : 'edit',
                        options: {iconImg: ed.info && ed.info.iconImg ? fm.baseUrl + ed.info.iconImg : void(0)},
                        callback: function () {
                            store(files[0].mime, ed);
                            callback && callback.call(ed)
                        }
                    })
                });
                return subMenuRaw
            }, getStoreId = function (name) {
                return name.toLowerCase().replace(/ +/g, '')
            }, getStoredEditor = function (mime) {
                var name = stored[mime];
                return name && Object.keys(editors).length ? editors[getStoreId(name)] : void(0)
            }, infoRequest = function () {
            }, stored;
        this.shortcuts = [{pattern: 'ctrl+e'}];
        this.init = function () {
            var self = this, fm = this.fm, opts = this.options, cmdChecks = [], ccData, dfd;
            this.onlyMimes = this.options.mimes || [];
            fm.one('open', function () {
                if (opts.editors && Array.isArray(opts.editors)) {
                    fm.trigger('canMakeEmptyFile', {mimes: Object.keys(fm.storage('mkfileTextMimes') || {}).concat(opts.makeTextMimes || ['text/plain'])});
                    $.each(opts.editors, function (i, editor) {
                        if (editor.info && editor.info.cmdCheck) {
                            cmdChecks.push(editor.info.cmdCheck)
                        }
                    });
                    if (cmdChecks.length) {
                        if (fm.api >= 2.1030) {
                            dfd = fm.request({
                                data: {cmd: 'editor', name: cmdChecks, method: 'enabled'},
                                preventDefault: !0
                            }).done(function (d) {
                                ccData = d
                            }).fail(function () {
                                ccData = {}
                            })
                        } else {
                            ccData = {};
                            dfd = $.Deferred().resolve()
                        }
                    } else {
                        dfd = $.Deferred().resolve()
                    }
                    dfd.always(function () {
                        if (ccData) {
                            opts.editors = $.grep(opts.editors, function (e) {
                                if (e.info && e.info.cmdCheck) {
                                    return ccData[e.info.cmdCheck] ? !0 : !1
                                } else {
                                    return !0
                                }
                            })
                        }
                        $.each(opts.editors, function (i, editor) {
                            if (editor.setup && typeof editor.setup === 'function') {
                                editor.setup.call(editor, opts, fm)
                            }
                            if (!editor.disabled) {
                                if (editor.mimes && Array.isArray(editor.mimes)) {
                                    mimesSingle = mimesSingle.concat(editor.mimes);
                                    if (!editor.info || !editor.info.single) {
                                        mimes = mimes.concat(editor.mimes)
                                    }
                                }
                                if (!allowAll && editor.mimes && editor.mimes[0] === '*') {
                                    allowAll = !0
                                }
                                if (!editor.info) {
                                    editor.info = {}
                                }
                                if (editor.info.integrate) {
                                    fm.trigger('helpIntegration', Object.assign({cmd: 'edit'}, editor.info.integrate))
                                }
                                if (editor.info.canMakeEmpty) {
                                    fm.trigger('canMakeEmptyFile', {mimes: editor.mimes})
                                }
                            }
                        });
                        mimesSingle = ($.uniqueSort || $.unique)(mimesSingle);
                        mimes = ($.uniqueSort || $.unique)(mimes);
                        opts.editors = $.grep(opts.editors, function (e) {
                            return e.disabled ? !1 : !0
                        })
                    })
                }
            }).bind('select', function () {
                editors = null
            }).bind('contextmenucreate', function (e) {
                var file, editor, single = function (editor) {
                    var title = self.title;
                    fm.one('contextmenucreatedone', function () {
                        self.title = title
                    });
                    self.title = fm.escape(editor.i18n);
                    if (editor.info && editor.info.iconImg) {
                        self.contextmenuOpts = {iconImg: fm.baseUrl + editor.info.iconImg}
                    }
                    delete self.variants
                };
                self.contextmenuOpts = void(0);
                if (e.data.type === 'files' && self.enabled()) {
                    file = fm.file(e.data.targets[0]);
                    if (setEditors(file, e.data.targets.length)) {
                        if (Object.keys(editors).length > 1) {
                            if (!useStoredEditor() || !(editor = getStoredEditor(file.mime))) {
                                delete self.extra;
                                self.variants = [];
                                $.each(editors, function (id, editor) {
                                    self.variants.push([{editor: editor}, editor.i18n, editor.info && editor.info.iconImg ? fm.baseUrl + editor.info.iconImg : 'edit'])
                                })
                            } else {
                                single(editor);
                                self.extra = {
                                    icon: 'menu',
                                    node: $('<span/>').attr({title: fm.i18n('select')}).on('click touchstart', function (e) {
                                        if (e.type === 'touchstart' && e.originalEvent.touches.length > 1) {
                                            return
                                        }
                                        var node = $(this);
                                        e.stopPropagation();
                                        e.preventDefault();
                                        fm.trigger('contextmenu', {
                                            raw: getSubMenuRaw(fm.selectedFiles(), function () {
                                                var hashes = fm.selected();
                                                fm.exec('edit', hashes, {editor: this});
                                                fm.trigger('selectfiles', {files: hashes})
                                            }), x: node.offset().left, y: node.offset().top
                                        })
                                    })
                                }
                            }
                        } else {
                            single(editors[Object.keys(editors)[0]]);
                            delete self.extra
                        }
                    }
                }
            }).bind('canMakeEmptyFile', function (e) {
                if (e.data && e.data.resetTexts) {
                    var defs = fm.arrayFlip(self.options.makeTextMimes || ['text/plain']),
                        hides = fm.storage('mkfileHides') || {};
                    $.each((fm.storage('mkfileTextMimes') || {}), function (mime, type) {
                        if (!defs[mime]) {
                            delete fm.mimesCanMakeEmpty[mime];
                            delete hides[mime]
                        }
                    });
                    fm.storage('mkfileTextMimes', null);
                    if (Object.keys(hides).length) {
                        fm.storage('mkfileHides', hides)
                    } else {
                        fm.storage('mkfileHides', null)
                    }
                }
            })
        };
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length;
            return cnt && filter(sel).length == cnt ? 0 : -1
        };
        this.exec = function (select, opts) {
            var fm = this.fm, files = filter(this.files(select)), hashes = $.map(files, function (f) {
                    return f.hash
                }), list = [], editor = opts && opts.editor ? opts.editor : null,
                node = $(opts && opts._currentNode ? opts._currentNode : fm.cwdHash2Elm(hashes[0])),
                getEditor = function () {
                    var dfd = $.Deferred(), storedId;
                    if (!editor && Object.keys(editors).length > 1) {
                        if (useStoredEditor() && (editor = getStoredEditor(files[0].mime))) {
                            return dfd.resolve(editor)
                        }
                        fm.trigger('contextmenu', {
                            raw: getSubMenuRaw(files, function () {
                                dfd.resolve(this)
                            }), x: node.offset().left, y: node.offset().top + 22, opened: function () {
                                fm.one('closecontextmenu', function () {
                                    requestAnimationFrame(function () {
                                        if (dfd.state() === 'pending') {
                                            dfd.reject()
                                        }
                                    })
                                })
                            }
                        });
                        fm.trigger('selectfiles', {files: hashes});
                        return dfd
                    } else {
                        Object.keys(editors).length > 1 && editor && store(files[0].mime, editor);
                        return dfd.resolve(editor ? editor : (Object.keys(editors).length ? editors[Object.keys(editors)[0]] : null))
                    }
                }, dfrd = $.Deferred(), file;
            if (editors === null) {
                setEditors(files[0], hashes.length)
            }
            if (!node.length) {
                node = fm.getUI('cwd')
            }
            getEditor().done(function (editor) {
                while ((file = files.shift())) {
                    list.push(edit(file, void(0), editor).fail(function (error) {
                        error && fm.error(error)
                    }))
                }
                if (list.length) {
                    $.when.apply(null, list).done(function () {
                        dfrd.resolve()
                    }).fail(function () {
                        dfrd.reject()
                    })
                } else {
                    dfrd.reject()
                }
            }).fail(function () {
                dfrd.reject()
            });
            return dfrd
        }
    };
    elFinder.prototype.commands.empty = function () {
        var self, fm, selFiles = function (select) {
            var sel = self.files(select);
            if (!sel.length) {
                sel = [fm.cwd()]
            }
            return sel
        };
        this.linkedCmds = ['rm'];
        this.init = function () {
            self = this;
            fm = this.fm
        };
        this.getstate = function (select) {
            var sel = selFiles(select), cnt;
            cnt = sel.length;
            return $.grep(sel, function (f) {
                return f.read && f.write && f.mime === 'directory' ? !0 : !1
            }).length == cnt ? 0 : -1
        };
        this.exec = function (hashes) {
            var dirs = selFiles(hashes), cnt = dirs.length, dfrd = $.Deferred().done(function () {
                var data = {changed: {}};
                fm.toast({msg: fm.i18n(['"' + success.join('", ') + '"', 'complete', fm.i18n('cmdempty')])});
                $.each(dirs, function (i, dir) {
                    data.changed[dir.hash] = dir
                });
                fm.change(data)
            }).always(function () {
                var cwd = fm.cwd().hash;
                fm.trigger('selectfiles', {
                    files: $.map(dirs, function (d) {
                        return cwd === d.phash ? d.hash : null
                    })
                })
            }), success = [], done = function (res) {
                if (typeof res === 'number') {
                    success.push(dirs[res].name);
                    delete dirs[res].dirs
                } else {
                    res && fm.error(res)
                }
                (--cnt < 1) && dfrd[success.length ? 'resolve' : 'reject']()
            };
            $.each(dirs, function (i, dir) {
                var tm;
                if (!(dir.write && dir.mime === 'directory')) {
                    done(['errEmpty', dir.name, 'errPerm']);
                    return null
                }
                if (!fm.isCommandEnabled('rm', dir.hash)) {
                    done(['errCmdNoSupport', '"rm"']);
                    return null
                }
                tm = setTimeout(function () {
                    fm.notify({type: 'search', cnt: 1, hideCnt: cnt > 1 ? !1 : !0})
                }, fm.notifyDelay);
                fm.request({
                    data: {cmd: 'open', target: dir.hash},
                    preventDefault: !0,
                    asNotOpen: !0
                }).done(function (data) {
                    var targets = [];
                    tm && clearTimeout(tm);
                    if (fm.ui.notify.children('.elfinder-notify-search').length) {
                        fm.notify({type: 'search', cnt: -1, hideCnt: cnt > 1 ? !1 : !0})
                    }
                    if (data && data.files && data.files.length) {
                        if (data.files.length > fm.maxTargets) {
                            done(['errEmpty', dir.name, 'errMaxTargets', fm.maxTargets])
                        } else {
                            fm.updateCache(data);
                            $.each(data.files, function (i, f) {
                                if (!f.write || f.locked) {
                                    done(['errEmpty', dir.name, 'errRm', f.name, 'errPerm']);
                                    targets = [];
                                    return !1
                                }
                                targets.push(f.hash)
                            });
                            if (targets.length) {
                                fm.exec('rm', targets, {
                                    _userAction: !0,
                                    addTexts: [fm.i18n('folderToEmpty', dir.name)]
                                }).fail(function (error) {
                                    fm.trigger('unselectfiles', {files: fm.selected()});
                                    done(fm.parseError(error) || '')
                                }).done(function () {
                                    done(i)
                                })
                            }
                        }
                    } else {
                        fm.toast({mode: 'warning', msg: fm.i18n('filderIsEmpty', dir.name)});
                        done('')
                    }
                }).fail(function (error) {
                    done(fm.parseError(error) || '')
                })
            });
            return dfrd
        }
    };
    elFinder.prototype.commands.extract = function () {
        var self = this, fm = self.fm, mimes = [], filter = function (files) {
            return $.grep(files, function (file) {
                return file.read && $.inArray(file.mime, mimes) !== -1 ? !0 : !1
            })
        };
        this.variants = [];
        this.disableOnSearch = !0;
        fm.bind('open reload', function () {
            mimes = fm.option('archivers')['extract'] || [];
            if (fm.api > 2) {
                self.variants = [[{makedir: !0}, fm.i18n('cmdmkdir')], [{}, fm.i18n('btnCwd')]]
            } else {
                self.variants = [[{}, fm.i18n('btnCwd')]]
            }
            self.change()
        });
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length;
            return cnt && this.fm.cwd().write && filter(sel).length == cnt ? 0 : -1
        };
        this.exec = function (hashes, opts) {
            var files = this.files(hashes), dfrd = $.Deferred(), cnt = files.length,
                makedir = opts && opts.makedir ? 1 : 0, i, error, decision;
            var overwriteAll = !1;
            var omitAll = !1;
            var mkdirAll = 0;
            var names = $.map(fm.files(hashes), function (file) {
                return file.name
            });
            var map = {};
            $.grep(fm.files(hashes), function (file) {
                map[file.name] = file;
                return !1
            });
            var decide = function (decision) {
                switch (decision) {
                    case 'overwrite_all':
                        overwriteAll = !0;
                        break;
                    case 'omit_all':
                        omitAll = !0;
                        break
                }
            };
            var unpack = function (file) {
                if (!(file.read && fm.file(file.phash).write)) {
                    error = ['errExtract', file.name, 'errPerm'];
                    fm.error(error);
                    dfrd.reject(error)
                } else if ($.inArray(file.mime, mimes) === -1) {
                    error = ['errExtract', file.name, 'errNoArchive'];
                    fm.error(error);
                    dfrd.reject(error)
                } else {
                    fm.request({
                        data: {cmd: 'extract', target: file.hash, makedir: makedir},
                        notify: {type: 'extract', cnt: 1},
                        syncOnFail: !0,
                        navigate: {
                            toast: makedir ? {
                                incwd: {
                                    msg: fm.i18n(['complete', fm.i18n('cmdextract')]),
                                    action: {cmd: 'open', msg: 'cmdopen'}
                                },
                                inbuffer: {
                                    msg: fm.i18n(['complete', fm.i18n('cmdextract')]),
                                    action: {cmd: 'open', msg: 'cmdopen'}
                                }
                            } : {inbuffer: {msg: fm.i18n(['complete', fm.i18n('cmdextract')])}}
                        }
                    }).fail(function (error) {
                        if (dfrd.state() != 'rejected') {
                            dfrd.reject(error)
                        }
                    }).done(function () {
                    })
                }
            };
            var confirm = function (files, index) {
                var file = files[index], name = fm.splitFileExtention(file.name)[0],
                    existed = ($.inArray(name, names) >= 0), next = function () {
                        if ((index + 1) < cnt) {
                            confirm(files, index + 1)
                        } else {
                            dfrd.resolve()
                        }
                    };
                if (!makedir && existed && map[name].mime != 'directory') {
                    fm.confirm({
                        title: fm.i18n('ntfextract'), text: ['errExists', name, 'confirmRepl'], accept: {
                            label: 'btnYes', callback: function (all) {
                                decision = all ? 'overwrite_all' : 'overwrite';
                                decide(decision);
                                if (!overwriteAll && !omitAll) {
                                    if ('overwrite' == decision) {
                                        unpack(file)
                                    }
                                    if ((index + 1) < cnt) {
                                        confirm(files, index + 1)
                                    } else {
                                        dfrd.resolve()
                                    }
                                } else if (overwriteAll) {
                                    for (i = index; i < cnt; i++) {
                                        unpack(files[i])
                                    }
                                    dfrd.resolve()
                                }
                            }
                        }, reject: {
                            label: 'btnNo', callback: function (all) {
                                decision = all ? 'omit_all' : 'omit';
                                decide(decision);
                                if (!overwriteAll && !omitAll && (index + 1) < cnt) {
                                    confirm(files, index + 1)
                                } else if (omitAll) {
                                    dfrd.resolve()
                                }
                            }
                        }, cancel: {
                            label: 'btnCancel', callback: function () {
                                dfrd.resolve()
                            }
                        }, all: ((index + 1) < cnt)
                    })
                } else if (!makedir) {
                    if (mkdirAll == 0) {
                        fm.confirm({
                            title: fm.i18n('cmdextract'),
                            text: [fm.i18n('cmdextract') + ' "' + file.name + '"', 'confirmRepl'],
                            accept: {
                                label: 'btnYes', callback: function (all) {
                                    all && (mkdirAll = 1);
                                    unpack(file);
                                    next()
                                }
                            },
                            reject: {
                                label: 'btnNo', callback: function (all) {
                                    all && (mkdirAll = -1);
                                    next()
                                }
                            },
                            cancel: {
                                label: 'btnCancel', callback: function () {
                                    dfrd.resolve()
                                }
                            },
                            all: ((index + 1) < cnt)
                        })
                    } else {
                        (mkdirAll > 0) && unpack(file);
                        next()
                    }
                } else {
                    unpack(file);
                    next()
                }
            };
            if (!(this.enabled() && cnt && mimes.length)) {
                return dfrd.reject()
            }
            if (cnt > 0) {
                confirm(files, 0)
            }
            return dfrd
        }
    };
    (elFinder.prototype.commands.forward = function () {
        this.alwaysEnabled = !0;
        this.updateOnSelect = !0;
        this.shortcuts = [{pattern: 'ctrl+right'}];
        this.getstate = function () {
            return this.fm.history.canForward() ? 0 : -1
        };
        this.exec = function () {
            return this.fm.history.forward()
        }
    }).prototype = {forceLoad: !0};
    elFinder.prototype.commands.fullscreen = function () {
        var self = this, fm = this.fm, update = function (e, data) {
            e.preventDefault();
            e.stopPropagation();
            if (data && data.fullscreen) {
                self.update(void(0), (data.fullscreen === 'on'))
            }
        };
        this.alwaysEnabled = !0;
        this.updateOnSelect = !1;
        this.syncTitleOnChange = !0;
        this.value = !1;
        this.options = {ui: 'fullscreenbutton'};
        this.getstate = function () {
            return 0
        };
        this.exec = function () {
            var node = fm.getUI().get(0), full = (node === fm.toggleFullscreen(node));
            self.title = fm.i18n(full ? 'reinstate' : 'cmdfullscreen');
            self.update(void(0), full);
            return $.Deferred().resolve()
        };
        fm.bind('init', function () {
            fm.getUI().off('resize.' + fm.namespace, update).on('resize.' + fm.namespace, update)
        })
    };
    (elFinder.prototype.commands.getfile = function () {
        var self = this, fm = this.fm, filter = function (files) {
            var o = self.options;
            files = $.grep(files, function (file) {
                return (file.mime != 'directory' || o.folders) && file.read ? !0 : !1
            });
            return o.multiple || files.length == 1 ? files : []
        };
        this.alwaysEnabled = !0;
        this.callback = fm.options.getFileCallback;
        this._disabled = typeof(this.callback) == 'function';
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length;
            return this.callback && cnt && filter(sel).length == cnt ? 0 : -1
        };
        this.exec = function (hashes) {
            var fm = this.fm, opts = this.options, files = this.files(hashes), cnt = files.length,
                url = fm.option('url'), tmb = fm.option('tmbUrl'), dfrd = $.Deferred().done(function (data) {
                    var res, done = function () {
                        if (opts.oncomplete == 'close') {
                            fm.hide()
                        } else if (opts.oncomplete == 'destroy') {
                            fm.destroy()
                        }
                    }, fail = function (error) {
                        if (opts.onerror == 'close') {
                            fm.hide()
                        } else if (opts.onerror == 'destroy') {
                            fm.destroy()
                        } else {
                            error && fm.error(error)
                        }
                    };
                    fm.trigger('getfile', {files: data});
                    try {
                        res = self.callback(data, fm)
                    } catch (e) {
                        fail(['Error in `getFileCallback`.', e.message]);
                        return
                    }
                    if (typeof res === 'object' && typeof res.done === 'function') {
                        res.done(done).fail(fail)
                    } else {
                        done()
                    }
                }), result = function (file) {
                    return opts.onlyURL ? opts.multiple ? $.map(files, function (f) {
                        return f.url
                    }) : files[0].url : opts.multiple ? files : files[0]
                }, req = [], i, file, dim;
            for (i = 0; i < cnt; i++) {
                file = files[i];
                if (file.mime == 'directory' && !opts.folders) {
                    return dfrd.reject()
                }
                file.baseUrl = url;
                if (file.url == '1') {
                    req.push(fm.request({
                        data: {cmd: 'url', target: file.hash},
                        notify: {type: 'url', cnt: 1, hideCnt: !0},
                        preventDefault: !0
                    }).done(function (data) {
                        if (data.url) {
                            var rfile = fm.file(this.hash);
                            rfile.url = this.url = data.url
                        }
                    }.bind(file)))
                } else {
                    file.url = fm.url(file.hash)
                }
                if (!opts.onlyURL) {
                    if (opts.getPath) {
                        file.path = fm.path(file.hash);
                        if (file.path === '' && file.phash) {
                            (function () {
                                var dfd = $.Deferred();
                                req.push(dfd);
                                fm.path(file.hash, !1, {}).done(function (path) {
                                    file.path = path
                                }).fail(function () {
                                    file.path = ''
                                }).always(function () {
                                    dfd.resolve()
                                })
                            })()
                        }
                    }
                    if (file.tmb && file.tmb != 1) {
                        file.tmb = tmb + file.tmb
                    }
                    if (!file.width && !file.height) {
                        if (file.dim) {
                            dim = file.dim.split('x');
                            file.width = dim[0];
                            file.height = dim[1]
                        } else if (opts.getImgSize && file.mime.indexOf('image') !== -1) {
                            req.push(fm.request({
                                data: {cmd: 'dim', target: file.hash},
                                notify: {type: 'dim', cnt: 1, hideCnt: !0},
                                preventDefault: !0
                            }).done(function (data) {
                                if (data.dim) {
                                    var dim = data.dim.split('x');
                                    var rfile = fm.file(this.hash);
                                    rfile.width = this.width = dim[0];
                                    rfile.height = this.height = dim[1]
                                }
                            }.bind(file)))
                        }
                    }
                }
            }
            if (req.length) {
                $.when.apply(null, req).always(function () {
                    dfrd.resolve(result(files))
                });
                return dfrd
            }
            return dfrd.resolve(result(files))
        }
    }).prototype = {forceLoad: !0};
    (elFinder.prototype.commands.help = function () {
        var fm = this.fm, self = this, linktpl = '<div class="elfinder-help-link"> <a href="{url}">{link}</a></div>',
            linktpltgt = '<div class="elfinder-help-link"> <a href="{url}" target="_blank">{link}</a></div>',
            atpl = '<div class="elfinder-help-team"><div>{author}</div>{work}</div>', url = /\{url\}/,
            link = /\{link\}/, author = /\{author\}/, work = /\{work\}/, r = 'replace', prim = 'ui-priority-primary',
            sec = 'ui-priority-secondary', lic = 'elfinder-help-license',
            tab = '<li class="' + fm.res('class', 'tabstab') + ' elfinder-help-tab-{id}"><a href="#' + fm.namespace + '-help-{id}" class="ui-tabs-anchor">{title}</a></li>',
            html = ['<div class="ui-tabs ui-widget ui-widget-content ui-corner-all elfinder-help">', '<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-top">'],
            stpl = '<div class="elfinder-help-shortcut"><div class="elfinder-help-shortcut-pattern">{pattern}</div> {descrip}</div>',
            sep = '<div class="elfinder-help-separator"/>',
            selfUrl = $('base').length ? document.location.href.replace(/#.*$/, '') : '',
            clTabActive = fm.res('class', 'tabsactive'), getTheme = function () {
                var src;
                if (fm.theme && fm.theme.author) {
                    src = atpl[r]('elfinder-help-team', 'elfinder-help-team elfinder-help-term-theme')[r](author, fm.i18n(fm.theme.author) + (fm.theme.email ? ' &lt;' + fm.theme.email + '&gt;' : ''))[r](work, fm.i18n('theme') + ' (' + fm.i18n(fm.theme.name) + ')')
                } else {
                    src = '<div class="elfinder-help-team elfinder-help-term-theme" style="display:none"></div>'
                }
                return src
            }, about = function () {
                html.push('<div id="' + fm.namespace + '-help-about" class="ui-tabs-panel ui-widget-content ui-corner-bottom"><div class="elfinder-help-logo"/>');
                html.push('<h3>elFinder</h3>');
                html.push('<div class="' + prim + '">' + fm.i18n('webfm') + '</div>');
                html.push('<div class="' + sec + '">' + fm.i18n('ver') + ': ' + fm.version + '</div>');
                html.push('<div class="' + sec + '">' + fm.i18n('protocolver') + ': <span class="apiver"></span></div>');
                html.push('<div class="' + sec + '">jQuery/jQuery UI: ' + $().jquery + '/' + $.ui.version + '</div>');
                html.push(sep);
                html.push(linktpltgt[r](url, 'https://studio-42.github.io/elFinder/')[r](link, fm.i18n('homepage')));
                html.push(linktpltgt[r](url, 'https://github.com/Studio-42/elFinder/wiki')[r](link, fm.i18n('docs')));
                html.push(linktpltgt[r](url, 'https://github.com/Studio-42/elFinder')[r](link, fm.i18n('github')));
                html.push(sep);
                html.push('<div class="' + prim + '">' + fm.i18n('team') + '</div>');
                html.push(atpl[r](author, 'Dmitry "dio" Levashov &lt;dio@std42.ru&gt;')[r](work, fm.i18n('chiefdev')));
                html.push(atpl[r](author, 'Naoki Sawada &lt;hypweb+elfinder@gmail.com&gt;')[r](work, fm.i18n('developer')));
                html.push(atpl[r](author, 'Troex Nevelin &lt;troex@fury.scancode.ru&gt;')[r](work, fm.i18n('maintainer')));
                html.push(atpl[r](author, 'Alexey Sukhotin &lt;strogg@yandex.ru&gt;')[r](work, fm.i18n('contributor')));
                if (fm.i18[fm.lang].translator) {
                    $.each(fm.i18[fm.lang].translator.split(', '), function () {
                        html.push(atpl[r](author, $.trim(this))[r](work, fm.i18n('translator') + ' (' + fm.i18[fm.lang].language + ')'))
                    })
                }
                html.push(getTheme());
                html.push(sep);
                html.push('<div class="' + lic + '">' + fm.i18n('icons') + ': Pixelmixer, <a href="http://p.yusukekamiyamane.com" target="_blank">Fugue</a>, <a href="https://icons8.com" target="_blank">Icons8</a></div>');
                html.push(sep);
                html.push('<div class="' + lic + '">Licence: 3-clauses BSD Licence</div>');
                html.push('<div class="' + lic + '">Copyright © 2009-2019, Studio 42</div>');
                html.push('<div class="' + lic + '">„ …' + fm.i18n('dontforget') + ' ”</div>');
                html.push('</div>')
            }, shortcuts = function () {
                var sh = fm.shortcuts();
                html.push('<div id="' + fm.namespace + '-help-shortcuts" class="ui-tabs-panel ui-widget-content ui-corner-bottom">');
                if (sh.length) {
                    html.push('<div class="ui-widget-content elfinder-help-shortcuts">');
                    $.each(sh, function (i, s) {
                        html.push(stpl.replace(/\{pattern\}/, s[0]).replace(/\{descrip\}/, s[1]))
                    });
                    html.push('</div>')
                } else {
                    html.push('<div class="elfinder-help-disabled">' + fm.i18n('shortcutsof') + '</div>')
                }
                html.push('</div>')
            }, help = function () {
                html.push('<div id="' + fm.namespace + '-help-help" class="ui-tabs-panel ui-widget-content ui-corner-bottom">');
                html.push('<a href="https://github.com/Studio-42/elFinder/wiki" target="_blank" class="elfinder-dont-panic"><span>DON\'T PANIC</span></a>');
                html.push('</div>')
            }, useInteg = !1, integrations = function () {
                useInteg = !0;
                html.push('<div id="' + fm.namespace + '-help-integrations" class="ui-tabs-panel ui-widget-content ui-corner-bottom"/>')
            }, useDebug = !1, debug = function () {
                useDebug = !0;
                html.push('<div id="' + fm.namespace + '-help-debug" class="ui-tabs-panel ui-widget-content ui-corner-bottom">');
                html.push('<div class="ui-widget-content elfinder-help-debug"><ul></ul></div>');
                html.push('</div>')
            }, debugRender = function () {
                var render = function (elm, obj) {
                    $.each(obj, function (k, v) {
                        elm.append($('<dt/>').text(k));
                        if (typeof v === 'undefined') {
                            elm.append($('<dd/>').append($('<span/>').text('undfined')))
                        } else if (typeof v === 'object' && !v) {
                            elm.append($('<dd/>').append($('<span/>').text('null')))
                        } else if (typeof v === 'object' && ($.isPlainObject(v) || v.length)) {
                            elm.append($('<dd/>').append(render($('<dl/>'), v)))
                        } else {
                            elm.append($('<dd/>').append($('<span/>').text((v && typeof v === 'object') ? '[]' : (v ? v : '""'))))
                        }
                    });
                    return elm
                }, cnt = debugUL.children('li').length, targetL, target, tabId, info, lastUL, lastDIV;
                if (self.debug.options || self.debug.debug) {
                    if (cnt >= 5) {
                        lastUL = debugUL.children('li:last');
                        lastDIV = debugDIV.children('div:last');
                        if (lastDIV.is(':hidden')) {
                            lastUL.remove();
                            lastDIV.remove()
                        } else {
                            lastUL.prev().remove();
                            lastDIV.prev().remove()
                        }
                    }
                    tabId = fm.namespace + '-help-debug-' + (+new Date());
                    targetL = $('<li/>').html('<a href="' + selfUrl + '#' + tabId + '">' + self.debug.debug.cmd + '</a>').prependTo(debugUL);
                    target = $('<div id="' + tabId + '"/>').data('debug', self.debug);
                    targetL.on('click.debugrender', function () {
                        var debug = target.data('debug');
                        target.removeData('debug');
                        if (debug) {
                            target.hide();
                            if (debug.debug) {
                                info = $('<fieldset>').append($('<legend/>').text('debug'), render($('<dl/>'), debug.debug));
                                target.append(info)
                            }
                            if (debug.options) {
                                info = $('<fieldset>').append($('<legend/>').text('options'), render($('<dl/>'), debug.options));
                                target.append(info)
                            }
                            target.show()
                        }
                        targetL.off('click.debugrender')
                    });
                    debugUL.after(target);
                    opened && debugDIV.tabs('refresh')
                }
            }, content = '', opened, tabInteg, integDIV, tabDebug, debugDIV, debugUL;
        this.alwaysEnabled = !0;
        this.updateOnSelect = !1;
        this.state = -1;
        this.shortcuts = [{pattern: 'f1', description: this.title}];
        fm.bind('load', function () {
            var parts = self.options.view || ['about', 'shortcuts', 'help', 'integrations', 'debug'], i, helpSource,
                tabBase, tabNav, tabs, delta;
            if ((i = $.inArray('preference', parts)) !== -1) {
                parts.splice(i, 1)
            }
            if (!$.fn.tabs) {
                if ((i = $.inArray(parts, 'debug')) !== -1) {
                    parts.splice(i, 1)
                }
            }
            $.each(parts, function (i, title) {
                html.push(tab[r](/\{id\}/g, title)[r](/\{title\}/, fm.i18n(title)))
            });
            html.push('</ul>');
            $.inArray('about', parts) !== -1 && about();
            $.inArray('shortcuts', parts) !== -1 && shortcuts();
            if ($.inArray('help', parts) !== -1) {
                helpSource = fm.i18nBaseUrl + 'help/%s.html.js';
                help()
            }
            $.inArray('integrations', parts) !== -1 && integrations();
            $.inArray('debug', parts) !== -1 && debug();
            html.push('</div>');
            content = $(html.join(''));
            content.find('.ui-tabs-nav li').on('mouseenter mouseleave', function (e) {
                $(this).toggleClass('ui-state-hover', e.type === 'mouseenter')
            }).on('focus blur', 'a', function (e) {
                $(e.delegateTarget).toggleClass('ui-state-focus', e.type === 'focusin')
            }).children().on('click', function (e) {
                var link = $(this);
                e.preventDefault();
                e.stopPropagation();
                link.parent().addClass(clTabActive).siblings().removeClass(clTabActive);
                content.children('.ui-tabs-panel').hide().filter(link.attr('href')).show()
            }).filter(':first').trigger('click');
            if (useInteg) {
                tabInteg = content.find('.elfinder-help-tab-integrations').hide();
                integDIV = content.find('#' + fm.namespace + '-help-integrations').hide().append($('<div class="elfinder-help-integrations-desc"/>').html(fm.i18n('integrationWith')));
                fm.bind('helpIntegration', function (e) {
                    var ul = integDIV.children('ul:first'), data, elm, cmdUL, cmdCls;
                    if (e.data) {
                        if ($.isPlainObject(e.data)) {
                            data = Object.assign({link: '', title: '', banner: ''}, e.data);
                            if (data.title || data.link) {
                                if (!data.title) {
                                    data.title = data.link
                                }
                                if (data.link) {
                                    elm = $('<a/>').attr('href', data.link).attr('target', '_blank').text(data.title)
                                } else {
                                    elm = $('<span/>').text(data.title)
                                }
                                if (data.banner) {
                                    elm = $('<span/>').append($('<img/>').attr(data.banner), elm)
                                }
                            }
                        } else {
                            elm = $(e.data);
                            elm.filter('a').each(function () {
                                var tgt = $(this);
                                if (!tgt.attr('target')) {
                                    tgt.attr('target', '_blank')
                                }
                            })
                        }
                        if (elm) {
                            tabInteg.show();
                            if (!ul.length) {
                                ul = $('<ul class="elfinder-help-integrations"/>').appendTo(integDIV)
                            }
                            if (data && data.cmd) {
                                cmdCls = 'elfinder-help-integration-' + data.cmd;
                                cmdUL = ul.find('ul.' + cmdCls);
                                if (!cmdUL.length) {
                                    cmdUL = $('<ul class="' + cmdCls + '"/>');
                                    ul.append($('<li/>').append($('<span/>').html(fm.i18n('cmd' + data.cmd))).append(cmdUL))
                                }
                                elm = cmdUL.append($('<li/>').append(elm))
                            } else {
                                ul.append($('<li/>').append(elm))
                            }
                        }
                    }
                }).bind('themechange', function () {
                    content.find('div.elfinder-help-term-theme').replaceWith(getTheme())
                })
            }
            if (useDebug) {
                tabDebug = content.find('.elfinder-help-tab-debug').hide();
                debugDIV = content.find('#' + fm.namespace + '-help-debug').children('div:first');
                debugUL = debugDIV.children('ul:first').on('click', function (e) {
                    e.preventDefault();
                    e.stopPropagation()
                });
                self.debug = {};
                fm.bind('backenddebug', function (e) {
                    if (useDebug && e.data && e.data.debug) {
                        self.debug = {
                            options: e.data.options,
                            debug: Object.assign({cmd: fm.currentReqCmd}, e.data.debug)
                        };
                        if (self.dialog) {
                            debugRender()
                        }
                    }
                })
            }
            content.find('#' + fm.namespace + '-help-about').find('.apiver').text(fm.api);
            self.dialog = self.fmDialog(content, {
                title: self.title,
                width: 530,
                maxWidth: 'window',
                maxHeight: 'window',
                autoOpen: !1,
                destroyOnClose: !1,
                close: function () {
                    if (useDebug) {
                        tabDebug.hide();
                        debugDIV.tabs('destroy')
                    }
                    opened = !1
                }
            }).on('click', function (e) {
                e.stopPropagation()
            }).css({overflow: 'hidden'});
            tabBase = self.dialog.children('.ui-tabs');
            tabNav = tabBase.children('.ui-tabs-nav:first');
            tabs = tabBase.children('.ui-tabs-panel');
            delta = self.dialog.outerHeight(!0) - self.dialog.height();
            self.dialog.closest('.ui-dialog').on('resize', function () {
                tabs.height(self.dialog.height() - delta - tabNav.outerHeight(!0) - 20)
            });
            if (helpSource) {
                self.dialog.one('initContents', function () {
                    $.ajax({
                        url: self.options.helpSource ? self.options.helpSource : helpSource.replace('%s', fm.lang),
                        dataType: 'html'
                    }).done(function (source) {
                        $('#' + fm.namespace + '-help-help').html(source)
                    }).fail(function () {
                        $.ajax({url: helpSource.replace('%s', 'en'), dataType: 'html'}).done(function (source) {
                            $('#' + fm.namespace + '-help-help').html(source)
                        })
                    })
                })
            }
            self.state = 0;
            fm.trigger('helpBuilded', self.dialog)
        }).one('open', function () {
            var debug = !1;
            fm.one('backenddebug', function () {
                debug = !0
            }).one('opendone', function () {
                requestAnimationFrame(function () {
                    if (!debug && useDebug) {
                        useDebug = !1;
                        tabDebug.hide();
                        debugDIV.hide();
                        debugUL.hide()
                    }
                })
            })
        });
        this.getstate = function () {
            return 0
        };
        this.exec = function (sel, opts) {
            var tab = opts ? opts.tab : void(0), debugShow = function () {
                if (useDebug) {
                    debugDIV.tabs();
                    debugUL.find('a:first').trigger('click');
                    tabDebug.show();
                    opened = !0
                }
            };
            debugShow();
            this.dialog.trigger('initContents').elfinderdialog('open').find((tab ? '.elfinder-help-tab-' + tab : '.ui-tabs-nav li') + ' a:first').trigger('click');
            return $.Deferred().resolve()
        }
    }).prototype = {forceLoad: !0};
    elFinder.prototype.commands.hidden = function () {
        this.hidden = !0;
        this.updateOnSelect = !1;
        this.getstate = function () {
            return -1
        }
    };
    elFinder.prototype.commands.hide = function () {
        var self = this, nameCache = {}, hideData, hideCnt, cMenuType, sOrigin;
        this.syncTitleOnChange = !0;
        this.shortcuts = [{pattern: 'ctrl+shift+dot', description: this.fm.i18n('toggleHidden')}];
        this.init = function () {
            var fm = this.fm;
            hideData = fm.storage('hide') || {items: {}};
            hideCnt = Object.keys(hideData.items).length;
            this.title = fm.i18n(hideData.show ? 'hideHidden' : 'showHidden');
            self.update(void(0), self.title)
        };
        this.fm.bind('select contextmenucreate closecontextmenu', function (e, fm) {
            var sel = (e.data ? (e.data.selected || e.data.targets) : null) || fm.selected();
            if (e.type === 'select' && e.data) {
                sOrigin = e.data.origin
            } else if (e.type === 'contextmenucreate') {
                cMenuType = e.data.type
            }
            if (!sel.length || (((e.type !== 'contextmenucreate' && sOrigin !== 'navbar') || cMenuType === 'cwd') && sel[0] === fm.cwd().hash)) {
                self.title = fm.i18n(hideData.show ? 'hideHidden' : 'showHidden')
            } else {
                self.title = fm.i18n('cmdhide')
            }
            if (e.type !== 'closecontextmenu') {
                self.update(cMenuType === 'cwd' ? (hideCnt ? 0 : -1) : void(0), self.title)
            } else {
                cMenuType = '';
                requestAnimationFrame(function () {
                    self.update(void(0), self.title)
                })
            }
        });
        this.getstate = function (sel) {
            return (cMenuType !== 'cwd' && (sel || this.fm.selected()).length) || hideCnt ? 0 : -1
        };
        this.exec = function (hashes, opts) {
            var fm = this.fm, dfrd = $.Deferred().done(function () {
                    fm.trigger('hide', {items: items, opts: opts})
                }).fail(function (error) {
                    fm.error(error)
                }), o = opts || {}, items = o.targets ? o.targets : (hashes || fm.selected()), added = [], removed = [],
                notifyto, files, res;
            hideData = fm.storage('hide') || {};
            if (!$.isPlainObject(hideData)) {
                hideData = {}
            }
            if (!$.isPlainObject(hideData.items)) {
                hideData.items = {}
            }
            if (opts._currentType === 'shortcut' || !items.length || (opts._currentType !== 'navbar' && sOrigin !== 'navbar' && items[0] === fm.cwd().hash)) {
                if (hideData.show) {
                    o.hide = !0
                } else if (Object.keys(hideData.items).length) {
                    o.show = !0
                }
            }
            if (o.reset) {
                o.show = !0;
                hideCnt = 0
            }
            if (o.show || o.hide) {
                if (o.show) {
                    hideData.show = !0
                } else {
                    delete hideData.show
                }
                if (o.show) {
                    fm.storage('hide', o.reset ? null : hideData);
                    self.title = fm.i18n('hideHidden');
                    self.update(o.reset ? -1 : void(0), self.title);
                    $.each(hideData.items, function (h) {
                        var f = fm.file(h, !0);
                        if (f && (fm.searchStatus.state || !f.phash || fm.file(f.phash))) {
                            added.push(f)
                        }
                    });
                    if (added.length) {
                        fm.updateCache({added: added});
                        fm.add({added: added})
                    }
                    if (o.reset) {
                        hideData = {items: {}}
                    }
                    return dfrd.resolve()
                }
                items = Object.keys(hideData.items)
            }
            if (items.length) {
                $.each(items, function (i, h) {
                    var f;
                    if (!hideData.items[h]) {
                        f = fm.file(h);
                        if (f) {
                            nameCache[h] = f.i18 || f.name
                        }
                        hideData.items[h] = nameCache[h] ? nameCache[h] : h
                    }
                });
                hideCnt = Object.keys(hideData.items).length;
                files = this.files(items);
                fm.storage('hide', hideData);
                fm.remove({removed: items});
                if (hideData.show) {
                    this.exec(void(0), {hide: !0})
                }
                if (!o.hide) {
                    res = {};
                    res.undo = {
                        cmd: 'hide', callback: function () {
                            var nData = fm.storage('hide');
                            if (nData) {
                                $.each(items, function (i, h) {
                                    delete nData.items[h]
                                });
                                hideCnt = Object.keys(nData.items).length;
                                fm.storage('hide', nData);
                                fm.trigger('hide', {items: items, opts: {}});
                                self.update(hideCnt ? 0 : -1)
                            }
                            fm.updateCache({added: files});
                            fm.add({added: files})
                        }
                    };
                    res.redo = {
                        cmd: 'hide', callback: function () {
                            return fm.exec('hide', void(0), {targets: items})
                        }
                    }
                }
            }
            return dfrd.state() == 'rejected' ? dfrd : dfrd.resolve(res)
        }
    };
    (elFinder.prototype.commands.home = function () {
        this.title = 'Home';
        this.alwaysEnabled = !0;
        this.updateOnSelect = !1;
        this.shortcuts = [{pattern: 'ctrl+home ctrl+shift+up', description: 'Home'}];
        this.getstate = function () {
            var root = this.fm.root(), cwd = this.fm.cwd().hash;
            return root && cwd && root != cwd ? 0 : -1
        };
        this.exec = function () {
            return this.fm.exec('open', this.fm.root())
        }
    }).prototype = {forceLoad: !0};
    (elFinder.prototype.commands.info = function () {
        var m = 'msg', fm = this.fm, spclass = 'elfinder-spinner', btnclass = 'elfinder-info-button', msg = {
            calc: fm.i18n('calc'),
            size: fm.i18n('size'),
            unknown: fm.i18n('unknown'),
            path: fm.i18n('path'),
            aliasfor: fm.i18n('aliasfor'),
            modify: fm.i18n('modify'),
            perms: fm.i18n('perms'),
            locked: fm.i18n('locked'),
            dim: fm.i18n('dim'),
            kind: fm.i18n('kind'),
            files: fm.i18n('files'),
            folders: fm.i18n('folders'),
            roots: fm.i18n('volumeRoots'),
            items: fm.i18n('items'),
            yes: fm.i18n('yes'),
            no: fm.i18n('no'),
            link: fm.i18n('link'),
            owner: fm.i18n('owner'),
            group: fm.i18n('group'),
            perm: fm.i18n('perm'),
            getlink: fm.i18n('getLink')
        }, applyZWSP = function (str, remove) {
            if (remove) {
                return str.replace(/\u200B/g, '')
            } else {
                return str.replace(/(\/|\\)/g, "$1\u200B")
            }
        };
        this.items = ['size', 'aliasfor', 'path', 'link', 'dim', 'modify', 'perms', 'locked', 'owner', 'group', 'perm'];
        if (this.options.custom && Object.keys(this.options.custom).length) {
            $.each(this.options.custom, function (name, details) {
                details.label && this.items.push(details.label)
            })
        }
        this.tpl = {
            main: '<div class="ui-helper-clearfix elfinder-info-title {dirclass}"><span class="elfinder-cwd-icon {class} ui-corner-all"{style}/>{title}</div><table class="elfinder-info-tb">{content}</table>',
            itemTitle: '<strong>{name}</strong><span class="elfinder-info-kind">{kind}</span>',
            groupTitle: '<strong>{items}: {num}</strong>',
            row: '<tr><td class="elfinder-info-label">{label} : </td><td class="{class}">{value}</td></tr>',
            spinner: '<span>{text}</span> <span class="' + spclass + ' ' + spclass + '-{name}"/>'
        };
        this.alwaysEnabled = !0;
        this.updateOnSelect = !1;
        this.shortcuts = [{pattern: 'ctrl+i'}];
        this.init = function () {
            $.each(msg, function (k, v) {
                msg[k] = fm.i18n(v)
            })
        };
        this.getstate = function () {
            return 0
        };
        this.exec = function (hashes) {
            var files = this.files(hashes);
            if (!files.length) {
                files = this.files([this.fm.cwd().hash])
            }
            var self = this, fm = this.fm, o = this.options, tpl = this.tpl, row = tpl.row, cnt = files.length,
                content = [], view = tpl.main, l = '{label}', v = '{value}', reqs = [], reqDfrd = null, opts = {
                    title: fm.i18n('selectionInfo'), width: 'auto', close: function () {
                        $(this).elfinderdialog('destroy');
                        if (reqDfrd && reqDfrd.state() === 'pending') {
                            reqDfrd.reject()
                        }
                        $.grep(reqs, function (r) {
                            r && r.state() === 'pending' && r.reject()
                        })
                    }
                }, count = [], replSpinner = function (msg, name, className) {
                    dialog.find('.' + spclass + '-' + name).parent().html(msg).addClass(className || '')
                }, id = fm.namespace + '-info-' + $.map(files, function (f) {
                    return f.hash
                }).join('-'), dialog = fm.getUI().find('#' + id), customActions = [], style = '',
                hashClass = 'elfinder-font-mono elfinder-info-hash', size, tmb, file, title, dcnt, rdcnt, path,
                getHashAlgorisms, hideItems;
            if (!cnt) {
                return $.Deferred().reject()
            }
            if (dialog.length) {
                dialog.elfinderdialog('toTop');
                return $.Deferred().resolve()
            }
            hideItems = fm.storage('infohides') || fm.arrayFlip(o.hideItems, !0);
            if (cnt === 1) {
                file = files[0];
                if (file.icon) {
                    style = ' ' + fm.getIconStyle(file)
                }
                view = view.replace('{dirclass}', file.csscls ? fm.escape(file.csscls) : '').replace('{class}', fm.mime2class(file.mime)).replace('{style}', style);
                title = tpl.itemTitle.replace('{name}', fm.escape(file.i18 || file.name)).replace('{kind}', '<span title="' + fm.escape(file.mime) + '">' + fm.mime2kind(file) + '</span>');
                tmb = fm.tmb(file);
                if (!file.read) {
                    size = msg.unknown
                } else if (file.mime != 'directory' || file.alias) {
                    size = fm.formatSize(file.size)
                } else {
                    size = tpl.spinner.replace('{text}', msg.calc).replace('{name}', 'size');
                    count.push(file.hash)
                }
                !hideItems.size && content.push(row.replace(l, msg.size).replace(v, size));
                !hideItems.aleasfor && file.alias && content.push(row.replace(l, msg.aliasfor).replace(v, file.alias));
                if (!hideItems.path) {
                    if (path = fm.path(file.hash, !0)) {
                        content.push(row.replace(l, msg.path).replace(v, applyZWSP(fm.escape(path))).replace('{class}', 'elfinder-info-path'))
                    } else {
                        content.push(row.replace(l, msg.path).replace(v, tpl.spinner.replace('{text}', msg.calc).replace('{name}', 'path')).replace('{class}', 'elfinder-info-path'));
                        reqs.push(fm.path(file.hash, !0, {notify: null}).fail(function () {
                            replSpinner(msg.unknown, 'path')
                        }).done(function (path) {
                            replSpinner(applyZWSP(path), 'path')
                        }))
                    }
                }
                if (!hideItems.link && file.read) {
                    var href, name_esc = fm.escape(file.name);
                    if (file.url == '1') {
                        content.push(row.replace(l, msg.link).replace(v, '<button class="' + btnclass + ' ' + spclass + '-url">' + msg.getlink + '</button>'))
                    } else {
                        if (file.url) {
                            href = file.url
                        } else if (file.mime === 'directory') {
                            if (o.nullUrlDirLinkSelf && file.url === null) {
                                var loc = window.location;
                                href = loc.pathname + loc.search + '#elf_' + file.hash
                            } else if (file.url !== '' && fm.option('url', (!fm.isRoot(file) && file.phash) || file.hash)) {
                                href = fm.url(file.hash)
                            }
                        } else {
                            href = fm.url(file.hash)
                        }
                        href && content.push(row.replace(l, msg.link).replace(v, '<a href="' + href + '" target="_blank">' + name_esc + '</a>'))
                    }
                }
                if (!hideItems.dim) {
                    if (file.dim) {
                        content.push(row.replace(l, msg.dim).replace(v, file.dim))
                    } else if (file.mime.indexOf('image') !== -1) {
                        if (file.width && file.height) {
                            content.push(row.replace(l, msg.dim).replace(v, file.width + 'x' + file.height))
                        } else {
                            content.push(row.replace(l, msg.dim).replace(v, tpl.spinner.replace('{text}', msg.calc).replace('{name}', 'dim')));
                            reqs.push(fm.request({
                                data: {cmd: 'dim', target: file.hash},
                                preventDefault: !0
                            }).fail(function () {
                                replSpinner(msg.unknown, 'dim')
                            }).done(function (data) {
                                replSpinner(data.dim || msg.unknown, 'dim');
                                if (data.dim) {
                                    var dim = data.dim.split('x');
                                    var rfile = fm.file(file.hash);
                                    rfile.width = dim[0];
                                    rfile.height = dim[1]
                                }
                            }))
                        }
                    }
                }
                !hideItems.modify && content.push(row.replace(l, msg.modify).replace(v, fm.formatDate(file)));
                !hideItems.perms && content.push(row.replace(l, msg.perms).replace(v, fm.formatPermissions(file)));
                !hideItems.locked && content.push(row.replace(l, msg.locked).replace(v, file.locked ? msg.yes : msg.no));
                !hideItems.owner && file.owner && content.push(row.replace(l, msg.owner).replace(v, file.owner));
                !hideItems.group && file.group && content.push(row.replace(l, msg.group).replace(v, file.group));
                !hideItems.perm && file.perm && content.push(row.replace(l, msg.perm).replace(v, fm.formatFileMode(file.perm)));
                if (window.ArrayBuffer && (fm.options.cdns.sparkmd5 || fm.options.cdns.jssha) && file.mime !== 'directory' && file.size > 0 && (!o.showHashMaxsize || file.size <= o.showHashMaxsize)) {
                    getHashAlgorisms = [];
                    $.each(fm.storage('hashchekcer') || o.showHashAlgorisms, function (i, n) {
                        if (!file[n]) {
                            content.push(row.replace(l, fm.i18n(n)).replace(v, tpl.spinner.replace('{text}', msg.calc).replace('{name}', n)));
                            getHashAlgorisms.push(n)
                        } else {
                            content.push(row.replace(l, fm.i18n(n)).replace(v, file[n]).replace('{class}', hashClass))
                        }
                    });
                    reqs.push(fm.getContentsHashes(file.hash, getHashAlgorisms).progress(function (hashes) {
                        $.each(getHashAlgorisms, function (i, n) {
                            if (hashes[n]) {
                                replSpinner(hashes[n], n, hashClass)
                            }
                        })
                    }).always(function () {
                        $.each(getHashAlgorisms, function (i, n) {
                            replSpinner(msg.unknown, n)
                        })
                    }))
                }
                if (o.custom) {
                    $.each(o.custom, function (name, details) {
                        if (!hideItems[details.label] && (!details.mimes || $.grep(details.mimes, function (m) {
                                return (file.mime === m || file.mime.indexOf(m + '/') === 0) ? !0 : !1
                            }).length) && (!details.hashRegex || file.hash.match(details.hashRegex))) {
                            content.push(row.replace(l, fm.i18n(details.label)).replace(v, details.tpl.replace('{id}', id)));
                            if (details.action && (typeof details.action == 'function')) {
                                customActions.push(details.action)
                            }
                        }
                    })
                }
            } else {
                view = view.replace('{class}', 'elfinder-cwd-icon-group');
                title = tpl.groupTitle.replace('{items}', msg.items).replace('{num}', cnt);
                dcnt = $.grep(files, function (f) {
                    return f.mime == 'directory' ? !0 : !1
                }).length;
                if (!dcnt) {
                    size = 0;
                    $.each(files, function (h, f) {
                        var s = parseInt(f.size);
                        if (s >= 0 && size >= 0) {
                            size += s
                        } else {
                            size = 'unknown'
                        }
                    });
                    content.push(row.replace(l, msg.kind).replace(v, msg.files));
                    !hideItems.size && content.push(row.replace(l, msg.size).replace(v, fm.formatSize(size)))
                } else {
                    rdcnt = $.grep(files, function (f) {
                        return f.mime === 'directory' && (!f.phash || f.isroot) ? !0 : !1
                    }).length;
                    dcnt -= rdcnt;
                    content.push(row.replace(l, msg.kind).replace(v, (rdcnt === cnt || dcnt === cnt) ? msg[rdcnt ? 'roots' : 'folders'] : $.map({
                        roots: rdcnt,
                        folders: dcnt,
                        files: cnt - rdcnt - dcnt
                    }, function (c, t) {
                        return c ? msg[t] + ' ' + c : null
                    }).join(', ')));
                    !hideItems.size && content.push(row.replace(l, msg.size).replace(v, tpl.spinner.replace('{text}', msg.calc).replace('{name}', 'size')));
                    count = $.map(files, function (f) {
                        return f.hash
                    })
                }
            }
            view = view.replace('{title}', title).replace('{content}', content.join('').replace(/{class}/g, ''));
            dialog = self.fmDialog(view, opts);
            dialog.attr('id', id).one('mousedown', '.elfinder-info-path', function () {
                $(this).html(applyZWSP($(this).html(), !0))
            });
            if (fm.UA.Mobile && $.fn.tooltip) {
                dialog.children('.ui-dialog-content .elfinder-info-title').tooltip({
                    classes: {'ui-tooltip': 'elfinder-ui-tooltip ui-widget-shadow'},
                    tooltipClass: 'elfinder-ui-tooltip ui-widget-shadow',
                    track: !0
                })
            }
            if (file && file.url == '1') {
                dialog.on('click', '.' + spclass + '-url', function () {
                    $(this).parent().html(tpl.spinner.replace('{text}', fm.i18n('ntfurl')).replace('{name}', 'url'));
                    fm.request({data: {cmd: 'url', target: file.hash}, preventDefault: !0}).fail(function () {
                        replSpinner(name_esc, 'url')
                    }).done(function (data) {
                        if (data.url) {
                            replSpinner('<a href="' + data.url + '" target="_blank">' + name_esc + '</a>' || name_esc, 'url');
                            var rfile = fm.file(file.hash);
                            rfile.url = data.url
                        } else {
                            replSpinner(name_esc, 'url')
                        }
                    })
                })
            }
            if (tmb) {
                $('<img/>').on('load', function () {
                    dialog.find('.elfinder-cwd-icon').addClass(tmb.className).css('background-image', "url('" + tmb.url + "')")
                }).attr('src', tmb.url)
            }
            if (count.length) {
                reqDfrd = fm.getSize(count).done(function (data) {
                    replSpinner(data.formated, 'size')
                }).fail(function () {
                    replSpinner(msg.unknown, 'size')
                })
            }
            if (customActions.length) {
                $.each(customActions, function (i, action) {
                    try {
                        action(file, fm, dialog)
                    } catch (e) {
                        fm.debug('error', e)
                    }
                })
            }
            return $.Deferred().resolve()
        }
    }).prototype = {forceLoad: !0};
    elFinder.prototype.commands.mkdir = function () {
        var fm = this.fm, self = this, curOrg;
        this.value = '';
        this.disableOnSearch = !0;
        this.updateOnSelect = !1;
        this.syncTitleOnChange = !0;
        this.mime = 'directory';
        this.prefix = 'untitled folder';
        this.exec = function (select, cOpts) {
            var onCwd;
            if (select && select.length && cOpts && cOpts._currentType && cOpts._currentType === 'navbar') {
                this.origin = cOpts._currentType;
                this.data = {target: select[0]}
            } else {
                onCwd = fm.cwd().hash === select[0];
                this.origin = curOrg && !onCwd ? curOrg : 'cwd';
                delete this.data
            }
            if (!select && !this.options.intoNewFolderToolbtn) {
                fm.getUI('cwd').trigger('unselectall')
            }
            this.move = this.value === fm.i18n('cmdmkdirin');
            return $.proxy(fm.res('mixin', 'make'), self)()
        };
        this.shortcuts = [{pattern: 'ctrl+shift+n'}];
        this.init = function () {
            if (this.options.intoNewFolderToolbtn) {
                this.syncTitleOnChange = !0
            }
        };
        fm.bind('select contextmenucreate closecontextmenu', function (e) {
            var sel = (e.data ? (e.data.selected || e.data.targets) : null) || fm.selected();
            self.className = 'mkdir';
            curOrg = e.data && sel.length ? (e.data.origin || e.data.type || '') : '';
            if (!self.options.intoNewFolderToolbtn && curOrg === '') {
                curOrg = 'cwd'
            }
            if (sel.length && curOrg !== 'navbar' && curOrg !== 'cwd' && fm.cwd().hash !== sel[0]) {
                self.title = fm.i18n('cmdmkdirin');
                self.className += ' elfinder-button-icon-mkdirin'
            } else {
                self.title = fm.i18n('cmdmkdir')
            }
            if (e.type !== 'closecontextmenu') {
                self.update(void(0), self.title)
            } else {
                requestAnimationFrame(function () {
                    self.update(void(0), self.title)
                })
            }
        });
        this.getstate = function (select) {
            var cwd = fm.cwd(),
                sel = (curOrg === 'navbar' || (select && select[0] !== cwd.hash)) ? this.files(select || fm.selected()) : [],
                cnt = sel.length;
            if (curOrg === 'navbar') {
                return cnt && sel[0].write && sel[0].read ? 0 : -1
            } else {
                return cwd.write && (!cnt || $.grep(sel, function (f) {
                    return f.read && !f.locked ? !0 : !1
                }).length == cnt) ? 0 : -1
            }
        }
    };
    elFinder.prototype.commands.mkfile = function () {
        var self = this;
        this.disableOnSearch = !0;
        this.updateOnSelect = !1;
        this.mime = 'text/plain';
        this.prefix = 'untitled file.txt';
        this.variants = [];
        this.getTypeName = function (mime, type) {
            var fm = self.fm, name;
            if (name = fm.messages['kind' + fm.kinds[mime]]) {
                name = fm.i18n(['extentiontype', type.toUpperCase(), name])
            } else {
                name = fm.i18n(['extentionfile', type.toUpperCase()])
            }
            return name
        };
        this.fm.bind('open reload canMakeEmptyFile', function () {
            var fm = self.fm, hides = fm.storage('mkfileHides') || {};
            self.variants = [];
            if (fm.mimesCanMakeEmpty) {
                $.each(fm.mimesCanMakeEmpty, function (mime, type) {
                    type && !hides[mime] && fm.uploadMimeCheck(mime) && self.variants.push([mime, self.getTypeName(mime, type)])
                })
            }
            self.change()
        });
        this.getstate = function () {
            return this.fm.cwd().write ? 0 : -1
        };
        this.exec = function (_dum, mime) {
            var fm = self.fm, type, err;
            if (type = fm.mimesCanMakeEmpty[mime]) {
                if (fm.uploadMimeCheck(mime)) {
                    this.mime = mime;
                    this.prefix = fm.i18n(['untitled file', type]);
                    return $.proxy(fm.res('mixin', 'make'), self)()
                }
                err = ['errMkfile', self.getTypeName(mime, type)]
            }
            return $.Deferred().reject(err)
        }
    };
    elFinder.prototype.commands.netmount = function () {
        var self = this, hasMenus = !1, content;
        this.alwaysEnabled = !0;
        this.updateOnSelect = !1;
        this.drivers = [];
        this.handlers = {
            load: function () {
                var fm = self.fm;
                self.drivers = fm.netDrivers;
                if (self.drivers.length) {
                    requestAnimationFrame(function () {
                        $.each(self.drivers, function () {
                            var d = self.options[this];
                            if (d) {
                                hasMenus = !0;
                                if (d.integrateInfo) {
                                    fm.trigger('helpIntegration', Object.assign({cmd: 'netmount'}, d.integrateInfo))
                                }
                            }
                        })
                    })
                }
            }
        };
        this.getstate = function () {
            return hasMenus ? 0 : -1
        };
        this.exec = function () {
            var fm = self.fm, dfrd = $.Deferred(), o = self.options, create = function () {
                var winFocus = function () {
                    inputs.protocol.trigger('change', 'winfocus')
                }, inputs = {
                    protocol: $('<select/>').on('change', function (e, data) {
                        var protocol = this.value;
                        content.find('.elfinder-netmount-tr').hide();
                        content.find('.elfinder-netmount-tr-' + protocol).show();
                        dialogNode && dialogNode.children('.ui-dialog-buttonpane:first').find('button').show();
                        if (typeof o[protocol].select == 'function') {
                            o[protocol].select(fm, e, data)
                        }
                        requestAnimationFrame(function () {
                            content.find('input:text.elfinder-tabstop:visible:first').trigger('focus')
                        })
                    }).addClass('ui-corner-all')
                }, opts = {
                    title: fm.i18n('netMountDialogTitle'),
                    resizable: !1,
                    modal: !0,
                    destroyOnClose: !1,
                    open: function () {
                        $(window).on('focus.' + fm.namespace, winFocus);
                        inputs.protocol.trigger('change')
                    },
                    close: function () {
                        dfrd.state() == 'pending' && dfrd.reject();
                        $(window).off('focus.' + fm.namespace, winFocus)
                    },
                    buttons: {}
                }, doMount = function () {
                    var protocol = inputs.protocol.val(), data = {cmd: 'netmount', protocol: protocol},
                        cur = o[protocol];
                    $.each(content.find('input.elfinder-netmount-inputs-' + protocol), function (name, input) {
                        var val, elm;
                        elm = $(input);
                        if (elm.is(':radio,:checkbox')) {
                            if (elm.is(':checked')) {
                                val = $.trim(elm.val())
                            }
                        } else {
                            val = $.trim(elm.val())
                        }
                        if (val) {
                            data[input.name] = val
                        }
                    });
                    if (!data.host) {
                        return fm.trigger('error', {error: 'errNetMountHostReq', opts: {modal: !0}})
                    }
                    fm.request({data: data, notify: {type: 'netmount', cnt: 1, hideCnt: !0}}).done(function (data) {
                        var pdir;
                        if (data.added && data.added.length) {
                            if (data.added[0].phash) {
                                if (pdir = fm.file(data.added[0].phash)) {
                                    if (!pdir.dirs) {
                                        pdir.dirs = 1;
                                        fm.change({changed: [pdir]})
                                    }
                                }
                            }
                            fm.one('netmountdone', function () {
                                fm.exec('open', data.added[0].hash)
                            })
                        }
                        dfrd.resolve()
                    }).fail(function (error) {
                        if (cur.fail && typeof cur.fail == 'function') {
                            cur.fail(fm, fm.parseError(error))
                        }
                        dfrd.reject(error)
                    });
                    self.dialog.elfinderdialog('close')
                }, form = $('<form autocomplete="off"/>').on('keydown', 'input', function (e) {
                    var comp = !0, next;
                    if (e.keyCode === $.ui.keyCode.ENTER) {
                        $.each(form.find('input:visible:not(.elfinder-input-optional)'), function () {
                            if ($(this).val() === '') {
                                comp = !1;
                                next = $(this);
                                return !1
                            }
                        });
                        if (comp) {
                            doMount()
                        } else {
                            next.trigger('focus')
                        }
                    }
                }), hidden = $('<div/>'), dialog;
                content = $('<table class="elfinder-info-tb elfinder-netmount-tb"/>').append($('<tr/>').append($('<td>' + fm.i18n('protocol') + '</td>')).append($('<td/>').append(inputs.protocol)));
                $.each(self.drivers, function (i, protocol) {
                    if (o[protocol]) {
                        inputs.protocol.append('<option value="' + protocol + '">' + fm.i18n(o[protocol].name || protocol) + '</option>');
                        $.each(o[protocol].inputs, function (name, input) {
                            input.attr('name', name);
                            if (input.attr('type') != 'hidden') {
                                input.addClass('ui-corner-all elfinder-netmount-inputs-' + protocol);
                                content.append($('<tr/>').addClass('elfinder-netmount-tr elfinder-netmount-tr-' + protocol).append($('<td>' + fm.i18n(name) + '</td>')).append($('<td/>').append(input)))
                            } else {
                                input.addClass('elfinder-netmount-inputs-' + protocol);
                                hidden.append(input)
                            }
                        });
                        o[protocol].protocol = inputs.protocol
                    }
                });
                content.append(hidden);
                content.find('.elfinder-netmount-tr').hide();
                opts.buttons[fm.i18n('btnMount')] = doMount;
                opts.buttons[fm.i18n('btnCancel')] = function () {
                    self.dialog.elfinderdialog('close')
                };
                content.find('select,input').addClass('elfinder-tabstop');
                dialog = self.fmDialog(form.append(content), opts);
                dialogNode = dialog.closest('.ui-dialog');
                dialog.ready(function () {
                    inputs.protocol.trigger('change');
                    dialog.elfinderdialog('posInit')
                });
                return dialog
            }, dialogNode;
            if (!self.dialog) {
                self.dialog = create()
            } else {
                self.dialog.elfinderdialog('open')
            }
            return dfrd.promise()
        };
        self.fm.bind('netmount', function (e) {
            var d = e.data || null, o = self.options;
            if (d && d.protocol) {
                if (o[d.protocol] && typeof o[d.protocol].done == 'function') {
                    o[d.protocol].done(self.fm, d);
                    content.find('select,input').addClass('elfinder-tabstop');
                    self.dialog.elfinderdialog('tabstopsInit')
                }
            }
        })
    };
    elFinder.prototype.commands.netunmount = function () {
        var self = this;
        this.alwaysEnabled = !0;
        this.updateOnSelect = !1;
        this.drivers = [];
        this.handlers = {
            load: function () {
                this.drivers = this.fm.netDrivers
            }
        };
        this.getstate = function (sel) {
            var fm = this.fm, file;
            return !!sel && this.drivers.length && !this._disabled && (file = fm.file(sel[0])) && file.netkey ? 0 : -1
        };
        this.exec = function (hashes) {
            var self = this, fm = this.fm, dfrd = $.Deferred().fail(function (error) {
                error && fm.error(error)
            }), drive = fm.file(hashes[0]), childrenRoots = function (hash) {
                var roots = [], work;
                if (fm.leafRoots) {
                    work = [];
                    $.each(fm.leafRoots, function (phash, hashes) {
                        var parents = fm.parents(phash), idx, deep;
                        if ((idx = $.inArray(hash, parents)) !== -1) {
                            idx = parents.length - idx;
                            $.each(hashes, function (i, h) {
                                work.push({i: idx, hash: h})
                            })
                        }
                    });
                    if (work.length) {
                        work.sort(function (a, b) {
                            return a.i < b.i
                        });
                        $.each(work, function (i, o) {
                            roots.push(o.hash)
                        })
                    }
                }
                return roots
            };
            if (this._disabled) {
                return dfrd.reject()
            }
            if (dfrd.state() == 'pending') {
                fm.confirm({
                    title: self.title, text: fm.i18n('confirmUnmount', drive.name), accept: {
                        label: 'btnUnmount', callback: function () {
                            var target = drive.hash, roots = childrenRoots(target), requests = [], removed = [],
                                doUmount = function () {
                                    $.when(requests).done(function () {
                                        fm.request({
                                            data: {
                                                cmd: 'netmount',
                                                protocol: 'netunmount',
                                                host: drive.netkey,
                                                user: target,
                                                pass: 'dum'
                                            }, notify: {type: 'netunmount', cnt: 1, hideCnt: !0}, preventFail: !0
                                        }).fail(function (error) {
                                            dfrd.reject(error)
                                        }).done(function (data) {
                                            drive.volumeid && delete fm.volumeExpires[drive.volumeid];
                                            dfrd.resolve()
                                        })
                                    }).fail(function (error) {
                                        if (removed.length) {
                                            fm.remove({removed: removed})
                                        }
                                        dfrd.reject(error)
                                    })
                                };
                            if (roots.length) {
                                fm.confirm({
                                    title: self.title, text: (function () {
                                        var msgs = ['unmountChildren'];
                                        $.each(roots, function (i, hash) {
                                            msgs.push([fm.file(hash).name])
                                        });
                                        return msgs
                                    })(), accept: {
                                        label: 'btnUnmount', callback: function () {
                                            $.each(roots, function (i, hash) {
                                                var d = fm.file(hash);
                                                if (d.netkey) {
                                                    requests.push(fm.request({
                                                        data: {
                                                            cmd: 'netmount',
                                                            protocol: 'netunmount',
                                                            host: d.netkey,
                                                            user: d.hash,
                                                            pass: 'dum'
                                                        },
                                                        notify: {type: 'netunmount', cnt: 1, hideCnt: !0},
                                                        preventDefault: !0
                                                    }).done(function (data) {
                                                        if (data.removed) {
                                                            d.volumeid && delete fm.volumeExpires[d.volumeid];
                                                            removed = removed.concat(data.removed)
                                                        }
                                                    }))
                                                }
                                            });
                                            doUmount()
                                        }
                                    }, cancel: {
                                        label: 'btnCancel', callback: function () {
                                            dfrd.reject()
                                        }
                                    }
                                })
                            } else {
                                requests = null;
                                doUmount()
                            }
                        }
                    }, cancel: {
                        label: 'btnCancel', callback: function () {
                            dfrd.reject()
                        }
                    }
                })
            }
            return dfrd
        }
    };
    (elFinder.prototype.commands.open = function () {
        var fm = this.fm;
        this.alwaysEnabled = !0;
        this.noChangeDirOnRemovedCwd = !0;
        this._handlers = {
            dblclick: function (e) {
                e.preventDefault();
                fm.exec('open', e.data && e.data.file ? [e.data.file] : void(0))
            }, 'select enable disable reload': function (e) {
                this.update(e.type == 'disable' ? -1 : void(0))
            }
        };
        this.shortcuts = [{pattern: 'ctrl+down numpad_enter' + (fm.OS != 'mac' && ' enter')}];
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length;
            return cnt == 1 ? (sel[0].read ? 0 : -1) : (cnt && !fm.UA.Mobile) ? ($.grep(sel, function (file) {
                return file.mime == 'directory' || !file.read ? !1 : !0
            }).length == cnt ? 0 : -1) : -1
        };
        this.exec = function (hashes, cOpts) {
            var dfrd = $.Deferred().fail(function (error) {
                    error && fm.error(error)
                }), files = this.files(hashes), cnt = files.length, thash = (typeof cOpts == 'object') ? cOpts.thash : !1,
                opts = this.options, into = opts.into || 'window', file, url, s, w, imgW, imgH, winW, winH, reg, link,
                html5dl, inline, selAct, cmd;
            if (!cnt && !thash) {
                {
                    return dfrd.reject()
                }
            }
            if (thash || (cnt == 1 && (file = files[0]) && file.mime == 'directory')) {
                if (!thash && file && !file.read) {
                    return dfrd.reject(['errOpen', file.name, 'errPerm'])
                } else {
                    if (fm.keyState.ctrlKey && (fm.keyState.shiftKey || typeof fm.options.getFileCallback !== 'function')) {
                        if (fm.getCommand('opennew')) {
                            return fm.exec('opennew', [thash ? thash : file.hash])
                        }
                    }
                    return fm.request({
                        data: {cmd: 'open', target: thash || file.hash},
                        notify: {type: 'open', cnt: 1, hideCnt: !0},
                        syncOnFail: !0,
                        lazy: !1
                    })
                }
            }
            files = $.grep(files, function (file) {
                return file.mime != 'directory' ? !0 : !1
            });
            if (cnt != files.length) {
                return dfrd.reject()
            }
            var doOpen = function () {
                var wnd, target, getOnly;
                try {
                    reg = new RegExp(fm.option('dispInlineRegex'), 'i')
                } catch (e) {
                    reg = !1
                }
                link = $('<a>').hide().appendTo($('body')), html5dl = (typeof link.get(0).download === 'string');
                cnt = files.length;
                while (cnt--) {
                    target = 'elf_open_window';
                    file = files[cnt];
                    if (!file.read) {
                        return dfrd.reject(['errOpen', file.name, 'errPerm'])
                    }
                    inline = (reg && file.mime.match(reg));
                    url = fm.openUrl(file.hash, !inline);
                    if (fm.UA.Mobile || !inline) {
                        if (html5dl) {
                            if (!inline) {
                                link.attr('download', file.name)
                            } else {
                                link.attr('target', '_blank')
                            }
                            link.attr('href', url).get(0).click()
                        } else {
                            wnd = window.open(url);
                            if (!wnd) {
                                return dfrd.reject('errPopup')
                            }
                        }
                    } else {
                        getOnly = (typeof opts.method === 'string' && opts.method.toLowerCase() === 'get');
                        if (!getOnly && url.indexOf(fm.options.url) === 0 && fm.customData && Object.keys(fm.customData).length && !file.mime.match(/^(?:video|audio)/)) {
                            url = ''
                        }
                        if (into === 'window') {
                            imgW = winW = Math.round(2 * screen.availWidth / 3);
                            imgH = winH = Math.round(2 * screen.availHeight / 3);
                            if (parseInt(file.width) && parseInt(file.height)) {
                                imgW = parseInt(file.width);
                                imgH = parseInt(file.height)
                            } else if (file.dim) {
                                s = file.dim.split('x');
                                imgW = parseInt(s[0]);
                                imgH = parseInt(s[1])
                            }
                            if (winW >= imgW && winH >= imgH) {
                                winW = imgW;
                                winH = imgH
                            } else {
                                if ((imgW - winW) > (imgH - winH)) {
                                    winH = Math.round(imgH * (winW / imgW))
                                } else {
                                    winW = Math.round(imgW * (winH / imgH))
                                }
                            }
                            w = 'width=' + winW + ',height=' + winH;
                            wnd = window.open(url, target, w + ',top=50,left=50,scrollbars=yes,resizable=yes,titlebar=no')
                        } else {
                            if (into === 'tabs') {
                                target = file.hash
                            }
                            wnd = window.open('about:blank', target)
                        }
                        if (!wnd) {
                            return dfrd.reject('errPopup')
                        }
                        if (url === '') {
                            var form = document.createElement("form");
                            form.action = fm.options.url;
                            form.method = 'POST';
                            form.target = target;
                            form.style.display = 'none';
                            var params = Object.assign({}, fm.customData, {
                                cmd: 'file',
                                target: file.hash,
                                _t: file.ts || parseInt(+new Date() / 1000)
                            });
                            $.each(params, function (key, val) {
                                var input = document.createElement("input");
                                input.name = key;
                                input.value = val;
                                form.appendChild(input)
                            });
                            document.body.appendChild(form);
                            form.submit()
                        } else if (into !== 'window') {
                            wnd.location = url
                        }
                        $(wnd).trigger('focus')
                    }
                }
                link.remove();
                return dfrd.resolve(hashes)
            };
            if (cnt > 1) {
                fm.confirm({
                    title: 'openMulti',
                    text: ['openMultiConfirm', cnt + ''],
                    accept: {
                        label: 'cmdopen', callback: function () {
                            doOpen()
                        }
                    },
                    cancel: {
                        label: 'btnCancel', callback: function () {
                            dfrd.reject()
                        }
                    },
                    buttons: (fm.getCommand('zipdl') && fm.isCommandEnabled('zipdl', fm.cwd().hash)) ? [{
                        label: 'cmddownload',
                        callback: function () {
                            fm.exec('download', hashes);
                            dfrd.reject()
                        }
                    }] : []
                })
            } else {
                selAct = fm.storage('selectAction') || opts.selectAction;
                if (selAct) {
                    $.each(selAct.split('/'), function () {
                        var cmdName = this.valueOf();
                        if (cmdName !== 'open' && (cmd = fm.getCommand(cmdName)) && cmd.enabled()) {
                            return !1
                        }
                        cmd = null
                    });
                    if (cmd) {
                        return fm.exec(cmd.name)
                    }
                }
                doOpen()
            }
            return dfrd
        }
    }).prototype = {forceLoad: !0};
    elFinder.prototype.commands.opendir = function () {
        this.alwaysEnabled = !0;
        this.getstate = function () {
            var sel = this.fm.selected(), cnt = sel.length, wz;
            if (cnt !== 1) {
                return -1
            }
            wz = this.fm.getUI('workzone');
            return wz.hasClass('elfinder-search-result') ? 0 : -1
        };
        this.exec = function (hashes) {
            var fm = this.fm, dfrd = $.Deferred(), files = this.files(hashes), cnt = files.length, hash, pcheck = null;
            if (!cnt || !files[0].phash) {
                return dfrd.reject()
            }
            hash = files[0].phash;
            fm.trigger('searchend', {noupdate: !0});
            fm.request({
                data: {cmd: 'open', target: hash},
                notify: {type: 'open', cnt: 1, hideCnt: !0},
                syncOnFail: !1
            });
            return dfrd
        }
    };
    elFinder.prototype.commands.opennew = function () {
        var fm = this.fm;
        this.shortcuts = [{pattern: (typeof(fm.options.getFileCallback) === 'function' ? 'shift+' : '') + 'ctrl+enter'}];
        this.getstate = function (select) {
            var sel = this.files(select), cnt = sel.length;
            return cnt === 1 ? (sel[0].mime === 'directory' && sel[0].read ? 0 : -1) : -1
        };
        this.exec = function (hashes) {
            var dfrd = $.Deferred(), files = this.files(hashes), cnt = files.length, opts = this.options, file, loc,
                url, win;
            if (cnt === 1 && (file = files[0]) && file.mime === 'directory') {
                loc = window.location;
                if (opts.url) {
                    url = opts.url
                } else {
                    url = loc.pathname
                }
                if (opts.useOriginQuery) {
                    if (!url.match(/\?/)) {
                        url += loc.search
                    } else if (loc.search) {
                        url += '&' + loc.search.substr(1)
                    }
                }
                url += '#elf_' + file.hash;
                win = window.open(url, '_blank');
                setTimeout(function () {
                    win.focus()
                }, 1000);
                return dfrd.resolve()
            } else {
                return dfrd.reject()
            }
        }
    };
    elFinder.prototype.commands.paste = function () {
        this.updateOnSelect = !1;
        this.handlers = {
            changeclipboard: function () {
                this.update()
            }
        };
        this.shortcuts = [{pattern: 'ctrl+v shift+insert'}];
        this.getstate = function (dst) {
            if (this._disabled) {
                return -1
            }
            if (dst) {
                if (Array.isArray(dst)) {
                    if (dst.length != 1) {
                        return -1
                    }
                    dst = this.fm.file(dst[0])
                }
            } else {
                dst = this.fm.cwd()
            }
            return this.fm.clipboard().length && dst.mime == 'directory' && dst.write ? 0 : -1
        };
        this.exec = function (select, cOpts) {
            var self = this, fm = self.fm, opts = cOpts || {}, dst = select ? this.files(select)[0] : fm.cwd(),
                files = fm.clipboard(), cnt = files.length, cut = cnt ? files[0].cut : !1,
                cmd = opts._cmd ? opts._cmd : (cut ? 'move' : 'copy'),
                error = 'err' + cmd.charAt(0).toUpperCase() + cmd.substr(1), fpaste = [], fcopy = [],
                dfrd = $.Deferred().fail(function (error) {
                    error && fm.error(error)
                }).always(function () {
                    fm.unlockfiles({
                        files: $.map(files, function (f) {
                            return f.hash
                        })
                    })
                }), copy = function (files) {
                    return files.length && fm._commands.duplicate ? fm.exec('duplicate', files) : $.Deferred().resolve()
                }, paste = function (files) {
                    var dfrd = $.Deferred(), existed = [], hashes = {}, intersect = function (files, names) {
                        var ret = [], i = files.length;
                        while (i--) {
                            $.inArray(files[i].name, names) !== -1 && ret.unshift(i)
                        }
                        return ret
                    }, confirm = function (ndx) {
                        var i = existed[ndx], file = files[i], last = ndx == existed.length - 1;
                        if (!file) {
                            return
                        }
                        fm.confirm({
                            title: fm.i18n(cmd + 'Files'),
                            text: ['errExists', file.name, cmd === 'restore' ? 'confirmRest' : 'confirmRepl'],
                            all: !last,
                            accept: {
                                label: 'btnYes', callback: function (all) {
                                    !last && !all ? confirm(++ndx) : paste(files)
                                }
                            },
                            reject: {
                                label: 'btnNo', callback: function (all) {
                                    var i;
                                    if (all) {
                                        i = existed.length;
                                        while (ndx < i--) {
                                            files[existed[i]].remove = !0
                                        }
                                    } else {
                                        files[existed[ndx]].remove = !0
                                    }
                                    !last && !all ? confirm(++ndx) : paste(files)
                                }
                            },
                            cancel: {
                                label: 'btnCancel', callback: function () {
                                    dfrd.resolve()
                                }
                            },
                            buttons: [{
                                label: 'btnBackup', callback: function (all) {
                                    var i;
                                    if (all) {
                                        i = existed.length;
                                        while (ndx < i--) {
                                            files[existed[i]].rename = !0
                                        }
                                    } else {
                                        files[existed[ndx]].rename = !0
                                    }
                                    !last && !all ? confirm(++ndx) : paste(files)
                                }
                            }]
                        })
                    }, valid = function (names) {
                        var exists = {}, existedArr;
                        if (names) {
                            if (Array.isArray(names)) {
                                if (names.length) {
                                    if (typeof names[0] == 'string') {
                                        existed = intersect(files, names)
                                    } else {
                                        $.each(names, function (i, v) {
                                            exists[v.name] = v.hash
                                        });
                                        existed = intersect(files, $.map(exists, function (h, n) {
                                            return n
                                        }));
                                        $.each(files, function (i, file) {
                                            if (exists[file.name]) {
                                                hashes[exists[file.name]] = file.name
                                            }
                                        })
                                    }
                                }
                            } else {
                                existedArr = [];
                                existed = $.map(names, function (n) {
                                    if (typeof n === 'string') {
                                        return n
                                    } else {
                                        existedArr = existedArr.concat(n);
                                        return !1
                                    }
                                });
                                if (existedArr.length) {
                                    existed = existed.concat(existedArr)
                                }
                                existed = intersect(files, existed);
                                hashes = names
                            }
                        }
                        existed.length ? confirm(0) : paste(files)
                    }, paste = function (selFiles) {
                        var renames = [], files = $.grep(selFiles, function (file) {
                            if (file.rename) {
                                renames.push(file.name)
                            }
                            return !file.remove ? !0 : !1
                        }), cnt = files.length, groups = {}, args = [], targets, reqData;
                        if (!cnt) {
                            return dfrd.resolve()
                        }
                        targets = $.map(files, function (f) {
                            return f.hash
                        });
                        reqData = {
                            cmd: 'paste',
                            dst: dst.hash,
                            targets: targets,
                            cut: cut ? 1 : 0,
                            renames: renames,
                            hashes: hashes,
                            suffix: fm.options.backupSuffix
                        };
                        if (fm.api < 2.1) {
                            reqData.src = files[0].phash
                        }
                        fm.request({
                            data: reqData,
                            notify: {type: cmd, cnt: cnt},
                            navigate: {
                                toast: opts.noToast ? {} : {
                                    inbuffer: {
                                        msg: fm.i18n(['complete', fm.i18n('cmd' + cmd)]),
                                        action: {
                                            cmd: 'open',
                                            msg: 'cmdopendir',
                                            data: [dst.hash],
                                            done: 'select',
                                            cwdNot: dst.hash
                                        }
                                    }
                                }
                            }
                        }).done(function (data) {
                            var dsts = {}, added = data.added && data.added.length ? data.added : null;
                            if (cut && added) {
                                $.each(files, function (i, f) {
                                    var phash = f.phash, srcHash = function (name) {
                                        var hash;
                                        $.each(added, function (i, f) {
                                            if (f.name === name) {
                                                hash = f.hash;
                                                return !1
                                            }
                                        });
                                        return hash
                                    }, shash = srcHash(f.name);
                                    if (shash) {
                                        if (dsts[phash]) {
                                            dsts[phash].push(shash)
                                        } else {
                                            dsts[phash] = [shash]
                                        }
                                    }
                                });
                                if (Object.keys(dsts).length) {
                                    data.undo = {
                                        cmd: 'move', callback: function () {
                                            var reqs = [];
                                            $.each(dsts, function (dst, targets) {
                                                reqs.push(fm.request({
                                                    data: {
                                                        cmd: 'paste',
                                                        dst: dst,
                                                        targets: targets,
                                                        cut: 1
                                                    }, notify: {type: 'undo', cnt: targets.length}
                                                }))
                                            });
                                            return $.when.apply(null, reqs)
                                        }
                                    };
                                    data.redo = {
                                        cmd: 'move', callback: function () {
                                            return fm.request({data: reqData, notify: {type: 'redo', cnt: cnt}})
                                        }
                                    }
                                }
                            }
                            dfrd.resolve(data)
                        }).fail(function () {
                            dfrd.reject()
                        }).always(function () {
                            fm.unlockfiles({files: files})
                        })
                    }, internames;
                    if (!fm.isCommandEnabled(self.name, dst.hash) || !files.length) {
                        return dfrd.resolve()
                    }
                    if (fm.oldAPI) {
                        paste(files)
                    } else {
                        if (!fm.option('copyOverwrite', dst.hash)) {
                            paste(files)
                        } else {
                            internames = $.map(files, function (f) {
                                return f.name
                            });
                            dst.hash == fm.cwd().hash ? valid($.map(fm.files(), function (file) {
                                return file.phash == dst.hash ? {hash: file.hash, name: file.name} : null
                            })) : fm.request({
                                data: {cmd: 'ls', target: dst.hash, intersect: internames},
                                notify: {type: 'prepare', cnt: 1, hideCnt: !0},
                                preventFail: !0
                            }).always(function (data) {
                                valid(data.list)
                            })
                        }
                    }
                    return dfrd
                }, parents, fparents;
            if (!cnt || !dst || dst.mime != 'directory') {
                return dfrd.reject()
            }
            if (!dst.write) {
                return dfrd.reject([error, files[0].name, 'errPerm'])
            }
            parents = fm.parents(dst.hash);
            $.each(files, function (i, file) {
                if (!file.read) {
                    return !dfrd.reject([error, file.name, 'errPerm'])
                }
                if (cut && file.locked) {
                    return !dfrd.reject(['errLocked', file.name])
                }
                if ($.inArray(file.hash, parents) !== -1) {
                    return !dfrd.reject(['errCopyInItself', file.name])
                }
                if (file.mime && file.mime !== 'directory' && !fm.uploadMimeCheck(file.mime, dst.hash)) {
                    return !dfrd.reject([error, file.name, 'errUploadMime'])
                }
                fparents = fm.parents(file.hash);
                fparents.pop();
                if ($.inArray(dst.hash, fparents) !== -1) {
                    if ($.grep(fparents, function (h) {
                            var d = fm.file(h);
                            return d.phash == dst.hash && d.name == file.name ? !0 : !1
                        }).length) {
                        return !dfrd.reject(['errReplByChild', file.name])
                    }
                }
                if (file.phash == dst.hash) {
                    fcopy.push(file.hash)
                } else {
                    fpaste.push({hash: file.hash, phash: file.phash, name: file.name})
                }
            });
            if (dfrd.state() == 'rejected') {
                return dfrd
            }
            $.when(copy(fcopy), paste(fpaste)).done(function (cr, pr) {
                dfrd.resolve(pr && pr.undo ? pr : void(0))
            }).fail(function () {
                dfrd.reject()
            }).always(function () {
                cut && fm.clipboard([])
            });
            return dfrd
        }
    };
    elFinder.prototype.commands.places = function () {
        var self = this, fm = this.fm, filter = function (hashes) {
            return $.grep(self.files(hashes), function (f) {
                return f.mime == 'directory' ? !0 : !1
            })
        }, places = null;
        this.getstate = function (select) {
            var sel = this.hashes(select), cnt = sel.length;
            return places && cnt && cnt == filter(sel).length ? 0 : -1
        };
        this.exec = function (hashes) {
            var files = this.files(hashes);
            places.trigger('regist', [files]);
            return $.Deferred().resolve()
        };
        fm.one('load', function () {
            places = fm.ui.places
        })
    };
    elFinder.prototype.commands.preference = function () {
        var self = this, fm = this.fm, r = 'replace',
            tab = '<li class="' + fm.res('class', 'tabstab') + ' elfinder-preference-tab-{id}"><a href="#' + fm.namespace + '-preference-{id}" id="' + fm.namespace + '-preference-tab-{id}" class="ui-tabs-anchor {class}">{title}</a></li>',
            base = $('<div class="ui-tabs ui-widget ui-widget-content ui-corner-all elfinder-preference">'),
            ul = $('<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-top">'),
            tabs = $('<div class="elfinder-preference-tabs ui-tabs-panel ui-widget-content ui-corner-bottom"/>'),
            sep = '<div class="elfinder-preference-separator"/>',
            selfUrl = $('base').length ? document.location.href.replace(/#.*$/, '') : '', selectTab = function (tab) {
                $('#' + fm.namespace + '-preference-tab-' + tab).trigger('mouseover').trigger('click');
                openTab = tab
            }, clTabActive = fm.res('class', 'tabsactive'), build = function () {
                var cats = self.options.categories || {
                        'language': ['language'],
                        'theme': ['theme'],
                        'toolbar': ['toolbarPref'],
                        'workspace': ['iconSize', 'columnPref', 'selectAction', 'makefileTypes', 'useStoredEditor', 'editorMaximized', 'useFullscreen', 'showHidden'],
                        'dialog': ['autoFocusDialog'],
                        'selectionInfo': ['infoItems', 'hashChecker'],
                        'reset': ['clearBrowserData'],
                        'all': !0
                    },
                    forms = self.options.prefs || ['language', 'theme', 'toolbarPref', 'iconSize', 'columnPref', 'selectAction', 'makefileTypes', 'useStoredEditor', 'editorMaximized', 'useFullscreen', 'showHidden', 'infoItems', 'hashChecker', 'autoFocusDialog', 'clearBrowserData'];
                forms = fm.arrayFlip(forms, !0);
                if (fm.options.getFileCallback) {
                    delete forms.selectAction
                }
                if (!fm.UA.Fullscreen) {
                    delete forms.useFullscreen
                }
                forms.language && (forms.language = (function () {
                    var langSel = $('<select/>').on('change', function () {
                        var lang = $(this).val();
                        fm.storage('lang', lang);
                        $('#' + fm.id).elfinder('reload')
                    }), optTags = [], langs = self.options.langs || {
                        ar: 'العربية',
                        bg: 'Български',
                        ca: 'Català',
                        cs: 'Čeština',
                        da: 'Dansk',
                        de: 'Deutsch',
                        el: 'Ελληνικά',
                        en: 'English',
                        es: 'Español',
                        fa: 'فارسی',
                        fo: 'Føroyskt',
                        fr: 'Français',
                        he: 'עברית',
                        hr: 'Hrvatski',
                        hu: 'Magyar',
                        id: 'Bahasa Indonesia',
                        it: 'Italiano',
                        ja: '日本語',
                        ko: '한국어',
                        nl: 'Nederlands',
                        no: 'Norsk',
                        pl: 'Polski',
                        pt_BR: 'Português',
                        ro: 'Română',
                        ru: 'Pусский',
                        si: 'සිංහල',
                        sk: 'Slovenčina',
                        sl: 'Slovenščina',
                        sr: 'Srpski',
                        sv: 'Svenska',
                        tr: 'Türkçe',
                        ug_CN: 'ئۇيغۇرچە',
                        uk: 'Український',
                        vi: 'Tiếng Việt',
                        zh_CN: '简体中文',
                        zh_TW: '正體中文'
                    };
                    $.each(langs, function (lang, name) {
                        optTags.push('<option value="' + lang + '">' + name + '</option>')
                    });
                    return langSel.append(optTags.join('')).val(fm.lang)
                })());
                forms.theme && (forms.theme = (function () {
                    var cnt = fm.options.themes ? Object.keys(fm.options.themes).length : 0;
                    if (cnt === 0 || (cnt === 1 && fm.options.themes.default)) {
                        return null
                    }
                    var themeSel = $('<select/>').on('change', function () {
                            var theme = $(this).val();
                            fm.changeTheme(theme).storage('theme', theme)
                        }), optTags = [], tpl = {
                            image: '<img class="elfinder-preference-theme elfinder-preference-theme-image" src="$2" />',
                            link: '<a href="$1" target="_blank" title="$3">$2</a>',
                            data: '<dt>$1</dt><dd><span class="elfinder-preference-theme elfinder-preference-theme-$0">$2</span></dd>'
                        }, items = ['image', 'description', 'author', 'email', 'license'], render = function (key, data) {
                        },
                        defBtn = $('<button class="ui-button ui-corner-all ui-widget elfinder-preference-theme-default"/>').text(fm.i18n('default')).on('click', function (e) {
                            themeSel.val('default').trigger('change')
                        }), list = $('<div class="elfinder-reference-hide-taball"/>').on('click', 'button', function () {
                            var val = $(this).data('themeid');
                            themeSel.val(val).trigger('change')
                        });
                    if (!fm.options.themes.default) {
                        themeSel.append('<option value="default">' + fm.i18n('default') + '</option>')
                    }
                    $.each(fm.options.themes, function (id, val) {
                        var opt = $('<option class="elfinder-theme-option-' + id + '" value="' + id + '">' + fm.i18n(id) + '</option>'),
                            dsc = $('<fieldset class="ui-widget ui-widget-content ui-corner-all elfinder-theme-list-' + id + '"><legend>' + fm.i18n(id) + '</legend><div><span class="elfinder-spinner"/></div></fieldset>'),
                            tm;
                        themeSel.append(opt);
                        list.append(dsc);
                        tm = setTimeout(function () {
                            dsc.find('span.elfinder-spinner').replaceWith(fm.i18n(['errRead', id]))
                        }, 10000);
                        fm.getTheme(id).always(function () {
                            tm && clearTimeout(tm)
                        }).done(function (data) {
                            var link, val = $(), dl = $('<dl/>');
                            link = data.link ? tpl.link.replace(/\$1/g, data.link).replace(/\$3/g, fm.i18n('website')) : '$2';
                            if (data.name) {
                                opt.html(fm.i18n(data.name))
                            }
                            dsc.children('legend').html(link.replace(/\$2/g, fm.i18n(data.name) || id));
                            $.each(items, function (i, key) {
                                var t = tpl[key] || tpl.data, elm;
                                if (data[key]) {
                                    elm = t.replace(/\$0/g, fm.escape(key)).replace(/\$1/g, fm.i18n(key)).replace(/\$2/g, fm.i18n(data[key]));
                                    if (key === 'image' && data.link) {
                                        elm = $(elm).on('click', function () {
                                            themeSel.val(id).trigger('change')
                                        }).attr('title', fm.i18n('select'))
                                    }
                                    dl.append(elm)
                                }
                            });
                            val = val.add(dl);
                            val = val.add($('<div class="elfinder-preference-theme-btn"/>').append($('<button class="ui-button ui-corner-all ui-widget"/>').data('themeid', id).html(fm.i18n('select'))));
                            dsc.find('span.elfinder-spinner').replaceWith(val)
                        }).fail(function () {
                            dsc.find('span.elfinder-spinner').replaceWith(fm.i18n(['errRead', id]))
                        })
                    });
                    return $('<div/>').append(themeSel.val(fm.theme && fm.theme.id ? fm.theme.id : 'default'), defBtn, list)
                })());
                forms.toolbarPref && (forms.toolbarPref = (function () {
                    var pnls = $.map(fm.options.uiOptions.toolbar, function (v) {
                        return $.isArray(v) ? v : null
                    }), tags = [], hides = fm.storage('toolbarhides') || {};
                    $.each(pnls, function () {
                        var cmd = this, name = fm.i18n('cmd' + cmd);
                        if (name === 'cmd' + cmd) {
                            name = fm.i18n(cmd)
                        }
                        tags.push('<span class="elfinder-preference-toolbar-item"><label><input type="checkbox" value="' + cmd + '" ' + (hides[cmd] ? '' : 'checked') + '/>' + name + '</label></span>')
                    });
                    return $(tags.join(' ')).on('change', 'input', function () {
                        var v = $(this).val(), o = $(this).is(':checked');
                        if (!o && !hides[v]) {
                            hides[v] = !0
                        } else if (o && hides[v]) {
                            delete hides[v]
                        }
                        fm.storage('toolbarhides', hides);
                        fm.trigger('toolbarpref')
                    })
                })());
                forms.iconSize && (forms.iconSize = (function () {
                    var max = fm.options.uiOptions.cwd.iconsView.sizeMax || 3, size = fm.storage('iconsize') || 0,
                        sld = $('<div class="touch-punch"/>').slider({
                            classes: {'ui-slider-handle': 'elfinder-tabstop',},
                            value: size,
                            max: max,
                            slide: function (e, ui) {
                                fm.getUI('cwd').trigger('iconpref', {size: ui.value})
                            },
                            change: function (e, ui) {
                                fm.storage('iconsize', ui.value)
                            }
                        });
                    fm.getUI('cwd').on('iconpref', function (e, data) {
                        sld.slider('option', 'value', data.size)
                    });
                    return sld
                })());
                forms.columnPref && (forms.columnPref = (function () {
                    var cols = fm.options.uiOptions.cwd.listView.columns, tags = [],
                        hides = fm.storage('columnhides') || {};
                    $.each(cols, function () {
                        var key = this, name = fm.getColumnName(key);
                        tags.push('<span class="elfinder-preference-column-item"><label><input type="checkbox" value="' + key + '" ' + (hides[key] ? '' : 'checked') + '/>' + name + '</label></span>')
                    });
                    return $(tags.join(' ')).on('change', 'input', function () {
                        var v = $(this).val(), o = $(this).is(':checked');
                        if (!o && !hides[v]) {
                            hides[v] = !0
                        } else if (o && hides[v]) {
                            delete hides[v]
                        }
                        fm.storage('columnhides', hides);
                        fm.trigger('columnpref', {repaint: !0})
                    })
                })());
                forms.selectAction && (forms.selectAction = (function () {
                    var actSel = $('<select/>').on('change', function () {
                            var act = $(this).val();
                            fm.storage('selectAction', act === 'default' ? null : act)
                        }), optTags = [], acts = self.options.selectActions,
                        defAct = fm.getCommand('open').options.selectAction || 'open';
                    if ($.inArray(defAct, acts) === -1) {
                        acts.unshift(defAct)
                    }
                    $.each(acts, function (i, act) {
                        var names = $.map(act.split('/'), function (cmd) {
                            var name = fm.i18n('cmd' + cmd);
                            if (name === 'cmd' + cmd) {
                                name = fm.i18n(cmd)
                            }
                            return name
                        });
                        optTags.push('<option value="' + act + '">' + names.join('/') + '</option>')
                    });
                    return actSel.append(optTags.join('')).val(fm.storage('selectAction') || defAct)
                })());
                forms.makefileTypes && (forms.makefileTypes = (function () {
                    var hides = fm.storage('mkfileHides') || {}, getTag = function () {
                            var tags = [];
                            hides = fm.storage('mkfileHides') || {};
                            $.each(fm.mimesCanMakeEmpty, function (mime, type) {
                                var name = fm.getCommand('mkfile').getTypeName(mime, type);
                                tags.push('<span class="elfinder-preference-column-item" title="' + fm.escape(name) + '"><label><input type="checkbox" value="' + mime + '" ' + (hides[mime] ? '' : 'checked') + '/>' + type + '</lab