/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Settings_Vtiger_Edit_Js("Settings_RelationMaker_DashBoard_Js",{},{
    registerSubmitEvent : function(container){ 
		
		jQuery('#frm_relationmaker').on('submit', function(e) {
			 e.preventDefault();
			
			var rm_pri_module=jQuery('#rm_pri_module').val();
			var rm_sec_module=jQuery('#rm_sec_module').val();
			var rm_reltype=jQuery('#rm_reltype').val();
			
			if(rm_pri_module==''){
				app.helper.showErrorNotification({'message' : "Primary Module can not be empty"});
				return false;
			}else if(rm_sec_module==''){
				app.helper.showErrorNotification({'message' : "Secondary Module can not be empty"});
				return false;
			}else if(rm_reltype==''){
				app.helper.showErrorNotification({'message' : "Relation Type can not be empty"});
				return false;
			}
			else if(rm_pri_module==rm_sec_module){
				app.helper.showErrorNotification({'message' : "Primary Module and Secondary Module Can not be same"});
				return false;
			}else{
				var message = app.vtranslate('Are you sure to proceed?');
				app.helper.showConfirmationBox({'message' : message}).then(function() {
					
				var formData = jQuery(e.currentTarget).serializeFormData();
                app.helper.showProgress();
                app.request.post({'data':formData}).then(function(e,res) {
                    app.helper.hideProgress();
					var message=res.message;
					var message_status=res.success;
					if(message_status)
						{
							 app.helper.showSuccessNotification({'message' : res.message});
							 
							 var modulename=res.modulename;
							 /*var url='index.php?module=LayoutEditor&parent=Settings&view=Index&sourceModule='+modulename+'&mode=showFieldLayout';
							 setTimeout(function() {
       							window.location.href = url
      						 }, 2000);*/
							 
						}
					else
						{
							 app.helper.showErrorNotification({'message' : res.message});
						}
                });
					
				},
				function(error, err){});
				}
		})
	},
	registerEvents : function() {
		var container=jQuery('#frm_relationmaker'); 
		this._super();
		this.registerSubmitEvent(container);
	}
});