/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Settings_Vtiger_Edit_Js("Settings_ModuleMaker_Edit_Js",{},{
	capitalize : function(string){
		return string.replace(/(?:^|\s)\S/g, function(a) { return a.toUpperCase(); });
	},	
	registerKeyupEvent: function(container){
		container.find('[name="cm_modulename"]').on('keyup', function(e) {
			elem=jQuery(e.currentTarget);
			var modulename = elem.val();
			var modulename1 = modulename.replace(/\s\s+/g, ' ');
			var obj=new Settings_ModuleMaker_Edit_Js();
			var cap_modulename=obj.capitalize(modulename1);
			container.find('[name="cm_modulename"]').val(cap_modulename)
			cap_modulename = cap_modulename.replace(/\s+/g, '');
			container.find('[name="cm_crmmodulenamne"]').val(cap_modulename);
		})
	},
    registerSubmitEvent : function(container){
		
		jQuery('#frm_createmodule').on('submit', function(e) {
			 e.preventDefault();
			
			var cm_modulename=jQuery('#cm_modulename').val();
			var cm_prefix=jQuery('#cm_prefix').val();
			var cm_startseq=jQuery('#cm_startseq').val();
			var cm_appmenu=jQuery('#cm_appmenu').val();
			
			if(cm_modulename==''){
				app.helper.showErrorNotification({'message' : "Module Name can not be empty"});
				return false;
			}else if(cm_prefix==''){
				app.helper.showErrorNotification({'message' : "Prefix can not be empty"});
				return false;
			}else if(cm_startseq==''){
				app.helper.showErrorNotification({'message' : "Start Sequesnce can not be empty"});
				return false;
			}
			else if(cm_appmenu==''){
				app.helper.showErrorNotification({'message' : "Please select App Menu"});
				return false;
			}else{
				var message = app.vtranslate('Please confirm all details are correct');
				app.helper.showConfirmationBox({'message' : message}).then(function() {
					
				var formData = jQuery(e.currentTarget).serializeFormData();
                app.helper.showProgress();
                app.request.post({'data':formData}).then(function(e,res) {
                    app.helper.hideProgress();
					var message=res.message;
					var message_status=res.success;
					if(message_status)
						{
							 app.helper.showSuccessNotification({'message' : res.message});
							 
							 var modulename=res.modulename;
							 var url='index.php?module=LayoutEditor&parent=Settings&view=Index&sourceModule='+modulename+'&mode=showFieldLayout';
							 setTimeout(function() {
       							window.location.href = url
      						 }, 2000);
							 
						}
					else
						{
							 app.helper.showErrorNotification({'message' : res.message});
						}
                });
					
				},
				function(error, err){});
				}
		})
	},
	registerEvents : function() {
		var container=jQuery('#frm_createmodule'); 
		this._super();
		this.registerKeyupEvent(container);
		this.registerSubmitEvent(container);
		container.find('[name="cm_crmmodulenamne"]').attr('readonly', 'readonly');
		container.find('[name="cm_crmmodulenamne"]').parent().css('pointer-events', 'none');
		container.find('[name="cm_crmmodulenamne"]').css('background-color' , '#DEDEDE');
		
		container.find('[name="cm_startseq"]').attr('readonly', 'readonly');
		container.find('[name="cm_startseq"]').parent().css('pointer-events', 'none');
		container.find('[name="cm_startseq"]').css('background-color' , '#DEDEDE');
		
		container.find('[name="cm_modulename"]').on('keypress', function (event) {
		var regex = new RegExp("^[a-zA-Z ]+$");

		var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			if (!regex.test(key)) {
			   event.preventDefault();
			   return false;
			}
		});
		
		
		
	}
});