/* ********************************************************************************
 * The content of this file is subject to the Dynamic Blocks ("License");
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is VTExperts.com
 * Portions created by VTExperts.com. are Copyright(C) VTExperts.com.
 * All Rights Reserved.
 * ****************************************************************************** */
Vtiger.Class("DynamicBlocks_Js",{
    editInstance:false,
    isSummaryPopup : false,
    getInstance: function(){
        if(DynamicBlocks_Js.editInstance == false){
            var instance = new DynamicBlocks_Js();
            DynamicBlocks_Js.editInstance = instance;
            return instance;
        }
        return DynamicBlocks_Js.editInstance;
    },
    doDynamicBlocks: function() {
        var recordId ='';
        var frm = jQuery("#detailView");
        var fieldBlockHeader = ".fieldBlockHeader";
        var fieldBlockContainer = ".fieldBlockContainer";
        var view = app.view();

        // Only load when view is Detail or Edit
        if(view!='Detail' && view!='Edit') return;

        if (frm.length == 0){
            frm = jQuery("#EditView");
            recordId = frm.find('[name="record"]').val();
        } else {
            recordId = jQuery(document).find('#recordId').val();
            fieldBlockHeader = ".textOverflowEllipsis";
            fieldBlockContainer = ".block";
        }
        var module = _META.module;
        var url ='index.php?module=DynamicBlocks&action=ActionAjax&mode=getModuleConfigBlock';
        var actionParams = {
            "type":"POST",
            "url":url,
            "dataType":"json",
            "data" : {
                'source_module':module,
                'source_record':recordId
            }
        };
        if(module == 'Calendar'){
            var requestMode=app.convertUrlToDataParams(location.href).mode;
            actionParams.data.source_mode = requestMode;
        }
        app.request.post(actionParams).then(
            function(err,data){
                if(err === null) {
                    var configBlocks=data;
                    if(configBlocks != null && jQuery.isEmptyObject(configBlocks)==false && configBlocks!='' && typeof (configBlocks.result) == 'undefined') {
                        jQuery.each(configBlocks, function(field, configs) {
                            var fieldElm= jQuery(document).find('[name*="'+field+'"]');
                            if(fieldElm.length > 1 || (typeof fieldElm.attr('multiple') !== 'undefined' && fieldElm.attr('multiple') !== false)) {
                                var selectFld = field+'[]';
                                jQuery(document).on('change','[name="'+selectFld+'"]', function(e) {
                                    DynamicBlocks_Js.showHideBlocks(configBlocks, fieldBlockHeader, fieldBlockContainer);
                                });
                                jQuery(document).find('[name="'+selectFld+'"]').trigger("change");
                            }else{
                                jQuery(document).on('change','[name="'+field+'"]', function(e) {
                                    DynamicBlocks_Js.showHideBlocks(configBlocks, fieldBlockHeader, fieldBlockContainer);
                                });
                                jQuery(document).find('[name="'+field+'"]').trigger("change");
                            }
                            if (view == 'Detail') {
                                // For detail
                                DynamicBlocks_Js.showHideBlocksInDetail(module,configBlocks, fieldBlockHeader, fieldBlockContainer);
                            }

                        });
                    }
                    // to do
                }else{
                    // to do
                }
            }
        );
    },
    getQueryParams:function(qs) {
        if(typeof(qs) != 'undefined' ){
            qs = qs.replace('index.php?','');
            qs = qs.toString().split('+').join(' ');
            var params = {},
                tokens,
                re = /[?&]?([^=]+)=([^&]*)/g;
            while (tokens = re.exec(qs)) {
                params[decodeURIComponent(tokens[1])] = decodeURIComponent(tokens[2]);
            }
            return params;
        }
    },
    convertHTMLEntity: function(text){
        const span = document.createElement('span');
        return text.replace(/&[#A-Za-z0-9]+;/gi, (entity,position,text)=> {
                span.innerHTML = entity;
                return span.innerText;
            });
    },
    showHideBlocks : function (configBlocks, fieldBlockHeader, fieldBlockContainer) {
        var instance= this;
        // Set block data-show
        var set_showdata = 0;
        jQuery.each(configBlocks, function(field, configs) {
            var fieldElm= jQuery(document).find('[name*="'+field+'"]');
            jQuery.each(configs, function(values,config) {
                var found = false;
                //values = jQuery('<span>').html(values).html();
                values = instance.convertHTMLEntity(values);
                var picklist_values=values.split("|##|");
                var fieldValue = fieldElm.val();
                if(fieldValue !== null && fieldValue !='') {
                    if (fieldElm.length > 1 || (typeof fieldElm.attr('multiple') !== 'undefined' && fieldElm.attr('multiple') !== false)) {
                        jQuery.each(fieldValue, function (i, v) {
                            if (jQuery.inArray(v, picklist_values) !== -1) {
                                found = true;
                                set_showdata += 1;
                            }
                        });
                    } else {
                        if (jQuery.inArray(fieldValue, picklist_values) !== -1) {
                            found = true;
                            set_showdata += 1;
                        }
                    }
                }else{
                    if (jQuery.inArray('__blank__', picklist_values) !== -1) {
                        found = true;
                        set_showdata += 1;
                    }
                }
                if(found) {
                    jQuery.each(config, function (blocklbl, show) {
                        blocklbl = blocklbl.replace('Related List','');
                        blocklbl = blocklbl.replace('Related Block','');
                        blocklbl = blocklbl.replace(':','');
                        blocklbl = blocklbl.trim();
                        var blockHeader = jQuery(document).find(fieldBlockContainer + '[data-block="'+blocklbl+'"]');
                        if(show != 2) {
                            blockHeader.attr('data-show', show);
                        }
                        var blockHeader = jQuery(document).find(fieldBlockHeader + ':contains("'+blocklbl+'")');
                        jQuery.each(blockHeader, function(i,e) {
                            if(jQuery(e).text().trim() == blocklbl.trim()) {
                                var table = jQuery(e).closest(fieldBlockContainer);
                                if(show != 2) {
                                    table.attr('data-show', show);
                                }
                            }
                        });
                    });
                }
                //reset all show/hide block
                if(!found && set_showdata == 0){
                    jQuery(document).find(fieldBlockContainer).attr('data-show','');
                }
            });
        });

        // show/hide block based on data-show
        jQuery(document).find('div'+fieldBlockContainer).each(function (idx, el) {
            var table = jQuery(el);
            var dataShow=table.attr('data-show');
            if(typeof dataShow != 'undefined' && dataShow != "") {
                if(table.hasClass('tab')){
                    //this for Tab module
                    var idBlock = '#'+table.attr('id');
                    var parentTable = table.closest('.tab-content').closest('.fieldBlockContainer');
                    var tablink = parentTable.find('a[href="'+idBlock+'"]');
                    if(dataShow == '1') {
                        tablink.closest('li').removeClass('hide');
                    }else if(dataShow == '0') {
                        tablink.closest('li').addClass('hide');
                        table.hide();
                        // table.next().hide();
                    }
                }else{
                    if(dataShow == '1') {
                        table.show();
                        // table.next().show();
                    }else if(dataShow == '0') {
                        table.hide();
                        // table.next().hide();
                        table.prev('br').remove();
                    }
                }
            }
            else{
                table.show();
            }
        })
    },
    showHideBlocksInDetail : function (module, configBlocks, fieldBlockHeader, fieldBlockContainer) {
        var instance = this;
        // Set block data-show
        jQuery.each(configBlocks, function(field, configs) {
            jQuery.each(configs, function(values,config) {
                var found = false;
                //values = jQuery('<span>').html(values).html();
                values = instance.convertHTMLEntity(values);
                var picklist_values=values.split("|##|");
                var fieldValue = '';
                if(module == 'Calendar') {
                    var fieldElm= jQuery(document).find('[id$="detailView_fieldValue_'+field+'"]');
                    fieldValue=jQuery(document).find('[id$="detailView_fieldValue_'+field+'"]').text();
                }else{
                    var fieldElement = $('input[data-name="'+field+'"]');
                    if(fieldElement != undefined && fieldElement.length > 0){
                        fieldValue = fieldElement.data('value');
                    }
                    else{
                        var fieldElm = jQuery(document).find('[data-name="' + field + '"]');
                        fieldValue = fieldElm.attr('data-value');
                        if (!fieldValue){
                            fieldValue=jQuery(document).find('[id$="detailView_fieldValue_'+field+'"]').text();
                        }
                    }
                }
                fieldValue=jQuery.trim(fieldValue);
                if(fieldValue !== null && fieldValue !='') {
                    if(jQuery.isArray(fieldValue)) {
                        jQuery.each(fieldValue, function (i, v) {
                            if (jQuery.inArray(v, picklist_values) !== -1) {
                                found = true;
                            }
                        });
                    } else {
                        if (jQuery.inArray(fieldValue, picklist_values) !== -1) {
                            found = true;
                        }
                    }
                }else{
                    if (jQuery.inArray('__blank__', picklist_values) !== -1) {
                        found = true;
                    }
                }
                if(found) {
                    jQuery.each(config, function (blocklbl, show) {
                        blocklbl = blocklbl.replace('Related List','');
                        blocklbl = blocklbl.replace('Related Block','');
                        blocklbl = blocklbl.replace(':','');
                        blocklbl = blocklbl.trim();
                        if(DynamicBlocks_Js.isSummaryPopup){
                            var blockHeader = jQuery('.overlayDetail').find(fieldBlockHeader + ':contains("'+blocklbl+'")');
                        }else{
                            var blockHeader = jQuery(document).find(fieldBlockHeader + ':contains("'+blocklbl+'")');
                        }
                        jQuery.each(blockHeader, function(i,e) {
                            if(jQuery(e).text().trim() == blocklbl.trim()) {
                                if(jQuery(e).hasClass('tablinks')){
                                    //this for VTETab
                                    var idBlock = jQuery(e).attr('href');
                                    var table = jQuery(idBlock);
                                    var dataShow=table.attr('data-show');
                                    var addDataShow = true;
                                    if(typeof dataShow != 'undefined' && dataShow == '0') {
                                        addDataShow =false;
                                    }
                                    if(show != 2) {
                                        if(addDataShow){
                                            table.attr('data-show', show);
                                        }else if(dataShow == 0 && show == 1 && addDataShow == false){
                                            table.attr('data-show', show);
                                        }
                                    }
                                }else{
                                    var table = jQuery(e).closest(fieldBlockContainer);
                                    var dataShow=table.attr('data-show');
                                    var addDataShow = true;
                                    if(typeof dataShow != 'undefined' && dataShow == '0') {
                                        addDataShow =false;
                                    }
                                    if(show != 2) {
                                        if(addDataShow){
                                            if(typeof dataShow == 'undefined') dataShow = show;
                                            table.attr('data-show', dataShow);
                                        }else if(dataShow == 0 && show == 1 && addDataShow == false){
                                            table.attr('data-show', show);
                                        }
                                    }
                                }
                            }
                        });
                    });
                }
            });
        });

        // show/hide block based on data-show
        jQuery(document).find('div'+fieldBlockContainer).each(function (idx, el) {
            var table = jQuery(el);
            var dataShow=table.attr('data-show');
            if(typeof dataShow != 'undefined' && dataShow!="" ) {
                if(table.hasClass('tab')){
                    //this for Tab module
                    var idBlock = '#'+table.attr('id');
                    var parentTable = table.closest('.tab-content').closest('.tabs');
                    var tablink = parentTable.find('a[href="'+idBlock+'"]');
                    if(dataShow == '1') {
                        tablink.closest('li').removeClass('hide');
                    }else if(dataShow == '0') {
                        tablink.closest('li').addClass('hide');
                        table.hide();
                        // table.next().hide();
                    }
                }else{
                    if(dataShow == '1') {
                        table.show();
                        // table.next().show();
                    }else if(dataShow == '0') {
                        table.hide();
                        // table.next().hide();
                        table.prev('br').remove();
                    }
                }
            }
            else{
                table.show();
            }
        })

    },
},{
    registerEvent : function () {
        app.event.on("post.relatedListLoad.click", function() {
            DynamicBlocks_Js.doDynamicBlocks();
        });
    },
});

jQuery(document).ready(function() {
    // Only load when loadHeaderScript=1 BEGIN #241208
    if (typeof VTECheckLoadHeaderScript == 'function') {
        if (!VTECheckLoadHeaderScript('DynamicBlocks')) {
            return;
        }
    }
    // Only load when loadHeaderScript=1 END #241208

    DynamicBlocks_Js.doDynamicBlocks();
    var instance= new DynamicBlocks_Js();
    instance.registerEvent();
    jQuery( document ).ajaxComplete(function(event, xhr, settings) {
        // Only load when loadHeaderScript=1 BEGIN #241208
        if (typeof VTECheckLoadHeaderScript == 'function') {
            if (!VTECheckLoadHeaderScript('DynamicBlocks')) {
                return;
            }
        }
        // Only load when loadHeaderScript=1 END #241208

        var url = settings.data;
        if(typeof url == 'undefined' && settings.url) url = settings.url;
        var other_url = DynamicBlocks_Js.getQueryParams(url);
        // fix issue not work popup QuickCreate
        if(other_url.module == 'RelatedBlocksLists' && other_url.view == 'MassActionAjax' || other_url.displayMode == "overlay") {
            if(other_url.displayMode == "overlay"){
                _META.module = other_url.module;
                DynamicBlocks_Js.isSummaryPopup = true;
            }else{
                DynamicBlocks_Js.isSummaryPopup = false;
            }

            setTimeout(function () {
                DynamicBlocks_Js.doDynamicBlocks();
            }, 500);
        }else{
            DynamicBlocks_Js.isSummaryPopup = false;
        }
        if(other_url.module == 'VTETabs' && other_url.view == 'DetailViewAjax' && other_url.mode == "showModuleDetailView") {
            setTimeout(function () {
                DynamicBlocks_Js.doDynamicBlocks();
            }, 500);
        }
    });
});
